/*
 * Decompiled with CFR 0.152.
 */
package reascer.wom.world.capabilities.item;

import com.mojang.datafixers.util.Pair;
import java.util.function.Function;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TieredItem;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import reascer.wom.gameasset.WOMAnimations;
import reascer.wom.gameasset.WOMSkills;
import reascer.wom.gameasset.WOMWeaponColliders;
import reascer.wom.skill.WOMSkillDataKeys;
import reascer.wom.world.capabilities.item.GesetzCapability;
import reascer.wom.world.capabilities.item.WOMWeaponCategories;
import reascer.wom.world.item.WOMItems;
import yesman.epicfight.api.animation.LivingMotion;
import yesman.epicfight.api.animation.LivingMotions;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.api.forgeevent.WeaponCapabilityPresetRegistryEvent;
import yesman.epicfight.gameasset.Animations;
import yesman.epicfight.gameasset.EpicFightSkills;
import yesman.epicfight.gameasset.EpicFightSounds;
import yesman.epicfight.particle.EpicFightParticles;
import yesman.epicfight.particle.HitParticleType;
import yesman.epicfight.skill.SkillDataKey;
import yesman.epicfight.skill.SkillSlot;
import yesman.epicfight.skill.SkillSlots;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;
import yesman.epicfight.world.capabilities.item.CapabilityItem;
import yesman.epicfight.world.capabilities.item.Style;
import yesman.epicfight.world.capabilities.item.WeaponCapability;
import yesman.epicfight.world.capabilities.item.WeaponCategory;
import yesman.epicfight.world.entity.ai.attribute.EpicFightAttributes;

@Mod.EventBusSubscriber(modid="wom", bus=Mod.EventBusSubscriber.Bus.MOD)
public class WOMWeaponCapabilityPresets {
    public static final Function<Item, CapabilityItem.Builder> STAFF = item -> {
        WeaponCapability.Builder builder = WeaponCapability.builder().category((WeaponCategory)CapabilityItem.WeaponCategories.SPEAR).styleProvider(playerpatch -> CapabilityItem.Styles.TWO_HAND).collider(WOMWeaponColliders.STAFF).hitSound((SoundEvent)EpicFightSounds.BLUNT_HIT.get()).hitParticle((HitParticleType)EpicFightParticles.HIT_BLUNT.get()).canBePlacedOffhand(false).newStyleCombo((Style)CapabilityItem.Styles.TWO_HAND, new StaticAnimation[]{WOMAnimations.STAFF_AUTO_1, WOMAnimations.STAFF_AUTO_2, WOMAnimations.STAFF_AUTO_3, WOMAnimations.STAFF_DASH, WOMAnimations.STAFF_KINKONG}).newStyleCombo((Style)CapabilityItem.Styles.MOUNT, new StaticAnimation[]{Animations.SPEAR_MOUNT_ATTACK}).innateSkill((Style)CapabilityItem.Styles.TWO_HAND, itemstack -> WOMSkills.CHARYBDIS).comboCancel(style -> false).livingMotionModifier((Style)CapabilityItem.Styles.TWO_HAND, (LivingMotion)LivingMotions.IDLE, WOMAnimations.STAFF_IDLE).livingMotionModifier((Style)CapabilityItem.Styles.TWO_HAND, (LivingMotion)LivingMotions.WALK, Animations.BIPED_HOLD_SPEAR).livingMotionModifier((Style)CapabilityItem.Styles.TWO_HAND, (LivingMotion)LivingMotions.CHASE, WOMAnimations.STAFF_RUN).livingMotionModifier((Style)CapabilityItem.Styles.TWO_HAND, (LivingMotion)LivingMotions.RUN, WOMAnimations.STAFF_RUN).livingMotionModifier((Style)CapabilityItem.Styles.TWO_HAND, (LivingMotion)LivingMotions.SWIM, Animations.BIPED_HOLD_SPEAR).livingMotionModifier((Style)CapabilityItem.Styles.TWO_HAND, (LivingMotion)LivingMotions.BLOCK, Animations.SPEAR_GUARD);
        return builder;
    };
    public static final Function<Item, CapabilityItem.Builder> AGONY = item -> {
        WeaponCapability.Builder builder = WeaponCapability.builder().category((WeaponCategory)CapabilityItem.WeaponCategories.SPEAR).styleProvider(playerpatch -> CapabilityItem.Styles.TWO_HAND).collider(WOMWeaponColliders.AGONY).hitSound((SoundEvent)EpicFightSounds.BLADE_HIT.get()).canBePlacedOffhand(false).newStyleCombo((Style)CapabilityItem.Styles.TWO_HAND, new StaticAnimation[]{WOMAnimations.AGONY_AUTO_1, WOMAnimations.AGONY_AUTO_2, WOMAnimations.AGONY_AUTO_3, WOMAnimations.AGONY_AUTO_4, WOMAnimations.AGONY_CLAWSTRIKE, WOMAnimations.AGONY_RIPPING_FANGS}).newStyleCombo((Style)CapabilityItem.Styles.MOUNT, new StaticAnimation[]{Animations.SPEAR_MOUNT_ATTACK}).innateSkill((Style)CapabilityItem.Styles.TWO_HAND, itemstack -> WOMSkills.AGONY_PLUNGE).comboCancel(style -> false).livingMotionModifier((Style)CapabilityItem.Styles.TWO_HAND, (LivingMotion)LivingMotions.IDLE, WOMAnimations.AGONY_IDLE).livingMotionModifier((Style)CapabilityItem.Styles.TWO_HAND, (LivingMotion)LivingMotions.WALK, WOMAnimations.AGONY_WALK).livingMotionModifier((Style)CapabilityItem.Styles.TWO_HAND, (LivingMotion)LivingMotions.CHASE, WOMAnimations.AGONY_RUN).livingMotionModifier((Style)CapabilityItem.Styles.TWO_HAND, (LivingMotion)LivingMotions.RUN, WOMAnimations.AGONY_RUN).livingMotionModifier((Style)CapabilityItem.Styles.TWO_HAND, (LivingMotion)LivingMotions.SWIM, Animations.BIPED_HOLD_SPEAR).livingMotionModifier((Style)CapabilityItem.Styles.TWO_HAND, (LivingMotion)LivingMotions.BLOCK, WOMAnimations.AGONY_GUARD);
        return builder;
    };
    public static final Function<Item, CapabilityItem.Builder> TORMENT = item -> {
        WeaponCapability.Builder builder = WeaponCapability.builder().category((WeaponCategory)WOMWeaponCategories.TORMENT).styleProvider(entitypatch -> {
            if (entitypatch instanceof PlayerPatch && ((PlayerPatch)entitypatch).getSkill((SkillSlot)SkillSlots.WEAPON_INNATE).getRemainDuration() > 0) {
                return CapabilityItem.Styles.OCHS;
            }
            return CapabilityItem.Styles.TWO_HAND;
        }).collider(WOMWeaponColliders.TORMENT).hitSound((SoundEvent)EpicFightSounds.BLADE_HIT.get()).swingSound((SoundEvent)EpicFightSounds.WHOOSH_BIG.get()).canBePlacedOffhand(false).newStyleCombo((Style)CapabilityItem.Styles.TWO_HAND, new StaticAnimation[]{WOMAnimations.TORMENT_AUTO_1, WOMAnimations.TORMENT_AUTO_2, WOMAnimations.TORMENT_AUTO_3, WOMAnimations.TORMENT_AUTO_4, WOMAnimations.TORMENT_DASH, WOMAnimations.TORMENT_AIRSLAM}).newStyleCombo((Style)CapabilityItem.Styles.OCHS, new StaticAnimation[]{WOMAnimations.TORMENT_BERSERK_AUTO_1, WOMAnimations.TORMENT_BERSERK_AUTO_2, WOMAnimations.TORMENT_BERSERK_DASH, WOMAnimations.TORMENT_BERSERK_AIRSLAM}).newStyleCombo((Style)CapabilityItem.Styles.MOUNT, new StaticAnimation[]{Animations.SWORD_MOUNT_ATTACK}).innateSkill((Style)CapabilityItem.Styles.TWO_HAND, itemstack -> WOMSkills.TRUE_BERSERK).innateSkill((Style)CapabilityItem.Styles.OCHS, itemstack -> WOMSkills.TRUE_BERSERK).passiveSkill(WOMSkills.TORMENT_PASSIVE).comboCancel(style -> false).livingMotionModifier((Style)CapabilityItem.Styles.TWO_HAND, (LivingMotion)LivingMotions.IDLE, WOMAnimations.TORMENT_IDLE).livingMotionModifier((Style)CapabilityItem.Styles.TWO_HAND, (LivingMotion)LivingMotions.WALK, WOMAnimations.TORMENT_WALK).livingMotionModifier((Style)CapabilityItem.Styles.TWO_HAND, (LivingMotion)LivingMotions.CHASE, WOMAnimations.TORMENT_RUN).livingMotionModifier((Style)CapabilityItem.Styles.TWO_HAND, (LivingMotion)LivingMotions.RUN, WOMAnimations.TORMENT_RUN).livingMotionModifier((Style)CapabilityItem.Styles.TWO_HAND, (LivingMotion)LivingMotions.SWIM, Animations.BIPED_HOLD_SPEAR).livingMotionModifier((Style)CapabilityItem.Styles.TWO_HAND, (LivingMotion)LivingMotions.BLOCK, WOMAnimations.TORMENT_CHARGE).livingMotionModifier((Style)CapabilityItem.Styles.OCHS, (LivingMotion)LivingMotions.IDLE, WOMAnimations.TORMENT_BERSERK_IDLE).livingMotionModifier((Style)CapabilityItem.Styles.OCHS, (LivingMotion)LivingMotions.WALK, WOMAnimations.TORMENT_BERSERK_WALK).livingMotionModifier((Style)CapabilityItem.Styles.OCHS, (LivingMotion)LivingMotions.CHASE, WOMAnimations.TORMENT_BERSERK_RUN).livingMotionModifier((Style)CapabilityItem.Styles.OCHS, (LivingMotion)LivingMotions.RUN, WOMAnimations.TORMENT_BERSERK_RUN).livingMotionModifier((Style)CapabilityItem.Styles.OCHS, (LivingMotion)LivingMotions.SWIM, Animations.BIPED_HOLD_SPEAR);
        return builder;
    };
    public static final Function<Item, CapabilityItem.Builder> RUINE = item -> {
        WeaponCapability.Builder builder = WeaponCapability.builder().category((WeaponCategory)CapabilityItem.WeaponCategories.LONGSWORD).styleProvider(entitypatch -> {
            if (entitypatch instanceof PlayerPatch && ((PlayerPatch)entitypatch).getSkill((SkillSlot)SkillSlots.WEAPON_INNATE).getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.BUFFED.get()) != null && ((Boolean)((PlayerPatch)entitypatch).getSkill((SkillSlot)SkillSlots.WEAPON_INNATE).getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.BUFFED.get())).booleanValue()) {
                return CapabilityItem.Styles.OCHS;
            }
            return CapabilityItem.Styles.TWO_HAND;
        }).hitSound((SoundEvent)EpicFightSounds.BLADE_HIT.get()).collider(WOMWeaponColliders.RUINE).canBePlacedOffhand(false).newStyleCombo((Style)CapabilityItem.Styles.TWO_HAND, new StaticAnimation[]{WOMAnimations.RUINE_AUTO_1, WOMAnimations.RUINE_AUTO_2, WOMAnimations.RUINE_AUTO_3, WOMAnimations.RUINE_AUTO_4, WOMAnimations.RUINE_CHATIMENT, WOMAnimations.RUINE_COMET}).newStyleCombo((Style)CapabilityItem.Styles.OCHS, new StaticAnimation[]{WOMAnimations.RUINE_AUTO_1, WOMAnimations.RUINE_AUTO_2, WOMAnimations.RUINE_AUTO_3, WOMAnimations.RUINE_AUTO_4, WOMAnimations.RUINE_CHATIMENT, WOMAnimations.RUINE_COMET}).newStyleCombo((Style)CapabilityItem.Styles.MOUNT, new StaticAnimation[]{Animations.SWORD_MOUNT_ATTACK}).innateSkill((Style)CapabilityItem.Styles.TWO_HAND, itemstack -> WOMSkills.SOUL_SNATCH).innateSkill((Style)CapabilityItem.Styles.OCHS, itemstack -> WOMSkills.SOUL_SNATCH).passiveSkill(WOMSkills.RUINE_PASSIVE).comboCancel(style -> false).livingMotionModifier((Style)CapabilityItem.Styles.TWO_HAND, (LivingMotion)LivingMotions.IDLE, WOMAnimations.RUINE_IDLE).livingMotionModifier((Style)CapabilityItem.Styles.TWO_HAND, (LivingMotion)LivingMotions.WALK, WOMAnimations.RUINE_WALK).livingMotionModifier((Style)CapabilityItem.Styles.TWO_HAND, (LivingMotion)LivingMotions.CHASE, Animations.BIPED_HOLD_GREATSWORD).livingMotionModifier((Style)CapabilityItem.Styles.TWO_HAND, (LivingMotion)LivingMotions.RUN, WOMAnimations.RUINE_RUN).livingMotionModifier((Style)CapabilityItem.Styles.TWO_HAND, (LivingMotion)LivingMotions.SNEAK, Animations.BIPED_HOLD_GREATSWORD).livingMotionModifier((Style)CapabilityItem.Styles.TWO_HAND, (LivingMotion)LivingMotions.KNEEL, Animations.BIPED_HOLD_GREATSWORD).livingMotionModifier((Style)CapabilityItem.Styles.TWO_HAND, (LivingMotion)LivingMotions.JUMP, Animations.BIPED_HOLD_GREATSWORD).livingMotionModifier((Style)CapabilityItem.Styles.TWO_HAND, (LivingMotion)LivingMotions.SWIM, Animations.BIPED_HOLD_GREATSWORD).livingMotionModifier((Style)CapabilityItem.Styles.TWO_HAND, (LivingMotion)LivingMotions.BLOCK, WOMAnimations.RUINE_BLOCK).livingMotionModifier((Style)CapabilityItem.Styles.OCHS, (LivingMotion)LivingMotions.IDLE, WOMAnimations.RUINE_BOOSTED_IDLE).livingMotionModifier((Style)CapabilityItem.Styles.OCHS, (LivingMotion)LivingMotions.WALK, WOMAnimations.RUINE_BOOSTED_WALK).livingMotionModifier((Style)CapabilityItem.Styles.OCHS, (LivingMotion)LivingMotions.CHASE, Animations.BIPED_HOLD_GREATSWORD).livingMotionModifier((Style)CapabilityItem.Styles.OCHS, (LivingMotion)LivingMotions.RUN, WOMAnimations.RUINE_RUN).livingMotionModifier((Style)CapabilityItem.Styles.OCHS, (LivingMotion)LivingMotions.SNEAK, Animations.BIPED_HOLD_GREATSWORD).livingMotionModifier((Style)CapabilityItem.Styles.OCHS, (LivingMotion)LivingMotions.KNEEL, Animations.BIPED_HOLD_GREATSWORD).livingMotionModifier((Style)CapabilityItem.Styles.OCHS, (LivingMotion)LivingMotions.JUMP, Animations.BIPED_HOLD_GREATSWORD).livingMotionModifier((Style)CapabilityItem.Styles.OCHS, (LivingMotion)LivingMotions.SWIM, Animations.BIPED_HOLD_GREATSWORD).livingMotionModifier((Style)CapabilityItem.Styles.OCHS, (LivingMotion)LivingMotions.BLOCK, WOMAnimations.RUINE_BLOCK);
        return builder;
    };
    public static final Function<Item, CapabilityItem.Builder> SATSUJIN = item -> {
        WeaponCapability.Builder builder = WeaponCapability.builder().category((WeaponCategory)CapabilityItem.WeaponCategories.UCHIGATANA).styleProvider(entitypatch -> {
            PlayerPatch playerpatch;
            if (entitypatch instanceof PlayerPatch && (playerpatch = (PlayerPatch)entitypatch).getSkill((SkillSlot)SkillSlots.WEAPON_PASSIVE).getDataManager().hasData((SkillDataKey)WOMSkillDataKeys.SHEATH.get()) && ((Boolean)playerpatch.getSkill((SkillSlot)SkillSlots.WEAPON_PASSIVE).getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.SHEATH.get())).booleanValue()) {
                return CapabilityItem.Styles.SHEATH;
            }
            return CapabilityItem.Styles.TWO_HAND;
        }).passiveSkill(WOMSkills.SATSUJIN_PASSIVE).hitSound((SoundEvent)EpicFightSounds.BLADE_HIT.get()).collider(WOMWeaponColliders.KATANA).canBePlacedOffhand(false).newStyleCombo((Style)CapabilityItem.Styles.SHEATH, new StaticAnimation[]{WOMAnimations.KATANA_SHEATHED_AUTO_1, WOMAnimations.KATANA_SHEATHED_AUTO_2, WOMAnimations.KATANA_SHEATHED_AUTO_3, WOMAnimations.KATANA_SHEATHED_DASH, WOMAnimations.KATANA_TSUKUYOMI}).newStyleCombo((Style)CapabilityItem.Styles.TWO_HAND, new StaticAnimation[]{WOMAnimations.KATANA_AUTO_1, WOMAnimations.KATANA_AUTO_2, WOMAnimations.KATANA_AUTO_3, WOMAnimations.KATANA_DASH, WOMAnimations.KATANA_TSUKUYOMI}).newStyleCombo((Style)CapabilityItem.Styles.MOUNT, new StaticAnimation[]{Animations.SWORD_MOUNT_ATTACK}).innateSkill((Style)CapabilityItem.Styles.SHEATH, itemstack -> WOMSkills.SAKURA_STATE).innateSkill((Style)CapabilityItem.Styles.TWO_HAND, itemstack -> WOMSkills.SAKURA_STATE).comboCancel(style -> false).livingMotionModifier((Style)CapabilityItem.Styles.TWO_HAND, (LivingMotion)LivingMotions.IDLE, WOMAnimations.KATANA_IDLE).livingMotionModifier((Style)CapabilityItem.Styles.TWO_HAND, (LivingMotion)LivingMotions.KNEEL, WOMAnimations.KATANA_IDLE).livingMotionModifier((Style)CapabilityItem.Styles.TWO_HAND, (LivingMotion)LivingMotions.WALK, WOMAnimations.KATANA_WALK).livingMotionModifier((Style)CapabilityItem.Styles.TWO_HAND, (LivingMotion)LivingMotions.CHASE, WOMAnimations.KATANA_RUN).livingMotionModifier((Style)CapabilityItem.Styles.TWO_HAND, (LivingMotion)LivingMotions.RUN, WOMAnimations.KATANA_RUN).livingMotionModifier((Style)CapabilityItem.Styles.TWO_HAND, (LivingMotion)LivingMotions.SNEAK, WOMAnimations.KATANA_IDLE).livingMotionModifier((Style)CapabilityItem.Styles.TWO_HAND, (LivingMotion)LivingMotions.SWIM, WOMAnimations.KATANA_IDLE).livingMotionModifier((Style)CapabilityItem.Styles.TWO_HAND, (LivingMotion)LivingMotions.FLOAT, WOMAnimations.KATANA_IDLE).livingMotionModifier((Style)CapabilityItem.Styles.TWO_HAND, (LivingMotion)LivingMotions.FALL, WOMAnimations.KATANA_IDLE).livingMotionModifier((Style)CapabilityItem.Styles.SHEATH, (LivingMotion)LivingMotions.IDLE, WOMAnimations.KATANA_SHEATHED_IDLE).livingMotionModifier((Style)CapabilityItem.Styles.SHEATH, (LivingMotion)LivingMotions.KNEEL, WOMAnimations.KATANA_SHEATHED_IDLE).livingMotionModifier((Style)CapabilityItem.Styles.SHEATH, (LivingMotion)LivingMotions.WALK, WOMAnimations.KATANA_SHEATHED_IDLE).livingMotionModifier((Style)CapabilityItem.Styles.SHEATH, (LivingMotion)LivingMotions.CHASE, WOMAnimations.KATANA_SHEATHED_RUN).livingMotionModifier((Style)CapabilityItem.Styles.SHEATH, (LivingMotion)LivingMotions.RUN, WOMAnimations.KATANA_SHEATHED_RUN).livingMotionModifier((Style)CapabilityItem.Styles.SHEATH, (LivingMotion)LivingMotions.SNEAK, WOMAnimations.KATANA_SHEATHED_IDLE).livingMotionModifier((Style)CapabilityItem.Styles.SHEATH, (LivingMotion)LivingMotions.SWIM, WOMAnimations.KATANA_SHEATHED_IDLE).livingMotionModifier((Style)CapabilityItem.Styles.SHEATH, (LivingMotion)LivingMotions.FLOAT, WOMAnimations.KATANA_SHEATHED_IDLE).livingMotionModifier((Style)CapabilityItem.Styles.SHEATH, (LivingMotion)LivingMotions.FALL, WOMAnimations.KATANA_SHEATHED_IDLE).livingMotionModifier((Style)CapabilityItem.Styles.TWO_HAND, (LivingMotion)LivingMotions.BLOCK, WOMAnimations.KATANA_GUARD);
        return builder;
    };
    public static final Function<Item, CapabilityItem.Builder> ENDER_BLASTER = item -> {
        WeaponCapability.Builder builder = WeaponCapability.builder().zoomInType(CapabilityItem.ZoomInType.CUSTOM).category((WeaponCategory)WOMWeaponCategories.ENDERBLASTER).styleProvider(playerpatch -> playerpatch.getHoldingItemCapability(InteractionHand.OFF_HAND).getWeaponCategory() == WOMWeaponCategories.ENDERBLASTER ? CapabilityItem.Styles.TWO_HAND : CapabilityItem.Styles.ONE_HAND).hitSound((SoundEvent)EpicFightSounds.BLADE_HIT.get()).collider(WOMWeaponColliders.PUNCH).newStyleCombo((Style)CapabilityItem.Styles.ONE_HAND, new StaticAnimation[]{WOMAnimations.ENDERBLASTER_ONEHAND_AUTO_1, WOMAnimations.ENDERBLASTER_ONEHAND_AUTO_2, WOMAnimations.ENDERBLASTER_ONEHAND_AUTO_3, WOMAnimations.ENDERBLASTER_ONEHAND_AUTO_4, WOMAnimations.ENDERBLASTER_ONEHAND_DASH, WOMAnimations.ENDERBLASTER_ONEHAND_JUMPKICK}).newStyleCombo((Style)CapabilityItem.Styles.TWO_HAND, new StaticAnimation[]{WOMAnimations.ENDERBLASTER_TWOHAND_AUTO_1, WOMAnimations.ENDERBLASTER_TWOHAND_AUTO_2, WOMAnimations.ENDERBLASTER_TWOHAND_AUTO_3, WOMAnimations.ENDERBLASTER_TWOHAND_AUTO_4, WOMAnimations.ENDERBLASTER_ONEHAND_DASH, WOMAnimations.ENDERBLASTER_TWOHAND_TISHNAW}).newStyleCombo((Style)CapabilityItem.Styles.MOUNT, new StaticAnimation[]{Animations.SWORD_MOUNT_ATTACK}).innateSkill((Style)CapabilityItem.Styles.ONE_HAND, itemstack -> WOMSkills.ENDER_BLAST).innateSkill((Style)CapabilityItem.Styles.TWO_HAND, itemstack -> WOMSkills.ENDER_FUSION).comboCancel(style -> false).livingMotionModifier((Style)CapabilityItem.Styles.ONE_HAND, (LivingMotion)LivingMotions.IDLE, WOMAnimations.ENDERBLASTER_ONEHAND_IDLE).livingMotionModifier((Style)CapabilityItem.Styles.ONE_HAND, (LivingMotion)LivingMotions.WALK, WOMAnimations.ENDERBLASTER_ONEHAND_WALK).livingMotionModifier((Style)CapabilityItem.Styles.ONE_HAND, (LivingMotion)LivingMotions.CHASE, WOMAnimations.ENDERBLASTER_ONEHAND_RUN).livingMotionModifier((Style)CapabilityItem.Styles.ONE_HAND, (LivingMotion)LivingMotions.RUN, WOMAnimations.ENDERBLASTER_ONEHAND_RUN).livingMotionModifier((Style)CapabilityItem.Styles.ONE_HAND, (LivingMotion)LivingMotions.SWIM, Animations.BIPED_SWIM).livingMotionModifier((Style)CapabilityItem.Styles.ONE_HAND, (LivingMotion)LivingMotions.BLOCK, WOMAnimations.ENDERBLASTER_ONEHAND_AIMING).livingMotionModifier((Style)CapabilityItem.Styles.TWO_HAND, (LivingMotion)LivingMotions.IDLE, WOMAnimations.ENDERBLASTER_TWOHAND_IDLE).livingMotionModifier((Style)CapabilityItem.Styles.TWO_HAND, (LivingMotion)LivingMotions.WALK, WOMAnimations.ENDERBLASTER_TWOHAND_WALK).livingMotionModifier((Style)CapabilityItem.Styles.TWO_HAND, (LivingMotion)LivingMotions.CHASE, WOMAnimations.ENDERBLASTER_ONEHAND_RUN).livingMotionModifier((Style)CapabilityItem.Styles.TWO_HAND, (LivingMotion)LivingMotions.RUN, WOMAnimations.ENDERBLASTER_ONEHAND_RUN).livingMotionModifier((Style)CapabilityItem.Styles.TWO_HAND, (LivingMotion)LivingMotions.SWIM, Animations.BIPED_SWIM).livingMotionModifier((Style)CapabilityItem.Styles.TWO_HAND, (LivingMotion)LivingMotions.BLOCK, WOMAnimations.ENDERBLASTER_TWOHAND_AIMING).weaponCombinationPredicator(entitypatch -> EpicFightCapabilities.getItemStackCapability((ItemStack)((LivingEntity)entitypatch.getOriginal()).m_21206_()).getWeaponCollider() == WOMWeaponColliders.PUNCH);
        return builder;
    };
    public static final Function<Item, CapabilityItem.Builder> ANTITHEUS = item -> {
        WeaponCapability.Builder builder = WeaponCapability.builder().zoomInType(CapabilityItem.ZoomInType.CUSTOM).category((WeaponCategory)WOMWeaponCategories.ANTITHEUS).styleProvider(entitypatch -> {
            if (entitypatch instanceof PlayerPatch && ((PlayerPatch)entitypatch).getSkill((SkillSlot)SkillSlots.WEAPON_INNATE).getRemainDuration() > 0) {
                return CapabilityItem.Styles.OCHS;
            }
            return CapabilityItem.Styles.TWO_HAND;
        }).collider(WOMWeaponColliders.ANTITHEUS).hitSound((SoundEvent)EpicFightSounds.BLADE_HIT.get()).swingSound((SoundEvent)EpicFightSounds.WHOOSH.get()).passiveSkill(WOMSkills.DEMON_MARK_PASSIVE).canBePlacedOffhand(false).newStyleCombo((Style)CapabilityItem.Styles.TWO_HAND, new StaticAnimation[]{WOMAnimations.ANTITHEUS_AUTO_1, WOMAnimations.ANTITHEUS_AUTO_2, WOMAnimations.ANTITHEUS_AUTO_3, WOMAnimations.ANTITHEUS_AUTO_4, WOMAnimations.ANTITHEUS_AGRESSION, WOMAnimations.ANTITHEUS_GUILLOTINE}).newStyleCombo((Style)CapabilityItem.Styles.OCHS, new StaticAnimation[]{WOMAnimations.ANTITHEUS_ASCENDED_AUTO_1, WOMAnimations.ANTITHEUS_ASCENDED_AUTO_2, WOMAnimations.ANTITHEUS_ASCENDED_AUTO_3, WOMAnimations.ANTITHEUS_ASCENDED_BLINK, WOMAnimations.ANTITHEUS_ASCENDED_DEATHFALL}).newStyleCombo((Style)CapabilityItem.Styles.MOUNT, new StaticAnimation[]{Animations.SWORD_MOUNT_ATTACK}).innateSkill((Style)CapabilityItem.Styles.TWO_HAND, itemstack -> WOMSkills.DEMONIC_ASCENSION).innateSkill((Style)CapabilityItem.Styles.OCHS, itemstack -> WOMSkills.DEMONIC_ASCENSION).comboCancel(style -> false).livingMotionModifier((Style)CapabilityItem.Styles.TWO_HAND, (LivingMotion)LivingMotions.IDLE, WOMAnimations.ANTITHEUS_IDLE).livingMotionModifier((Style)CapabilityItem.Styles.TWO_HAND, (LivingMotion)LivingMotions.WALK, WOMAnimations.ANTITHEUS_WALK).livingMotionModifier((Style)CapabilityItem.Styles.TWO_HAND, (LivingMotion)LivingMotions.CHASE, WOMAnimations.ANTITHEUS_RUN).livingMotionModifier((Style)CapabilityItem.Styles.TWO_HAND, (LivingMotion)LivingMotions.RUN, WOMAnimations.ANTITHEUS_RUN).livingMotionModifier((Style)CapabilityItem.Styles.TWO_HAND, (LivingMotion)LivingMotions.SWIM, Animations.BIPED_HOLD_SPEAR).livingMotionModifier((Style)CapabilityItem.Styles.TWO_HAND, (LivingMotion)LivingMotions.BLOCK, WOMAnimations.ANTITHEUS_AIMING).livingMotionModifier((Style)CapabilityItem.Styles.OCHS, (LivingMotion)LivingMotions.IDLE, WOMAnimations.ANTITHEUS_ASCENDED_IDLE).livingMotionModifier((Style)CapabilityItem.Styles.OCHS, (LivingMotion)LivingMotions.WALK, WOMAnimations.ANTITHEUS_ASCENDED_WALK).livingMotionModifier((Style)CapabilityItem.Styles.OCHS, (LivingMotion)LivingMotions.CHASE, WOMAnimations.ANTITHEUS_ASCENDED_RUN).livingMotionModifier((Style)CapabilityItem.Styles.OCHS, (LivingMotion)LivingMotions.RUN, WOMAnimations.ANTITHEUS_ASCENDED_RUN).livingMotionModifier((Style)CapabilityItem.Styles.OCHS, (LivingMotion)LivingMotions.SWIM, Animations.BIPED_SWIM);
        return builder;
    };
    public static final Function<Item, CapabilityItem.Builder> HERRSCHER = item -> {
        WeaponCapability.Builder builder = WeaponCapability.builder().category((WeaponCategory)CapabilityItem.WeaponCategories.SWORD).styleProvider(playerpatch -> {
            if (playerpatch.getHoldingItemCapability(InteractionHand.OFF_HAND).getWeaponCategory() == CapabilityItem.WeaponCategories.SWORD && !((LivingEntity)playerpatch.getOriginal()).m_21120_(InteractionHand.OFF_HAND).m_150930_((Item)WOMItems.GESETZ.get())) {
                return CapabilityItem.Styles.TWO_HAND;
            }
            return CapabilityItem.Styles.ONE_HAND;
        }).collider(WOMWeaponColliders.HERSCHER).hitSound((SoundEvent)EpicFightSounds.BLADE_HIT.get()).comboCancel(style -> false).newStyleCombo((Style)CapabilityItem.Styles.TWO_HAND, new StaticAnimation[]{Animations.SWORD_DUAL_AUTO1, Animations.SWORD_DUAL_AUTO2, Animations.SWORD_DUAL_AUTO3, Animations.SWORD_DUAL_DASH, Animations.SWORD_DUAL_AIR_SLASH}).newStyleCombo((Style)CapabilityItem.Styles.ONE_HAND, new StaticAnimation[]{WOMAnimations.HERRSCHER_AUTO_1, WOMAnimations.HERRSCHER_AUTO_2, WOMAnimations.HERRSCHER_AUTO_3, WOMAnimations.HERRSCHER_VERDAMMNIS, WOMAnimations.HERRSCHER_AUSROTTUNG}).newStyleCombo((Style)CapabilityItem.Styles.MOUNT, new StaticAnimation[]{Animations.SWORD_MOUNT_ATTACK}).innateSkill((Style)CapabilityItem.Styles.ONE_HAND, itemstack -> WOMSkills.REGIERUNG).passiveSkill(WOMSkills.HERRSCHER_PASSIVE).innateSkill((Style)CapabilityItem.Styles.TWO_HAND, itemstack -> EpicFightSkills.DANCING_EDGE).livingMotionModifier((Style)CapabilityItem.Styles.TWO_HAND, (LivingMotion)LivingMotions.BLOCK, Animations.SWORD_DUAL_GUARD).livingMotionModifier((Style)CapabilityItem.Styles.ONE_HAND, (LivingMotion)LivingMotions.IDLE, WOMAnimations.HERRSCHER_IDLE).livingMotionModifier((Style)CapabilityItem.Styles.ONE_HAND, (LivingMotion)LivingMotions.WALK, WOMAnimations.HERRSCHER_WALK).livingMotionModifier((Style)CapabilityItem.Styles.ONE_HAND, (LivingMotion)LivingMotions.RUN, WOMAnimations.HERRSCHER_RUN).livingMotionModifier((Style)CapabilityItem.Styles.ONE_HAND, (LivingMotion)LivingMotions.BLOCK, WOMAnimations.HERRSCHER_GUARD).weaponCombinationPredicator(entitypatch -> EpicFightCapabilities.getItemStackCapability((ItemStack)((LivingEntity)entitypatch.getOriginal()).m_21206_()).getWeaponCategory() == CapabilityItem.WeaponCategories.SWORD);
        if (item instanceof TieredItem) {
            int harvestLevel = ((TieredItem)item).m_43314_().m_6604_();
            builder.addStyleAttibutes((Style)CapabilityItem.Styles.COMMON, Pair.of((Object)((Attribute)EpicFightAttributes.IMPACT.get()), (Object)EpicFightAttributes.getImpactModifier((double)(0.5 + 0.2 * (double)harvestLevel))));
            builder.addStyleAttibutes((Style)CapabilityItem.Styles.COMMON, Pair.of((Object)((Attribute)EpicFightAttributes.MAX_STRIKES.get()), (Object)EpicFightAttributes.getMaxStrikesModifier((int)1)));
        }
        return builder;
    };
    public static final Function<Item, CapabilityItem.Builder> GESETZ = item -> GesetzCapability.builder().constructor(GesetzCapability::new).category((WeaponCategory)CapabilityItem.WeaponCategories.SHIELD);
    public static final Function<Item, CapabilityItem.Builder> MOONLESS = item -> {
        WeaponCapability.Builder builder = WeaponCapability.builder().category((WeaponCategory)CapabilityItem.WeaponCategories.TACHI).styleProvider(entitypatch -> {
            PlayerPatch playerpatch;
            if (entitypatch instanceof PlayerPatch && (playerpatch = (PlayerPatch)entitypatch).getSkill((SkillSlot)SkillSlots.WEAPON_PASSIVE).getDataManager().hasData((SkillDataKey)WOMSkillDataKeys.VERSO.get()) && ((Boolean)playerpatch.getSkill((SkillSlot)SkillSlots.WEAPON_PASSIVE).getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.VERSO.get())).booleanValue()) {
                return CapabilityItem.Styles.OCHS;
            }
            return CapabilityItem.Styles.TWO_HAND;
        }).collider(WOMWeaponColliders.MOONLESS).hitSound((SoundEvent)EpicFightSounds.BLADE_HIT.get()).comboCancel(style -> false).canBePlacedOffhand(false).newStyleCombo((Style)CapabilityItem.Styles.TWO_HAND, new StaticAnimation[]{WOMAnimations.MOONLESS_AUTO_1, WOMAnimations.MOONLESS_AUTO_2, WOMAnimations.MOONLESS_AUTO_3, WOMAnimations.MOONLESS_REVERSED_BYPASS, WOMAnimations.MOONLESS_CRESCENT}).innateSkill((Style)CapabilityItem.Styles.TWO_HAND, itemstack -> WOMSkills.lUNAR_ECLIPSE).newStyleCombo((Style)CapabilityItem.Styles.OCHS, new StaticAnimation[]{WOMAnimations.MOONLESS_AUTO_1_VERSO, WOMAnimations.MOONLESS_AUTO_2_VERSO, WOMAnimations.MOONLESS_AUTO_3_VERSO, WOMAnimations.MOONLESS_BYPASS, WOMAnimations.MOONLESS_FULLMOON}).innateSkill((Style)CapabilityItem.Styles.OCHS, itemstack -> WOMSkills.lUNAR_ECLIPSE).newStyleCombo((Style)CapabilityItem.Styles.MOUNT, new StaticAnimation[]{Animations.SWORD_MOUNT_ATTACK}).passiveSkill(WOMSkills.LUNAR_ECHO_PASSIVE).livingMotionModifier((Style)CapabilityItem.Styles.TWO_HAND, (LivingMotion)LivingMotions.IDLE, WOMAnimations.MOONLESS_IDLE).livingMotionModifier((Style)CapabilityItem.Styles.TWO_HAND, (LivingMotion)LivingMotions.WALK, WOMAnimations.MOONLESS_WALK).livingMotionModifier((Style)CapabilityItem.Styles.TWO_HAND, (LivingMotion)LivingMotions.CHASE, WOMAnimations.MOONLESS_RUN).livingMotionModifier((Style)CapabilityItem.Styles.TWO_HAND, (LivingMotion)LivingMotions.RUN, WOMAnimations.MOONLESS_RUN).livingMotionModifier((Style)CapabilityItem.Styles.TWO_HAND, (LivingMotion)LivingMotions.SWIM, Animations.BIPED_HOLD_SPEAR).livingMotionModifier((Style)CapabilityItem.Styles.TWO_HAND, (LivingMotion)LivingMotions.BLOCK, WOMAnimations.MOONLESS_GUARD).livingMotionModifier((Style)CapabilityItem.Styles.OCHS, (LivingMotion)LivingMotions.IDLE, WOMAnimations.MOONLESS_IDLE).livingMotionModifier((Style)CapabilityItem.Styles.OCHS, (LivingMotion)LivingMotions.WALK, WOMAnimations.MOONLESS_WALK).livingMotionModifier((Style)CapabilityItem.Styles.OCHS, (LivingMotion)LivingMotions.CHASE, WOMAnimations.MOONLESS_RUN).livingMotionModifier((Style)CapabilityItem.Styles.OCHS, (LivingMotion)LivingMotions.RUN, WOMAnimations.MOONLESS_RUN).livingMotionModifier((Style)CapabilityItem.Styles.OCHS, (LivingMotion)LivingMotions.SWIM, Animations.BIPED_HOLD_SPEAR).livingMotionModifier((Style)CapabilityItem.Styles.OCHS, (LivingMotion)LivingMotions.BLOCK, WOMAnimations.MOONLESS_GUARD);
        return builder;
    };
    public static final Function<Item, CapabilityItem.Builder> SOLAR = item -> {
        WeaponCapability.Builder builder = WeaponCapability.builder().category((WeaponCategory)CapabilityItem.WeaponCategories.GREATSWORD).styleProvider(entitypatch -> {
            PlayerPatch playerpatch;
            if (entitypatch instanceof PlayerPatch && (playerpatch = (PlayerPatch)entitypatch).getSkill((SkillSlot)SkillSlots.WEAPON_INNATE).getDataManager().hasData((SkillDataKey)WOMSkillDataKeys.SOLAR_OBSCURIDAD.get()) && ((Boolean)playerpatch.getSkill((SkillSlot)SkillSlots.WEAPON_INNATE).getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.SOLAR_OBSCURIDAD.get())).booleanValue()) {
                return CapabilityItem.Styles.OCHS;
            }
            return CapabilityItem.Styles.TWO_HAND;
        }).collider(WOMWeaponColliders.SOLAR).hitSound((SoundEvent)EpicFightSounds.BLADE_HIT.get()).swingSound((SoundEvent)EpicFightSounds.WHOOSH_BIG.get()).canBePlacedOffhand(false).newStyleCombo((Style)CapabilityItem.Styles.TWO_HAND, new StaticAnimation[]{WOMAnimations.SOLAR_AUTO_1, WOMAnimations.SOLAR_AUTO_2, WOMAnimations.SOLAR_AUTO_3, WOMAnimations.SOLAR_AUTO_4, WOMAnimations.SOLAR_QUEMADURA, WOMAnimations.SOLAR_HORNO}).newStyleCombo((Style)CapabilityItem.Styles.OCHS, new StaticAnimation[]{WOMAnimations.SOLAR_OBSCURIDAD_AUTO_1, WOMAnimations.SOLAR_OBSCURIDAD_AUTO_2, WOMAnimations.SOLAR_OBSCURIDAD_AUTO_3, WOMAnimations.SOLAR_OBSCURIDAD_AUTO_4, WOMAnimations.SOLAR_OBSCURIDAD_IMPACTO, WOMAnimations.SOLAR_OBSCURIDAD_DINAMITA}).newStyleCombo((Style)CapabilityItem.Styles.MOUNT, new StaticAnimation[]{Animations.SWORD_MOUNT_ATTACK}).innateSkill((Style)CapabilityItem.Styles.TWO_HAND, itemstack -> WOMSkills.SOLAR_ARCANO).innateSkill((Style)CapabilityItem.Styles.OCHS, itemstack -> WOMSkills.SOLAR_ARCANO).passiveSkill(WOMSkills.SOLAR_PASSIVE).comboCancel(style -> false).livingMotionModifier((Style)CapabilityItem.Styles.TWO_HAND, (LivingMotion)LivingMotions.IDLE, WOMAnimations.SOLAR_IDLE).livingMotionModifier((Style)CapabilityItem.Styles.TWO_HAND, (LivingMotion)LivingMotions.WALK, WOMAnimations.SOLAR_WALK).livingMotionModifier((Style)CapabilityItem.Styles.TWO_HAND, (LivingMotion)LivingMotions.CHASE, WOMAnimations.SOLAR_RUN).livingMotionModifier((Style)CapabilityItem.Styles.TWO_HAND, (LivingMotion)LivingMotions.RUN, WOMAnimations.SOLAR_RUN).livingMotionModifier((Style)CapabilityItem.Styles.TWO_HAND, (LivingMotion)LivingMotions.SWIM, Animations.BIPED_HOLD_GREATSWORD).livingMotionModifier((Style)CapabilityItem.Styles.TWO_HAND, (LivingMotion)LivingMotions.BLOCK, WOMAnimations.SOLAR_GUARD).livingMotionModifier((Style)CapabilityItem.Styles.OCHS, (LivingMotion)LivingMotions.IDLE, WOMAnimations.SOLAR_OBSCURIDAD_IDLE).livingMotionModifier((Style)CapabilityItem.Styles.OCHS, (LivingMotion)LivingMotions.WALK, WOMAnimations.SOLAR_OBSCURIDAD_WALK).livingMotionModifier((Style)CapabilityItem.Styles.OCHS, (LivingMotion)LivingMotions.CHASE, WOMAnimations.SOLAR_OBSCURIDAD_RUN).livingMotionModifier((Style)CapabilityItem.Styles.OCHS, (LivingMotion)LivingMotions.RUN, WOMAnimations.SOLAR_OBSCURIDAD_RUN).livingMotionModifier((Style)CapabilityItem.Styles.OCHS, (LivingMotion)LivingMotions.SWIM, Animations.BIPED_HOLD_GREATSWORD).livingMotionModifier((Style)CapabilityItem.Styles.OCHS, (LivingMotion)LivingMotions.BLOCK, WOMAnimations.SOLAR_GUARD);
        return builder;
    };

    @SubscribeEvent
    public static void register(WeaponCapabilityPresetRegistryEvent event) {
        event.getTypeEntry().put(new ResourceLocation("wom", "staff"), STAFF);
        event.getTypeEntry().put(new ResourceLocation("wom", "agony"), AGONY);
        event.getTypeEntry().put(new ResourceLocation("wom", "torment"), TORMENT);
        event.getTypeEntry().put(new ResourceLocation("wom", "ruine"), RUINE);
        event.getTypeEntry().put(new ResourceLocation("wom", "satsujin"), SATSUJIN);
        event.getTypeEntry().put(new ResourceLocation("wom", "ender_blaster"), ENDER_BLASTER);
        event.getTypeEntry().put(new ResourceLocation("wom", "antitheus"), ANTITHEUS);
        event.getTypeEntry().put(new ResourceLocation("wom", "herrscher"), HERRSCHER);
        event.getTypeEntry().put(new ResourceLocation("wom", "gesetz"), GESETZ);
        event.getTypeEntry().put(new ResourceLocation("wom", "moonless"), MOONLESS);
        event.getTypeEntry().put(new ResourceLocation("wom", "solar"), SOLAR);
    }
}

