/*
 * Decompiled with CFR 0.152.
 */
package reascer.wom.world.entity.ai.goals;

import java.util.Random;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import reascer.wom.gameasset.WOMAnimationsEntity;
import reascer.wom.world.entity.mob.LupusRex;
import reascer.wom.world.entity.mobpatch.WomMobPatch;
import yesman.epicfight.api.animation.types.EntityState;

public class LupusRexAttackGoal<T extends WomMobPatch<?>>
extends Goal {
    protected final T mobpatch;

    public LupusRexAttackGoal(T mobpatch) {
        this.mobpatch = mobpatch;
    }

    public boolean m_6767_() {
        return true;
    }

    public boolean m_183429_() {
        return false;
    }

    public boolean m_8036_() {
        LupusRex lupusRex = (LupusRex)this.mobpatch.getOriginal();
        return this.checkTargetValid() && (Boolean)lupusRex.m_20088_().m_135370_(LupusRex.RUNNING_AROUND_TARGET) == false && !lupusRex.isOrderedToCome() && this.mobpatch.getEntityState().canBasicAttack();
    }

    /*
     * Enabled aggressive block sorting
     */
    public void m_8037_() {
        LupusRex lupusRex = (LupusRex)this.mobpatch.getOriginal();
        EntityState state = this.mobpatch.getEntityState();
        if (state.canBasicAttack() && state.inaction() && !((Boolean)lupusRex.m_20088_().m_135370_(LupusRex.RUNNING_AROUND_TARGET)).booleanValue() && lupusRex.m_21223_() < lupusRex.m_21233_() * 0.3f) {
            Random random = new Random();
            if (random.nextFloat(0.0f, 100.0f) < 30.0f && !this.mobpatch.getServerAnimator().animationPlayer.getAnimation().equals(WOMAnimationsEntity.LUPUS_REX_EXHAUSTED)) {
                this.mobpatch.playAnimationSynchronized(WOMAnimationsEntity.LUPUS_REX_EXHAUSTED, 0.0f);
                lupusRex.m_21573_().m_26573_();
                lupusRex.m_20334_(0.0, 0.0, 0.0);
                return;
            }
        }
        if (state.canBasicAttack()) {
            this.mobpatch.rotateTo((Entity)((Mob)this.mobpatch.getOriginal()).m_5448_(), 360.0f, false);
            ((Mob)this.mobpatch.getOriginal()).m_21563_().m_148051_((Entity)((Mob)this.mobpatch.getOriginal()).m_5448_());
        }
        boolean basicCombo = true;
        if (state.canBasicAttack() && this.mobpatch.getServerAnimator().animationPlayer.getAnimation().equals(WOMAnimationsEntity.LUPUS_REX_COUNTERATTACK)) {
            basicCombo = false;
            this.mobpatch.playAnimationSynchronized(WOMAnimationsEntity.LUPUS_REX_STRONG_BITE, 0.0f);
        }
        if (state.canBasicAttack() && this.mobpatch.getServerAnimator().animationPlayer.getAnimation().equals(WOMAnimationsEntity.LUPUS_REX_DODGE)) {
            basicCombo = false;
            Random random = new Random();
            if (random.nextFloat(0.0f, 100.0f) < 50.0f) {
                this.mobpatch.playAnimationSynchronized(WOMAnimationsEntity.LUPUS_REX_DASH_BITE, 0.0f);
            } else {
                this.mobpatch.playAnimationSynchronized(WOMAnimationsEntity.LUPUS_REX_BOMBE_BITE, 0.0f);
            }
        }
        if (state.canBasicAttack() && this.mobpatch.getServerAnimator().animationPlayer.getAnimation().equals(WOMAnimationsEntity.LUPUS_REX_STRONG_BITE)) {
            basicCombo = false;
            this.mobpatch.playAnimationSynchronized(WOMAnimationsEntity.LUPUS_REX_DODGE, 0.0f);
        }
        if (state.canBasicAttack() && this.mobpatch.getServerAnimator().animationPlayer.getAnimation().equals(WOMAnimationsEntity.LUPUS_REX_DASH_BITE)) {
            basicCombo = false;
            ((Mob)this.mobpatch.getOriginal()).m_21563_().m_24960_((Entity)((Mob)this.mobpatch.getOriginal()).m_5448_(), 30.0f, 30.0f);
            Random random = new Random();
            if (random.nextFloat(0.0f, 100.0f) < 65.0f) {
                this.mobpatch.playAnimationSynchronized(WOMAnimationsEntity.LUPUS_REX_DASH_BITE, 0.0f);
            } else {
                this.mobpatch.playAnimationSynchronized(WOMAnimationsEntity.LUPUS_REX_IDLE, 0.0f);
            }
        }
        if (state.canBasicAttack() && this.mobpatch.getServerAnimator().animationPlayer.getAnimation().equals(WOMAnimationsEntity.LUPUS_REX_WEAK_BITE)) {
            basicCombo = false;
            this.mobpatch.playAnimationSynchronized(WOMAnimationsEntity.LUPUS_REX_TAIL_WIPE, 0.0f);
        }
        if (state.canBasicAttack() && this.mobpatch.getServerAnimator().animationPlayer.getAnimation().equals(WOMAnimationsEntity.LUPUS_REX_TAIL_WIPE)) {
            basicCombo = false;
            ((Mob)this.mobpatch.getOriginal()).m_21563_().m_24960_((Entity)((Mob)this.mobpatch.getOriginal()).m_5448_(), 30.0f, 30.0f);
            Random random = new Random();
            if (random.nextFloat(0.0f, 100.0f) < 50.0f) {
                this.mobpatch.playAnimationSynchronized(WOMAnimationsEntity.LUPUS_REX_DASH_BITE, 0.0f);
            } else {
                this.mobpatch.playAnimationSynchronized(WOMAnimationsEntity.LUPUS_REX_DODGE, 0.0f);
            }
        }
        LivingEntity livingentity = ((Mob)this.mobpatch.getOriginal()).m_5448_();
        double distanceToTarget = ((Mob)this.mobpatch.getOriginal()).m_20275_(livingentity.m_20185_(), livingentity.m_20186_(), livingentity.m_20189_());
        if (!state.canBasicAttack()) return;
        if (!basicCombo) return;
        if (!(distanceToTarget < 9.0)) return;
        Random random = new Random();
        if (random.nextFloat(0.0f, 100.0f) < 50.0f) {
            this.mobpatch.playAnimationSynchronized(WOMAnimationsEntity.LUPUS_REX_STRONG_BITE, 0.0f);
            return;
        }
        this.mobpatch.playAnimationSynchronized(WOMAnimationsEntity.LUPUS_REX_WEAK_BITE, 0.0f);
    }

    private boolean checkTargetValid() {
        LivingEntity livingentity = ((Mob)this.mobpatch.getOriginal()).m_5448_();
        if (livingentity == null) {
            return false;
        }
        if (!livingentity.m_6084_()) {
            return false;
        }
        return !(livingentity instanceof Player) || !livingentity.m_5833_() && !((Player)livingentity).m_7500_();
    }
}

