/*
 * Decompiled with CFR 0.152.
 */
package reascer.wom.world.entity.ai.goals;

import java.util.Random;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import reascer.wom.gameasset.WOMAnimationsEntity;
import reascer.wom.world.entity.mob.LupusRex;
import reascer.wom.world.entity.mobpatch.WomMobPatch;
import yesman.epicfight.api.utils.math.OpenMatrix4f;
import yesman.epicfight.api.utils.math.Vec3f;

public class RunAroundTargetGoal<T extends WomMobPatch<?>>
extends Goal {
    protected final T mobpatch;
    public int timer;
    public int cooldown;
    public boolean side;

    public RunAroundTargetGoal(T mobpatch) {
        this.mobpatch = mobpatch;
    }

    public boolean m_6767_() {
        return true;
    }

    public boolean m_183429_() {
        return true;
    }

    public void m_8056_() {
        super.m_8056_();
        this.timer = 0;
        this.cooldown = -new Random().nextInt(40, 120);
        this.side = new Random().nextBoolean();
    }

    public void m_8041_() {
        super.m_8041_();
        LupusRex lupusRex = (LupusRex)this.mobpatch.getOriginal();
        this.timer = 0;
        this.cooldown = -new Random().nextInt(40, 120);
        this.side = new Random().nextBoolean();
        lupusRex.m_20088_().m_135381_(LupusRex.RUNNING_AROUND_TARGET, (Object)false);
    }

    public boolean m_8036_() {
        LupusRex lupusRex = (LupusRex)this.mobpatch.getOriginal();
        return this.checkTargetValid() && !((Mob)this.mobpatch.getOriginal()).m_21224_() && !lupusRex.isOrderedToCome();
    }

    public boolean m_8045_() {
        LupusRex lupusRex = (LupusRex)this.mobpatch.getOriginal();
        return this.checkTargetValid() && !((Mob)this.mobpatch.getOriginal()).m_21224_() && !lupusRex.isOrderedToCome();
    }

    public void m_8037_() {
        if (((Mob)this.mobpatch.getOriginal()).m_20184_().m_165924_() < 0.1) {
            this.side = !this.side;
        }
        LupusRex lupusRex = (LupusRex)this.mobpatch.getOriginal();
        if (this.timer == this.cooldown) {
            ((Mob)this.mobpatch.getOriginal()).m_21573_().m_26573_();
            lupusRex.m_20088_().m_135381_(LupusRex.RUNNING_AROUND_TARGET, (Object)true);
        } else if (this.timer == 0 && lupusRex.m_5448_() != null) {
            ((Mob)this.mobpatch.getOriginal()).m_21573_().m_5624_((Entity)lupusRex.m_5448_(), 1.4);
            lupusRex.m_20088_().m_135381_(LupusRex.RUNNING_AROUND_TARGET, (Object)false);
        }
        if (this.timer > this.cooldown) {
            if (this.timer > 0 && this.mobpatch.getEntityState().inaction()) {
                if (this.mobpatch.getEntityState().canBasicAttack()) {
                    this.mobpatch.playAnimationSynchronized(WOMAnimationsEntity.LUPUS_REX_RUN, 0.0f);
                }
            } else if (this.mobpatch.getEntityState().inaction() && !this.mobpatch.getServerAnimator().animationPlayer.getAnimation().equals(WOMAnimationsEntity.LUPUS_REX_DODGE) || this.timer > 0) {
                --this.timer;
            }
        } else {
            this.timer = new Random().nextInt(20, 100);
            this.cooldown = -new Random().nextInt(100, 200);
            this.side = new Random().nextBoolean();
        }
        LivingEntity targetEntity = this.mobpatch.getTarget();
        if (this.timer > 0 && !this.mobpatch.getEntityState().inaction() && targetEntity != null) {
            double distanceToTarget = ((Mob)this.mobpatch.getOriginal()).m_20275_(targetEntity.m_20185_(), targetEntity.m_20186_(), targetEntity.m_20189_());
            float angle = (float)(((Mob)this.mobpatch.getOriginal()).m_21051_(Attributes.f_22279_).m_22135_() * (double)8.1f);
            ((Mob)this.mobpatch.getOriginal()).m_21573_().m_26573_();
            if (Math.sqrt(distanceToTarget) < 10.0) {
                angle = -10.0f;
            } else if (Math.sqrt(distanceToTarget) > 11.0) {
                angle = 10.0f;
            }
            this.mobpatch.rotateTo((Entity)targetEntity, 360.0f, true);
            if (this.side) {
                this.mobpatch.rotateTo(this.mobpatch.getYRot() - 90.0f + angle, 360.0f, true);
            } else {
                this.mobpatch.rotateTo(this.mobpatch.getYRot() + 90.0f - angle, 360.0f, true);
            }
            ((Mob)this.mobpatch.getOriginal()).m_21563_().m_148051_((Entity)targetEntity);
            Vec3 forwardHorizontal = Vec3.m_82503_((Vec2)new Vec2(0.0f, ((Mob)this.mobpatch.getOriginal()).m_6080_()));
            Vec3 jumpDir = OpenMatrix4f.transform((OpenMatrix4f)OpenMatrix4f.createRotatorDeg((float)0.0f, (Vec3f)Vec3f.Y_AXIS), (Vec3)forwardHorizontal.m_82490_(((Mob)this.mobpatch.getOriginal()).m_21051_(Attributes.f_22279_).m_22135_() * 2.5));
            ((Mob)this.mobpatch.getOriginal()).m_20334_(jumpDir.f_82479_, ((Mob)this.mobpatch.getOriginal()).m_20184_().f_82480_, jumpDir.f_82481_);
        }
    }

    private boolean checkTargetValid() {
        LivingEntity livingentity = ((Mob)this.mobpatch.getOriginal()).m_5448_();
        if (livingentity == null) {
            return false;
        }
        if (!livingentity.m_6084_()) {
            return false;
        }
        return !(livingentity instanceof Player) || !livingentity.m_5833_() && !((Player)livingentity).m_7500_();
    }
}

