/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.werewolves.config;

import de.teamlapen.werewolves.config.BalanceConfig;
import de.teamlapen.werewolves.config.ClientConfig;
import de.teamlapen.werewolves.config.CommonConfig;
import de.teamlapen.werewolves.config.ServerConfig;
import de.teamlapen.werewolves.util.FormHelper;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.commons.lang3.tuple.Pair;

public class WerewolvesConfig {
    public static final ClientConfig CLIENT;
    public static final ServerConfig SERVER;
    public static final CommonConfig COMMON;
    public static final BalanceConfig BALANCE;
    private static final ForgeConfigSpec clientSpec;
    private static final ForgeConfigSpec serverSpec;
    private static final ForgeConfigSpec commonSpec;
    private static final ForgeConfigSpec balanceSpec;

    public static void registerConfigs() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)clientSpec);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)commonSpec);
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, (IConfigSpec)serverSpec);
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, (IConfigSpec)balanceSpec, "werewolves-balance.toml");
        FMLJavaModLoadingContext.get().getModEventBus().register(WerewolvesConfig.class);
    }

    @SubscribeEvent
    public static void onLoad(ModConfigEvent.Loading event) {
        if (event.getConfig().getType() == ModConfig.Type.SERVER) {
            FormHelper.reload();
        }
    }

    @SubscribeEvent
    public static void onReLoad(ModConfigEvent.Reloading event) {
        if (event.getConfig().getType() == ModConfig.Type.SERVER) {
            FormHelper.reload();
        }
    }

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(ClientConfig::new);
        clientSpec = (ForgeConfigSpec)specPair.getRight();
        CLIENT = (ClientConfig)specPair.getLeft();
        specPair = new ForgeConfigSpec.Builder().configure(ServerConfig::new);
        serverSpec = (ForgeConfigSpec)specPair.getRight();
        SERVER = (ServerConfig)specPair.getLeft();
        specPair = new ForgeConfigSpec.Builder().configure(CommonConfig::new);
        commonSpec = (ForgeConfigSpec)specPair.getRight();
        COMMON = (CommonConfig)specPair.getLeft();
        specPair = new ForgeConfigSpec.Builder().configure(BalanceConfig::new);
        balanceSpec = (ForgeConfigSpec)specPair.getRight();
        BALANCE = (BalanceConfig)specPair.getLeft();
    }
}

