/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.werewolves.entities.player;

import de.teamlapen.vampirism.api.entity.player.actions.ILastingAction;
import de.teamlapen.vampirism.api.entity.player.refinement.IRefinement;
import de.teamlapen.vampirism.api.entity.player.skills.ISkill;
import de.teamlapen.vampirism.entity.factions.FactionPlayerHandler;
import de.teamlapen.vampirism.entity.player.actions.ActionHandler;
import de.teamlapen.vampirism.items.VampirismItemBloodFoodItem;
import de.teamlapen.werewolves.api.WReference;
import de.teamlapen.werewolves.api.entities.werewolf.WerewolfForm;
import de.teamlapen.werewolves.api.items.ISilverItem;
import de.teamlapen.werewolves.config.WerewolvesConfig;
import de.teamlapen.werewolves.core.ModActions;
import de.teamlapen.werewolves.core.ModBlocks;
import de.teamlapen.werewolves.core.ModEffects;
import de.teamlapen.werewolves.core.ModItems;
import de.teamlapen.werewolves.core.ModRefinements;
import de.teamlapen.werewolves.core.ModSkills;
import de.teamlapen.werewolves.core.ModTags;
import de.teamlapen.werewolves.effects.SilverEffect;
import de.teamlapen.werewolves.effects.inst.UnWerewolfEffectInstance;
import de.teamlapen.werewolves.entities.player.werewolf.WerewolfPlayer;
import de.teamlapen.werewolves.entities.werewolf.WerewolfBaseEntity;
import de.teamlapen.werewolves.items.UnWerewolfInjectionItem;
import de.teamlapen.werewolves.mixin.LivingEntityAccessor;
import de.teamlapen.werewolves.util.Helper;
import de.teamlapen.werewolves.util.REFERENCE;
import java.util.Optional;
import java.util.stream.StreamSupport;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Equipable;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.TierSortingRegistry;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.EntityMountEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.living.LivingEquipmentChangeEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerFlyableFallEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.entity.player.PlayerWakeUpEvent;
import net.minecraftforge.event.entity.player.SleepingTimeCheckEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ModPlayerEventHandler {
    private static final Logger LOGGER = LogManager.getLogger();

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onAttachCapability(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof Player) {
            try {
                event.addCapability(REFERENCE.WEREWOLF_PLAYER_KEY, WerewolfPlayer.createNewCapability((Player)event.getObject()));
            }
            catch (Exception e) {
                LOGGER.error("Failed to attach capabilities to player. Player: {}", event.getObject());
                throw e;
            }
        }
    }

    @SubscribeEvent
    public void onFootEatenFinish(LivingEntityUseItemEvent.Finish event) {
        if (event.getEntity() instanceof Player && Helper.isWerewolf((Player)event.getEntity()) && event.getItem().m_41720_() instanceof VampirismItemBloodFoodItem) {
            event.getEntity().m_21195_(MobEffects.f_19604_);
        }
    }

    @SubscribeEvent
    public void onKilled(LivingDeathEvent event) {
        if (!Helper.isNoLiving(event.getEntity()) && event.getSource().m_7639_() instanceof Player && Helper.isWerewolf((Player)event.getSource().m_7639_())) {
            WerewolfPlayer player = WerewolfPlayer.get((Player)event.getSource().m_7639_());
            if (player.getSkillHandler().isSkillEnabled((ISkill)ModSkills.HEALTH_AFTER_KILL.get())) {
                ((Player)event.getSource().m_7639_()).m_7292_(new MobEffectInstance(MobEffects.f_19605_, player.getSkillHandler().isRefinementEquipped((IRefinement)ModRefinements.HEALTH_AFTER_KILL.get()) ? 5 : 4, 10));
            }
            ((Player)event.getSource().m_7639_()).m_36324_().m_38717_(((Player)event.getSource().m_7639_()).m_36324_().m_38722_() + 0.5f);
        }
    }

    @SubscribeEvent
    public void onFall(PlayerFlyableFallEvent event) {
        if (Helper.isWerewolf(event.getEntity())) {
            WerewolfPlayer werewolf = WerewolfPlayer.get(event.getEntity());
            if (werewolf.getSpecialAttributes().leap) {
                ((ActionHandler)werewolf.getActionHandler()).deactivateAction((ILastingAction)ModActions.LEAP.get(), false, true);
            }
        }
    }

    @SubscribeEvent
    public void onFall(LivingFallEvent event) {
        if (event.getEntity() instanceof Player && Helper.isWerewolf((Player)event.getEntity())) {
            WerewolfPlayer werewolf = WerewolfPlayer.get((Player)event.getEntity());
            if (werewolf.getSkillHandler().isSkillEnabled((ISkill)ModSkills.WOLF_PAWN.get())) {
                event.setDistance(event.getDistance() * 0.8f);
                event.setDamageMultiplier(event.getDamageMultiplier() * 0.8f);
            }
            if (werewolf.getSpecialAttributes().leap) {
                ((ActionHandler)werewolf.getActionHandler()).deactivateAction((ILastingAction)ModActions.LEAP.get(), false, true);
            }
            if (werewolf.getForm().isTransformed() && werewolf.getSkillHandler().isSkillEnabled((ISkill)ModSkills.JUMP.get())) {
                event.setDistance(event.getDistance() - 0.5f);
            }
        }
    }

    @SubscribeEvent
    public void onEquipmentChange(LivingEquipmentChangeEvent event) {
        LivingEntity livingEntity;
        if (event.getSlot() == EquipmentSlot.MAINHAND && (livingEntity = event.getEntity()) instanceof Player) {
            Player player = (Player)livingEntity;
            WerewolfPlayer.getOpt(player).ifPresent(s -> s.checkToolDamage(event.getFrom(), event.getTo(), false));
        }
    }

    @SubscribeEvent
    public void onJump(LivingEvent.LivingJumpEvent event) {
        if (event.getEntity() instanceof Player && Helper.isWerewolf((Player)event.getEntity())) {
            LivingEntity entity = event.getEntity();
            WerewolfPlayer werewolf = WerewolfPlayer.get((Player)entity);
            if (werewolf.getSkillHandler().isSkillEnabled((ISkill)ModSkills.WOLF_PAWN.get())) {
                Vec3 motion = entity.m_20184_().m_82542_(1.1, 1.2, 1.1);
                entity.m_20256_(motion);
            }
            if (werewolf.getActionHandler().isActionActive((ILastingAction)ModActions.LEAP.get()) && !werewolf.getSpecialAttributes().leap) {
                werewolf.getSpecialAttributes().leap = true;
                Vec3 viewVector = entity.m_20252_(0.0f);
                Vec3 leap = new Vec3(viewVector.f_82479_, (double)((LivingEntityAccessor)entity).invokeGetJumpPower_werewolves() * 0.5, viewVector.f_82481_);
                float leapModifier = werewolf.getForm().getLeapModifier();
                entity.m_246865_(leap.m_82542_((double)leapModifier, (double)leapModifier, (double)leapModifier));
            }
            if (werewolf.getForm().isTransformed() && werewolf.getSkillHandler().isSkillEnabled((ISkill)ModSkills.JUMP.get())) {
                entity.m_246865_(new Vec3(0.0, 0.05, 0.0));
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onWakeUp(PlayerWakeUpEvent event) {
        if (!event.getEntity().m_9236_().f_46443_ && event.getEntity().m_21124_((MobEffect)ModEffects.LUPUS_SANGUINEM.get()) != null) {
            event.getEntity().m_21124_((MobEffect)ModEffects.LUPUS_SANGUINEM.get()).m_19550_((LivingEntity)event.getEntity());
            event.getEntity().m_21195_((MobEffect)ModEffects.LUPUS_SANGUINEM.get());
        }
    }

    @SubscribeEvent
    public void onItemUseEntity(PlayerInteractEvent.EntityInteract event) {
        if (event.getEntity().m_21120_(event.getHand()).m_41720_() == ModItems.V.INJECTION_EMPTY.get() && event.getTarget() instanceof WerewolfBaseEntity) {
            event.getEntity().m_21120_(event.getHand()).m_41774_(1);
            event.getEntity().m_36356_(((UnWerewolfInjectionItem)((Object)ModItems.INJECTION_UN_WEREWOLF.get())).m_7968_());
        }
    }

    @SubscribeEvent
    public void onItemUseBlock(PlayerInteractEvent.RightClickBlock event) {
        Player player = event.getEntity();
        if (player.m_21120_(event.getHand()).m_41720_() == ModItems.INJECTION_UN_WEREWOLF.get()) {
            if (event.getLevel().m_8055_(event.getPos()).m_60734_() == ModBlocks.V.MED_CHAIR.get()) {
                ItemStack stack = player.m_21120_(event.getHand());
                if (player.m_6084_()) {
                    FactionPlayerHandler.getOpt((Player)event.getEntity()).resolve().map(FactionPlayerHandler::getCurrentFaction).filter(faction -> {
                        if (WReference.WEREWOLF_FACTION.equals(faction)) {
                            if (player.m_21124_((MobEffect)ModEffects.UN_WEREWOLF.get()) == null) {
                                player.m_7292_((MobEffectInstance)new UnWerewolfEffectInstance(2000));
                                return true;
                            }
                            player.m_5661_((Component)Component.m_237115_((String)"text.werewolves.injection.in_use"), true);
                        } else {
                            player.m_5661_((Component)Component.m_237115_((String)"text.werewolves.injection.not_use"), true);
                        }
                        return false;
                    }).ifPresent(f -> {
                        stack.m_41774_(1);
                        if (stack.m_41619_()) {
                            player.m_150109_().m_36057_(stack);
                        }
                    });
                }
            }
            event.setCancellationResult(InteractionResult.SUCCESS);
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void useItem(PlayerInteractEvent.RightClickItem event) {
        Equipable equip;
        Item item;
        if (Helper.isWerewolf(event.getEntity()) && (item = event.getItemStack().m_41720_()) instanceof Equipable && (equip = (Equipable)item).m_40402_().m_254934_()) {
            WerewolfPlayer.getOpt(event.getEntity()).ifPresent(s -> {
                if (!s.canWearArmor(event.getItemStack())) {
                    event.setCancellationResult(InteractionResult.FAIL);
                    event.setCanceled(true);
                    event.getEntity().m_5661_((Component)Component.m_237115_((String)"text.werewolves.equipment.equip_failed"), true);
                }
            });
        }
    }

    @SubscribeEvent
    public void playerSize(EntityEvent.Size event) {
        LazyOptional<WerewolfPlayer> werewolf;
        Optional size;
        Player player;
        Entity entity = event.getEntity();
        if (entity instanceof Player && (player = (Player)entity).m_150109_() != null && event.getEntity().m_6084_() && (size = (werewolf = WerewolfPlayer.getOpt((Player)event.getEntity())).map(WerewolfPlayer::getForm).flatMap(form -> form.getSize(event.getPose()))).isPresent()) {
            event.setNewSize((EntityDimensions)size.get());
            event.setNewEyeHeight(((EntityDimensions)size.get()).f_20378_ * 0.85f);
        }
    }

    @SubscribeEvent
    public void onPlayerAttacked(LivingAttackEvent event) {
        int sum;
        LivingEntity source;
        Player player;
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player && Helper.isWerewolf(player = (Player)livingEntity)) {
            WerewolfPlayer.getOpt(player).filter(w -> w.getForm() == WerewolfForm.SURVIVALIST).map(WerewolfPlayer::getSkillHandler).ifPresent(skillHandler -> {
                if (player.m_20184_().m_82556_() > 0.01 && skillHandler.isSkillEnabled((ISkill)ModSkills.ARROW_AWARENESS.get()) && event.getSource().m_276093_(DamageTypes.f_268739_) && (double)event.getEntity().m_217043_().m_188501_() < 0.4) {
                    event.setCanceled(true);
                } else if (player.m_20142_() && event.getSource().m_7639_() != null && skillHandler.isSkillEnabled((ISkill)ModSkills.MOVEMENT_TACTICS.get())) {
                    float limit = ((Double)WerewolvesConfig.BALANCE.SKILLS.movement_tactics_doge_chance.get()).floatValue();
                    if (skillHandler.isRefinementEquipped((IRefinement)ModRefinements.GREATER_DOGE_CHANCE.get())) {
                        limit += ((Double)WerewolvesConfig.BALANCE.REFINEMENTS.greater_doge_chance.get()).floatValue();
                    }
                    if (player.m_217043_().m_188501_() < limit) {
                        event.setCanceled(true);
                    }
                }
            });
            if (!event.isCanceled() && event.getSource().m_269533_(ModTags.DamageTypes.WEREWOLF_FUR_IMMUNE) && WerewolfPlayer.getOpt(player).filter(w -> w.getForm().isTransformed()).map(w -> w.getSkillHandler().isSkillEnabled((ISkill)ModSkills.WOLF_PAWN.get())).orElse(false).booleanValue()) {
                event.setCanceled(true);
            }
        }
        if (event.getSource().m_276093_(DamageTypes.f_268566_) && (livingEntity = event.getSource().m_7640_()) instanceof LivingEntity && Helper.isWerewolf((Entity)(source = livingEntity)) && (sum = StreamSupport.stream(event.getEntity().m_6168_().spliterator(), false).mapToInt(stack -> stack.m_41720_() instanceof ISilverItem ? 1 : 0).sum()) > 0) {
            source.m_7292_(SilverEffect.createSilverEffect(source, (Integer)WerewolvesConfig.BALANCE.UTIL.silverArmorAttackEffectDuration.get() * sum, 0));
        }
    }

    @SubscribeEvent
    public void onPlayerHurt(LivingHurtEvent event) {
        MobEffectInstance effect;
        Player player;
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player && Helper.isWerewolf(player = (Player)livingEntity) && (effect = player.m_21124_((MobEffect)ModEffects.SILVER.get())) != null) {
            event.setAmount(event.getAmount() * (1.0f + (float)(effect.m_19564_() + 1) * 0.1f));
        }
    }

    @SubscribeEvent
    public void onMountEvent(EntityMountEvent event) {
        if (event.isMounting() && WerewolfPlayer.getOptEx(event.getEntityMounting()).map(p -> !p.getForm().isHumanLike()).orElse(false).booleanValue()) {
            event.setCanceled(true);
            ((Player)event.getEntityMounting()).m_5661_((Component)Component.m_237115_((String)"text.werewolves.nomount.transformed"), true);
        }
    }

    @SubscribeEvent
    public void onSleepTime(SleepingTimeCheckEvent event) {
    }

    @SubscribeEvent
    public void isCorrectToolForDrop(PlayerEvent.HarvestCheck event) {
        if (!event.canHarvest() && Helper.isWerewolf(event.getEntity())) {
            WerewolfPlayer.getOpt(event.getEntity()).filter(a -> a.getForm().isTransformed()).ifPresent(werewolf -> event.setCanHarvest(event.getEntity().m_21205_().m_41619_() && werewolf.getDigDropTier().map(tier -> TierSortingRegistry.isCorrectTierForDrops((Tier)tier, (BlockState)event.getTargetBlock())).orElse(false) != false && (event.getTargetBlock().m_204336_(BlockTags.f_144282_) || event.getTargetBlock().m_204336_(BlockTags.f_144283_) || event.getTargetBlock().m_204336_(BlockTags.f_144281_))));
        }
    }

    @SubscribeEvent
    public void tickTool(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.END && Helper.isWerewolf(event.player)) {
            if (Helper.isSilverItem(event.player.m_21205_()) || Helper.isSilverItem(event.player.m_21206_()) && event.player.m_9236_().m_46467_() % 10L == 0L) {
                event.player.m_7292_(SilverEffect.createSilverEffect((LivingEntity)event.player, 20, 1, true));
            }
            if (StreamSupport.stream(event.player.m_6168_().spliterator(), false).anyMatch(Helper::isSilverItem)) {
                event.player.m_7292_(SilverEffect.createSilverEffect((LivingEntity)event.player, 20, 1, true));
            }
        }
    }
}

