/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.werewolves.network;

import de.teamlapen.lib.network.IMessage;
import de.teamlapen.werewolves.WerewolvesMod;
import de.teamlapen.werewolves.api.entities.werewolf.WerewolfForm;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public record ServerboundWerewolfAppearancePacket(int entityId, String name, WerewolfForm form, int[] data) implements IMessage.IServerBoundMessage
{
    static void encode(ServerboundWerewolfAppearancePacket msg, FriendlyByteBuf buf) {
        buf.m_130130_(msg.entityId);
        buf.m_130070_(msg.name);
        buf.m_130070_(msg.form.getName());
        buf.m_130130_(msg.data.length);
        for (int value : msg.data) {
            buf.m_130130_(value);
        }
    }

    static ServerboundWerewolfAppearancePacket decode(FriendlyByteBuf buf) {
        int entityId = buf.m_130242_();
        String newName = buf.m_130136_(15);
        String form = buf.m_130136_(Short.MAX_VALUE);
        int[] data = new int[buf.m_130242_()];
        for (int i = 0; i < data.length; ++i) {
            data[i] = buf.m_130242_();
        }
        return new ServerboundWerewolfAppearancePacket(entityId, newName, WerewolfForm.getForm(form), data);
    }

    public static void handle(ServerboundWerewolfAppearancePacket msg, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context ctx = contextSupplier.get();
        ctx.enqueueWork(() -> WerewolvesMod.proxy.handleAppearancePacket(ctx.getSender(), msg));
        ctx.setPacketHandled(true);
    }
}

