/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.client.gui;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import io.wispforest.accessories.Accessories;
import io.wispforest.accessories.AccessoriesInternals;
import io.wispforest.accessories.api.AccessoriesContainer;
import io.wispforest.accessories.api.slot.SlotGroup;
import io.wispforest.accessories.api.slot.SlotType;
import io.wispforest.accessories.api.slot.UniqueSlotHandling;
import io.wispforest.accessories.client.AccessoriesMenu;
import io.wispforest.accessories.client.GuiGraphicsUtils;
import io.wispforest.accessories.client.gui.AccessoriesInternalSlot;
import io.wispforest.accessories.client.gui.SpriteGetter;
import io.wispforest.accessories.client.gui.ToggleButton;
import io.wispforest.accessories.data.EntitySlotLoader;
import io.wispforest.accessories.data.SlotGroupLoader;
import io.wispforest.accessories.impl.ExpandedSimpleContainer;
import io.wispforest.accessories.impl.SlotGroupImpl;
import io.wispforest.accessories.mixin.client.ScreenAccessor;
import io.wispforest.accessories.networking.holder.HolderProperty;
import io.wispforest.accessories.networking.holder.SyncHolderChange;
import io.wispforest.accessories.networking.server.MenuScroll;
import io.wispforest.accessories.pond.ContainerScreenExtension;
import it.unimi.dsi.fastutil.Pair;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import org.apache.commons.lang3.Range;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix3f;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector2i;
import org.joml.Vector2ic;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.joml.Vector3f;
import org.joml.Vector4i;

public class AccessoriesScreen
extends AbstractContainerScreen<AccessoriesMenu>
implements ContainerScreenExtension {
    private static final ResourceLocation SLOT = Accessories.of("textures/gui/slot.png");
    private static final ResourceLocation ACCESSORIES_INVENTORY_LOCATION = Accessories.of("textures/gui/container/accessories_inventory.png");
    private static final ResourceLocation BACKGROUND_PATCH = Accessories.of("background_patch");
    private static final ResourceLocation SCROLL_BAR_PATCH = Accessories.of("scroll_bar_patch");
    private static final ResourceLocation SCROLL_BAR = Accessories.of("scroll_bar");
    private static final ResourceLocation HORIZONTAL_TABS;
    public static final SpriteGetter<AbstractButton> SPRITES_12X12;
    public static final SpriteGetter<AbstractButton> SPRITES_8X8;
    private static final ResourceLocation BACk_ICON;
    private static final ResourceLocation LINE_HIDDEN;
    private static final ResourceLocation LINE_SHOWN;
    private static final ResourceLocation UNUSED_SLOTS_HIDDEN;
    private static final ResourceLocation UNUSED_SLOTS_SHOWN;
    public static Vector4i SCISSOR_BOX;
    public static boolean IS_RENDERING_UI_ENTITY;
    public static boolean IS_RENDERING_LINE_TARGET;
    public static boolean COLLECT_ACCESSORY_POSITIONS;
    public static final Map<String, Vector3d> NOT_VERY_NICE_POSITIONS;
    public static boolean FORCE_TOOLTIP_LEFT;
    private final List<Pair<Vector3d, Vector3d>> accessoryLines = new ArrayList<Pair<Vector3d, Vector3d>>();
    private final List<Vector3d> accessoryPositions = new ArrayList<Vector3d>();
    private final Map<AccessoriesInternalSlot, ToggleButton> cosmeticButtons = new LinkedHashMap<AccessoriesInternalSlot, ToggleButton>();
    private int currentTabPage = 1;
    private int scrollBarHeight = 0;
    private boolean isScrolling = false;
    private static final int upperPadding = 8;
    private Button backButton = null;
    private Button cosmeticToggleButton = null;
    private Button linesToggleButton = null;
    private Button unusedSlotsToggleButton = null;
    private Button uniqueSlotsToggleButton = null;
    private Button tabUpButton = null;
    private Button tabDownButton = null;

    public AccessoriesScreen(AccessoriesMenu menu, Inventory inventory, Component component) {
        super((AbstractContainerMenu)menu, inventory, (Component)Component.m_237119_());
        this.f_97728_ = 97;
        this.f_97730_ = 42069;
    }

    public int getPanelHeight() {
        return this.getPanelHeight(8);
    }

    public int getPanelHeight(int upperPadding) {
        return 14 + Math.min(((AccessoriesMenu)this.f_97732_).totalSlots, 8) * 18 + upperPadding;
    }

    public int getPanelWidth() {
        int width = 44;
        if (((AccessoriesMenu)this.f_97732_).isCosmeticsOpen()) {
            width += 20;
        }
        if (!((AccessoriesMenu)this.f_97732_).overMaxVisibleSlots) {
            width -= 12;
        }
        return width;
    }

    public int getStartingPanelX() {
        int x = this.f_97735_ - (((AccessoriesMenu)this.f_97732_).isCosmeticsOpen() ? 72 : 52);
        if (!((AccessoriesMenu)this.f_97732_).overMaxVisibleSlots) {
            x += 12;
        }
        return x;
    }

    public int leftPos() {
        return this.f_97735_;
    }

    public int topPos() {
        return this.f_97736_;
    }

    public final LivingEntity targetEntityDefaulted() {
        LivingEntity targetEntity = ((AccessoriesMenu)this.f_97732_).targetEntity();
        return targetEntity != null ? targetEntity : this.f_96541_.f_91074_;
    }

    protected boolean insideScrollbar(double mouseX, double mouseY) {
        int x = this.getStartingPanelX() + 13;
        int y = this.f_97736_ + 7 + 8;
        int height = this.getPanelHeight() - 22;
        int width = 8;
        return ((AccessoriesMenu)this.f_97732_).overMaxVisibleSlots && mouseX >= (double)x && mouseY >= (double)y && mouseX < (double)(x + width) && mouseY < (double)(y + height);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        boolean bl = super.m_6375_(mouseX, mouseY, button);
        if (this.m_7222_() instanceof Button) {
            ((ScreenAccessor)((Object)this)).call$clearFocus();
        }
        if (this.insideScrollbar(mouseX, mouseY)) {
            this.isScrolling = true;
            return true;
        }
        if (Accessories.getConfig().clientData.showGroupTabs && ((AccessoriesMenu)this.f_97732_).maxScrollableIndex() > 0) {
            int x = this.getStartingPanelX();
            int y = this.f_97736_;
            for (SlotGroupData value : this.getGroups(x, y).values()) {
                if (!value.isInBounds((int)Math.round(mouseX), (int)Math.round(mouseY))) continue;
                int index = value.startingIndex;
                if (index > ((AccessoriesMenu)this.f_97732_).maxScrollableIndex()) {
                    index = ((AccessoriesMenu)this.f_97732_).maxScrollableIndex();
                }
                if (index == ((AccessoriesMenu)this.f_97732_).scrolledIndex) break;
                AccessoriesInternals.getNetworkHandler().sendToServer(new MenuScroll(index, false));
                Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_263171_((Holder)SoundEvents.f_12490_, (float)1.0f));
                break;
            }
        }
        return bl;
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        if (!this.insideScrollbar(mouseX, mouseY) && button == 0) {
            this.isScrolling = false;
        }
        return super.m_6348_(mouseX, mouseY, button);
    }

    protected void m_7286_(GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        AccessoriesInternalSlot slot2;
        Slot slot3;
        this.m_280273_(guiGraphics);
        int leftPos = this.f_97735_;
        int topPos = this.f_97736_;
        guiGraphics.m_280218_(ACCESSORIES_INVENTORY_LOCATION, leftPos, topPos, 0, 0, this.f_97726_, this.f_97727_);
        Vector2i scissorStart = new Vector2i(leftPos + 26, topPos + 8);
        Vector2i scissorEnd = new Vector2i(leftPos + 26 + 124, topPos + 8 + 70);
        Vector2i size = new Vector2i((scissorEnd.x - scissorStart.x) / 2, scissorEnd.y - scissorStart.y);
        SCISSOR_BOX.set(scissorStart.x, scissorStart.y, scissorEnd.x, scissorEnd.y);
        COLLECT_ACCESSORY_POSITIONS = Accessories.getConfig().clientData.hoverOptions.hoveredOptions.line || Accessories.getConfig().clientData.hoverOptions.hoveredOptions.clickbait;
        IS_RENDERING_UI_ENTITY = true;
        IS_RENDERING_LINE_TARGET = true;
        this.renderEntityInInventoryFollowingMouseRotated(guiGraphics, scissorStart, size, scissorStart, scissorEnd, mouseX, mouseY, 0.0f);
        IS_RENDERING_LINE_TARGET = false;
        this.renderEntityInInventoryFollowingMouseRotated(guiGraphics, new Vector2i((Vector2ic)scissorStart).add(size.x, 0), size, scissorStart, scissorEnd, mouseX, mouseY, 180.0f);
        IS_RENDERING_UI_ENTITY = false;
        COLLECT_ACCESSORY_POSITIONS = false;
        PoseStack pose = guiGraphics.m_280168_();
        pose.m_85836_();
        pose.m_252880_(0.0f, 0.0f, 0.0f);
        int x = this.getStartingPanelX();
        int y = this.f_97736_;
        int height = this.getPanelHeight();
        int width = this.getPanelWidth();
        GuiGraphicsUtils.blitSpriteBatched(guiGraphics, BACKGROUND_PATCH, x + 6, y, width, height);
        if (((AccessoriesMenu)this.f_97732_).overMaxVisibleSlots) {
            GuiGraphicsUtils.blitSpriteBatched(guiGraphics, SCROLL_BAR_PATCH, x + 13, y + 7 + 8, 8, height - 22);
        }
        pose.m_85849_();
        pose.m_85836_();
        pose.m_252880_(-1.0f, -1.0f, 0.0f);
        GuiGraphicsUtils.batched(guiGraphics, SLOT, ((AccessoriesMenu)this.f_97732_).f_38839_, (bufferBuilder, poseStack, slot) -> {
            if (!(slot.f_40218_ instanceof ExpandedSimpleContainer) || !slot.m_6659_()) {
                return;
            }
            GuiGraphicsUtils.blit(bufferBuilder, poseStack, slot.f_40220_ + this.f_97735_, slot.f_40221_ + this.f_97736_, 18);
        });
        if (this.getHoveredSlot() != null && (slot3 = this.getHoveredSlot()) instanceof AccessoriesInternalSlot && (slot2 = (AccessoriesInternalSlot)slot3).m_6659_() && !slot2.m_7993_().m_41619_() && NOT_VERY_NICE_POSITIONS.containsKey(slot2.accessoriesContainer.getSlotName() + slot2.m_150661_())) {
            this.accessoryPositions.add(NOT_VERY_NICE_POSITIONS.get(slot2.accessoriesContainer.getSlotName() + slot2.m_150661_()));
            String positionKey = slot2.accessoriesContainer.getSlotName() + slot2.m_150661_();
            Vector3d vec = NOT_VERY_NICE_POSITIONS.getOrDefault(positionKey, null);
            if (!slot2.isCosmetic && vec != null && ((AccessoriesMenu)this.f_97732_).areLinesShown()) {
                Vector3d start = new Vector3d((double)(slot2.f_40220_ + this.f_97735_ + 17), (double)(slot2.f_40221_ + this.f_97736_ + 9), 5000.0);
                Vector3d vec3 = vec.add(0.0, 0.0, 5000.0);
                this.accessoryLines.add((Pair<Vector3d, Vector3d>)Pair.of((Object)start, (Object)vec3));
            }
        }
        pose.m_85849_();
    }

    public boolean m_6050_(double mouseX, double mouseY, double scrollY) {
        int index;
        if ((this.insideScrollbar(mouseX, mouseY) || Accessories.getConfig().clientData.allowSlotScrolling && this.f_97734_ instanceof AccessoriesInternalSlot) && (index = (int)Math.max(Math.min(-scrollY + (double)((AccessoriesMenu)this.f_97732_).scrolledIndex, (double)((AccessoriesMenu)this.f_97732_).maxScrollableIndex()), 0.0)) != ((AccessoriesMenu)this.f_97732_).scrolledIndex) {
            AccessoriesInternals.getNetworkHandler().sendToServer(new MenuScroll(index, false));
            return true;
        }
        return super.m_6050_(mouseX, mouseY, scrollY);
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.isScrolling) {
            int patchYOffset = this.f_97736_ + 7 + 8;
            int height = this.getPanelHeight();
            ((AccessoriesMenu)this.f_97732_).smoothScroll = Mth.m_14036_((float)((float)(mouseY - (double)patchYOffset) / ((float)height - 22.0f)), (float)0.0f, (float)1.0f);
            int index = Math.round(((AccessoriesMenu)this.f_97732_).smoothScroll * (float)((AccessoriesMenu)this.f_97732_).maxScrollableIndex());
            if (index != ((AccessoriesMenu)this.f_97732_).scrolledIndex) {
                AccessoriesInternals.getNetworkHandler().sendToServer(new MenuScroll(index, true));
                return true;
            }
        }
        return super.m_7979_(mouseX, mouseY, button, dragX, dragY);
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
        for (ToggleButton cosmeticButton : this.cosmeticButtons.values()) {
            cosmeticButton.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
        }
        int x = this.getStartingPanelX();
        int y = this.f_97736_;
        int panelHeight = this.getPanelHeight();
        if (((AccessoriesMenu)this.f_97732_).overMaxVisibleSlots) {
            int startingY = y + 8 + 8;
            startingY = (int)((float)startingY + ((AccessoriesMenu)this.f_97732_).smoothScroll * (float)(panelHeight - 24 - this.scrollBarHeight));
            GuiGraphicsUtils.blitSpriteBatched(guiGraphics, SCROLL_BAR, x + 14, startingY, 6, this.scrollBarHeight);
        }
        PoseStack pose = guiGraphics.m_280168_();
        if (Accessories.getConfig().clientData.showGroupTabs) {
            for (Map.Entry<SlotGroup, SlotGroupData> entry : this.getGroups(x, y).entrySet()) {
                SlotGroup group = entry.getKey();
                SlotGroupData pair = entry.getValue();
                Vector4i vector = pair.dimensions();
                int v = pair.isSelected() ? vector.w : vector.w * 3;
                guiGraphics.m_280163_(HORIZONTAL_TABS, vector.x, vector.y, 0.0f, (float)v, vector.z, vector.w, 19, vector.w * 4);
                pose.m_85836_();
                pose.m_252880_((float)(vector.x + 3), (float)(vector.y + 3), 0.0f);
                pose.m_252880_(1.0f, 1.0f, 0.0f);
                if (pair.isSelected) {
                    pose.m_252880_(2.0f, 0.0f, 0.0f);
                }
                guiGraphics.m_280163_(group.icon().m_246208_("textures/").m_266382_(".png"), 0, 0, 0.0f, 0.0f, 8, 8, 8, 8);
                pose.m_85849_();
            }
        }
        if (Accessories.getConfig().clientData.hoverOptions.hoveredOptions.clickbait) {
            this.accessoryPositions.forEach(pos -> {
                PoseStack matrix = guiGraphics.m_280168_();
                matrix.m_85836_();
                matrix.m_252880_((float)pos.x - 128.0f, (float)pos.y - 128.0f, 200.0f);
                matrix.m_85841_(0.5f, 0.5f, 0.0f);
                guiGraphics.m_280398_(Accessories.of("textures/gui/sprites/highlight/clickbait.png"), 0, 0, 0, 0.0f, 0.0f, 512, 512, 512, 512);
                matrix.m_85849_();
            });
            this.accessoryPositions.clear();
        }
        this.m_280072_(guiGraphics, mouseX, mouseY);
        if (!this.accessoryLines.isEmpty() && Accessories.getConfig().clientData.hoverOptions.hoveredOptions.line) {
            VertexConsumer buf = guiGraphics.m_280091_().m_6299_((RenderType)RenderType.f_110371_);
            Matrix3f lastPose = guiGraphics.m_280168_().m_85850_().m_252943_();
            for (Pair<Vector3d, Vector3d> line : this.accessoryLines) {
                Vector3f normalVec = ((Vector3d)line.second()).sub((Vector3dc)line.first(), new Vector3d()).normalize().get(new Vector3f());
                double segments = Math.max(10, (int)(((Vector3d)line.first()).distance((Vector3dc)line.second()) * 10.0) / 100);
                double movement = (double)System.currentTimeMillis() / ((segments *= 2.0) * 1000.0) % 1.0;
                double delta = movement % (2.0 / segments) % segments;
                Vector3f firstVec = ((Vector3d)line.first()).get(new Vector3f());
                if (delta > 0.05) {
                    buf.m_5483_((double)firstVec.x(), (double)firstVec.y(), (double)firstVec.z()).m_6122_(255, 255, 255, 255).m_86008_(OverlayTexture.f_118083_).m_85969_(240).m_252939_(lastPose, normalVec.x, normalVec.y, normalVec.z).m_5752_();
                    Vector3f pos2 = new Vector3d(Mth.m_14139_((double)(delta - 0.05), (double)((Vector3d)line.first()).x, (double)((Vector3d)line.second()).x), Mth.m_14139_((double)(delta - 0.05), (double)((Vector3d)line.first()).y, (double)((Vector3d)line.second()).y), Mth.m_14139_((double)(delta - 0.05), (double)((Vector3d)line.first()).z, (double)((Vector3d)line.second()).z)).get(new Vector3f());
                    buf.m_5483_((double)pos2.x(), (double)pos2.y(), (double)pos2.z()).m_6122_(255, 255, 255, 255).m_86008_(OverlayTexture.f_118083_).m_85969_(240).m_252939_(lastPose, normalVec.x, normalVec.y, normalVec.z).m_5752_();
                }
                int i = 0;
                while ((double)i < segments / 2.0) {
                    double delta1 = ((double)(i * 2) / segments + movement) % 1.0;
                    double delta2 = ((double)(i * 2 + 1) / segments + movement) % 1.0;
                    Vector3f pos1 = new Vector3d(Mth.m_14139_((double)delta1, (double)((Vector3d)line.first()).x, (double)((Vector3d)line.second()).x), Mth.m_14139_((double)delta1, (double)((Vector3d)line.first()).y, (double)((Vector3d)line.second()).y), Mth.m_14139_((double)delta1, (double)((Vector3d)line.first()).z, (double)((Vector3d)line.second()).z)).get(new Vector3f());
                    Vector3f pos2 = (delta2 > delta1 ? new Vector3d(Mth.m_14139_((double)delta2, (double)((Vector3d)line.first()).x, (double)((Vector3d)line.second()).x), Mth.m_14139_((double)delta2, (double)((Vector3d)line.first()).y, (double)((Vector3d)line.second()).y), Mth.m_14139_((double)delta2, (double)((Vector3d)line.first()).z, (double)((Vector3d)line.second()).z)) : (Vector3d)line.second()).get(new Vector3f());
                    buf.m_5483_((double)pos1.x(), (double)pos1.y(), (double)pos1.z()).m_6122_(255, 255, 255, 255).m_86008_(OverlayTexture.f_118083_).m_85969_(240).m_252939_(lastPose, normalVec.x, normalVec.y, normalVec.z).m_5752_();
                    buf.m_5483_((double)pos2.x(), (double)pos2.y(), (double)pos2.z()).m_6122_(255, 255, 255, 255).m_86008_(OverlayTexture.f_118083_).m_85969_(240).m_252939_(lastPose, normalVec.x, normalVec.y, normalVec.z).m_5752_();
                    ++i;
                }
            }
            this.f_96541_.m_91269_().m_110104_().m_109912_((RenderType)RenderType.f_110371_);
            this.accessoryLines.clear();
        }
    }

    protected void m_7856_() {
        boolean anyUniqueSlots;
        super.m_7856_();
        this.currentTabPage = 1;
        this.cosmeticButtons.clear();
        this.backButton = (Button)((Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237119_(), btn -> this.f_96541_.m_91152_((Screen)new InventoryScreen((Player)this.f_96541_.f_91074_))).m_252987_(this.f_97735_ + 141, this.f_97736_ + 9, 8, 8).m_257505_(Tooltip.m_257550_((Component)Component.m_237115_((String)Accessories.translation("back.screen")))).m_253136_())).adjustRendering((button, guiGraphics, sprite, x, y, width, height) -> {
            guiGraphics.m_280163_(SPRITES_8X8.getLocation(button), x, y, (float)width, (float)height, 8, 8, 8, 8);
            PoseStack pose = guiGraphics.m_280168_();
            return true;
        });
        boolean cosmeticsOpen = ((AccessoriesMenu)this.f_97732_).isCosmeticsOpen();
        this.cosmeticToggleButton = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237119_(), btn -> AccessoriesInternals.getNetworkHandler().sendToServer(SyncHolderChange.of(HolderProperty.COSMETIC_PROP, ((AccessoriesMenu)this.m_6262_()).owner(), bl -> bl == false))).m_257505_(AccessoriesScreen.cosmeticsToggleTooltip(cosmeticsOpen)).m_252987_(this.f_97735_ - 27 + (cosmeticsOpen ? -20 : 0), this.f_97736_ + 7, cosmeticsOpen ? 38 : 18, 6).m_253136_());
        int btnOffset = this.f_97736_ + 7;
        this.unusedSlotsToggleButton = (Button)((Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237119_(), btn -> AccessoriesInternals.getNetworkHandler().sendToServer(SyncHolderChange.of(HolderProperty.UNUSED_PROP, ((AccessoriesMenu)this.m_6262_()).owner(), bl -> bl == false))).m_257505_(AccessoriesScreen.unusedSlotsToggleButton(((AccessoriesMenu)this.f_97732_).areUnusedSlotsShown())).m_252987_(this.f_97735_ + 154, btnOffset, 12, 12).m_253136_())).adjustRendering((button, guiGraphics, sprite, x, y, width, height) -> {
            guiGraphics.m_280163_(SPRITES_12X12.getLocation(button), x, y, (float)width, (float)height, 12, 12, 12, 12);
            guiGraphics.m_280163_(((AccessoriesMenu)this.f_97732_).areUnusedSlotsShown() ? UNUSED_SLOTS_SHOWN : UNUSED_SLOTS_HIDDEN, x, y, (float)width, (float)height, 12, 12, 12, 12);
            return true;
        });
        btnOffset += 15;
        if (Accessories.getConfig().clientData.showUniqueRendering && (anyUniqueSlots = EntitySlotLoader.getEntitySlots(this.targetEntityDefaulted()).values().stream().anyMatch(slotType -> UniqueSlotHandling.isUniqueSlot(slotType.name())))) {
            this.uniqueSlotsToggleButton = (Button)((Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237119_(), btn -> AccessoriesInternals.getNetworkHandler().sendToServer(SyncHolderChange.of(HolderProperty.UNIQUE_PROP, ((AccessoriesMenu)this.m_6262_()).owner(), bl -> bl == false))).m_257505_(AccessoriesScreen.uniqueSlotsToggleButton(((AccessoriesMenu)this.f_97732_).areUniqueSlotsShown())).m_252987_(this.f_97735_ + 154, btnOffset, 12, 12).m_253136_())).adjustRendering((button, guiGraphics, sprite, x, y, width, height) -> {
                guiGraphics.m_280163_(SPRITES_12X12.getLocation(button), x, y, (float)width, (float)height, 12, 12, 12, 12);
                guiGraphics.m_280163_(((AccessoriesMenu)this.f_97732_).areUniqueSlotsShown() ? UNUSED_SLOTS_SHOWN : UNUSED_SLOTS_HIDDEN, x, y, (float)width, (float)height, 12, 12, 12, 12);
                return true;
            });
            btnOffset += 15;
        }
        int accessoriesSlots = 0;
        for (Slot slot : ((AccessoriesMenu)this.f_97732_).f_38839_) {
            if (!(slot instanceof AccessoriesInternalSlot)) continue;
            AccessoriesInternalSlot accessoriesSlot = (AccessoriesInternalSlot)slot;
            if (accessoriesSlot.isCosmetic) continue;
            ToggleButton slotButton = ToggleButton.ofSlot(slot.f_40220_ + this.f_97735_ + 13, slot.f_40221_ + this.f_97736_ - 2, 300, accessoriesSlot);
            slotButton.f_93624_ = accessoriesSlot.m_6659_();
            slotButton.f_93623_ = accessoriesSlot.m_6659_();
            this.cosmeticButtons.put(accessoriesSlot, (ToggleButton)this.m_7787_((GuiEventListener)slotButton));
            ++accessoriesSlots;
        }
        if (AccessoriesScreen.tabPageCount() > 1) {
            this.tabDownButton = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"\u2b06"), button -> this.onTabPageChange(true)).m_252987_(this.f_97735_ - 56, this.f_97736_ - 11, 10, 10).m_253136_());
            this.tabDownButton.f_93623_ = false;
            int height2 = this.getPanelHeight();
            this.tabUpButton = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"\u2b07"), button -> this.onTabPageChange(false)).m_252987_(this.f_97735_ - 56, this.f_97736_ + height2 + 0, 10, 10).m_253136_());
            this.tabUpButton.m_257544_(Tooltip.m_257550_((Component)Component.m_237113_((String)"Page 2")));
            this.tabUpButton.f_93623_ = AccessoriesScreen.tabPageCount() != 1;
        }
        ((AccessoriesMenu)this.f_97732_).setScrollEvent(this::updateAccessoryToggleButtons);
        this.scrollBarHeight = Mth.m_269140_((float)Math.min((float)accessoriesSlots / 20.0f, 1.0f), (int)101, (int)31);
        if (this.scrollBarHeight % 2 == 0) {
            ++this.scrollBarHeight;
        }
    }

    private void onTabPageChange(boolean isDown) {
        if (this.currentTabPage <= 1 && isDown || this.currentTabPage > AccessoriesScreen.tabPageCount() && !isDown) {
            return;
        }
        this.currentTabPage += isDown ? -1 : 1;
        String lowerLabel = "Page " + (this.currentTabPage - 1);
        String upperLabel = "Page " + (this.currentTabPage + 1);
        this.tabDownButton.m_257544_(Tooltip.m_257550_((Component)Component.m_237113_((String)lowerLabel)));
        this.tabUpButton.m_257544_(Tooltip.m_257550_((Component)Component.m_237113_((String)upperLabel)));
        if (this.currentTabPage <= 1) {
            this.tabDownButton.f_93623_ = false;
        } else if (!this.tabDownButton.f_93623_) {
            this.tabDownButton.f_93623_ = true;
        }
        if (this.currentTabPage >= AccessoriesScreen.tabPageCount()) {
            this.tabUpButton.f_93623_ = false;
        } else if (!this.tabUpButton.f_93623_) {
            this.tabUpButton.f_93623_ = true;
        }
    }

    public void updateButtons(String name) {
        switch (name) {
            case "lines": {
                this.updateLinesButton();
                break;
            }
            case "cosmetic": {
                this.updateCosmeticToggleButton();
                break;
            }
            case "unused_slots": {
                this.updateUnusedSlotToggleButton();
                break;
            }
            case "unique_slots": {
                this.updateUniqueSlotToggleButton();
            }
        }
    }

    public void updateLinesButton() {
    }

    public void updateCosmeticToggleButton() {
        Button btn = this.cosmeticToggleButton;
        btn.m_93674_(((AccessoriesMenu)this.f_97732_).isCosmeticsOpen() ? 38 : 18);
        btn.m_252865_(btn.m_252754_() + (((AccessoriesMenu)this.f_97732_).isCosmeticsOpen() ? -20 : 20));
        btn.m_257544_(AccessoriesScreen.cosmeticsToggleTooltip(((AccessoriesMenu)this.f_97732_).isCosmeticsOpen()));
    }

    public void updateUnusedSlotToggleButton() {
        this.unusedSlotsToggleButton.m_257544_(AccessoriesScreen.unusedSlotsToggleButton(((AccessoriesMenu)this.f_97732_).areUnusedSlotsShown()));
        ((AccessoriesMenu)this.f_97732_).reopenMenu();
    }

    public void updateUniqueSlotToggleButton() {
        this.uniqueSlotsToggleButton.m_257544_(AccessoriesScreen.uniqueSlotsToggleButton(((AccessoriesMenu)this.f_97732_).areUniqueSlotsShown()));
        ((AccessoriesMenu)this.f_97732_).reopenMenu();
    }

    public void updateAccessoryToggleButtons() {
        for (Map.Entry<AccessoriesInternalSlot, ToggleButton> entry : this.cosmeticButtons.entrySet()) {
            AccessoriesInternalSlot accessoriesSlot = entry.getKey();
            ToggleButton btn = entry.getValue();
            if (!accessoriesSlot.m_6659_()) {
                btn.f_93623_ = false;
                btn.f_93624_ = false;
                continue;
            }
            btn.m_257544_(AccessoriesScreen.toggleTooltip(accessoriesSlot.accessoriesContainer.shouldRender(accessoriesSlot.m_150661_())));
            btn.m_252865_(accessoriesSlot.f_40220_ + this.f_97735_ + 13);
            btn.m_253211_(accessoriesSlot.f_40221_ + this.f_97736_ - 2);
            btn.toggled(accessoriesSlot.accessoriesContainer.shouldRender(accessoriesSlot.m_150661_()));
            btn.f_93623_ = true;
            btn.f_93624_ = true;
        }
    }

    private static Tooltip cosmeticsToggleTooltip(boolean value) {
        return AccessoriesScreen.createToggleTooltip("slot.cosmetics", value);
    }

    private static Tooltip linesToggleTooltip(boolean value) {
        return AccessoriesScreen.createToggleTooltip("lines", value);
    }

    private static Tooltip unusedSlotsToggleButton(boolean value) {
        return AccessoriesScreen.createToggleTooltip("unused_slots", value);
    }

    private static Tooltip uniqueSlotsToggleButton(boolean value) {
        return AccessoriesScreen.createToggleTooltip("unique_slots", value);
    }

    private static Tooltip toggleTooltip(boolean value) {
        return AccessoriesScreen.createToggleTooltip("display", value);
    }

    private static Tooltip createToggleTooltip(String type, boolean value) {
        String key = type + ".toggle." + (!value ? "show" : "hide");
        return Tooltip.m_257550_((Component)Component.m_237115_((String)Accessories.translation(key)));
    }

    @Override
    @Nullable
    public Boolean isHovering(Slot slot, double mouseX, double mouseY) {
        for (GuiEventListener child : this.m_6702_()) {
            ToggleButton btn;
            if (!(child instanceof ToggleButton) || !(btn = (ToggleButton)child).m_5953_(mouseX, mouseY)) continue;
            return false;
        }
        return ContainerScreenExtension.super.isHovering(slot, mouseX, mouseY);
    }

    protected void m_280072_(GuiGraphics guiGraphics, int x, int y) {
        Slot slot = this.f_97734_;
        if (slot instanceof AccessoriesInternalSlot) {
            AccessoriesInternalSlot slot2 = (AccessoriesInternalSlot)slot;
            FORCE_TOOLTIP_LEFT = true;
            if (slot2.m_7993_().m_41619_() && slot2.accessoriesContainer.slotType() != null) {
                guiGraphics.m_280677_(Minecraft.m_91087_().f_91062_, slot2.getTooltipData(), Optional.empty(), x, y);
                return;
            }
        }
        if (Accessories.getConfig().clientData.showGroupTabs) {
            int panelX = this.getStartingPanelX();
            int panelY = this.f_97736_;
            for (Map.Entry<SlotGroup, SlotGroupData> entry : this.getGroups(panelX, panelY).entrySet()) {
                if (!entry.getValue().isInBounds(x, y)) continue;
                ArrayList<MutableComponent> tooltipData = new ArrayList<MutableComponent>();
                SlotGroup group = entry.getKey();
                tooltipData.add(Component.m_237115_((String)group.translation()));
                if (UniqueSlotHandling.isUniqueGroup(group.name(), true)) {
                    tooltipData.add(Component.m_237113_((String)group.name()).m_130944_(new ChatFormatting[]{ChatFormatting.BLUE, ChatFormatting.ITALIC}));
                }
                guiGraphics.m_280677_(Minecraft.m_91087_().f_91062_, tooltipData, Optional.empty(), x, y);
                break;
            }
        }
        super.m_280072_(guiGraphics, x, y);
        FORCE_TOOLTIP_LEFT = false;
    }

    protected boolean m_7467_(double mouseX, double mouseY, int x, int y, int mouseButton) {
        int leftPos = this.f_97735_;
        int topPos = this.f_97736_;
        boolean insideMainPanel = mouseX >= (double)leftPos && mouseX <= (double)(leftPos + this.f_97726_) && mouseY >= (double)topPos && mouseY <= (double)(topPos + this.f_97727_);
        int sidePanelX = this.getStartingPanelX();
        int sidePanelY = topPos;
        boolean insideSidePanel = mouseX >= (double)sidePanelX && mouseX <= (double)(sidePanelX + this.getPanelWidth() + this.f_97726_) && mouseY >= (double)sidePanelY && mouseY <= (double)(sidePanelY + this.getPanelHeight());
        boolean insideGroupPanel = false;
        if (Accessories.getConfig().clientData.showGroupTabs && ((AccessoriesMenu)this.f_97732_).maxScrollableIndex() > 0) {
            for (SlotGroupData value : this.getGroups(sidePanelX, sidePanelY).values()) {
                if (!value.isInBounds((int)Math.round(mouseX), (int)Math.round(mouseY))) continue;
                insideGroupPanel = true;
                break;
            }
        }
        return !insideMainPanel && !insideSidePanel && !insideGroupPanel;
    }

    public static int tabPageCount() {
        List<SlotGroup> groups = SlotGroupLoader.INSTANCE.getGroups(true, true);
        return (int)Math.ceil((float)groups.size() / 9.0f);
    }

    private Map<SlotGroup, SlotGroupData> getGroups(int x, int y) {
        List<SlotGroup> groups = ((AccessoriesMenu)this.m_6262_()).validGroups().stream().sorted(Comparator.comparingInt(SlotGroup::order).reversed()).toList();
        if (AccessoriesScreen.tabPageCount() > 1) {
            int lowerBound = (this.currentTabPage - 1) * 9;
            int upperBound = lowerBound + 9;
            if (upperBound > groups.size()) {
                upperBound = groups.size();
            }
            groups = groups.subList(lowerBound, upperBound);
        }
        int bottomIndex = ((AccessoriesMenu)this.f_97732_).scrolledIndex;
        int upperIndex = bottomIndex + 8 - 1;
        Range scrollRange = Range.between((Object)bottomIndex, (Object)upperIndex, Integer::compareTo);
        LivingEntity targetEntity = this.targetEntityDefaulted();
        Map<String, AccessoriesContainer> containers = targetEntity.accessoriesCapability().getContainers();
        HashMap<String, Integer> slotToSize = new HashMap<String, Integer>();
        for (SlotType slotType : EntitySlotLoader.getEntitySlots(targetEntity).values()) {
            Object container;
            Set<SlotType> usedSlots = ((AccessoriesMenu)this.m_6262_()).usedSlots();
            if (usedSlots != null && !usedSlots.contains(slotType) || (container = containers.get(slotType.name())) == null) continue;
            slotToSize.put(slotType.name(), container.getAccessories().m_6643_());
        }
        int currentIndexOffset = 0;
        HashMap<SlotGroup, Integer> groupToIndex = new HashMap<SlotGroup, Integer>();
        HashSet<String> selectedGroup = new HashSet<String>();
        for (SlotGroup group : groups) {
            int groupSize = slotToSize.entrySet().stream().filter(entry -> group.slots().contains(entry.getKey())).mapToInt(Map.Entry::getValue).sum();
            if (groupSize <= 0) continue;
            int groupMinIndex = currentIndexOffset;
            int groupMaxIndex = groupMinIndex + groupSize - 1;
            Range groupRange = Range.between((Object)groupMinIndex, (Object)groupMaxIndex, Integer::compareTo);
            if (groupRange.isOverlappedBy(scrollRange)) {
                selectedGroup.add(group.name());
            }
            groupToIndex.put(group, groupMinIndex);
            currentIndexOffset += groupSize;
        }
        int maxHeight = this.getPanelHeight() - 4;
        int width = 19;
        int height = 16;
        int tabY = y + 4;
        int tabX = x - (width - 10);
        int yOffset = 0;
        HashMap<SlotGroup, SlotGroupData> groupValues = new HashMap<SlotGroup, SlotGroupData>();
        for (SlotGroup group : groups) {
            if (yOffset + height > maxHeight) break;
            boolean selected = selectedGroup.contains(group.name());
            int xOffset = selected ? 0 : 2;
            Integer index = (Integer)groupToIndex.get(group);
            if (index == null) continue;
            groupValues.put(group, new SlotGroupData(new Vector4i(tabX + xOffset, tabY + yOffset, width - xOffset, height), selected, index));
            yOffset += height + 1;
        }
        return groupValues;
    }

    private static SlotGroupImpl copy(SlotGroup group) {
        return new SlotGroupImpl(group.name() + "1", group.order(), group.slots(), group.icon());
    }

    private void renderEntityInInventoryFollowingMouseRotated(GuiGraphics guiGraphics, Vector2i pos, Vector2i size, Vector2i scissorStart, Vector2i scissorEnd, float mouseX, float mouseY, float rotation) {
        int scale = 30;
        float yOffset = 0.0625f;
        LivingEntity entity = this.targetEntityDefaulted();
        float f = (float)(pos.x + pos.x + size.x) / 2.0f;
        float g = (float)(pos.y + pos.y + size.y) / 2.0f;
        guiGraphics.m_280588_(scissorStart.x, scissorStart.y, scissorEnd.x, scissorEnd.y);
        float h = (float)Math.atan(((float)(scissorStart.x + scissorStart.x + size.x) / 2.0f - mouseX) / 40.0f);
        float i = (float)Math.atan(((float)(scissorStart.y + scissorStart.y + size.y) / 2.0f - mouseY) / 40.0f);
        Quaternionf quaternionf = new Quaternionf().rotateZ((float)Math.PI).rotateY((float)((double)rotation * (Math.PI / 180)));
        Quaternionf quaternionf2 = new Quaternionf().rotateX(i * 20.0f * ((float)Math.PI / 180));
        quaternionf.mul((Quaternionfc)quaternionf2);
        float j = entity.f_20883_;
        float k = entity.m_146908_();
        float l = entity.m_146909_();
        float m = entity.f_20886_;
        float n = entity.f_20885_;
        entity.f_20883_ = 180.0f + h * 30.0f;
        entity.m_146922_(180.0f + h * 40.0f);
        entity.m_146926_(-i * 20.0f);
        entity.f_20885_ = entity.m_146908_();
        entity.f_20886_ = entity.m_146908_();
        InventoryScreen.m_280432_((GuiGraphics)guiGraphics, (int)((int)f), (int)((int)(g + (entity.m_20206_() * 17.0f + yOffset))), (int)28, (Quaternionf)quaternionf, (Quaternionf)quaternionf2, (LivingEntity)entity);
        entity.f_20883_ = j;
        entity.m_146922_(k);
        entity.m_146926_(l);
        entity.f_20886_ = m;
        entity.f_20885_ = n;
        guiGraphics.m_280618_();
    }

    public Slot getHoveredSlot() {
        return this.f_97734_;
    }

    static {
        GuiGraphicsUtils.register(BACKGROUND_PATCH, GuiGraphicsUtils.NineSlicingDimensionImpl.of(Accessories.of("textures/gui/sprites/background_patch.png"), 15, 15, 5));
        GuiGraphicsUtils.register(SCROLL_BAR_PATCH, GuiGraphicsUtils.NineSlicingDimensionImpl.of(Accessories.of("textures/gui/sprites/scroll_bar_patch.png"), 6, 6, 2));
        GuiGraphicsUtils.register(SCROLL_BAR, GuiGraphicsUtils.NineSlicingDimensionImpl.of(Accessories.of("textures/gui/sprites/scroll_bar.png"), 6, 6, 2));
        HORIZONTAL_TABS = Accessories.of("textures/gui/container/horizontal_tabs_small.png");
        SPRITES_12X12 = SpriteGetter.ofButton(Accessories.of("textures/gui/sprites/widget/12x12/button.png"), Accessories.of("textures/gui/sprites/widget/12x12/button_disabled.png"), Accessories.of("textures/gui/sprites/widget/12x12/button_highlighted.png"));
        SPRITES_8X8 = SpriteGetter.ofButton(Accessories.of("textures/gui/sprites/widget/8x8/button.png"), Accessories.of("textures/gui/sprites/widget/8x8/button_disabled.png"), Accessories.of("textures/gui/sprites/widget/8x8/button_highlighted.png"));
        BACk_ICON = Accessories.of("textures/gui/sprites/widget/back.png");
        LINE_HIDDEN = Accessories.of("textures/gui/sprites/widget/line_hidden.png");
        LINE_SHOWN = Accessories.of("textures/gui/sprites/widget/line_shown.png");
        UNUSED_SLOTS_HIDDEN = Accessories.of("textures/gui/sprites/widget/unused_slots_hidden.png");
        UNUSED_SLOTS_SHOWN = Accessories.of("textures/gui/sprites/widget/unused_slots_shown.png");
        SCISSOR_BOX = new Vector4i();
        IS_RENDERING_UI_ENTITY = false;
        IS_RENDERING_LINE_TARGET = false;
        COLLECT_ACCESSORY_POSITIONS = false;
        NOT_VERY_NICE_POSITIONS = new HashMap<String, Vector3d>();
        FORCE_TOOLTIP_LEFT = false;
    }

    private record SlotGroupData(Vector4i dimensions, boolean isSelected, int startingIndex) {
        private boolean isInBounds(int x, int y) {
            return x > this.dimensions.x && y > this.dimensions.y && x < this.dimensions.x + this.dimensions.z && y < this.dimensions.y + this.dimensions.w;
        }
    }
}

