/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.LiteralMessage;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.Dynamic3CommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.logging.LogUtils;
import io.wispforest.accessories.Accessories;
import io.wispforest.accessories.AccessoriesInternals;
import io.wispforest.accessories.api.components.AccessoriesDataComponents;
import io.wispforest.accessories.api.components.AccessoryItemAttributeModifiers;
import io.wispforest.accessories.api.slot.SlotGroup;
import io.wispforest.accessories.api.slot.SlotType;
import io.wispforest.accessories.commands.RecordArgumentTypeInfo;
import io.wispforest.accessories.commands.ResourceExtendedArgument;
import io.wispforest.accessories.commands.SlotArgumentType;
import io.wispforest.accessories.data.EntitySlotLoader;
import io.wispforest.accessories.data.SlotGroupLoader;
import io.wispforest.accessories.data.SlotTypeLoader;
import io.wispforest.accessories.utils.AttributeUtils;
import it.unimi.dsi.fastutil.Pair;
import java.util.Arrays;
import java.util.Locale;
import java.util.UUID;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.slf4j.Logger;

public class AccessoriesCommands {
    public static final SimpleCommandExceptionType NON_LIVING_ENTITY_TARGET = new SimpleCommandExceptionType((Message)Component.m_237115_((String)"argument.livingEntities.nonLiving"));
    public static final SimpleCommandExceptionType INVALID_SLOT_TYPE = new SimpleCommandExceptionType((Message)new LiteralMessage("Invalid Slot Type"));
    public static final Logger LOGGER = LogUtils.getLogger();
    private static final Dynamic3CommandExceptionType ERROR_MODIFIER_ALREADY_PRESENT = new Dynamic3CommandExceptionType((var1, var2, var3) -> Component.m_237110_((String)"commands.attribute.failed.modifier_already_present_itemstack", (Object[])new Object[]{var1, var2, var3}));
    private static final Dynamic3CommandExceptionType ERROR_NO_SUCH_MODIFIER = new Dynamic3CommandExceptionType((var1, var2, var3) -> Component.m_237110_((String)"commands.attribute.failed.no_modifier_itemstack", (Object[])new Object[]{var1, var2, var3}));

    public static void registerCommandArgTypes() {
        AccessoriesInternals.registerCommandArgumentType(Accessories.of("slot_type"), SlotArgumentType.class, RecordArgumentTypeInfo.of(ctx -> SlotArgumentType.INSTANCE));
        AccessoriesInternals.registerCommandArgumentType(Accessories.of("resource"), ResourceExtendedArgument.class, RecordArgumentTypeInfo.of(ResourceExtendedArgument::attributes));
    }

    public static LivingEntity getOrThrowLivingEntity(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        Entity entity = EntityArgument.m_91452_(ctx, (String)"entity");
        if (!(entity instanceof LivingEntity)) {
            throw NON_LIVING_ENTITY_TARGET.create();
        }
        LivingEntity livingEntity = (LivingEntity)entity;
        return livingEntity;
    }

    public static void registerCommands(CommandDispatcher<CommandSourceStack> dispatcher, CommandBuildContext context) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"accessories").requires(commandSourceStack -> commandSourceStack.m_6761_(2))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"edit").then(Commands.m_82129_((String)"entity", (ArgumentType)EntityArgument.m_91449_()).executes(ctx -> {
            ServerPlayer player = ((CommandSourceStack)ctx.getSource()).m_81375_();
            Accessories.openAccessoriesMenu((Player)player, AccessoriesCommands.getOrThrowLivingEntity((CommandContext<CommandSourceStack>)ctx));
            return 1;
        }))).executes(ctx -> Accessories.attemptOpenScreenPlayer(((CommandSourceStack)ctx.getSource()).m_81375_()) ? 1 : 0))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"slot").then(((LiteralArgumentBuilder)Commands.m_82127_((String)"add").then(Commands.m_82127_((String)"valid").then(Commands.m_82129_((String)"slot", (ArgumentType)SlotArgumentType.INSTANCE).executes(ctx -> AccessoriesCommands.adjustSlotValidationOnStack(0, (LivingEntity)((CommandSourceStack)ctx.getSource()).m_81375_(), (CommandContext<CommandSourceStack>)ctx))))).then(Commands.m_82127_((String)"invalid").then(Commands.m_82129_((String)"slot", (ArgumentType)SlotArgumentType.INSTANCE).executes(ctx -> AccessoriesCommands.adjustSlotValidationOnStack(1, (LivingEntity)((CommandSourceStack)ctx.getSource()).m_81375_(), (CommandContext<CommandSourceStack>)ctx)))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"remove").then(Commands.m_82127_((String)"valid").then(Commands.m_82129_((String)"slot", (ArgumentType)SlotArgumentType.INSTANCE).executes(ctx -> AccessoriesCommands.adjustSlotValidationOnStack(2, (LivingEntity)((CommandSourceStack)ctx.getSource()).m_81375_(), (CommandContext<CommandSourceStack>)ctx))))).then(Commands.m_82127_((String)"invalid").then(Commands.m_82129_((String)"slot", (ArgumentType)SlotArgumentType.INSTANCE).executes(ctx -> AccessoriesCommands.adjustSlotValidationOnStack(3, (LivingEntity)((CommandSourceStack)ctx.getSource()).m_81375_(), (CommandContext<CommandSourceStack>)ctx))))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"stack-sizing").then(Commands.m_82127_((String)"useStackSize").then(Commands.m_82129_((String)"value", (ArgumentType)BoolArgumentType.bool()).executes(ctx -> {
            ServerPlayer player = ((CommandSourceStack)ctx.getSource()).m_81375_();
            Boolean bl = (Boolean)ctx.getArgument("value", Boolean.class);
            AccessoriesDataComponents.update(AccessoriesDataComponents.STACK_SIZE, player.m_21205_(), component -> component.useStackSize(bl));
            return 1;
        })))).then(Commands.m_82129_((String)"value", (ArgumentType)IntegerArgumentType.integer()).executes(ctx -> {
            ServerPlayer player = ((CommandSourceStack)ctx.getSource()).m_81375_();
            Integer size = (Integer)ctx.getArgument("value", Integer.class);
            AccessoriesDataComponents.update(AccessoriesDataComponents.STACK_SIZE, player.m_21205_(), component -> component.sizeOverride(size));
            return 1;
        })))).then(Commands.m_82127_((String)"attribute").then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"modifier").then(Commands.m_82127_((String)"add").then(Commands.m_82129_((String)"attribute", ResourceExtendedArgument.attributes(context)).then(Commands.m_82129_((String)"id", (ArgumentType)ResourceLocationArgument.m_106984_()).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.m_82129_((String)"value", (ArgumentType)DoubleArgumentType.doubleArg()).then(AccessoriesCommands.createAddLiteral("addition"))).then(AccessoriesCommands.createAddLiteral("multiply_base"))).then(AccessoriesCommands.createAddLiteral("multiply_total"))))))).then(Commands.m_82127_((String)"remove").then(Commands.m_82129_((String)"attribute", ResourceExtendedArgument.attributes(context)).then(Commands.m_82129_((String)"id", (ArgumentType)ResourceLocationArgument.m_106984_()).executes(ctx -> AccessoriesCommands.removeModifier((CommandSourceStack)ctx.getSource(), (LivingEntity)((CommandSourceStack)ctx.getSource()).m_81375_(), ResourceExtendedArgument.getAttribute((CommandContext<CommandSourceStack>)ctx, "attribute"), ResourceLocationArgument.m_107011_((CommandContext)ctx, (String)"id"))))))).then(Commands.m_82127_((String)"get").then(Commands.m_82129_((String)"attribute", ResourceExtendedArgument.attributes(context)).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"id", (ArgumentType)ResourceLocationArgument.m_106984_()).executes(ctx -> AccessoriesCommands.getAttributeModifier((CommandSourceStack)ctx.getSource(), (LivingEntity)((CommandSourceStack)ctx.getSource()).m_81375_(), ResourceExtendedArgument.getAttribute((CommandContext<CommandSourceStack>)ctx, "attribute"), ResourceLocationArgument.m_107011_((CommandContext)ctx, (String)"id"), 1.0))).then(Commands.m_82129_((String)"scale", (ArgumentType)DoubleArgumentType.doubleArg()).executes(ctx -> AccessoriesCommands.getAttributeModifier((CommandSourceStack)ctx.getSource(), (LivingEntity)((CommandSourceStack)ctx.getSource()).m_81375_(), ResourceExtendedArgument.getAttribute((CommandContext<CommandSourceStack>)ctx, "attribute"), ResourceLocationArgument.m_107011_((CommandContext)ctx, (String)"id"), DoubleArgumentType.getDouble((CommandContext)ctx, (String)"scale")))))))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"log").then(Commands.m_82127_((String)"slots").executes(ctx -> {
            LOGGER.info("All given Slots registered:");
            for (SlotType slotType : SlotTypeLoader.getSlotTypes((Level)((CommandSourceStack)ctx.getSource()).m_81372_()).values()) {
                LOGGER.info(slotType.toString());
            }
            return 1;
        }))).then(Commands.m_82127_((String)"groups").executes(ctx -> {
            LOGGER.info("All given Slot Groups registered:");
            for (SlotGroup group : SlotGroupLoader.getGroups((Level)((CommandSourceStack)ctx.getSource()).m_81372_())) {
                LOGGER.info(group.toString());
            }
            return 1;
        }))).then(Commands.m_82127_((String)"entity_bindings").executes(ctx -> {
            LOGGER.info("All given Entity Bindings registered:");
            EntitySlotLoader.INSTANCE.getEntitySlotData(false).forEach((type, slots) -> LOGGER.info("[{}]: {}", type, slots.keySet()));
            return 1;
        }))));
    }

    private static LiteralArgumentBuilder<CommandSourceStack> createAddLiteral(String literal) {
        AttributeModifier.Operation selectedValue = Arrays.stream(AttributeModifier.Operation.values()).filter(value -> value.name().toLowerCase(Locale.ROOT).equals(literal)).findFirst().orElse(null);
        if (selectedValue == null) {
            throw new IllegalStateException("Unable to handle the given literal as its not a valid AttributeModifier Operation! [Literal: " + literal + "]");
        }
        return (LiteralArgumentBuilder)Commands.m_82127_((String)literal).then(Commands.m_82129_((String)"slot", (ArgumentType)SlotArgumentType.INSTANCE).then(Commands.m_82129_((String)"isStackable", (ArgumentType)BoolArgumentType.bool()).executes(ctx -> AccessoriesCommands.addModifier((CommandSourceStack)ctx.getSource(), (LivingEntity)((CommandSourceStack)ctx.getSource()).m_81375_(), ResourceExtendedArgument.getAttribute((CommandContext<CommandSourceStack>)ctx, "attribute"), ResourceLocationArgument.m_107011_((CommandContext)ctx, (String)"id"), DoubleArgumentType.getDouble((CommandContext)ctx, (String)"value"), selectedValue, SlotArgumentType.getSlot((CommandContext<CommandSourceStack>)ctx, "slot"), BoolArgumentType.getBool((CommandContext)ctx, (String)"isStackable")))));
    }

    private static int getAttributeModifier(CommandSourceStack commandSourceStack, LivingEntity livingEntity, Holder<Attribute> holder, ResourceLocation resourceLocation, double d) throws CommandSyntaxException {
        ItemStack stack = livingEntity.m_21205_();
        AccessoryItemAttributeModifiers component = AccessoriesDataComponents.readOrDefault(AccessoriesDataComponents.ATTRIBUTES, stack);
        AttributeModifier modifier = component.getModifier((Attribute)holder.m_203334_(), resourceLocation);
        if (modifier == null) {
            throw ERROR_NO_SUCH_MODIFIER.create((Object)stack.m_41611_(), (Object)AccessoriesCommands.getAttributeDescription(holder), (Object)resourceLocation);
        }
        double e = modifier.m_22218_();
        commandSourceStack.m_288197_(() -> Component.m_237110_((String)"commands.attribute.modifier.value.get.success_itemstack", (Object[])new Object[]{resourceLocation, AccessoriesCommands.getAttributeDescription(holder), stack.m_41611_(), e}), false);
        return (int)(e * d);
    }

    private static int addModifier(CommandSourceStack commandSourceStack, LivingEntity livingEntity, Holder<Attribute> holder, ResourceLocation resourceLocation, double d, AttributeModifier.Operation operation, String slotName, boolean isStackable) throws CommandSyntaxException {
        ItemStack stack = livingEntity.m_21205_();
        AccessoryItemAttributeModifiers component = AccessoriesDataComponents.readOrDefault(AccessoriesDataComponents.ATTRIBUTES, stack);
        if (component.hasModifier((Attribute)holder.m_203334_(), resourceLocation)) {
            throw ERROR_MODIFIER_ALREADY_PRESENT.create((Object)resourceLocation, (Object)AccessoriesCommands.getAttributeDescription(holder), (Object)stack.m_41611_());
        }
        Pair<String, UUID> data = AttributeUtils.getModifierData(resourceLocation);
        AccessoriesDataComponents.write(AccessoriesDataComponents.ATTRIBUTES, stack, component.withModifierAdded((Attribute)holder.m_203334_(), new AttributeModifier((UUID)data.second(), (String)data.first(), d, operation), slotName, isStackable));
        commandSourceStack.m_288197_(() -> Component.m_237110_((String)"commands.attribute.modifier.add.success_itemstack", (Object[])new Object[]{resourceLocation, AccessoriesCommands.getAttributeDescription(holder), stack.m_41611_()}), false);
        return 1;
    }

    private static int removeModifier(CommandSourceStack commandSourceStack, LivingEntity livingEntity, Holder<Attribute> holder, ResourceLocation resourceLocation) throws CommandSyntaxException {
        MutableBoolean removedModifier = new MutableBoolean(false);
        ItemStack stack = livingEntity.m_21205_();
        AccessoriesDataComponents.update(AccessoriesDataComponents.ATTRIBUTES, stack, component -> {
            int size = component.modifiers().size();
            if (size != (component = component.withoutModifier(holder, resourceLocation)).modifiers().size()) {
                removedModifier.setTrue();
            }
            return component;
        });
        if (!removedModifier.getValue().booleanValue()) {
            throw ERROR_NO_SUCH_MODIFIER.create((Object)resourceLocation, (Object)AccessoriesCommands.getAttributeDescription(holder), (Object)stack.m_41611_());
        }
        commandSourceStack.m_288197_(() -> Component.m_237110_((String)"commands.attribute.modifier.remove.success_itemstack", (Object[])new Object[]{resourceLocation, AccessoriesCommands.getAttributeDescription(holder), stack.m_41611_()}), false);
        return 1;
    }

    private static Component getAttributeDescription(Holder<Attribute> attribute) {
        return Component.m_237115_((String)((Attribute)attribute.m_203334_()).m_22087_());
    }

    private static int adjustSlotValidationOnStack(int operation, LivingEntity player, CommandContext<CommandSourceStack> ctx) {
        String slotName = SlotArgumentType.getSlot(ctx, "slot");
        AccessoriesDataComponents.update(AccessoriesDataComponents.SLOT_VALIDATION, player.m_21205_(), component -> switch (operation) {
            case 0 -> component.addValidSlot(slotName);
            case 1 -> component.addInvalidSlot(slotName);
            case 2 -> component.removeValidSlot(slotName);
            case 3 -> component.removeInvalidSlot(slotName);
            default -> throw new IllegalStateException("Unexpected value: " + operation);
        });
        return 1;
    }
}

