/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.networking.client;

import com.mojang.logging.LogUtils;
import io.wispforest.accessories.api.AccessoriesCapability;
import io.wispforest.accessories.api.AccessoriesContainer;
import io.wispforest.accessories.client.AccessoriesMenu;
import io.wispforest.accessories.endec.CodecUtils;
import io.wispforest.accessories.endec.NbtMapCarrier;
import io.wispforest.accessories.impl.AccessoriesContainerImpl;
import io.wispforest.accessories.networking.BaseAccessoriesPacket;
import io.wispforest.endec.Endec;
import io.wispforest.endec.SerializationContext;
import io.wispforest.endec.impl.StructEndecBuilder;
import io.wispforest.endec.impl.StructField;
import io.wispforest.endec.util.MapCarrier;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.slf4j.Logger;

public record SyncContainerData(int entityId, Map<String, NbtMapCarrier> updatedContainers, Map<String, ItemStack> dirtyStacks, Map<String, ItemStack> dirtyCosmeticStacks) implements BaseAccessoriesPacket
{
    public static Endec<SyncContainerData> ENDEC = StructEndecBuilder.of((StructField)Endec.VAR_INT.fieldOf("entityId", SyncContainerData::entityId), (StructField)NbtMapCarrier.ENDEC.mapOf().fieldOf("updatedContainers", SyncContainerData::updatedContainers), (StructField)CodecUtils.ofCodec(ItemStack.f_41582_).mapOf().fieldOf("dirtyStacks", SyncContainerData::dirtyStacks), (StructField)CodecUtils.ofCodec(ItemStack.f_41582_).mapOf().fieldOf("dirtyCosmeticStacks", SyncContainerData::dirtyCosmeticStacks), SyncContainerData::new);
    private static final Logger LOGGER = LogUtils.getLogger();

    public static SyncContainerData of(LivingEntity livingEntity, Collection<AccessoriesContainer> updatedContainers, Map<String, ItemStack> dirtyStacks, Map<String, ItemStack> dirtyCosmeticStacks) {
        HashMap<String, NbtMapCarrier> updatedContainerTags = new HashMap<String, NbtMapCarrier>();
        for (AccessoriesContainer updatedContainer : updatedContainers) {
            NbtMapCarrier syncCarrier = NbtMapCarrier.of();
            ((AccessoriesContainerImpl)updatedContainer).write(syncCarrier, SerializationContext.empty(), true);
            updatedContainerTags.put(updatedContainer.getSlotName(), syncCarrier);
        }
        return new SyncContainerData(livingEntity.m_19879_(), updatedContainerTags, dirtyStacks, dirtyCosmeticStacks);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void handle(Player player) {
        AbstractContainerMenu abstractContainerMenu;
        Level level = player.m_9236_();
        Entity entity = level.m_6815_(this.entityId);
        if (entity == null) {
            LOGGER.error("Unable to Sync Container Data for a given Entity as it is null on the Client! [EntityId: {}]", (Object)this.entityId);
            return;
        }
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity livingEntity = (LivingEntity)entity;
        AccessoriesCapability capability = AccessoriesCapability.get(livingEntity);
        if (capability == null) {
            LOGGER.error("Unable to Sync Container Data for a given Entity as its Capability is null on the Client! [EntityId: {}]", (Object)this.entityId);
            return;
        }
        Map<String, AccessoriesContainer> containers = capability.getContainers();
        boolean aContainerHasResized = false;
        HashSet<String> invalidSyncedContainers = new HashSet<String>();
        for (Map.Entry<String, NbtMapCarrier> entry : this.updatedContainers.entrySet()) {
            if (!containers.containsKey(entry.getKey())) {
                invalidSyncedContainers.add(entry.getKey());
                continue;
            }
            AccessoriesContainer accessoriesContainer = containers.get(entry.getKey());
            ((AccessoriesContainerImpl)accessoriesContainer).read((MapCarrier)entry.getValue(), SerializationContext.empty(), true);
            if (!accessoriesContainer.getAccessories().wasNewlyConstructed()) continue;
            aContainerHasResized = true;
        }
        if (!invalidSyncedContainers.isEmpty()) {
            LOGGER.warn("Unable to sync container data for the following containers: {}", invalidSyncedContainers);
        }
        HashSet<String> invalidDirtyStackContainers = new HashSet<String>();
        for (Map.Entry entry : this.dirtyStacks.entrySet()) {
            String[] stringArray = ((String)entry.getKey()).split("/");
            String slot = stringArray[0];
            if (!containers.containsKey(slot)) {
                invalidDirtyStackContainers.add(slot);
                continue;
            }
            AccessoriesContainer container = containers.get(slot);
            try {
                container.getAccessories().m_6836_(Integer.parseInt(stringArray[1]), (ItemStack)entry.getValue());
            }
            catch (NumberFormatException numberFormatException) {}
        }
        if (!invalidDirtyStackContainers.isEmpty()) {
            LOGGER.warn("Unable to sync dirty stack data for the following containers: {}", invalidSyncedContainers);
        }
        HashSet<String> invalidDirtyCosmeticContainers = new HashSet<String>();
        for (Map.Entry<String, ItemStack> entry : this.dirtyCosmeticStacks.entrySet()) {
            String[] parts = entry.getKey().split("/");
            String slot = parts[0];
            if (!containers.containsKey(slot)) {
                invalidDirtyCosmeticContainers.add(slot);
                continue;
            }
            AccessoriesContainer container = containers.get(slot);
            try {
                container.getCosmeticAccessories().m_6836_(Integer.parseInt(parts[1]), entry.getValue());
            }
            catch (NumberFormatException numberFormatException) {}
        }
        if (!invalidDirtyCosmeticContainers.isEmpty()) {
            LOGGER.warn("Unable to sync dirty stack data for the following containers: {}", invalidSyncedContainers);
        }
        if ((abstractContainerMenu = player.f_36096_) instanceof AccessoriesMenu) {
            AccessoriesMenu accessoriesMenu = (AccessoriesMenu)abstractContainerMenu;
            if (aContainerHasResized) {
                accessoriesMenu.reopenMenu();
            }
        }
    }
}

