/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.api.components;

import com.mojang.logging.LogUtils;
import io.wispforest.accessories.Accessories;
import io.wispforest.accessories.api.components.AccessoryItemAttributeModifiers;
import io.wispforest.accessories.api.components.AccessoryNestContainerContents;
import io.wispforest.accessories.api.components.AccessoryRenderOverrideComponent;
import io.wispforest.accessories.api.components.AccessorySlotValidationComponent;
import io.wispforest.accessories.api.components.AccessoryStackSizeComponent;
import io.wispforest.accessories.endec.NbtMapCarrier;
import io.wispforest.accessories.endec.format.nbt.NbtDeserializer;
import io.wispforest.accessories.endec.format.nbt.NbtEndec;
import io.wispforest.accessories.endec.format.nbt.NbtSerializer;
import io.wispforest.endec.Endec;
import io.wispforest.endec.SerializationAttribute;
import io.wispforest.endec.SerializationContext;
import io.wispforest.endec.impl.KeyedEndec;
import java.util.HashMap;
import java.util.Map;
import java.util.function.UnaryOperator;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.ApiStatus;
import org.slf4j.Logger;

public class AccessoriesDataComponents {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final KeyedEndec<AccessoryNestContainerContents> NESTED_ACCESSORIES = AccessoryNestContainerContents.ENDEC.keyed(Accessories.of("nested_accessories").toString(), (Object)AccessoryNestContainerContents.EMPTY);
    public static final KeyedEndec<AccessoryRenderOverrideComponent> RENDER_OVERRIDE = AccessoryRenderOverrideComponent.ENDEC.keyed(Accessories.of("render_override").toString(), (Object)AccessoryRenderOverrideComponent.DEFAULT);
    public static final KeyedEndec<AccessorySlotValidationComponent> SLOT_VALIDATION = AccessorySlotValidationComponent.ENDEC.keyed(Accessories.of("slot_validation").toString(), (Object)AccessorySlotValidationComponent.EMPTY);
    public static final KeyedEndec<AccessoryItemAttributeModifiers> ATTRIBUTES = AccessoryItemAttributeModifiers.ENDEC.keyed(Accessories.of("attributes").toString(), (Object)AccessoryItemAttributeModifiers.EMPTY);
    public static final KeyedEndec<AccessoryStackSizeComponent> STACK_SIZE = AccessoryStackSizeComponent.ENDEC.keyed(Accessories.of("stack_size").toString(), (Object)AccessoryStackSizeComponent.DEFAULT);
    public static final Endec<Map<ResourceLocation, Tag>> COMPONENTS_ENDEC = NbtEndec.COMPOUND.xmap(compoundTag -> {
        HashMap<ResourceLocation, Tag> map = new HashMap<ResourceLocation, Tag>();
        for (String key : compoundTag.m_128431_()) {
            ResourceLocation location = ResourceLocation.m_135820_((String)key);
            if (location == null) continue;
            map.put(location, compoundTag.m_128423_(key));
        }
        return map;
    }, map -> {
        CompoundTag compound = new CompoundTag();
        map.forEach((location, tag) -> compound.m_128365_(location.toString(), tag));
        return compound;
    });
    public static final KeyedEndec<Map<ResourceLocation, Tag>> COMPONENTS_KEY = COMPONENTS_ENDEC.keyed("components", HashMap::new);

    @ApiStatus.Internal
    public static void init() {
    }

    public static <T> boolean has(KeyedEndec<T> keyedEndec, ItemStack stack) {
        ResourceLocation location;
        CompoundTag tag = stack.m_41783_();
        if (tag != null && (location = ResourceLocation.m_135820_((String)keyedEndec.key())) != null) {
            return ((Map)new NbtMapCarrier(tag).get(COMPONENTS_KEY)).containsKey(location);
        }
        return false;
    }

    public static <T> T readOrDefault(KeyedEndec<T> keyedEndec, ItemStack stack) {
        NbtMapCarrier carrier;
        Map components;
        Tag data;
        ResourceLocation location;
        CompoundTag tag = stack.m_41783_();
        if (tag != null && (location = ResourceLocation.m_135820_((String)keyedEndec.key())) != null && (data = (Tag)(components = (Map)(carrier = new NbtMapCarrier(tag)).get(COMPONENTS_KEY)).get(location)) != null) {
            try {
                return (T)keyedEndec.endec().decodeFully(SerializationContext.attributes((SerializationAttribute.Instance[])new SerializationAttribute.Instance[]{new StackAttribute(stack.m_41777_())}), NbtDeserializer::of, (Object)data);
            }
            catch (Exception e) {
                LOGGER.warn("Unable to read the given component from the given stack: [Key: {}]", (Object)keyedEndec.key(), (Object)e);
                components.remove(location);
                carrier.put(SerializationContext.attributes((SerializationAttribute.Instance[])new SerializationAttribute.Instance[]{new StackAttribute(stack.m_41777_())}), COMPONENTS_KEY, components);
            }
        }
        return (T)keyedEndec.defaultValue();
    }

    public static <T> void write(KeyedEndec<T> keyedEndec, ItemStack stack, T data) {
        NbtMapCarrier carrier = new NbtMapCarrier(stack.m_41784_());
        Map components = (Map)carrier.get(COMPONENTS_KEY);
        ResourceLocation location = ResourceLocation.m_135820_((String)keyedEndec.key());
        if (location != null) {
            try {
                components.put(location, (Tag)keyedEndec.endec().encodeFully(NbtSerializer::of, data));
            }
            catch (Exception e) {
                LOGGER.warn("Unable to write the given component from the given stack: [Key: {}]", (Object)keyedEndec.key(), (Object)e);
            }
        }
        carrier.put(COMPONENTS_KEY, components);
    }

    public static <T> void update(KeyedEndec<T> keyedEndec, ItemStack stack, UnaryOperator<T> operator) {
        AccessoriesDataComponents.write(keyedEndec, stack, operator.apply(AccessoriesDataComponents.readOrDefault(keyedEndec, stack)));
    }

    public record StackAttribute(ItemStack stack) implements SerializationAttribute.Instance
    {
        public static final SerializationAttribute.WithValue<StackAttribute> INSTANCE = SerializationAttribute.withValue((String)"accessories:stack");

        public SerializationAttribute attribute() {
            return INSTANCE;
        }

        public Object value() {
            return this;
        }
    }
}

