/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.impl;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.mojang.datafixers.util.Pair;
import io.wispforest.accessories.api.AccessoriesAPI;
import io.wispforest.accessories.api.AccessoriesCapability;
import io.wispforest.accessories.api.AccessoriesContainer;
import io.wispforest.accessories.api.Accessory;
import io.wispforest.accessories.api.slot.ExtraSlotTypeProperties;
import io.wispforest.accessories.api.slot.SlotReference;
import io.wispforest.accessories.api.slot.SlotType;
import io.wispforest.accessories.endec.format.nbt.NbtEndec;
import io.wispforest.accessories.impl.AccessoriesCapabilityImpl;
import io.wispforest.accessories.impl.AccessoriesHolderImpl;
import io.wispforest.accessories.impl.ExpandedSimpleContainer;
import io.wispforest.accessories.impl.InstanceEndec;
import io.wispforest.accessories.utils.AttributeUtils;
import io.wispforest.endec.Endec;
import io.wispforest.endec.SerializationContext;
import io.wispforest.endec.impl.KeyedEndec;
import io.wispforest.endec.util.MapCarrier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerListener;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class AccessoriesContainerImpl
implements AccessoriesContainer,
InstanceEndec,
ContainerListener {
    protected AccessoriesCapability capability;
    private String slotName;
    protected final Map<UUID, AttributeModifier> modifiers = new HashMap<UUID, AttributeModifier>();
    protected final Set<AttributeModifier> persistentModifiers = new HashSet<AttributeModifier>();
    protected final Set<AttributeModifier> cachedModifiers = new HashSet<AttributeModifier>();
    private final Multimap<AttributeModifier.Operation, AttributeModifier> modifiersByOperation = HashMultimap.create();
    @Nullable
    private Integer baseSize;
    private List<Boolean> renderOptions;
    private ExpandedSimpleContainer accessories;
    private ExpandedSimpleContainer cosmeticAccessories;
    private boolean update = false;
    private boolean resizingUpdate = false;
    protected boolean containerListenerLock = false;
    public static final KeyedEndec<String> SLOT_NAME_KEY = Endec.STRING.keyed("SlotName", (Object)"UNKNOWN");
    public static final KeyedEndec<Integer> BASE_SIZE_KEY = Endec.INT.keyed("BaseSize", () -> null);
    public static final KeyedEndec<Integer> CURRENT_SIZE_KEY = Endec.INT.keyed("size", (Object)0);
    public static final KeyedEndec<List<Boolean>> RENDER_OPTIONS_KEY = Endec.BOOLEAN.listOf().keyed("RenderOptions", ArrayList::new);
    public static final KeyedEndec<List<CompoundTag>> MODIFIERS_KEY = NbtEndec.COMPOUND.listOf().keyed("Modifiers", ArrayList::new);
    public static final KeyedEndec<List<CompoundTag>> PERSISTENT_MODIFIERS_KEY = NbtEndec.COMPOUND.listOf().keyed("PersistentModifiers", ArrayList::new);
    public static final KeyedEndec<List<CompoundTag>> CACHED_MODIFIERS_KEY = NbtEndec.COMPOUND.listOf().keyed("CachedModifiers", ArrayList::new);
    public static final KeyedEndec<ListTag> ITEMS_KEY = NbtEndec.LIST.keyed("Items", ListTag::new);
    public static final KeyedEndec<ListTag> COSMETICS_KEY = NbtEndec.LIST.keyed("Cosmetics", ListTag::new);

    public AccessoriesContainerImpl(AccessoriesCapability capability, SlotType slotType) {
        this.capability = capability;
        this.slotName = slotType.name();
        this.baseSize = slotType.amount();
        this.accessories = new ExpandedSimpleContainer(this, this.baseSize, "accessories", false);
        this.cosmeticAccessories = new ExpandedSimpleContainer(this, this.baseSize, "cosmetic_accessories", false);
        this.renderOptions = this.getWithSize(this.baseSize, new ArrayList(), true);
    }

    public void m_5757_(Container container) {
        if (this.containerListenerLock) {
            return;
        }
        if (((ExpandedSimpleContainer)container).name().contains("cosmetic")) {
            return;
        }
        this.markChanged();
        this.update();
    }

    @Nullable
    public Integer getBaseSize() {
        return this.baseSize;
    }

    @Override
    public void markChanged(boolean resizingUpdate) {
        this.update = true;
        this.resizingUpdate = resizingUpdate;
        if (this.capability.entity().m_9236_().f_46443_) {
            return;
        }
        Map<AccessoriesContainer, Boolean> inv = ((AccessoriesCapabilityImpl)this.capability).getUpdatingInventories();
        inv.remove(this);
        inv.put(this, resizingUpdate);
    }

    @Override
    public boolean hasChanged() {
        return this.update;
    }

    @Override
    public void update() {
        int currentSize;
        double size;
        boolean hasChangeOccurred;
        boolean bl = hasChangeOccurred = !this.resizingUpdate;
        if (!this.update) {
            return;
        }
        this.update = false;
        if (this.capability.entity().m_9236_().f_46443_) {
            return;
        }
        SlotType slotType = this.slotType();
        if (this.baseSize == null) {
            this.baseSize = 0;
        }
        if (slotType != null && this.baseSize.intValue() != slotType.amount()) {
            this.baseSize = slotType.amount();
            hasChangeOccurred = true;
        }
        double baseSize = this.baseSize.intValue();
        if (ExtraSlotTypeProperties.getProperty(this.slotName, false).allowResizing()) {
            for (AttributeModifier modifier : this.getModifiersForOperation(AttributeModifier.Operation.ADDITION)) {
                baseSize += modifier.m_22218_();
            }
            size = baseSize;
            for (AttributeModifier modifier : this.getModifiersForOperation(AttributeModifier.Operation.MULTIPLY_BASE)) {
                size += (double)this.baseSize.intValue() * modifier.m_22218_();
            }
            for (AttributeModifier modifier : this.getModifiersForOperation(AttributeModifier.Operation.MULTIPLY_TOTAL)) {
                size *= modifier.m_22218_();
            }
        } else {
            size = baseSize;
        }
        if ((currentSize = (int)Math.round(size)) != this.accessories.m_6643_()) {
            hasChangeOccurred = true;
            ArrayList<Pair> invalidAccessories = new ArrayList<Pair>();
            ArrayList<ItemStack> invalidStacks = new ArrayList<ItemStack>();
            this.containerListenerLock = true;
            ExpandedSimpleContainer newAccessories = new ExpandedSimpleContainer(this, currentSize, "accessories");
            ExpandedSimpleContainer newCosmetics = new ExpandedSimpleContainer(this, currentSize, "cosmetic_accessories");
            for (int i = 0; i < this.accessories.m_6643_(); ++i) {
                if (i < newAccessories.m_6643_()) {
                    newAccessories.m_6836_(i, this.accessories.m_8020_(i));
                    newCosmetics.m_6836_(i, this.cosmeticAccessories.m_8020_(i));
                    continue;
                }
                invalidAccessories.add(Pair.of((Object)i, (Object)this.accessories.m_8020_(i)));
                invalidStacks.add(this.cosmeticAccessories.m_8020_(i));
            }
            this.containerListenerLock = false;
            newAccessories.copyPrev(this.accessories);
            newCosmetics.copyPrev(this.cosmeticAccessories);
            this.accessories = newAccessories;
            this.cosmeticAccessories = newCosmetics;
            this.renderOptions = this.getWithSize(currentSize, this.renderOptions, true);
            LivingEntity livingEntity = this.capability.entity();
            for (Pair invalidAccessory : invalidAccessories) {
                Integer index = (Integer)invalidAccessory.getFirst();
                ItemStack invalidStack = (ItemStack)invalidAccessory.getSecond();
                if (invalidStack.m_41619_()) continue;
                SlotReference slotReference = SlotReference.of(livingEntity, this.slotName, index);
                AttributeUtils.removeTransientAttributeModifiers(livingEntity, AccessoriesAPI.getAttributeModifiers(invalidStack, slotReference));
                Accessory accessory = AccessoriesAPI.getAccessory(invalidStack);
                if (accessory != null) {
                    accessory.onUnequip(invalidStack, slotReference);
                }
                invalidStacks.add(invalidStack);
            }
            ((AccessoriesHolderImpl)this.capability.getHolder()).invalidStacks.addAll(invalidStacks);
            if (this.update) {
                this.capability.updateContainers();
            }
        }
        if (!hasChangeOccurred) {
            Map<AccessoriesContainer, Boolean> inv = ((AccessoriesCapabilityImpl)this.capability).getUpdatingInventories();
            inv.remove(this);
        }
    }

    @Override
    public int getSize() {
        this.update();
        return this.accessories.m_6643_();
    }

    @Override
    public String getSlotName() {
        return this.slotName;
    }

    @Override
    public AccessoriesCapability capability() {
        return this.capability;
    }

    @Override
    public List<Boolean> renderOptions() {
        this.update();
        return this.renderOptions;
    }

    @Override
    public ExpandedSimpleContainer getAccessories() {
        this.update();
        return this.accessories;
    }

    @Override
    public ExpandedSimpleContainer getCosmeticAccessories() {
        this.update();
        return this.cosmeticAccessories;
    }

    @Override
    public Map<UUID, AttributeModifier> getModifiers() {
        return this.modifiers;
    }

    @Override
    public Set<AttributeModifier> getCachedModifiers() {
        return this.cachedModifiers;
    }

    @Override
    public Collection<AttributeModifier> getModifiersForOperation(AttributeModifier.Operation operation) {
        return this.modifiersByOperation.get((Object)operation);
    }

    @Override
    public void addTransientModifier(AttributeModifier modifier) {
        this.modifiers.put(modifier.m_22209_(), modifier);
        this.getModifiersForOperation(modifier.m_22217_()).add(modifier);
        this.markChanged();
    }

    @Override
    public void addPersistentModifier(AttributeModifier modifier) {
        this.addTransientModifier(modifier);
        this.persistentModifiers.add(modifier);
    }

    @Override
    public boolean hasModifier(UUID id) {
        return this.modifiers.containsKey(id);
    }

    @Override
    public void removeModifier(UUID id) {
        AttributeModifier modifier = this.modifiers.remove(id);
        if (modifier == null) {
            return;
        }
        this.persistentModifiers.remove(modifier);
        this.getModifiersForOperation(modifier.m_22217_()).remove(modifier);
        this.markChanged();
    }

    @Override
    public void clearModifiers() {
        this.getModifiers().keySet().iterator().forEachRemaining(this::removeModifier);
    }

    @Override
    public void removeCachedModifiers(AttributeModifier modifier) {
        this.cachedModifiers.remove(modifier);
    }

    @Override
    public void clearCachedModifiers() {
        this.cachedModifiers.forEach(cachedModifier -> this.removeModifier(cachedModifier.m_22209_()));
        this.cachedModifiers.clear();
    }

    public void copyFrom(AccessoriesContainerImpl other) {
        this.modifiers.clear();
        this.modifiersByOperation.clear();
        this.persistentModifiers.clear();
        other.modifiers.values().forEach(this::addTransientModifier);
        other.persistentModifiers.forEach(this::addPersistentModifier);
        this.update();
    }

    @Override
    public void write(MapCarrier carrier, SerializationContext ctx) {
        this.write(carrier, ctx, false);
    }

    public void write(MapCarrier carrier, SerializationContext ctx, boolean sync) {
        carrier.put(SLOT_NAME_KEY, (Object)this.slotName);
        carrier.putIfNotNull(ctx, BASE_SIZE_KEY, (Object)this.baseSize);
        carrier.put(RENDER_OPTIONS_KEY, this.renderOptions);
        if (!sync || this.accessories.wasNewlyConstructed()) {
            carrier.put(CURRENT_SIZE_KEY, (Object)this.accessories.m_6643_());
            carrier.put(ITEMS_KEY, (Object)this.accessories.m_7927_());
            carrier.put(COSMETICS_KEY, (Object)this.cosmeticAccessories.m_7927_());
        }
        if (sync) {
            if (!this.modifiers.isEmpty()) {
                ArrayList modifiersTag = new ArrayList();
                this.modifiers.values().forEach(modifier -> modifiersTag.add(modifier.m_22219_()));
                carrier.put(MODIFIERS_KEY, modifiersTag);
            }
        } else {
            if (!this.persistentModifiers.isEmpty()) {
                ArrayList persistentTag = new ArrayList();
                this.persistentModifiers.forEach(modifier -> persistentTag.add(modifier.m_22219_()));
                carrier.put(PERSISTENT_MODIFIERS_KEY, persistentTag);
            }
            if (!this.modifiers.isEmpty()) {
                ArrayList cachedTag = new ArrayList();
                this.modifiers.values().forEach(modifier -> {
                    if (this.persistentModifiers.contains(modifier)) {
                        return;
                    }
                    cachedTag.add(modifier.m_22219_());
                });
                carrier.put(CACHED_MODIFIERS_KEY, cachedTag);
            }
        }
    }

    @Override
    public void read(MapCarrier carrier, SerializationContext ctx) {
        this.read(carrier, ctx, false);
    }

    public void read(MapCarrier carrier, SerializationContext ctx, boolean sync) {
        this.slotName = (String)carrier.get(SLOT_NAME_KEY);
        this.baseSize = (Integer)carrier.get(BASE_SIZE_KEY);
        if (sync) {
            this.modifiers.clear();
            this.persistentModifiers.clear();
            this.modifiersByOperation.clear();
            if (carrier.has(MODIFIERS_KEY)) {
                persistentTag = (List)carrier.get(MODIFIERS_KEY);
                for (CompoundTag compoundTag : persistentTag) {
                    AttributeModifier modifier = AttributeModifier.m_22212_((CompoundTag)compoundTag);
                    if (modifier == null) continue;
                    this.addTransientModifier(modifier);
                }
            }
        } else {
            AttributeModifier modifier;
            if (carrier.has(PERSISTENT_MODIFIERS_KEY)) {
                persistentTag = (List)carrier.get(PERSISTENT_MODIFIERS_KEY);
                for (CompoundTag compoundTag : persistentTag) {
                    modifier = AttributeModifier.m_22212_((CompoundTag)compoundTag);
                    if (modifier == null) continue;
                    this.addPersistentModifier(modifier);
                }
            }
            if (carrier.has(CACHED_MODIFIERS_KEY)) {
                List cachedTag = (List)carrier.get(CACHED_MODIFIERS_KEY);
                for (CompoundTag compoundTag : cachedTag) {
                    modifier = AttributeModifier.m_22212_((CompoundTag)compoundTag);
                    if (modifier != null) {
                        this.cachedModifiers.add(modifier);
                        this.addTransientModifier(modifier);
                    }
                    this.update();
                }
            }
        }
        if (carrier.has(CURRENT_SIZE_KEY)) {
            Integer currentSize = (Integer)carrier.get(CURRENT_SIZE_KEY);
            List sentOptions = (List)carrier.get(RENDER_OPTIONS_KEY);
            this.renderOptions = this.getWithSize(currentSize, sentOptions, true);
            if (this.accessories.m_6643_() != currentSize.intValue()) {
                this.accessories = new ExpandedSimpleContainer(this, currentSize, "accessories");
                this.cosmeticAccessories = new ExpandedSimpleContainer(this, currentSize, "cosmetic_accessories");
            }
            this.accessories.m_7797_((ListTag)carrier.get(ITEMS_KEY));
            this.cosmeticAccessories.m_7797_((ListTag)carrier.get(COSMETICS_KEY));
        } else {
            this.renderOptions = (List)carrier.get(RENDER_OPTIONS_KEY);
        }
    }

    private <T> List<T> getWithSize(int size, List<T> list, T defaultValue) {
        ArrayList<T> sizedList = new ArrayList<T>(size);
        for (int i = 0; i < size; ++i) {
            T value = i < list.size() ? list.get(i) : defaultValue;
            sizedList.add(value);
        }
        return sizedList;
    }

    public static SimpleContainer readContainer(MapCarrier carrier, SerializationContext ctx, KeyedEndec<ListTag> key) {
        return AccessoriesContainerImpl.readContainers(carrier, ctx, key).get(0);
    }

    @SafeVarargs
    public static List<SimpleContainer> readContainers(MapCarrier carrier, SerializationContext ctx, KeyedEndec<ListTag> ... keys) {
        ArrayList<SimpleContainer> containers = new ArrayList<SimpleContainer>();
        for (KeyedEndec<ListTag> key : keys) {
            SimpleContainer stacks = new SimpleContainer(new ItemStack[0]);
            if (carrier.has(key)) {
                stacks.m_7797_((ListTag)carrier.get(key));
            }
            containers.add(stacks);
        }
        return containers;
    }

    public static SimpleContainer copyContainerList(SimpleContainer container) {
        return new SimpleContainer((ItemStack[])container.m_19195_().toArray(ItemStack[]::new));
    }
}

