/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.impl;

import com.mojang.logging.LogUtils;
import io.wispforest.accessories.Accessories;
import io.wispforest.accessories.api.AccessoriesCapability;
import io.wispforest.accessories.api.AccessoriesContainer;
import io.wispforest.accessories.api.AccessoriesHolder;
import io.wispforest.accessories.api.slot.SlotType;
import io.wispforest.accessories.data.EntitySlotLoader;
import io.wispforest.accessories.endec.NbtMapCarrier;
import io.wispforest.accessories.endec.format.nbt.NbtEndec;
import io.wispforest.accessories.impl.AccessoriesContainerImpl;
import io.wispforest.accessories.impl.InstanceEndec;
import io.wispforest.accessories.impl.PlayerEquipControl;
import io.wispforest.endec.Endec;
import io.wispforest.endec.SerializationAttribute;
import io.wispforest.endec.SerializationContext;
import io.wispforest.endec.impl.KeyedEndec;
import io.wispforest.endec.util.MapCarrier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.ApiStatus;
import org.slf4j.Logger;

@ApiStatus.Internal
public class AccessoriesHolderImpl
implements AccessoriesHolder,
InstanceEndec {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final MapCarrier EMPTY = new NbtMapCarrier(new CompoundTag());
    private final Map<String, AccessoriesContainer> slotContainers = new LinkedHashMap<String, AccessoriesContainer>();
    public final List<ItemStack> invalidStacks = new ArrayList<ItemStack>();
    protected final Map<AccessoriesContainer, Boolean> containersRequiringUpdates = new HashMap<AccessoriesContainer, Boolean>();
    private boolean showUnusedSlots = false;
    private boolean showUniqueSlots = false;
    private boolean cosmeticsShown = false;
    private int scrolledSlot = 0;
    private boolean linesShown = false;
    private PlayerEquipControl equipControl = PlayerEquipControl.MUST_NOT_CROUCH;
    private MapCarrier carrier;
    protected boolean loadedFromTag = false;
    private static final KeyedEndec<Map<String, AccessoriesContainer>> CONTAINERS_KEY = NbtEndec.COMPOUND.xmapWithContext((ctx, containersMap) -> {
        LivingEntity entity = ((EntityAttribute)ctx.requireAttributeValue(EntityAttribute.ENTITY)).livingEntity();
        Map<String, AccessoriesContainer> slotContainers = ((ContainersAttribute)ctx.requireAttributeValue(ContainersAttribute.CONTAINERS)).slotContainers();
        List<ItemStack> invalidStacks = ((InvalidStacksAttribute)ctx.requireAttributeValue(InvalidStacksAttribute.INVALID_STACKS)).invalidStacks();
        Map<String, SlotType> slots = EntitySlotLoader.getEntitySlots(entity);
        for (String key : containersMap.m_128431_()) {
            int i;
            CompoundTag containerElement = containersMap.m_128469_(key);
            if (containerElement.m_128456_()) continue;
            if (slots.containsKey(key)) {
                AccessoriesContainer container = slotContainers.get(key);
                SimpleContainer prevAccessories = AccessoriesContainerImpl.copyContainerList(container.getAccessories());
                SimpleContainer prevCosmetics = AccessoriesContainerImpl.copyContainerList(container.getCosmeticAccessories());
                ((AccessoriesContainerImpl)container).read(new NbtMapCarrier(containerElement), (SerializationContext)ctx);
                if (prevAccessories.m_6643_() <= container.getSize()) continue;
                for (i = container.getSize() - 1; i < prevAccessories.m_6643_(); ++i) {
                    ItemStack prevCosmetic;
                    ItemStack prevStack = prevAccessories.m_8020_(i);
                    if (!prevStack.m_41619_()) {
                        invalidStacks.add(prevStack);
                    }
                    if ((prevCosmetic = prevCosmetics.m_8020_(i)).m_41619_()) continue;
                    invalidStacks.add(prevCosmetic);
                }
                continue;
            }
            List<SimpleContainer> containers = AccessoriesContainerImpl.readContainers(new NbtMapCarrier(containerElement), ctx, AccessoriesContainerImpl.COSMETICS_KEY, AccessoriesContainerImpl.ITEMS_KEY);
            for (SimpleContainer simpleContainer : containers) {
                for (i = 0; i < simpleContainer.m_6643_(); ++i) {
                    ItemStack stack = simpleContainer.m_8020_(i);
                    if (stack.m_41619_()) continue;
                    invalidStacks.add(stack);
                }
            }
        }
        return slotContainers;
    }, (ctx, containers) -> {
        CompoundTag containerMap = new CompoundTag();
        containers.forEach((s, container) -> containerMap.m_128365_(s, (Tag)((NbtMapCarrier)Util.m_137469_((Object)NbtMapCarrier.of(), innerCarrier -> ((AccessoriesContainerImpl)container).write((MapCarrier)innerCarrier, (SerializationContext)ctx))).compoundTag()));
        return containerMap;
    }).keyed("AccessoriesContainers", HashMap::new);
    private static final KeyedEndec<Boolean> COSMETICS_SHOWN_KEY = Endec.BOOLEAN.keyed("CosmeticsShown", (Object)false);
    private static final KeyedEndec<Boolean> LINES_SHOWN_KEY = Endec.BOOLEAN.keyed("LinesShown", (Object)false);
    private static final KeyedEndec<PlayerEquipControl> EQUIP_CONTROL_KEY = Endec.forEnum(PlayerEquipControl.class).keyed("EquipControl", (Object)PlayerEquipControl.MUST_CROUCH);

    public static AccessoriesHolderImpl of() {
        AccessoriesHolderImpl holder = new AccessoriesHolderImpl();
        holder.loadedFromTag = true;
        holder.carrier = EMPTY;
        return holder;
    }

    @ApiStatus.Internal
    protected Map<String, AccessoriesContainer> getSlotContainers() {
        return this.slotContainers;
    }

    @Override
    public boolean cosmeticsShown() {
        return this.cosmeticsShown;
    }

    @Override
    public AccessoriesHolder cosmeticsShown(boolean value) {
        this.cosmeticsShown = value;
        return this;
    }

    @Override
    public int scrolledSlot() {
        return this.scrolledSlot;
    }

    @Override
    public AccessoriesHolder scrolledSlot(int slot) {
        this.scrolledSlot = slot;
        return this;
    }

    @Override
    public boolean linesShown() {
        return this.linesShown;
    }

    @Override
    public AccessoriesHolder linesShown(boolean value) {
        this.linesShown = value;
        return this;
    }

    @Override
    public boolean showUnusedSlots() {
        return this.showUnusedSlots;
    }

    @Override
    public AccessoriesHolder showUnusedSlots(boolean value) {
        this.showUnusedSlots = value;
        return this;
    }

    @Override
    public boolean showUniqueSlots() {
        return this.showUniqueSlots;
    }

    @Override
    public AccessoriesHolder showUniqueSlots(boolean value) {
        this.showUniqueSlots = value;
        return this;
    }

    @Override
    public PlayerEquipControl equipControl() {
        return this.equipControl;
    }

    @Override
    public AccessoriesHolder equipControl(PlayerEquipControl value) {
        this.equipControl = value;
        return this;
    }

    public void init(AccessoriesCapability capability) {
        LivingEntity livingEntity = capability.entity();
        this.slotContainers.clear();
        Map<String, SlotType> entitySlots = EntitySlotLoader.getEntitySlots(livingEntity);
        if (livingEntity instanceof Player && entitySlots.isEmpty()) {
            LOGGER.warn("It seems the given player has no slots bound to it within a init call, is that desired?");
        }
        if (this.loadedFromTag) {
            entitySlots.forEach((s, slotType) -> this.slotContainers.putIfAbsent((String)s, new AccessoriesContainerImpl(capability, (SlotType)slotType)));
            SerializationContext ctx = SerializationContext.attributes((SerializationAttribute.Instance[])new SerializationAttribute.Instance[]{new EntityAttribute(livingEntity)});
            this.read(capability, livingEntity, this.carrier, ctx);
        } else {
            entitySlots.forEach((s, slotType) -> this.slotContainers.put((String)s, new AccessoriesContainerImpl(capability, (SlotType)slotType)));
        }
    }

    @Override
    public void write(MapCarrier carrier, SerializationContext ctx) {
        if (this.slotContainers.isEmpty()) {
            return;
        }
        carrier.put(COSMETICS_SHOWN_KEY, (Object)this.cosmeticsShown);
        carrier.put(LINES_SHOWN_KEY, (Object)this.linesShown);
        carrier.put(EQUIP_CONTROL_KEY, (Object)this.equipControl);
        carrier.put(ctx, CONTAINERS_KEY, this.slotContainers);
    }

    public void read(LivingEntity entity, MapCarrier carrier, SerializationContext ctx) {
        this.read(entity.accessoriesCapability(), entity, carrier, ctx);
    }

    public void read(AccessoriesCapability capability, LivingEntity entity, MapCarrier carrier, SerializationContext ctx) {
        this.loadedFromTag = false;
        this.cosmeticsShown = (Boolean)carrier.get(COSMETICS_SHOWN_KEY);
        this.linesShown = (Boolean)carrier.get(LINES_SHOWN_KEY);
        this.equipControl = (PlayerEquipControl)((Object)carrier.get(EQUIP_CONTROL_KEY));
        carrier.getWithErrors(ctx.withAttributes(new SerializationAttribute.Instance[]{new ContainersAttribute(this.slotContainers), new InvalidStacksAttribute(this.invalidStacks)}), CONTAINERS_KEY);
        capability.clearCachedSlotModifiers();
        this.carrier = EMPTY;
    }

    @Override
    public void read(MapCarrier carrier, SerializationContext context) {
        this.loadedFromTag = true;
        this.carrier = carrier;
    }

    private record EntityAttribute(LivingEntity livingEntity) implements SerializationAttribute.Instance
    {
        public static final SerializationAttribute.WithValue<EntityAttribute> ENTITY = SerializationAttribute.withValue((String)"entity");

        public SerializationAttribute attribute() {
            return ENTITY;
        }

        public Object value() {
            return this;
        }
    }

    private record ContainersAttribute(Map<String, AccessoriesContainer> slotContainers) implements SerializationAttribute.Instance
    {
        public static final SerializationAttribute.WithValue<ContainersAttribute> CONTAINERS = SerializationAttribute.withValue((String)Accessories.translation("containers"));

        public SerializationAttribute attribute() {
            return CONTAINERS;
        }

        public Object value() {
            return this;
        }
    }

    private record InvalidStacksAttribute(List<ItemStack> invalidStacks) implements SerializationAttribute.Instance
    {
        public static final SerializationAttribute.WithValue<InvalidStacksAttribute> INVALID_STACKS = SerializationAttribute.withValue((String)Accessories.translation("invalidStacks"));

        public SerializationAttribute attribute() {
            return INVALID_STACKS;
        }

        public Object value() {
            return this;
        }
    }
}

