/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.adaptiveperformancetweaksspawn.commands;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import de.markusbordihn.adaptiveperformancetweakscore.commands.CustomCommand;
import de.markusbordihn.adaptiveperformancetweaksspawn.spawn.SpawnConfigManager;
import java.util.Set;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SpawnRulesCommand
extends CustomCommand {
    protected static final Logger log = LogManager.getLogger((String)"APTweaks(Spawn)");
    private static final SpawnRulesCommand command = new SpawnRulesCommand();

    public static ArgumentBuilder<CommandSourceStack, ?> register() {
        return ((LiteralArgumentBuilder)Commands.m_82127_((String)"spawnrules").requires(cs -> cs.m_6761_(2))).executes((Command)command);
    }

    public int run(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        Set entitiesKeys = ForgeRegistries.ENTITY_TYPES.getKeys();
        if (entitiesKeys.isEmpty()) {
            SpawnRulesCommand.sendFeedback(context, (String)"Unable to find any entities. Server / World is not loaded?");
            return 0;
        }
        SpawnRulesCommand.sendFeedback(context, (String)"Spawn Rules, please check info.log for the full output.\n===");
        SpawnRulesCommand.sendFeedback(context, (String)"Entity Name|perPlayer|perWorld");
        for (ResourceLocation entityKey : entitiesKeys) {
            String entityName = entityKey.toString();
            if (entityName == null || !SpawnConfigManager.hasSpawnLimit(entityName)) continue;
            int spawnRatePerPlayer = SpawnConfigManager.getSpawnLimitPerPlayer(entityName);
            int spawnRatePerWorld = SpawnConfigManager.getSpawnLimitPerWorld(entityName);
            SpawnRulesCommand.sendFeedback(context, (String)String.format("%s|%s|%s", entityName, spawnRatePerPlayer, spawnRatePerWorld));
        }
        return 0;
    }
}

