/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.adaptiveperformancetweaksspawn.commands;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import de.markusbordihn.adaptiveperformancetweakscore.commands.CustomCommand;
import de.markusbordihn.adaptiveperformancetweaksspawn.spawn.SpawnerManager;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.BaseSpawner;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SpawnerCommand
extends CustomCommand {
    protected static final Logger log = LogManager.getLogger((String)"APTweaks(Spawn)");
    private static final SpawnerCommand command = new SpawnerCommand();

    public static ArgumentBuilder<CommandSourceStack, ?> register() {
        return ((LiteralArgumentBuilder)Commands.m_82127_((String)"spawner").requires(cs -> cs.m_6761_(2))).executes((Command)command);
    }

    public int run(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        Set<BaseSpawner> spawnerList = SpawnerManager.getSpawnerList();
        if (spawnerList.isEmpty()) {
            SpawnerCommand.sendFeedback(context, (String)"Unable to find any active mob spawner. World is not loaded or nor spawner are active yet?");
        } else {
            SpawnerCommand.sendFeedback(context, (String)"Spawner Overview (please check latest.log for full output with position and meta data)\n===");
            HashMap<String, Integer> spawnerCounter = new HashMap<String, Integer>();
            for (BaseSpawner baseSpawner : spawnerList) {
                BlockEntity blockEntity = baseSpawner.getSpawnerBlockEntity();
                if (blockEntity == null) continue;
                Level level = blockEntity.m_58904_();
                String worldName = level != null ? level.m_46472_().m_135782_().toString() : "";
                CompoundTag spawnerData = blockEntity.serializeNBT();
                String spawnerId = spawnerData.m_128461_("id");
                String spawnEntityId = spawnerData.m_128469_("SpawnData").m_128469_("entity").m_128461_("id");
                log.info("[Mob Spawner] {}({}) at {} in {} with {}", (Object)spawnerId, (Object)spawnEntityId, (Object)blockEntity.m_58899_(), (Object)worldName, (Object)spawnerData);
                spawnerCounter.put(spawnEntityId, spawnerCounter.getOrDefault(spawnEntityId, 0) + 1);
            }
            for (Map.Entry entry : spawnerCounter.entrySet()) {
                SpawnerCommand.sendFeedback(context, (String)String.format("\u221f %s x %s", entry.getValue(), entry.getKey()));
            }
        }
        return 0;
    }
}

