/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.adaptiveperformancetweaksspawn.config.spawn;

import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.loading.FMLPaths;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public final class AquacultureSpawnConfig {
    public static final ForgeConfigSpec commonSpec;
    public static final Config COMMON;
    protected static final Logger log;

    private AquacultureSpawnConfig() {
    }

    static {
        log = LogManager.getLogger((String)"APTweaks(Spawn)");
        com.electronwill.nightconfig.core.Config.setInsertionOrderPreserved((boolean)true);
        Pair specPair = new ForgeConfigSpec.Builder().configure(Config::new);
        commonSpec = (ForgeConfigSpec)specPair.getRight();
        COMMON = (Config)specPair.getLeft();
        log.info("Registering {} {} spawn config ...", (Object)"Adaptive Performance Tweaks: Spawn", (Object)"Aquaculture 2");
        try {
            Files.createDirectories(FMLPaths.CONFIGDIR.get().resolve("adaptive_performance_tweaks"), new FileAttribute[0]);
        }
        catch (Exception exception) {
            log.error("There was an error, creating the directory:", (Throwable)exception);
        }
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)commonSpec, "adaptive_performance_tweaks//spawn/AquacultureSpawn.toml");
    }

    public static class Config {
        public final ForgeConfigSpec.BooleanValue enabled;
        public final ForgeConfigSpec.ConfigValue<String> id;
        public final ForgeConfigSpec.IntValue fishPerPlayer;
        public final ForgeConfigSpec.IntValue fishPerWorld;
        public final ForgeConfigSpec.IntValue fishPerServer;
        public final ForgeConfigSpec.ConfigValue<List<String>> fishList;

        Config(ForgeConfigSpec.Builder builder) {
            builder.comment("Adaptive Performance Tweaks: Spawn");
            builder.push("Aquaculture 2 Spawn Config");
            this.enabled = builder.define("Enabled", true);
            this.id = builder.define("Id", (Object)"aquaculture");
            this.fishPerPlayer = builder.defineInRange("MaxFishPerPlayer", 4, 1, 64);
            this.fishPerWorld = builder.defineInRange("MaxFishPerWorld", 16, 1, 512);
            this.fishPerServer = builder.defineInRange("MaxFishPerServer", 320, 1, 1024);
            this.fishList = builder.comment("List of passive Mobs to optimize in the format [\"minecraft:bat\", \"minecraft:cat\", ..]").define("FishList", new ArrayList<String>(Arrays.asList("aquaculture:acacia_fish_mount", "aquaculture:arapaima", "aquaculture:arrau_turtle", "aquaculture:atlantic_cod", "aquaculture:atlantic_halibut", "aquaculture:atlantic_herring", "aquaculture:bayad", "aquaculture:birch_fish_mount", "aquaculture:blackfish", "aquaculture:bluegill", "aquaculture:bobber", "aquaculture:boulti", "aquaculture:box_turtle", "aquaculture:brown_shrooma", "aquaculture:brown_trout", "aquaculture:capitaine", "aquaculture:carp", "aquaculture:catfish", "aquaculture:dark_oak_fish_mount", "aquaculture:gar", "aquaculture:jellyfish", "aquaculture:jungle_fish_mount", "aquaculture:minnow", "aquaculture:muskellunge", "aquaculture:oak_fish_mount", "aquaculture:pacific_halibut", "aquaculture:perch", "aquaculture:pink_salmon", "aquaculture:piranha", "aquaculture:pollock", "aquaculture:rainbow_trout", "aquaculture:red_grouper", "aquaculture:red_shrooma", "aquaculture:smallmouth_bass", "aquaculture:spruce_fish_mount", "aquaculture:starshell_turtle", "aquaculture:synodontis", "aquaculture:tambaqui", "aquaculture:tuna", "aquaculture:water_arrow")));
            builder.pop();
        }
    }
}

