/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.adaptiveperformancetweaksspawn.config.spawn;

import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.loading.FMLPaths;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public final class MekanismAdditionsSpawnConfig {
    public static final ForgeConfigSpec commonSpec;
    public static final Config COMMON;
    protected static final Logger log;

    private MekanismAdditionsSpawnConfig() {
    }

    static {
        log = LogManager.getLogger((String)"APTweaks(Spawn)");
        com.electronwill.nightconfig.core.Config.setInsertionOrderPreserved((boolean)true);
        Pair specPair = new ForgeConfigSpec.Builder().configure(Config::new);
        commonSpec = (ForgeConfigSpec)specPair.getRight();
        COMMON = (Config)specPair.getLeft();
        log.info("Registering {} {} spawn config ...", (Object)"Adaptive Performance Tweaks: Spawn", (Object)"Mekanism Additions");
        try {
            Files.createDirectories(FMLPaths.CONFIGDIR.get().resolve("adaptive_performance_tweaks"), new FileAttribute[0]);
        }
        catch (Exception exception) {
            log.error("There was an error, creating the directory:", (Throwable)exception);
        }
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)commonSpec, "adaptive_performance_tweaks//spawn/MekanismAdditionsSpawn.toml");
    }

    public static class Config {
        public final ForgeConfigSpec.BooleanValue enabled;
        public final ForgeConfigSpec.ConfigValue<String> id;
        public final ForgeConfigSpec.IntValue passiveMobsPerPlayer;
        public final ForgeConfigSpec.IntValue passiveMobsPerWorld;
        public final ForgeConfigSpec.IntValue passiveMobsPerServer;
        public final ForgeConfigSpec.ConfigValue<List<String>> passiveMobsList;
        public final ForgeConfigSpec.IntValue neutralMobsPerPlayer;
        public final ForgeConfigSpec.IntValue neutralMobsPerWorld;
        public final ForgeConfigSpec.IntValue neutralMobsPerServer;
        public final ForgeConfigSpec.ConfigValue<List<String>> neutralMobsList;
        public final ForgeConfigSpec.IntValue hostileMobsPerPlayer;
        public final ForgeConfigSpec.IntValue hostileMobsPerWorld;
        public final ForgeConfigSpec.IntValue hostileMobsPerServer;
        public final ForgeConfigSpec.ConfigValue<List<String>> hostileMobsList;

        Config(ForgeConfigSpec.Builder builder) {
            builder.comment("Adaptive Performance Tweaks: Spawn");
            builder.push("Mekanism Spawn Config");
            this.enabled = builder.define("Enabled", true);
            this.id = builder.define("Id", (Object)"mekanismadditions");
            this.passiveMobsPerPlayer = builder.defineInRange("MaxPassiveMobsPerPlayer", 4, 1, 64);
            this.passiveMobsPerWorld = builder.defineInRange("MaxPassiveMobsPerWorld", 12, 1, 512);
            this.passiveMobsPerServer = builder.defineInRange("MaxPassiveMobsPerServer", 320, 1, 1024);
            this.passiveMobsList = builder.comment("List of passive Mobs to optimize in the format [\"minecraft:bat\", \"minecraft:cat\", ..]").define("PassiveMobsList", new ArrayList(List.of()));
            this.neutralMobsPerPlayer = builder.defineInRange("MaxNeutralMobsPerPlayer", 4, 1, 64);
            this.neutralMobsPerWorld = builder.defineInRange("MaxNeutralMobsPerWorld", 16, 1, 512);
            this.neutralMobsPerServer = builder.defineInRange("MaxNeutralMobsPerServer", 320, 1, 1024);
            this.neutralMobsList = builder.comment("List of neutral Mobs to optimize in the format [\"minecraft:bee\", \"minecraft:wolf\", ..]").define("NeutralMobsList", new ArrayList(List.of()));
            this.hostileMobsPerPlayer = builder.defineInRange("MaxHostileMobsPerPlayer", 4, 1, 64);
            this.hostileMobsPerWorld = builder.defineInRange("MaxHostileMobsPerWorld", 16, 1, 512);
            this.hostileMobsPerServer = builder.defineInRange("MaxHostileMobsPerServer", 320, 1, 1024);
            this.hostileMobsList = builder.comment("List of hostile Mobs to optimize in the format [\"minecraft:blaze\", \"minecraft:cave_spider\", ..]").define("HostileMobsList", new ArrayList<String>(Arrays.asList("mekanismadditions:baby_creeper", "mekanismadditions:baby_enderman", "mekanismadditions:baby_skeleton", "mekanismadditions:baby_stray", "mekanismadditions:baby_wither_skeleton")));
            builder.pop();
        }
    }
}

