/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.adaptiveperformancetweaksspawn.spawn;

import de.markusbordihn.adaptiveperformancetweakscore.CoreConstants;
import de.markusbordihn.adaptiveperformancetweakscore.entity.CoreEntityManager;
import de.markusbordihn.adaptiveperformancetweakscore.message.WarnMessages;
import de.markusbordihn.adaptiveperformancetweakscore.player.PlayerPositionManager;
import de.markusbordihn.adaptiveperformancetweakscore.server.ServerLevelLoad;
import de.markusbordihn.adaptiveperformancetweakscore.server.ServerLevelLoadEvent;
import de.markusbordihn.adaptiveperformancetweakscore.server.ServerLoadEvent;
import de.markusbordihn.adaptiveperformancetweakscore.server.ServerManager;
import de.markusbordihn.adaptiveperformancetweaksspawn.config.CommonConfig;
import de.markusbordihn.adaptiveperformancetweaksspawn.spawn.SpawnConfigManager;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.living.LivingConversionEvent;
import net.minecraftforge.event.entity.living.MobSpawnEvent;
import net.minecraftforge.event.server.ServerAboutToStartEvent;
import net.minecraftforge.event.server.ServerStartedEvent;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber
public class SpawnManager {
    protected static final Logger log = LogManager.getLogger((String)"APTweaks(Spawn)");
    private static final CommonConfig.Config COMMON = CommonConfig.COMMON;
    private static final int SERVER_STARTED_DELAY_TICKS = 400;
    private static final Map<String, ServerLevelLoad.ServerLevelLoadLevel> serverLevelLoadLevel = new ConcurrentHashMap<String, ServerLevelLoad.ServerLevelLoadLevel>();
    private static Set<String> allowList = new HashSet<String>();
    private static Set<String> denyList = new HashSet<String>();
    private static Set<String> ignoreDimensionList = new HashSet<String>();
    private static boolean allowZombieVillagerConversion = false;
    private static boolean hasHighServerLoad = false;
    private static boolean serverStarted = false;
    private static boolean serverStartedDelay = false;
    private static Entity lastAllowedSpawnEntity;
    private static Entity lastBlockedSpawnEntity;
    private static int friendlyChunkCounter;
    private static int serverStartedDelayTicks;
    private static int spawnLimiter;

    protected SpawnManager() {
    }

    @SubscribeEvent
    public static void handleServerAboutToStartEvent(ServerAboutToStartEvent event) {
        serverStarted = false;
        serverStartedDelay = false;
        serverStartedDelayTicks = 0;
        allowList = new HashSet<String>((Collection)SpawnManager.COMMON.spawnAllowList.get());
        denyList = new HashSet<String>((Collection)SpawnManager.COMMON.spawnDenyList.get());
        ignoreDimensionList = new HashSet<String>((Collection)SpawnManager.COMMON.spawnIgnoreDimensionList.get());
    }

    private static void showModSpecificWarnings() {
        if (CoreConstants.CHUNK_PREGEN_LOADED) {
            log.warn(() -> WarnMessages.chunkPregeneratorModWarning((String)"Chunk Pregenerator"));
        }
        if (CoreConstants.PERFORMANT_LOADED) {
            log.warn(() -> WarnMessages.coreModWarning((String)"Performant"));
        }
        if (CoreConstants.POKECUBE_AIO_LOADED) {
            log.warn(() -> WarnMessages.knownIssuesSpawnModWarning((String)"Pokecube AIO"));
        }
        if (CoreConstants.SODIUM_LOADED) {
            log.error(() -> WarnMessages.coreModWarning((String)"Sodium"));
        }
        if (CoreConstants.RUBIDIUM_LOADED) {
            log.error(() -> WarnMessages.coreModWarning((String)"Rubidium"));
        }
        if (CoreConstants.INCONTROL_LOADED) {
            log.warn(() -> WarnMessages.conflictingFeaturesModWarning((String)"InControl", (String)"controls the mob spawns and entity spawns"));
        }
        if (CoreConstants.THE_ENDERGETIC_EXPANSION_LOADED) {
            log.warn(() -> WarnMessages.knownIssuesGeneralModWarning((String)"The Endergetic Expansion"));
        }
        if (CoreConstants.CREATE_LOADED) {
            log.warn(() -> WarnMessages.disabledOptimizationModWarning((String)"Create"));
        }
        if (CoreConstants.BIGGER_REACTORS_LOADED) {
            log.warn(() -> WarnMessages.disabledOptimizationModWarning((String)"Bigger Reactors"));
        }
        if (CoreConstants.BOTANIA_LOADED) {
            log.warn(() -> WarnMessages.disabledOptimizationModWarning((String)"Botania"));
        }
        if (CoreConstants.INDUSTRIAL_FOREGOING_LOADED) {
            log.warn(() -> WarnMessages.disabledOptimizationModWarning((String)"Industrial Foregoing"));
        }
        if (CoreConstants.MEKANISM_LOADED) {
            log.warn(() -> WarnMessages.disabledOptimizationModWarning((String)"Mekanism"));
        }
        if (CoreConstants.PIPEZ_LOADED) {
            log.warn(() -> WarnMessages.disabledOptimizationModWarning((String)"Pipez"));
        }
        if (CoreConstants.POKECUBE_AIO_LOADED) {
            log.warn(() -> WarnMessages.disabledOptimizationModWarning((String)"Pokecube AIO"));
        }
        if (CoreConstants.REFINED_STORAGE_LOADED) {
            log.warn(() -> WarnMessages.disabledOptimizationModWarning((String)"Refined Storage"));
        }
        if (CoreConstants.ULTIMATE_CAR_LOADED) {
            log.warn(() -> WarnMessages.disabledOptimizationModWarning((String)"Ultimate Car Mod"));
        }
        if (CoreConstants.VIESCRAFT_MACHINES_LOADED) {
            log.warn(() -> WarnMessages.disabledOptimizationModWarning((String)"ViesCraft Machines"));
        }
        if (CoreConstants.XNET_LOADED) {
            log.warn(() -> WarnMessages.disabledOptimizationModWarning((String)"XNet"));
        }
    }

    @SubscribeEvent
    public static void handleServerStarting(ServerStartingEvent event) {
        if (!allowList.isEmpty()) {
            log.info("{} Spawn allow list: {}", (Object)"[APTweaks:Spawn]", allowList);
        }
        if (!denyList.isEmpty()) {
            log.info("{} Spawn deny list: {}", (Object)"[APTweaks:Spawn]", denyList);
        }
        if (!ignoreDimensionList.isEmpty()) {
            log.info("{} Ignore dimension list: {}", (Object)"[APTweaks:Spawn]", ignoreDimensionList);
        }
        if (Boolean.TRUE.equals(SpawnManager.COMMON.spawnAggressiveMode.get())) {
            log.warn("Enable more aggressive spawn optimizations!");
        } else {
            log.info("If you want to use a more aggressive spawn optimization, please set 'spawnAggressiveMode' to 'true'");
        }
        if (Boolean.FALSE.equals(SpawnManager.COMMON.viewAreaEnabled.get())) {
            log.info("Disable view area optimizations!");
        }
        if (Boolean.TRUE.equals(SpawnManager.COMMON.spawnLimitationEnabled.get())) {
            if ((Integer)SpawnManager.COMMON.spawnLimitationLimiter.get() > 0) {
                log.info("{} \u2713 Enable limiter and block randomly every {} mob from spawning ...", (Object)"[APTweaks:Spawn]", SpawnManager.COMMON.spawnLimitationLimiter.get());
            }
            if ((Integer)SpawnManager.COMMON.spawnLimitationMaxMobsPerPlayer.get() > 0) {
                log.info("{} \u2713 Enable spawn rate control with max {} per player ...", (Object)"[APTweaks:Spawn]", SpawnManager.COMMON.spawnLimitationMaxMobsPerPlayer.get());
            }
            if ((Integer)SpawnManager.COMMON.spawnLimitationMaxMobsPerWorld.get() > 0) {
                log.info("{} \u2713 Enable spawn rate control with max {} per world ...", (Object)"[APTweaks:Spawn]", SpawnManager.COMMON.spawnLimitationMaxMobsPerWorld.get());
            }
            if ((Integer)SpawnManager.COMMON.spawnLimitationMaxMobsPerServer.get() > 0) {
                log.info("{} \u2713 Enable spawn rate control with max {} per server ...", (Object)"[APTweaks:Spawn]", SpawnManager.COMMON.spawnLimitationMaxMobsPerServer.get());
            }
        }
        SpawnManager.showModSpecificWarnings();
    }

    @SubscribeEvent
    public static void handleServerStarted(ServerStartedEvent event) {
        serverStarted = true;
    }

    @SubscribeEvent
    public static void handleServerTickEvent(TickEvent.ServerTickEvent event) {
        if (serverStarted && !serverStartedDelay) {
            if (event.phase == TickEvent.Phase.START) {
                if (serverStartedDelayTicks >= 400) {
                    serverStartedDelay = true;
                }
            } else {
                ++serverStartedDelayTicks;
            }
        }
    }

    @SubscribeEvent
    public static void handleServerLoadEvent(ServerLoadEvent event) {
        if (event.hasChanged()) {
            hasHighServerLoad = event.hasHighServerLoad();
        }
    }

    @SubscribeEvent
    public static void handleServerLevelLoadEvent(ServerLevelLoadEvent event) {
        if (event.hasChanged()) {
            serverLevelLoadLevel.put(event.getServerLevelName(), event.getServerLevelLoadLevel());
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void handleFinalizeSpawnEvent(MobSpawnEvent.FinalizeSpawn event) {
        if (!event.isSpawnCancelled()) {
            SpawnManager.handleSpawnEvent((EntityEvent)event);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void handleEntityJoinWorldEvent(EntityJoinLevelEvent event) {
        SpawnManager.handleSpawnEvent((EntityEvent)event);
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void handleLivingConversionEvent(LivingConversionEvent.Pre event) {
        SpawnManager.handleConversionEvent(event);
    }

    private static void handleConversionEvent(LivingConversionEvent.Pre event) {
        if (event.getEntity() != null && event.getEntity().m_6095_() == EntityType.f_20492_ && event.getOutcome() == EntityType.f_20530_) {
            log.debug("[Zombie Villager Conversion] Convert {} to {}", (Object)event.getEntity(), (Object)event.getOutcome());
            allowZombieVillagerConversion = true;
        }
    }

    private static void handleSpawnEvent(EntityEvent event) {
        String eventType;
        if (event.isCanceled() || event.getResult() == Event.Result.DENY) {
            log.debug("[Canceled / denied Spawn Event] Ignore spawn event {}!", (Object)event);
            return;
        }
        Entity entity = event.getEntity();
        Level level = entity.m_9236_();
        if (level.m_5776_()) {
            return;
        }
        if (!serverStarted) {
            log.debug("[Server not started] Ignore spawn event {}!", (Object)event);
            return;
        }
        if (!serverStartedDelay) {
            log.debug("[Server start delay ({}/{})] Ignore spawn event {}!", (Object)serverStartedDelayTicks, (Object)400, (Object)event);
            return;
        }
        String entityName = entity.m_20078_();
        String levelName = level.m_46472_().m_135782_().toString();
        String string = eventType = event instanceof MobSpawnEvent.FinalizeSpawn ? "spawn" : "join";
        if (ignoreDimensionList.contains(levelName)) {
            log.debug("[Ignored Dimension] Allow spawn event for {} in {}", (Object)entity, (Object)levelName);
            return;
        }
        if (Boolean.TRUE.equals(SpawnManager.COMMON.spawnEggBypassLimitations.get()) && event instanceof MobSpawnEvent.FinalizeSpawn) {
            MobSpawnEvent.FinalizeSpawn finalizeSpawnEvent = (MobSpawnEvent.FinalizeSpawn)event;
            try {
                MobSpawnType spawnType = finalizeSpawnEvent.getSpawnType();
                if (spawnType == MobSpawnType.SPAWN_EGG) {
                    log.debug("[Spawn Egg] Allow spawn egg usage for {} in {}", (Object)entity, (Object)levelName);
                    lastAllowedSpawnEntity = entity;
                    return;
                }
            }
            catch (Exception e) {
                log.debug("[Spawn Egg Detection] Could not determine spawn type for {} in {}: {}", (Object)entity, (Object)levelName, (Object)e.getMessage());
            }
        }
        if (!CoreEntityManager.isRelevantEntity((Entity)entity, (String)entityName)) {
            return;
        }
        if (allowList.contains(entityName)) {
            log.debug("[Allowed Entity] Allow spawn event for {} in {}", (Object)entity, (Object)levelName);
            return;
        }
        if (lastAllowedSpawnEntity == entity || lastBlockedSpawnEntity == entity) {
            return;
        }
        if (allowZombieVillagerConversion && "minecraft:zombie_villager".equals(entityName)) {
            log.debug("[Zombie Villager Conversion] Allow {} event for {} in {}", (Object)eventType, (Object)entity, (Object)levelName);
            allowZombieVillagerConversion = false;
            return;
        }
        if (denyList.contains(entityName)) {
            log.debug("[Denied Entity] Denied {} event for {} in {}", (Object)eventType, (Object)entity, (Object)levelName);
            SpawnManager.cancelSpawnEvent(event);
            return;
        }
        if (entity.m_8077_()) {
            log.debug("[Custom Entity] Skip {} event for {} in {}", (Object)eventType, (Object)entity, (Object)levelName);
            return;
        }
        int entitySpawnX = 0;
        int entitySpawnY = 0;
        int entitySpawnZ = 0;
        boolean hasSpawnPosition = false;
        if (event instanceof MobSpawnEvent) {
            MobSpawnEvent mobSpawnEvent = (MobSpawnEvent)event;
            entitySpawnX = (int)mobSpawnEvent.getX();
            entitySpawnY = (int)mobSpawnEvent.getY();
            entitySpawnZ = (int)mobSpawnEvent.getZ();
            hasSpawnPosition = true;
        }
        int numberOfEntities = CoreEntityManager.getNumberOfEntities((String)entityName);
        int spawnLimitationMaxMobsPerServer = (Integer)SpawnManager.COMMON.spawnLimitationMaxMobsPerServer.get();
        if (spawnLimitationMaxMobsPerServer > 0 && numberOfEntities >= spawnLimitationMaxMobsPerServer) {
            log.debug("[Spawn Limitations Server] Blocked {} event for {} with {} entities of max {} in {}.", (Object)eventType, (Object)entity, (Object)numberOfEntities, (Object)spawnLimitationMaxMobsPerServer, (Object)levelName);
            SpawnManager.cancelSpawnEvent(event);
            return;
        }
        int numberOfEntitiesPerWorld = CoreEntityManager.getNumberOfEntities((String)levelName, (String)entityName);
        int spawnLimitationMaxMobsPerWorld = (Integer)SpawnManager.COMMON.spawnLimitationMaxMobsPerWorld.get();
        if (spawnLimitationMaxMobsPerWorld > 0 && numberOfEntitiesPerWorld >= spawnLimitationMaxMobsPerWorld) {
            log.debug("[Spawn Limitations World] Blocked {} event for {} with {} entities of max {} in {}.", (Object)eventType, (Object)entity, (Object)numberOfEntitiesPerWorld, (Object)spawnLimitationMaxMobsPerWorld, (Object)levelName);
            SpawnManager.cancelSpawnEvent(event);
            return;
        }
        int spawnLimitationLimiter = (Integer)SpawnManager.COMMON.spawnLimitationLimiter.get();
        if (spawnLimitationLimiter > 0 && spawnLimiter++ >= spawnLimitationLimiter) {
            log.debug("[Spawn Limiter {}] Blocked {} event for {} with {} entities in {}.", (Object)spawnLimitationLimiter, (Object)eventType, (Object)entity, (Object)numberOfEntities, (Object)levelName);
            SpawnManager.cancelSpawnEvent(event);
            spawnLimiter = 0;
            return;
        }
        BlockPos chunkSpawnPosition = hasSpawnPosition ? new BlockPos(entitySpawnX, entitySpawnY, entitySpawnZ) : null;
        boolean hasEntitySpawnedInChunk = hasSpawnPosition && CoreEntityManager.hasEntitySpawnedInChunk((String)levelName, (BlockPos)chunkSpawnPosition);
        int friendlyChunkSpawnRate = (Integer)SpawnManager.COMMON.friendlyChunkSpawnRate.get();
        if (!hasEntitySpawnedInChunk && friendlyChunkSpawnRate > 0 && friendlyChunkCounter++ > friendlyChunkSpawnRate) {
            if (numberOfEntities < SpawnConfigManager.getSpawnLimitPerServer(entityName) && numberOfEntities < SpawnConfigManager.getSpawnLimitPerWorld(entityName)) {
                log.debug("[Friendly Spawn per {} x Chunk] Allow {} event for {} in {}", (Object)friendlyChunkSpawnRate, (Object)eventType, (Object)entity, (Object)levelName);
                lastAllowedSpawnEntity = entity;
                friendlyChunkCounter = 0;
                return;
            }
            log.debug("[Friendly Spawn per {} x Chunk] Ignore {} event for {} in {} exceeding world / server limits", (Object)friendlyChunkSpawnRate, (Object)eventType, (Object)entity, (Object)levelName);
        }
        List playersPositionsInsideViewArea = null;
        int numOfPlayersInsideViewArea = 0;
        if (Boolean.TRUE.equals(SpawnManager.COMMON.viewAreaEnabled.get()) && hasSpawnPosition && (numOfPlayersInsideViewArea = (playersPositionsInsideViewArea = PlayerPositionManager.getPlayerPositionsInsideViewArea((String)levelName, (int)entitySpawnX, (int)entitySpawnY, (int)entitySpawnZ)).size()) == 0) {
            log.debug("[View Area Visibility] Blocked {} event for {} with {} entities and {} players in {}.", (Object)eventType, (Object)entity, (Object)numberOfEntities, (Object)numOfPlayersInsideViewArea, (Object)levelName);
            SpawnManager.cancelSpawnEvent(event);
            return;
        }
        int numberOfEntitiesInsideViewArea = 0;
        int spawnLimitationMaxMobsPerPlayer = (Integer)SpawnManager.COMMON.spawnLimitationMaxMobsPerPlayer.get();
        if (playersPositionsInsideViewArea != null) {
            numberOfEntitiesInsideViewArea = CoreEntityManager.getNumberOfEntitiesInPlayerPositions((String)levelName, (String)entityName, (List)playersPositionsInsideViewArea);
            if (spawnLimitationMaxMobsPerPlayer > 0 && numberOfEntitiesInsideViewArea >= spawnLimitationMaxMobsPerPlayer) {
                log.debug("[Spawn Limitations Player] Blocked {} event for {} with {} entities of max {} and {} players in {}.", (Object)eventType, (Object)entity, (Object)numberOfEntitiesInsideViewArea, (Object)spawnLimitationMaxMobsPerPlayer, (Object)numOfPlayersInsideViewArea, (Object)levelName);
                SpawnManager.cancelSpawnEvent(event);
                return;
            }
        }
        ServerLevelLoad.ServerLevelLoadLevel levelLoadLevel = serverLevelLoadLevel.computeIfAbsent(levelName, key -> ServerLevelLoad.getLevelNameLoadLevel().getOrDefault(key, ServerLevelLoad.ServerLevelLoadLevel.NORMAL));
        boolean aggressiveMode = Boolean.TRUE.equals(SpawnManager.COMMON.spawnAggressiveMode.get());
        boolean limitSpawnPerLimits = Boolean.TRUE.equals(hasHighServerLoad || ServerLevelLoad.hasHighLevelLoad((ServerLevelLoad.ServerLevelLoadLevel)levelLoadLevel) || aggressiveMode);
        if (limitSpawnPerLimits) {
            double spawnFactor = aggressiveMode ? 1.0 : ServerManager.getGameDifficultyFactor();
            int limitPerWorld = SpawnConfigManager.getSpawnLimitPerWorld(entityName);
            int limitPerPlayer = SpawnConfigManager.getSpawnLimitPerPlayer(entityName);
            int limitPerServer = SpawnConfigManager.getSpawnLimitPerServer(entityName);
            int numberOfPlayers = ServerManager.getNumberOfPlayers();
            if (limitPerServer > 0 && numberOfPlayers * limitPerPlayer <= limitPerServer && (double)numberOfEntities >= (double)limitPerServer * spawnFactor) {
                log.debug("[Server limit!] Blocked {} event for {} with {} entities of max {} in {}", (Object)eventType, (Object)entity, (Object)numberOfEntities, (Object)limitPerServer, (Object)levelName);
                SpawnManager.cancelSpawnEvent(event);
                return;
            }
            if (limitPerWorld > 0 && numberOfPlayers * limitPerPlayer <= limitPerWorld && (double)numberOfEntitiesPerWorld >= (double)limitPerWorld * spawnFactor) {
                log.debug("[World limit!] Blocked {} event for {} with {} entities of max {} in {}", (Object)eventType, (Object)entity, (Object)numberOfEntitiesPerWorld, (Object)limitPerWorld, (Object)levelName);
                SpawnManager.cancelSpawnEvent(event);
                return;
            }
            if (hasHighServerLoad && limitPerPlayer > 0 && numOfPlayersInsideViewArea > 0 && (double)numberOfEntitiesPerWorld >= (double)(limitPerPlayer * limitPerPlayer * numOfPlayersInsideViewArea) * spawnFactor) {
                log.debug("[High Server Load!] Blocked {} event for {} with {} entities of max {} and {} players in {}", (Object)eventType, (Object)entity, (Object)numberOfEntitiesPerWorld, (Object)limitPerPlayer, (Object)numOfPlayersInsideViewArea, (Object)levelName);
                SpawnManager.cancelSpawnEvent(event);
                return;
            }
            if (limitPerPlayer > 0 && numberOfEntitiesInsideViewArea > 0 && (double)numberOfEntitiesInsideViewArea >= (double)(limitPerPlayer * numOfPlayersInsideViewArea) * spawnFactor) {
                log.debug("[View Area Limit!] Blocked {} event for {} with {} entities of max {} and {} players in {}", (Object)eventType, (Object)entity, (Object)numberOfEntitiesInsideViewArea, (Object)limitPerPlayer, (Object)numOfPlayersInsideViewArea, (Object)levelName);
                SpawnManager.cancelSpawnEvent(event);
                return;
            }
        }
        if (!limitSpawnPerLimits) {
            log.debug("[Allow {} (low load)] For {} in {} and {} in world and {} global", (Object)eventType, (Object)entity, (Object)levelName, (Object)numberOfEntitiesPerWorld, (Object)numberOfEntities);
        } else if (numberOfEntitiesInsideViewArea > 0) {
            log.debug("[Allow {}] For {} in {} with {} in view area and {} in world and {} global", (Object)eventType, (Object)entity, (Object)levelName, (Object)numberOfEntitiesInsideViewArea, (Object)numberOfEntitiesPerWorld, (Object)numberOfEntities);
        } else {
            log.debug("[Allow {}] For {} in {} with {} in world and {} global", (Object)eventType, (Object)entity, (Object)levelName, (Object)numberOfEntitiesPerWorld, (Object)numberOfEntities);
        }
        lastAllowedSpawnEntity = entity;
    }

    private static void cancelSpawnEvent(EntityEvent event) {
        try {
            if (event instanceof MobSpawnEvent.FinalizeSpawn) {
                MobSpawnEvent.FinalizeSpawn finalizeSpawnEvent = (MobSpawnEvent.FinalizeSpawn)event;
                event.setCanceled(true);
                finalizeSpawnEvent.setSpawnCancelled(true);
                lastBlockedSpawnEntity = event.getEntity();
            } else if (event instanceof EntityJoinLevelEvent) {
                event.setCanceled(true);
                lastBlockedSpawnEntity = event.getEntity();
            }
        }
        catch (Exception e) {
            log.error("Failed to cancel spawn event for {}:", (Object)event.getEntity(), (Object)e);
        }
    }

    static {
        friendlyChunkCounter = 0;
        serverStartedDelayTicks = 0;
        spawnLimiter = 0;
    }
}

