/*
 * Decompiled with CFR 0.152.
 */
package org.adaptiveoptimization;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import cpw.mods.modlauncher.serviceapi.ILaunchPluginService;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryUsage;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.time.Instant;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Deque;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.LongAdder;
import java.util.concurrent.locks.LockSupport;
import java.util.function.Consumer;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.server.ServerStartedEvent;
import net.minecraftforge.event.server.ServerStoppingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.objectweb.asm.tree.VarInsnNode;

@Mod(value="adaptive_optimization")
public final class AdaptiveOptimization {
    public static final String MODID = "adaptive_optimization";
    private static final Logger LOGGER = LogManager.getLogger((String)"adaptive_optimization");
    private static final Engine ENGINE = new Engine();

    public AdaptiveOptimization() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void onServerStarted(ServerStartedEvent e) {
        ENGINE.start(e.getServer());
        Hooks.setServerReady(true);
        LOGGER.info("[AO] Started. 8.5.2 DISCOVER + EVOLVE active (no fixed targets).");
    }

    @SubscribeEvent
    public void onServerStopping(ServerStoppingEvent e) {
        Hooks.setServerReady(false);
        ENGINE.stop();
        LOGGER.info("[AO] Stopped. State saved.");
    }

    @SubscribeEvent
    public void onServerTick(TickEvent.ServerTickEvent e) {
        if (e.phase == TickEvent.Phase.END) {
            ENGINE.tick();
        }
    }

    private static final class Engine {
        private MinecraftServer server;
        private Phase phase = Phase.DISCOVER;
        private int tick;
        private int seconds;
        private int windowTicks;
        private static final int WINDOW_TICKS = 200;
        private static final int DISCOVER_MIN_SECONDS = 90;
        private static final int DISCOVER_MAX_SECONDS = 360;
        private static final int SAVE_COALESCE_MS = 1500;
        private int baseBudget;
        private int stableWindows;
        private int spikeWindows;
        private long lastHeavyMs = 0L;
        private int heavyJitterTicks = 0;
        private BackgroundWorker bg;
        private final Monitor monitor = new Monitor();
        private final PlanStore plan = new PlanStore();
        private int selfRetreatSeconds = 0;
        private int profilerMuteSeconds = 0;
        private final AtomicBoolean running = new AtomicBoolean(false);
        private int samplingN = 4;

        private Engine() {
        }

        void start(MinecraftServer srv) {
            BackgroundWorker old = this.bg;
            this.bg = new BackgroundWorker();
            if (old != null) {
                old.shutdown();
            }
            this.server = srv;
            this.running.set(true);
            this.tick = 0;
            this.seconds = 0;
            this.windowTicks = 0;
            this.stableWindows = 0;
            this.spikeWindows = 0;
            this.lastHeavyMs = 0L;
            this.heavyJitterTicks = 0;
            this.selfRetreatSeconds = 0;
            this.profilerMuteSeconds = 0;
            this.monitor.reset();
            this.plan.init();
            this.plan.load();
            if (!this.plan.lastRunCleanShutdown()) {
                LOGGER.warn("[AO] Detected previous unclean shutdown. Retreating newest genomes + softening remaining ones.");
                this.plan.onCrashRetreat();
                this.plan.save();
            }
            this.plan.markRunStarted();
            this.baseBudget = this.computeInitialBudget();
            Hooks.setOptimizeMode(true);
            Hooks.setProfilerEnabled(true);
            Hooks.setProfileEveryNTicks(4);
            Hooks.resetBudget(this.baseBudget);
            Hooks.setServerTick(0);
            this.phase = Phase.DISCOVER;
        }

        void stop() {
            this.running.set(false);
            this.server = null;
            Hooks.setOptimizeMode(false);
            Hooks.setProfilerEnabled(false);
            try {
                this.plan.markRunCleanShutdown();
                this.plan.save();
            }
            catch (Throwable t) {
                LOGGER.warn("[AO] Save failed: {}", (Object)t.toString());
            }
            BackgroundWorker b = this.bg;
            this.bg = null;
            if (b != null) {
                b.shutdown();
            }
        }

        void tick() {
            if (!this.running.get()) {
                return;
            }
            if (this.server == null) {
                return;
            }
            ++this.tick;
            ++this.windowTicks;
            Hooks.setServerTick(this.tick);
            Hooks.resetBudget(this.baseBudget);
            this.monitor.update(this.server);
            if (this.tick % 20 == 0) {
                ++this.seconds;
                this.adaptBudgetAndSampling();
                if (this.selfRetreatSeconds > 0) {
                    --this.selfRetreatSeconds;
                }
                if (this.profilerMuteSeconds > 0) {
                    --this.profilerMuteSeconds;
                }
                if (this.profilerMuteSeconds > 0) {
                    Hooks.setProfilerEnabled(false);
                } else {
                    Hooks.setProfilerEnabled(true);
                }
            }
            if (this.windowTicks >= 200) {
                this.windowTicks = 0;
                this.onWindow();
            }
        }

        private void onWindow() {
            boolean allowHeavy;
            boolean spikeWindow;
            if (!this.running.get()) {
                return;
            }
            if (this.server == null) {
                return;
            }
            double tps = this.monitor.getAvgTPS();
            double mspt = this.monitor.getAvgMSPT();
            double mem = this.monitor.getHeapUsageRatio();
            boolean critical = tps < 15.0 || mem > 0.92;
            boolean stable = tps >= 19.4 && mem < 0.85;
            Monitor.WindowStats ws = this.monitor.computeWindowStats();
            boolean bl = spikeWindow = ws.spikeCount > 0 || ws.p99Mspt > 60.0 || tps < 18.5;
            if (spikeWindow) {
                ++this.spikeWindows;
            } else {
                ++this.stableWindows;
            }
            if (spikeWindow) {
                this.profilerMuteSeconds = Math.max(this.profilerMuteSeconds, 8);
            }
            if (this.phase == Phase.DISCOVER) {
                boolean maxOk;
                boolean minOk = this.seconds >= 90;
                boolean bl2 = maxOk = this.seconds >= 360;
                if (minOk && stable && this.plan.genomeCount() > 0 || maxOk) {
                    this.phase = Phase.OPTIMIZE;
                    LOGGER.info("[AO] Phase transition: DISCOVER -> OPTIMIZE (genomes evolve; structural changes fully apply next run for already-loaded classes).");
                }
            }
            if (spikeWindow && this.selfRetreatSeconds <= 0) {
                this.selfRetreatSeconds = 45;
                this.baseBudget = Engine.clamp(this.baseBudget - 8, 10, 240);
            }
            int baseWindows = 4;
            if (critical) {
                baseWindows = 6;
            }
            if (this.stableWindows > 10 && this.spikeWindows == 0) {
                baseWindows = 3;
            }
            if (this.heavyJitterTicks == 0) {
                this.heavyJitterTicks = 20 + ThreadLocalRandom.current().nextInt(0, 60);
            }
            boolean timeOk = System.currentTimeMillis() - this.lastHeavyMs > (long)baseWindows * 10000L + (long)this.heavyJitterTicks * 50L;
            boolean bl3 = allowHeavy = timeOk && !spikeWindow && !critical && this.selfRetreatSeconds <= 0;
            if (allowHeavy) {
                this.lastHeavyMs = System.currentTimeMillis();
                this.heavyJitterTicks = 0;
                Map<String, Hooks.StatSnap> prof = Hooks.snapshotProfileBounded(1200);
                double ftps = tps;
                double fmspt = mspt;
                double fmem = mem;
                boolean fcritical = critical;
                BackgroundWorker w = this.bg;
                if (w != null && w.isAlive()) {
                    w.queueEvolve(() -> {
                        boolean changed = this.plan.evolveFromProfiling(prof, ftps, fmspt, fmem, fcritical);
                        if (changed) {
                            BackgroundWorker w2 = this.bg;
                            if (w2 != null && w2.isAlive()) {
                                w2.queueSave(1500L, this.plan::save);
                            } else {
                                this.plan.save();
                            }
                        }
                    });
                }
            }
            LOGGER.debug("[AO] Phase={} TPS={} MSPT={} p95={} p99={} spikes={} MEM={} budget={} sample=1/{} genomes={} blacklist={} retreat={} profMute={}", new Object[]{this.phase.name(), Engine.fmt2(tps), Engine.fmt2(mspt), Engine.fmt2(ws.p95Mspt), Engine.fmt2(ws.p99Mspt), ws.spikeCount, Engine.fmtPct(mem), this.baseBudget, this.getSamplingN(), this.plan.genomeCount(), this.plan.blacklistCount(), this.selfRetreatSeconds, this.profilerMuteSeconds});
        }

        private int getSamplingN() {
            return this.samplingN;
        }

        private void adaptBudgetAndSampling() {
            boolean stressed;
            double tps = this.monitor.getAvgTPS();
            double mem = this.monitor.getHeapUsageRatio();
            double mspt = this.monitor.getAvgMSPT();
            boolean critical = tps < 15.0 || mem > 0.92 || mspt > 60.0;
            boolean bl = stressed = tps < 18.5 || mem > 0.88 || mspt > 40.0;
            if (this.selfRetreatSeconds > 0) {
                this.baseBudget = Engine.clamp(this.baseBudget - 2, 10, 240);
                this.samplingN = Engine.clamp(this.samplingN + 1, 4, 40);
                Hooks.setProfileEveryNTicks(this.samplingN);
                return;
            }
            if (critical) {
                this.baseBudget = Engine.clamp(this.baseBudget - 6, 10, 240);
                this.samplingN = Engine.clamp(this.samplingN + 2, 6, 40);
            } else if (stressed) {
                this.baseBudget = Engine.clamp(this.baseBudget + 3, 10, 240);
                this.samplingN = Engine.clamp(this.samplingN + 1, 4, 30);
            } else {
                this.samplingN = Engine.clamp(this.samplingN, 4, 20);
            }
            Hooks.setProfileEveryNTicks(this.samplingN);
        }

        private int computeInitialBudget() {
            int cores = Math.max(1, Runtime.getRuntime().availableProcessors());
            long maxHeap = Math.max(0x40000000L, Runtime.getRuntime().maxMemory());
            int memGiB = (int)Math.max(1L, maxHeap / 0x40000000L);
            int b = 26;
            b += Math.min(28, Math.max(0, cores - 4) * 2);
            return Engine.clamp(b += Math.min(64, Math.max(0, memGiB - 2) * 4), 12, 240);
        }

        private static int clamp(int v, int lo, int hi) {
            return Math.max(lo, Math.min(hi, v));
        }

        private static String fmt2(double v) {
            return String.format(Locale.ROOT, "%.2f", v);
        }

        private static String fmtPct(double v) {
            return String.format(Locale.ROOT, "%.1f%%", v * 100.0);
        }

        private static enum Phase {
            DISCOVER,
            OPTIMIZE;

        }
    }

    public static final class Hooks {
        private static volatile boolean serverReady;
        private static volatile boolean optimizeMode;
        private static volatile boolean profilerEnabled;
        private static volatile int globalBudgetPerTick;
        private static volatile int serverTick;
        private static volatile int profileEveryNTicks;
        private static final int MAX_PROFILE_KEYS = 4096;
        private static final ConcurrentHashMap<String, Stat> PROFILE;
        private static final ConcurrentHashMap<Integer, Integer> LAST_TICK_RAN;

        public static boolean isProfilerEnabled() {
            return serverReady && profilerEnabled;
        }

        public static boolean shouldProfileNow() {
            if (!serverReady || !profilerEnabled) {
                return false;
            }
            int n = profileEveryNTicks;
            if (n <= 1) {
                return true;
            }
            int t = serverTick;
            return t % n == 0;
        }

        public static void record(String key, long nanos) {
            if (!serverReady || !profilerEnabled) {
                return;
            }
            if (key == null || key.isEmpty() || nanos <= 0L) {
                return;
            }
            if (PROFILE.size() > 4096 && !PROFILE.containsKey(key)) {
                return;
            }
            Stat s = PROFILE.get(key);
            if (s == null) {
                Stat fresh = new Stat();
                Stat prev = PROFILE.putIfAbsent(key, fresh);
                s = prev != null ? prev : fresh;
            }
            s.add(nanos);
        }

        public static boolean allowWork(int costHint) {
            if (!serverReady || !optimizeMode) {
                return true;
            }
            int b = globalBudgetPerTick;
            if (b <= 0) {
                return false;
            }
            int cost = Hooks.clamp(costHint, 1, 50);
            if (b < cost) {
                return false;
            }
            globalBudgetPerTick = b - cost;
            return true;
        }

        public static boolean allowRateLimited(int methodId, int rateN, int costHint) {
            int dt;
            if (!serverReady || !optimizeMode) {
                return true;
            }
            int n = Hooks.clamp(rateN, 1, 200);
            int now = serverTick;
            Integer last = LAST_TICK_RAN.get(methodId);
            if (last != null && (dt = now - last) >= 0 && dt < n) {
                return false;
            }
            LAST_TICK_RAN.put(methodId, now);
            return Hooks.allowWork(costHint);
        }

        static void setServerReady(boolean v) {
            serverReady = v;
        }

        static void setOptimizeMode(boolean v) {
            optimizeMode = v;
        }

        static void setProfilerEnabled(boolean v) {
            profilerEnabled = v;
        }

        static void setServerTick(int t) {
            serverTick = t;
        }

        static void resetBudget(int v) {
            globalBudgetPerTick = Math.max(0, v);
        }

        static void setProfileEveryNTicks(int n) {
            profileEveryNTicks = Hooks.clamp(n, 1, 40);
        }

        static Map<String, StatSnap> snapshotProfileBounded(int maxKeys) {
            int limit = Math.max(64, Math.min(4096, maxKeys));
            HashMap<String, StatSnap> snap = new HashMap<String, StatSnap>(limit);
            int added = 0;
            for (Map.Entry<String, Stat> e : PROFILE.entrySet()) {
                long ct;
                if (added >= limit) break;
                Stat s = e.getValue();
                if (s == null || (ct = s.count.sum()) < 10L) continue;
                snap.put(e.getKey(), s.snapshot());
                ++added;
            }
            if (PROFILE.size() > 4096) {
                int removed = 0;
                Iterator<Map.Entry<String, Stat>> it = PROFILE.entrySet().iterator();
                while (it.hasNext() && removed < 64) {
                    Map.Entry<String, Stat> e = it.next();
                    Stat s = e.getValue();
                    if (s == null || s.count.sum() >= 3L) continue;
                    it.remove();
                    ++removed;
                }
            }
            return snap;
        }

        private static int clamp(int v, int lo, int hi) {
            return Math.max(lo, Math.min(hi, v));
        }

        static {
            profileEveryNTicks = 4;
            PROFILE = new ConcurrentHashMap(1024);
            LAST_TICK_RAN = new ConcurrentHashMap(512);
        }

        static final class Stat {
            final LongAdder count = new LongAdder();
            final LongAdder totalNanos = new LongAdder();
            final AtomicLong maxNanos = new AtomicLong();

            Stat() {
            }

            void add(long nanos) {
                long prev;
                this.count.increment();
                this.totalNanos.add(nanos);
                while (nanos > (prev = this.maxNanos.get()) && !this.maxNanos.compareAndSet(prev, nanos)) {
                }
            }

            StatSnap snapshot() {
                long ct = this.count.sum();
                long tot = this.totalNanos.sum();
                long mx = this.maxNanos.get();
                return new StatSnap(ct, tot, mx);
            }
        }

        static final class StatSnap {
            final long count;
            final long totalNanos;
            final long maxNanos;

            StatSnap(long c, long t, long m) {
                this.count = c;
                this.totalNanos = t;
                this.maxNanos = m;
            }

            double avgNanos() {
                return this.count <= 0L ? 0.0 : (double)this.totalNanos / (double)this.count;
            }
        }
    }

    public static final class LaunchPlugin
    implements ILaunchPluginService {
        private static final String HOOKS_OWNER = "org/adaptiveoptimization/AdaptiveOptimization$Hooks";
        private static final PlanStore PLAN = new PlanStore();
        private static final Map<String, PlanStore.Genome> GENOMES;
        private static final Set<String> BLACKLIST;

        public String name() {
            return "AdaptiveOptimizationASM_8_5_2";
        }

        public EnumSet<ILaunchPluginService.Phase> handlesClass(Type classType, boolean isEmpty) {
            if (classType == null) {
                return EnumSet.noneOf(ILaunchPluginService.Phase.class);
            }
            String in = classType.getInternalName();
            if (in == null) {
                return EnumSet.noneOf(ILaunchPluginService.Phase.class);
            }
            if (in.startsWith("net/minecraft/") || in.startsWith("com/mojang/")) {
                return EnumSet.of(ILaunchPluginService.Phase.BEFORE);
            }
            return EnumSet.noneOf(ILaunchPluginService.Phase.class);
        }

        public int processClassWithFlags(ILaunchPluginService.Phase phase, ClassNode cn, Type classType, String reason) {
            if (cn == null || classType == null) {
                return 0;
            }
            String owner = classType.getInternalName();
            if (owner == null) {
                return 0;
            }
            if (LaunchPlugin.isSensitiveOwner(owner)) {
                return 0;
            }
            boolean changed = false;
            for (MethodNode m : cn.methods) {
                PlanStore.Genome g;
                String key;
                if (m == null || m.instructions == null || m.name == null || m.desc == null || "<init>".equals(m.name) || "<clinit>".equals(m.name) || !m.desc.endsWith(")V") || !LaunchPlugin.looksTickLike(m.name) || m.tryCatchBlocks != null && !m.tryCatchBlocks.isEmpty()) continue;
                if (LaunchPlugin.isSafeToProfile(owner) && LaunchPlugin.injectProfiler(owner, m)) {
                    changed = true;
                }
                if (BLACKLIST.contains(key = owner + "#" + m.name + m.desc) || (g = GENOMES.get(key)) == null || !LaunchPlugin.isSafeToOptimize(owner, m) || LaunchPlugin.referencesSensitiveStuff(m)) continue;
                boolean appliedAny = false;
                if (LaunchPlugin.hasOp(g.ops, PlanStore.Op.HEAD_RATE)) {
                    if (LaunchPlugin.injectHeadRateLimit(m, g.methodId, g.rateN, g.costHint)) {
                        appliedAny = true;
                    }
                } else if (LaunchPlugin.hasOp(g.ops, PlanStore.Op.HEAD_BUDGET) && LaunchPlugin.injectHeadBudget(m, g.costHint)) {
                    appliedAny = true;
                }
                if (LaunchPlugin.hasOp(g.ops, PlanStore.Op.LOOP_GUARD) && LaunchPlugin.injectLoopGuard(m, g.loopStride, g.loopCost)) {
                    appliedAny = true;
                }
                if (!appliedAny) continue;
                changed = true;
            }
            return changed ? 1 : 0;
        }

        public Consumer<Dist> getExtension() {
            return null;
        }

        private static boolean injectProfiler(String owner, MethodNode m) {
            if (LaunchPlugin.containsCall(m, HOOKS_OWNER, "record", "(Ljava/lang/String;J)V")) {
                return false;
            }
            String key = owner + "#" + m.name + m.desc;
            int t0Index = m.maxLocals;
            m.maxLocals += 2;
            InsnList head = new InsnList();
            LabelNode L_no = new LabelNode();
            LabelNode L_after = new LabelNode();
            head.add((AbstractInsnNode)new MethodInsnNode(184, HOOKS_OWNER, "shouldProfileNow", "()Z", false));
            head.add((AbstractInsnNode)new JumpInsnNode(153, L_no));
            head.add((AbstractInsnNode)new MethodInsnNode(184, "java/lang/System", "nanoTime", "()J", false));
            head.add((AbstractInsnNode)new VarInsnNode(55, t0Index));
            head.add((AbstractInsnNode)new JumpInsnNode(167, L_after));
            head.add((AbstractInsnNode)L_no);
            head.add((AbstractInsnNode)new InsnNode(9));
            head.add((AbstractInsnNode)new VarInsnNode(55, t0Index));
            head.add((AbstractInsnNode)L_after);
            LaunchPlugin.insertAtStart(m, head);
            for (AbstractInsnNode ins = m.instructions.getFirst(); ins != null; ins = ins.getNext()) {
                int op = ins.getOpcode();
                if (op != 177 && op != 191) continue;
                InsnList tail = new InsnList();
                LabelNode L_skip = new LabelNode();
                tail.add((AbstractInsnNode)new VarInsnNode(22, t0Index));
                tail.add((AbstractInsnNode)new InsnNode(9));
                tail.add((AbstractInsnNode)new InsnNode(148));
                tail.add((AbstractInsnNode)new JumpInsnNode(153, L_skip));
                tail.add((AbstractInsnNode)new LdcInsnNode((Object)key));
                tail.add((AbstractInsnNode)new MethodInsnNode(184, "java/lang/System", "nanoTime", "()J", false));
                tail.add((AbstractInsnNode)new VarInsnNode(22, t0Index));
                tail.add((AbstractInsnNode)new InsnNode(101));
                tail.add((AbstractInsnNode)new MethodInsnNode(184, HOOKS_OWNER, "record", "(Ljava/lang/String;J)V", false));
                tail.add((AbstractInsnNode)L_skip);
                m.instructions.insertBefore(ins, tail);
            }
            return true;
        }

        private static boolean injectHeadBudget(MethodNode m, int costHint) {
            if (LaunchPlugin.containsCall(m, HOOKS_OWNER, "allowWork", "(I)Z")) {
                return false;
            }
            InsnList head = new InsnList();
            LabelNode L_continue = new LabelNode();
            head.add((AbstractInsnNode)new LdcInsnNode((Object)LaunchPlugin.clamp(costHint, 1, 50)));
            head.add((AbstractInsnNode)new MethodInsnNode(184, HOOKS_OWNER, "allowWork", "(I)Z", false));
            head.add((AbstractInsnNode)new JumpInsnNode(154, L_continue));
            head.add((AbstractInsnNode)new InsnNode(177));
            head.add((AbstractInsnNode)L_continue);
            LaunchPlugin.insertAtStart(m, head);
            return true;
        }

        private static boolean injectHeadRateLimit(MethodNode m, int methodId, int rateN, int costHint) {
            if (LaunchPlugin.containsCall(m, HOOKS_OWNER, "allowRateLimited", "(III)Z")) {
                return false;
            }
            InsnList head = new InsnList();
            LabelNode L_continue = new LabelNode();
            head.add((AbstractInsnNode)new LdcInsnNode((Object)methodId));
            head.add((AbstractInsnNode)new LdcInsnNode((Object)LaunchPlugin.clamp(rateN, 1, 200)));
            head.add((AbstractInsnNode)new LdcInsnNode((Object)LaunchPlugin.clamp(costHint, 1, 50)));
            head.add((AbstractInsnNode)new MethodInsnNode(184, HOOKS_OWNER, "allowRateLimited", "(III)Z", false));
            head.add((AbstractInsnNode)new JumpInsnNode(154, L_continue));
            head.add((AbstractInsnNode)new InsnNode(177));
            head.add((AbstractInsnNode)L_continue);
            LaunchPlugin.insertAtStart(m, head);
            return true;
        }

        private static boolean injectLoopGuard(MethodNode m, int stride, int loopCost) {
            int allowCalls;
            if (stride <= 0) {
                stride = 12;
            }
            if (loopCost <= 0) {
                loopCost = 3;
            }
            if ((allowCalls = LaunchPlugin.countCalls(m, HOOKS_OWNER, "allowWork", "(I)Z")) > 6) {
                return false;
            }
            IdentityHashMap<AbstractInsnNode, Integer> pos = new IdentityHashMap<AbstractInsnNode, Integer>();
            int i = 0;
            for (AbstractInsnNode ins = m.instructions.getFirst(); ins != null; ins = ins.getNext()) {
                pos.put(ins, i++);
            }
            ArrayList<JumpInsnNode> backs = new ArrayList<JumpInsnNode>(8);
            for (AbstractInsnNode ins = m.instructions.getFirst(); ins != null; ins = ins.getNext()) {
                if (!(ins instanceof JumpInsnNode)) continue;
                JumpInsnNode j = (JumpInsnNode)ins;
                Integer here = (Integer)pos.get(j);
                Integer tgt = (Integer)pos.get(j.label);
                if (here == null || tgt == null || tgt >= here) continue;
                backs.add(j);
            }
            if (backs.isEmpty()) {
                return false;
            }
            int maxPatch = LaunchPlugin.clamp(1 + backs.size() / 2, 1, LaunchPlugin.clamp(stride, 1, 24));
            Collections.shuffle(backs, ThreadLocalRandom.current());
            int patched = 0;
            for (int k = 0; k < backs.size() && patched < maxPatch; ++patched, ++k) {
                JumpInsnNode back = (JumpInsnNode)backs.get(k);
                InsnList guard = new InsnList();
                LabelNode L_ok = new LabelNode();
                guard.add((AbstractInsnNode)new LdcInsnNode((Object)LaunchPlugin.clamp(loopCost, 1, 15)));
                guard.add((AbstractInsnNode)new MethodInsnNode(184, HOOKS_OWNER, "allowWork", "(I)Z", false));
                guard.add((AbstractInsnNode)new JumpInsnNode(154, L_ok));
                guard.add((AbstractInsnNode)new InsnNode(177));
                guard.add((AbstractInsnNode)L_ok);
                m.instructions.insertBefore((AbstractInsnNode)back, guard);
            }
            return patched > 0;
        }

        private static boolean looksTickLike(String name) {
            if ("tick".equals(name)) {
                return true;
            }
            if (name.endsWith("Tick") || name.endsWith("tick")) {
                return true;
            }
            if (name.contains("ai") || name.contains("Ai") || name.contains("AI")) {
                return true;
            }
            if (name.contains("update") || name.contains("Update")) {
                return true;
            }
            return name.contains("step") || name.contains("Step");
        }

        private static boolean isSensitiveOwner(String owner) {
            String o = owner.toLowerCase(Locale.ROOT);
            return o.startsWith("net/minecraft/network/") || o.contains("/network/") || o.contains("/chunk/") || o.contains("worldgen") || o.contains("levelgen") || o.contains("region") || o.contains("save") || o.contains("storage") || o.contains("nbt") || o.contains("io/");
        }

        private static boolean isSafeToProfile(String owner) {
            return !LaunchPlugin.isSensitiveOwner(owner);
        }

        private static boolean isSafeToOptimize(String owner, MethodNode m) {
            int size;
            if ((m.access & 0x20) != 0) {
                return false;
            }
            int n = size = m.instructions == null ? 0 : m.instructions.size();
            if (size < 120) {
                return false;
            }
            int returns = 0;
            for (AbstractInsnNode ins = m.instructions.getFirst(); ins != null; ins = ins.getNext()) {
                if (ins.getOpcode() == 177) {
                    ++returns;
                }
                if (returns <= 3) continue;
                return false;
            }
            return !LaunchPlugin.isSensitiveOwner(owner);
        }

        private static boolean referencesSensitiveStuff(MethodNode m) {
            for (AbstractInsnNode ins = m.instructions.getFirst(); ins != null; ins = ins.getNext()) {
                if (ins instanceof MethodInsnNode) {
                    MethodInsnNode mi = (MethodInsnNode)ins;
                    if (LaunchPlugin.isSensitiveRef(mi.owner)) {
                        return true;
                    }
                    if (mi.desc != null && mi.desc.contains("Lnet/minecraft/network/")) {
                        return true;
                    }
                    if (mi.desc == null || !mi.desc.contains("Lnet/minecraft/world/level/chunk/")) continue;
                    return true;
                }
                if (ins instanceof FieldInsnNode) {
                    FieldInsnNode fi = (FieldInsnNode)ins;
                    if (LaunchPlugin.isSensitiveRef(fi.owner)) {
                        return true;
                    }
                    if (fi.desc != null && fi.desc.contains("Lnet/minecraft/network/")) {
                        return true;
                    }
                    if (fi.desc == null || !fi.desc.contains("Lnet/minecraft/world/level/chunk/")) continue;
                    return true;
                }
                if (!(ins instanceof TypeInsnNode)) continue;
                TypeInsnNode ti = (TypeInsnNode)ins;
                if (!LaunchPlugin.isSensitiveRef(ti.desc)) continue;
                return true;
            }
            return false;
        }

        private static boolean isSensitiveRef(String internalOrDesc) {
            if (internalOrDesc == null) {
                return false;
            }
            String s = internalOrDesc.toLowerCase(Locale.ROOT);
            return s.contains("net/minecraft/network/") || s.contains("world/level/chunk") || s.contains("chunk") || s.contains("save") || s.contains("region") || s.contains("worldgen") || s.contains("nbt") || s.contains("io/");
        }

        private static void insertAtStart(MethodNode m, InsnList insn) {
            AbstractInsnNode at;
            for (at = m.instructions.getFirst(); at != null && (at.getType() == 8 || at.getType() == 15); at = at.getNext()) {
            }
            if (at != null) {
                m.instructions.insertBefore(at, insn);
            } else {
                m.instructions.insert(insn);
            }
        }

        private static boolean containsCall(MethodNode m, String owner, String name, String desc) {
            for (AbstractInsnNode ins = m.instructions.getFirst(); ins != null; ins = ins.getNext()) {
                if (!(ins instanceof MethodInsnNode)) continue;
                MethodInsnNode mi = (MethodInsnNode)ins;
                if (!owner.equals(mi.owner) || !name.equals(mi.name) || !desc.equals(mi.desc)) continue;
                return true;
            }
            return false;
        }

        private static int countCalls(MethodNode m, String owner, String name, String desc) {
            int c = 0;
            for (AbstractInsnNode ins = m.instructions.getFirst(); ins != null; ins = ins.getNext()) {
                if (!(ins instanceof MethodInsnNode)) continue;
                MethodInsnNode mi = (MethodInsnNode)ins;
                if (!owner.equals(mi.owner) || !name.equals(mi.name) || !desc.equals(mi.desc)) continue;
                ++c;
            }
            return c;
        }

        private static boolean hasOp(int ops, PlanStore.Op op) {
            if (op == PlanStore.Op.HEAD_BUDGET) {
                return (ops & 1) != 0;
            }
            if (op == PlanStore.Op.HEAD_RATE) {
                return (ops & 2) != 0;
            }
            return (ops & 4) != 0;
        }

        private static int clamp(int v, int lo, int hi) {
            return Math.max(lo, Math.min(hi, v));
        }

        static {
            PLAN.init();
            PLAN.load();
            GENOMES = PLAN.genomesSnapshot();
            BLACKLIST = PLAN.blacklistSnapshot();
        }
    }

    private static final class PlanStore {
        private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
        private final Object lock = new Object();
        private final Map<String, Genome> genomes = new HashMap<String, Genome>();
        private final Map<String, String> blacklist = new HashMap<String, String>();
        private final Map<String, Double> historyAvg = new HashMap<String, Double>();
        private final Deque<String> newest = new ArrayDeque<String>(32);
        private boolean cleanShutdown = true;
        private Path dir;
        private Path file;

        private PlanStore() {
        }

        void init() {
            Path gameDir = Paths.get(System.getProperty("user.dir"), new String[0]).normalize();
            this.dir = gameDir.resolve("config").resolve(AdaptiveOptimization.MODID);
            this.file = this.dir.resolve("engine_state_8_5_2.json");
            try {
                Files.createDirectories(this.dir, new FileAttribute[0]);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        int genomeCount() {
            Object object = this.lock;
            synchronized (object) {
                return this.genomes.size();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        int blacklistCount() {
            Object object = this.lock;
            synchronized (object) {
                return this.blacklist.size();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean lastRunCleanShutdown() {
            Object object = this.lock;
            synchronized (object) {
                return this.cleanShutdown;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void markRunStarted() {
            Object object = this.lock;
            synchronized (object) {
                this.cleanShutdown = false;
            }
            this.save();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void markRunCleanShutdown() {
            Object object = this.lock;
            synchronized (object) {
                this.cleanShutdown = true;
            }
            this.save();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void onCrashRetreat() {
            Object object = this.lock;
            synchronized (object) {
                int bl = 0;
                while (!this.newest.isEmpty() && bl < 5) {
                    String k = this.newest.pollLast();
                    if (k == null || !this.genomes.containsKey(k)) continue;
                    this.blacklist.put(k, "crash_retreat");
                    this.genomes.remove(k);
                    ++bl;
                }
                for (Genome g : this.genomes.values()) {
                    g.costHint = PlanStore.clamp(g.costHint - 2, 1, 50);
                    g.rateN = PlanStore.clamp(g.rateN + 2, 1, 200);
                    g.loopStride = PlanStore.clamp(g.loopStride + 2, 1, 64);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean evolveFromProfiling(Map<String, Hooks.StatSnap> prof, double tps, double mspt, double mem, boolean critical) {
            if (prof == null || prof.isEmpty()) {
                return false;
            }
            boolean changed = false;
            Object object = this.lock;
            synchronized (object) {
                ArrayList<Map.Entry<String, Hooks.StatSnap>> list = new ArrayList<Map.Entry<String, Hooks.StatSnap>>(prof.entrySet());
                Iterator<Map.Entry<String, Hooks.StatSnap>> it = list.iterator();
                while (it.hasNext()) {
                    Map.Entry<String, Hooks.StatSnap> e = it.next();
                    if (e.getKey() == null) {
                        it.remove();
                        continue;
                    }
                    if (this.blacklist.containsKey(e.getKey())) {
                        it.remove();
                        continue;
                    }
                    Hooks.StatSnap s = e.getValue();
                    if (s != null && s.count >= 40L) continue;
                    it.remove();
                }
                list.sort((a, b) -> Double.compare(((Hooks.StatSnap)b.getValue()).avgNanos(), ((Hooks.StatSnap)a.getValue()).avgNanos()));
                boolean stressed = critical || tps < 18.5 || mspt > 40.0 || mem > 0.88;
                int maxTotal = 26;
                int maxNew = stressed ? 8 : 5;
                int added = 0;
                for (int i = 0; i < list.size() && added < maxNew && this.genomes.size() < maxTotal; ++i) {
                    Genome g;
                    String key = list.get(i).getKey();
                    Hooks.StatSnap s = list.get(i).getValue();
                    if (this.genomes.containsKey(key) || (g = PlanStore.generateInitialGenome(key, s.avgNanos(), stressed)) == null) continue;
                    this.genomes.put(key, g);
                    this.historyAvg.put(key, s.avgNanos());
                    this.pushNewest(key);
                    changed = true;
                    if ((++added & 3) != 0) continue;
                    LockSupport.parkNanos(200000L);
                }
                int iter = 0;
                for (Map.Entry<String, Genome> e : new ArrayList<Map.Entry<String, Genome>>(this.genomes.entrySet())) {
                    double mutP;
                    if ((++iter & 0x3FF) == 0) {
                        LockSupport.parkNanos(200000L);
                    }
                    String key = e.getKey();
                    Genome g = e.getValue();
                    Hooks.StatSnap s = prof.get(key);
                    if (s == null || s.count < 40L) continue;
                    double avg = s.avgNanos();
                    Double last = this.historyAvg.get(key);
                    this.historyAvg.put(key, avg);
                    if (PlanStore.avgToMs(avg) < 0.4 && !stressed && ThreadLocalRandom.current().nextInt(6) == 0) {
                        this.genomes.remove(key);
                        changed = true;
                        continue;
                    }
                    if (last != null) {
                        if (avg < last * 0.7) {
                            g.costHint = PlanStore.clamp(g.costHint - 1, 1, 50);
                            g.rateN = PlanStore.clamp(g.rateN + 1, 1, 200);
                            g.loopStride = PlanStore.clamp(g.loopStride + 1, 1, 64);
                            changed = true;
                        } else if (avg > last * 1.25) {
                            g.costHint = PlanStore.clamp(g.costHint + 2, 1, 50);
                            g.rateN = PlanStore.clamp(g.rateN - 1, 1, 200);
                            g.loopStride = PlanStore.clamp(g.loopStride - 1, 1, 64);
                            changed = true;
                        }
                    }
                    double ms = PlanStore.avgToMs(avg);
                    int oldOps = g.ops;
                    if (ms >= 7.0) {
                        g.ops = PlanStore.unionOps(g.ops, Op.HEAD_RATE, Op.LOOP_GUARD, Op.HEAD_BUDGET);
                        g.rateN = PlanStore.clamp(Math.max(1, g.rateN), 1, 200);
                    } else if (ms >= 2.5) {
                        g.ops = PlanStore.unionOps(g.ops, Op.HEAD_BUDGET, Op.LOOP_GUARD);
                        if (stressed && ThreadLocalRandom.current().nextInt(5) == 0) {
                            g.ops = PlanStore.unionOps(g.ops, Op.HEAD_RATE);
                        }
                    } else {
                        g.ops = PlanStore.unionOps(g.ops, Op.HEAD_BUDGET);
                        g.ops = PlanStore.removeOp(g.ops, Op.HEAD_RATE);
                        if (!stressed) {
                            g.ops = PlanStore.removeOp(g.ops, Op.LOOP_GUARD);
                        }
                    }
                    if (g.ops != oldOps) {
                        changed = true;
                    }
                    double d = mutP = stressed ? 0.08 : 0.04;
                    if (!(ThreadLocalRandom.current().nextDouble() < mutP)) continue;
                    PlanStore.mutateGenome(g, stressed);
                    this.pushNewest(key);
                    changed = true;
                }
                if (this.genomes.size() > maxTotal) {
                    ArrayList<String> keys = new ArrayList<String>(this.genomes.keySet());
                    keys.sort(Comparator.comparingDouble(k -> this.historyAvg.getOrDefault(k, 0.0)));
                    while (this.genomes.size() > maxTotal && !keys.isEmpty()) {
                        String k2 = keys.remove(0);
                        this.genomes.remove(k2);
                        changed = true;
                    }
                }
            }
            return changed;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Map<String, Genome> genomesSnapshot() {
            Object object = this.lock;
            synchronized (object) {
                return new HashMap<String, Genome>(this.genomes);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Set<String> blacklistSnapshot() {
            Object object = this.lock;
            synchronized (object) {
                return new HashSet<String>(this.blacklist.keySet());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void load() {
            Object object = this.lock;
            synchronized (object) {
                this.genomes.clear();
                this.blacklist.clear();
                this.historyAvg.clear();
                this.newest.clear();
                this.cleanShutdown = true;
            }
            if (this.file == null || !Files.exists(this.file, new LinkOption[0])) {
                return;
            }
            try (BufferedReader r = Files.newBufferedReader(this.file, StandardCharsets.UTF_8);){
                JsonObject root = (JsonObject)GSON.fromJson((Reader)r, JsonObject.class);
                if (root == null) {
                    return;
                }
                boolean loadedClean = true;
                try {
                    loadedClean = root.has("clean_shutdown") && root.get("clean_shutdown").getAsBoolean();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                JsonObject bl = root.getAsJsonObject("blacklist");
                JsonObject hist = root.getAsJsonObject("history_avg_nanos");
                JsonObject gs = root.getAsJsonObject("genomes");
                Object object2 = this.lock;
                synchronized (object2) {
                    this.cleanShutdown = loadedClean;
                    if (bl != null) {
                        for (String k : bl.keySet()) {
                            try {
                                this.blacklist.put(k, bl.get(k).getAsString());
                            }
                            catch (Throwable throwable) {}
                        }
                    }
                    if (hist != null) {
                        for (String k : hist.keySet()) {
                            try {
                                this.historyAvg.put(k, hist.get(k).getAsDouble());
                            }
                            catch (Throwable throwable) {}
                        }
                    }
                    if (gs != null) {
                        for (String k : gs.keySet()) {
                            JsonObject o = gs.getAsJsonObject(k);
                            if (o == null) continue;
                            Genome g = new Genome();
                            g.methodId = PlanStore.stableMethodId(k);
                            try {
                                g.costHint = PlanStore.clamp(o.get("costHint").getAsInt(), 1, 50);
                            }
                            catch (Throwable ignored) {
                                g.costHint = 10;
                            }
                            try {
                                g.rateN = PlanStore.clamp(o.get("rateN").getAsInt(), 1, 200);
                            }
                            catch (Throwable ignored) {
                                g.rateN = 2;
                            }
                            try {
                                g.loopStride = PlanStore.clamp(o.get("loopStride").getAsInt(), 1, 64);
                            }
                            catch (Throwable ignored) {
                                g.loopStride = 12;
                            }
                            try {
                                g.loopCost = PlanStore.clamp(o.get("loopCost").getAsInt(), 1, 15);
                            }
                            catch (Throwable ignored) {
                                g.loopCost = Math.max(1, g.costHint / 4);
                            }
                            int ops = 0;
                            try {
                                JsonArray arr = o.getAsJsonArray("ops");
                                if (arr != null) {
                                    for (JsonElement el : arr) {
                                        String s = el.getAsString();
                                        if ("HEAD_BUDGET".equalsIgnoreCase(s)) {
                                            ops = PlanStore.addOp(ops, Op.HEAD_BUDGET);
                                            continue;
                                        }
                                        if ("HEAD_RATE".equalsIgnoreCase(s)) {
                                            ops = PlanStore.addOp(ops, Op.HEAD_RATE);
                                            continue;
                                        }
                                        if (!"LOOP_GUARD".equalsIgnoreCase(s)) continue;
                                        ops = PlanStore.addOp(ops, Op.LOOP_GUARD);
                                    }
                                }
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                            g.ops = ops = PlanStore.addOp(ops, Op.HEAD_BUDGET);
                            this.genomes.put(k, g);
                        }
                    }
                    try {
                        JsonArray arr;
                        if (root.has("newest") && (arr = root.getAsJsonArray("newest")) != null) {
                            for (JsonElement el : arr) {
                                String k = el.getAsString();
                                if (k != null && !k.isEmpty()) {
                                    this.newest.addLast(k);
                                }
                                if (this.newest.size() <= 32) continue;
                                this.newest.removeFirst();
                            }
                        }
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                LOGGER.info("[AO] Loaded 8.5.2 state: genomes={} blacklist={} clean_shutdown={}", (Object)this.genomeCount(), (Object)this.blacklistCount(), (Object)this.lastRunCleanShutdown());
            }
            catch (Throwable t) {
                LOGGER.warn("[AO] Failed to load state: {}", (Object)t.toString());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void save() {
            if (this.file == null) {
                return;
            }
            JsonObject root = new JsonObject();
            root.addProperty("mod", AdaptiveOptimization.MODID);
            root.addProperty("version", "8.5.2");
            root.addProperty("saved_at", Instant.now().toString());
            JsonObject bl = new JsonObject();
            JsonObject hist = new JsonObject();
            JsonObject gs = new JsonObject();
            JsonArray newestArr = new JsonArray();
            Object object = this.lock;
            synchronized (object) {
                root.addProperty("clean_shutdown", Boolean.valueOf(this.cleanShutdown));
                for (Map.Entry<String, String> entry : this.blacklist.entrySet()) {
                    bl.addProperty(entry.getKey(), entry.getValue());
                }
                for (Map.Entry<String, Object> entry : this.historyAvg.entrySet()) {
                    hist.addProperty(entry.getKey(), (Number)entry.getValue());
                }
                for (Map.Entry<String, Object> entry : this.genomes.entrySet()) {
                    Genome g = (Genome)entry.getValue();
                    JsonObject o = new JsonObject();
                    o.addProperty("methodId", (Number)g.methodId);
                    o.addProperty("costHint", (Number)PlanStore.clamp(g.costHint, 1, 50));
                    o.addProperty("rateN", (Number)PlanStore.clamp(g.rateN, 1, 200));
                    o.addProperty("loopStride", (Number)PlanStore.clamp(g.loopStride, 1, 64));
                    o.addProperty("loopCost", (Number)PlanStore.clamp(g.loopCost, 1, 15));
                    JsonArray ops = new JsonArray();
                    if (PlanStore.hasOp(g.ops, Op.HEAD_BUDGET)) {
                        ops.add("HEAD_BUDGET");
                    }
                    if (PlanStore.hasOp(g.ops, Op.HEAD_RATE)) {
                        ops.add("HEAD_RATE");
                    }
                    if (PlanStore.hasOp(g.ops, Op.LOOP_GUARD)) {
                        ops.add("LOOP_GUARD");
                    }
                    o.add("ops", (JsonElement)ops);
                    gs.add(entry.getKey(), (JsonElement)o);
                }
                for (String string : this.newest) {
                    newestArr.add(string);
                }
            }
            root.add("blacklist", (JsonElement)bl);
            root.add("history_avg_nanos", (JsonElement)hist);
            root.add("genomes", (JsonElement)gs);
            root.add("newest", (JsonElement)newestArr);
            try {
                Files.createDirectories(this.dir, new FileAttribute[0]);
                Path tmp = this.dir.resolve("engine_state_8_5_2.tmp");
                try (BufferedWriter w = Files.newBufferedWriter(tmp, StandardCharsets.UTF_8, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.WRITE);){
                    GSON.toJson((JsonElement)root, (Appendable)w);
                }
                Files.move(tmp, this.file, StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.ATOMIC_MOVE);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }

        private void pushNewest(String key) {
            if (key == null) {
                return;
            }
            if (this.newest.contains(key)) {
                this.newest.remove(key);
            }
            this.newest.addLast(key);
            while (this.newest.size() > 32) {
                this.newest.removeFirst();
            }
        }

        static int stableMethodId(String key) {
            int h = -2128831035;
            for (int i = 0; i < key.length(); ++i) {
                h ^= key.charAt(i);
                h *= 16777619;
            }
            return h;
        }

        static int toCostHint(double avgNanos) {
            double ms = PlanStore.avgToMs(avgNanos);
            int hint = (int)Math.round(2.0 + Math.sqrt(Math.max(0.0, ms)) * 14.0);
            return PlanStore.clamp(hint, 1, 50);
        }

        static double avgToMs(double nanos) {
            return nanos / 1000000.0;
        }

        private static Genome generateInitialGenome(String key, double avgNanos, boolean stressed) {
            int stride;
            double ms = PlanStore.avgToMs(avgNanos);
            Genome g = new Genome();
            g.methodId = PlanStore.stableMethodId(key);
            g.costHint = PlanStore.toCostHint(avgNanos);
            int ops = 0;
            ops = PlanStore.addOp(ops, Op.HEAD_BUDGET);
            if (ms >= 2.5) {
                ops = PlanStore.addOp(ops, Op.LOOP_GUARD);
            }
            if (ms >= 6.0 || stressed) {
                ops = PlanStore.addOp(ops, Op.HEAD_RATE);
            }
            g.ops = ops;
            g.rateN = PlanStore.clamp(2 + (int)Math.round(Math.sqrt(Math.max(0.0, ms))), 1, 200);
            if (stressed) {
                g.rateN = PlanStore.clamp(g.rateN - 1, 1, 200);
            }
            int n = ms >= 6.0 ? 8 : (stride = ms >= 2.5 ? 12 : 16);
            if (stressed) {
                stride = Math.max(6, stride - 2);
            }
            g.loopStride = PlanStore.clamp(stride, 1, 64);
            g.loopCost = PlanStore.clamp(Math.max(1, g.costHint / 4), 1, 15);
            return g;
        }

        private static void mutateGenome(Genome g, boolean stressed) {
            int roll = ThreadLocalRandom.current().nextInt(4);
            if (roll == 0) {
                g.ops = PlanStore.hasOp(g.ops, Op.HEAD_RATE) ? PlanStore.removeOp(g.ops, Op.HEAD_RATE) : PlanStore.addOp(g.ops, Op.HEAD_RATE);
            } else if (roll == 1) {
                g.ops = PlanStore.hasOp(g.ops, Op.LOOP_GUARD) ? PlanStore.removeOp(g.ops, Op.LOOP_GUARD) : PlanStore.addOp(g.ops, Op.LOOP_GUARD);
            } else if (roll == 2) {
                int delta = ThreadLocalRandom.current().nextInt(-3, 4);
                g.loopStride = PlanStore.clamp(g.loopStride + delta, 1, 64);
            } else {
                int delta = ThreadLocalRandom.current().nextInt(-2, 3);
                g.costHint = PlanStore.clamp(g.costHint + delta, 1, 50);
            }
            g.ops = PlanStore.addOp(g.ops, Op.HEAD_BUDGET);
            if (stressed) {
                g.loopCost = PlanStore.clamp(Math.max(1, g.costHint / 4), 1, 15);
                g.rateN = PlanStore.clamp(g.rateN, 1, 200);
            }
        }

        private static int bit(Op o) {
            if (o == Op.HEAD_BUDGET) {
                return 1;
            }
            if (o == Op.HEAD_RATE) {
                return 2;
            }
            return 4;
        }

        private static boolean hasOp(int ops, Op o) {
            return (ops & PlanStore.bit(o)) != 0;
        }

        private static int addOp(int ops, Op o) {
            return ops | PlanStore.bit(o);
        }

        private static int removeOp(int ops, Op o) {
            return ops & ~PlanStore.bit(o);
        }

        private static int unionOps(int ops, Op ... more) {
            int out = ops;
            for (Op o : more) {
                out = PlanStore.addOp(out, o);
            }
            return out;
        }

        private static int clamp(int v, int lo, int hi) {
            return Math.max(lo, Math.min(hi, v));
        }

        static final class Genome {
            int ops;
            int methodId;
            int costHint;
            int rateN;
            int loopStride;
            int loopCost;

            Genome() {
            }
        }

        static enum Op {
            HEAD_BUDGET,
            HEAD_RATE,
            LOOP_GUARD;

        }
    }

    private static final class Monitor {
        private static final int WINDOW = 200;
        private final long[] msptMicros = new long[200];
        private int idx;
        private int filled;
        private double lastAvgMspt = -1.0;
        private final MemoryMXBean memBean = ManagementFactory.getMemoryMXBean();
        private final List<GarbageCollectorMXBean> gcBeans = ManagementFactory.getGarbageCollectorMXBeans();
        private long lastGcCount;
        private long lastGcTimeMs;

        private Monitor() {
        }

        void reset() {
            Arrays.fill(this.msptMicros, 50000L);
            this.idx = 0;
            this.filled = 0;
            this.lastAvgMspt = -1.0;
            long c = 0L;
            long t = 0L;
            for (GarbageCollectorMXBean b : this.gcBeans) {
                long bc = b.getCollectionCount();
                long bt = b.getCollectionTime();
                if (bc > 0L) {
                    c += bc;
                }
                if (bt <= 0L) continue;
                t += bt;
            }
            this.lastGcCount = c;
            this.lastGcTimeMs = t;
        }

        void update(MinecraftServer server) {
            long micros;
            double mspt = server.m_129903_();
            this.msptMicros[this.idx] = micros = (long)Math.max(1.0, mspt * 1000.0);
            this.idx = (this.idx + 1) % 200;
            if (this.filled < 200) {
                ++this.filled;
            }
        }

        double getAvgMSPT() {
            int n = Math.max(1, this.filled);
            long sum = 0L;
            for (int i = 0; i < n; ++i) {
                sum += this.msptMicros[i];
            }
            return (double)sum / (double)n / 1000.0;
        }

        double getAvgTPS() {
            double mspt = this.getAvgMSPT();
            return Math.min(20.0, 1000.0 / Math.max(1.0, mspt));
        }

        double getHeapUsageRatio() {
            MemoryUsage heap = this.memBean.getHeapMemoryUsage();
            long max = heap.getMax();
            if (max <= 0L) {
                return 0.0;
            }
            return Monitor.clamp01((double)heap.getUsed() / (double)max);
        }

        WindowStats computeWindowStats() {
            int n = Math.max(1, this.filled);
            long[] copy = new long[n];
            for (int i = 0; i < n; ++i) {
                copy[i] = this.msptMicros[i];
            }
            Arrays.sort(copy);
            double p95 = Monitor.microsToMs(copy[(int)Math.min((double)(n - 1), Math.floor((double)n * 0.95))]);
            double p99 = Monitor.microsToMs(copy[(int)Math.min((double)(n - 1), Math.floor((double)n * 0.99))]);
            int spikes = 0;
            double median = Monitor.microsToMs(copy[n / 2]);
            double thr = Math.max(55.0, median * 1.35);
            for (int i = 0; i < n; ++i) {
                double ms = Monitor.microsToMs(copy[i]);
                if (!(ms > thr)) continue;
                ++spikes;
            }
            WindowStats ws = new WindowStats();
            ws.p95Mspt = p95;
            ws.p99Mspt = p99;
            ws.spikeCount = spikes;
            return ws;
        }

        double computeRewardAndRoll() {
            double avg = this.getAvgMSPT();
            long c = 0L;
            long t = 0L;
            for (GarbageCollectorMXBean b : this.gcBeans) {
                long bc = b.getCollectionCount();
                long bt = b.getCollectionTime();
                if (bc > 0L) {
                    c += bc;
                }
                if (bt <= 0L) continue;
                t += bt;
            }
            long dCount = Math.max(0L, c - this.lastGcCount);
            long dTime = Math.max(0L, t - this.lastGcTimeMs);
            this.lastGcCount = c;
            this.lastGcTimeMs = t;
            double reward = this.lastAvgMspt < 0.0 ? 0.0 : (this.lastAvgMspt - avg) / Math.max(0.001, this.lastAvgMspt);
            reward -= (double)dCount * 0.002;
            this.lastAvgMspt = avg;
            return reward -= (double)dTime / 1000.0 * 0.004;
        }

        private static double microsToMs(long micros) {
            return (double)micros / 1000.0;
        }

        private static double clamp01(double v) {
            return v < 0.0 ? 0.0 : (v > 1.0 ? 1.0 : v);
        }

        static final class WindowStats {
            double p95Mspt;
            double p99Mspt;
            int spikeCount;

            WindowStats() {
            }
        }
    }

    private static final class BackgroundWorker {
        private final AtomicBoolean alive = new AtomicBoolean(true);
        private final ScheduledExecutorService exec = Executors.newSingleThreadScheduledExecutor(r -> {
            Thread t = new Thread(r, "AO-Background");
            t.setDaemon(true);
            t.setPriority(1);
            return t;
        });
        private final AtomicBoolean evolveQueued = new AtomicBoolean(false);
        private final AtomicBoolean saveQueued = new AtomicBoolean(false);

        private BackgroundWorker() {
        }

        boolean isAlive() {
            return this.alive.get() && !this.exec.isShutdown() && !this.exec.isTerminated();
        }

        void shutdown() {
            this.alive.set(false);
            try {
                this.exec.shutdownNow();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }

        void queueEvolve(Runnable r) {
            if (r == null) {
                return;
            }
            if (!this.isAlive()) {
                return;
            }
            if (!this.evolveQueued.compareAndSet(false, true)) {
                return;
            }
            try {
                this.exec.execute(() -> {
                    try {
                        r.run();
                    }
                    catch (Throwable throwable) {
                    }
                    finally {
                        this.evolveQueued.set(false);
                    }
                });
            }
            catch (RejectedExecutionException ex) {
                this.evolveQueued.set(false);
            }
            catch (Throwable t) {
                this.evolveQueued.set(false);
            }
        }

        void queueSave(long delayMillis, Runnable r) {
            if (r == null) {
                return;
            }
            if (!this.isAlive()) {
                return;
            }
            if (!this.saveQueued.compareAndSet(false, true)) {
                return;
            }
            long d = Math.max(50L, delayMillis);
            try {
                this.exec.schedule(() -> {
                    try {
                        r.run();
                    }
                    catch (Throwable throwable) {
                    }
                    finally {
                        this.saveQueued.set(false);
                    }
                }, d, TimeUnit.MILLISECONDS);
            }
            catch (RejectedExecutionException ex) {
                this.saveQueued.set(false);
            }
            catch (Throwable t) {
                this.saveQueued.set(false);
            }
        }
    }
}

