/*
 * Decompiled with CFR 0.152.
 */
package dev.uncandango.alltheleaks.leaks.client.mods.entity_texture_features;

import dev.uncandango.alltheleaks.annotation.Issue;
import dev.uncandango.alltheleaks.utils.ReflectionHelper;
import java.lang.invoke.VarHandle;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.world.level.Level;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;
import org.jetbrains.annotations.Nullable;
import traben.entity_texture_features.features.ETFManager;
import traben.entity_texture_features.features.player.ETFPlayerEntity;
import traben.entity_texture_features.features.player.ETFPlayerTexture;
import traben.entity_texture_features.utils.ETFEntity;

@Issue(modId="entity_texture_features", versionRange="[6.2.3,)", mixins={"main.ATLLivingEntityRendererMixin"}, description="Clears `LivingEntityRenderer#etf$heldEntity` when level changes and updates player at `ETFManager#PLAYER_TEXTURE_MAP`")
public class UntrackedIssue001 {
    public static final VarHandle ETF$HELDENTITY = ReflectionHelper.getFieldFromClass(LivingEntityRenderer.class, "etf$heldEntity", ETFEntity.class, false);

    private static void updateEntityFromManager(ClientPlayerNetworkEvent.Clone event) {
        ETFPlayerTexture etfTexture = (ETFPlayerTexture)ETFManager.getInstance().PLAYER_TEXTURE_MAP.get((Object)event.getOldPlayer().m_20148_());
        if (etfTexture == null) {
            return;
        }
        LocalPlayer localPlayer = event.getNewPlayer();
        if (localPlayer instanceof ETFPlayerEntity) {
            ETFPlayerEntity playerEntity;
            etfTexture.player = playerEntity = (ETFPlayerEntity)localPlayer;
        }
    }

    public static void clearCachedEntityFromRenderer(LivingEntityRenderer<?, ?> livingEntityRenderer, @Nullable ClientLevel level) {
        ETFEntity etfEntity = ETF$HELDENTITY.get(livingEntityRenderer);
        if (etfEntity == null) {
            return;
        }
        Level world = etfEntity.etf$getWorld();
        if (world == null || world == level) {
            return;
        }
        ETF$HELDENTITY.set(livingEntityRenderer, null);
    }

    static {
        VarHandle enabled = ReflectionHelper.getFieldFromClass(LivingEntityRenderer.class, "atl$etfEnabled", Boolean.TYPE, true);
        enabled.set(true);
        IEventBus gameBus = MinecraftForge.EVENT_BUS;
        gameBus.addListener(UntrackedIssue001::updateEntityFromManager);
    }
}

