/*
 * Decompiled with CFR 0.152.
 */
package org.magiclife.alltogether;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.logging.LogUtils;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Type;
import java.nio.file.FileSystemException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.PlayerList;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.LevelResource;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.event.server.ServerStoppingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.apache.commons.io.FileUtils;
import org.magiclife.alltogether.Session;
import org.slf4j.Logger;

@Mod.EventBusSubscriber(modid="alltogether", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class LoginSecurity {
    public static List<UUID> premiumUsers = new ArrayList<UUID>();
    public static HashMap<UUID, List<Session>> sessions = new HashMap();
    public static List<UUID> notLogged = new ArrayList<UUID>();
    private static final HashMap<UUID, List<String>> playerPasswords = new HashMap();
    private static final File passwordFile = new File("player_passwords.json");
    private static final Gson gson = new Gson();
    private static final Logger logger = LogUtils.getLogger();

    private static String serializePasswordsToJson() {
        return gson.toJson(playerPasswords);
    }

    private static HashMap<UUID, List<String>> parsePasswordsFromJson(String json) {
        Type type = new TypeToken<HashMap<UUID, List<String>>>(){}.getType();
        return (HashMap)gson.fromJson(json, type);
    }

    private static void savePasswords() {
        try {
            String json = LoginSecurity.serializePasswordsToJson();
            FileUtils.writeStringToFile((File)passwordFile, (String)json, (String)"UTF-8");
        }
        catch (IOException e) {
            logger.error(e.getMessage());
        }
    }

    private static void loadPasswords() {
        if (passwordFile.exists()) {
            try {
                String json = FileUtils.readFileToString((File)passwordFile, (String)"UTF-8");
                if (LoginSecurity.parsePasswordsFromJson(json) == null) {
                    return;
                }
                playerPasswords.putAll(LoginSecurity.parsePasswordsFromJson(json));
            }
            catch (IOException err) {
                logger.error(err.getMessage());
            }
        } else {
            try {
                if (!passwordFile.createNewFile()) {
                    throw new FileSystemException("Error creating password storage file.");
                }
            }
            catch (IOException err) {
                logger.error(err.getMessage());
            }
        }
    }

    private static Session getSession(ServerPlayer player) {
        String name = player.m_7755_().getString().substring(player.m_7755_().getString().indexOf("]") + 2);
        UUID nameUUID = UUID.nameUUIDFromBytes(name.getBytes());
        if (sessions.get(nameUUID) != null) {
            for (int i = 0; i < sessions.get(nameUUID).size(); ++i) {
                if (!LoginSecurity.sessions.get((Object)nameUUID).get((int)i).ip.equals(player.m_9239_())) continue;
                return sessions.get(nameUUID).get(i);
            }
        }
        return null;
    }

    private static void savePlayer(ServerPlayer player, UUID uuid, CompoundTag tag) {
        if (tag == null) {
            tag = new CompoundTag();
            player.m_20240_(tag);
        }
        File outFile = new File(Objects.requireNonNull(player.m_20194_()).m_129843_(LevelResource.f_78176_).toFile(), uuid + ".dat");
        try {
            NbtIo.m_128944_((CompoundTag)tag, (File)outFile);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static void loadPlayer(ServerPlayer player, UUID sessionUUID) {
        try {
            CompoundTag tag = NbtIo.m_128937_((File)new File(Objects.requireNonNull(player.m_20194_()).m_129843_(LevelResource.f_78176_).toFile(), sessionUUID + ".dat"));
            player.m_20258_(tag);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static int register(CommandSourceStack source, String password, String confirm) {
        ServerPlayer player = source.m_230896_();
        assert (player != null);
        Session currentSession = LoginSecurity.getSession(player);
        if (premiumUsers.contains(player.m_20148_())) {
            source.m_81352_((Component)Component.m_237113_((String)"No necesitas registrarte, sos premium.").m_130940_(ChatFormatting.RED));
            return -1;
        }
        if (currentSession != null) {
            source.m_81352_((Component)Component.m_237113_((String)"No puedes registrarte 2 veces.").m_130940_(ChatFormatting.RED));
            return -1;
        }
        if (!password.equals(confirm)) {
            source.m_81352_((Component)Component.m_237113_((String)"Las contrase\u00f1as no son iguales, no se puede confirmar el registro.").m_130940_(ChatFormatting.RED));
            return -1;
        }
        if (password.length() <= 5) {
            source.m_81352_((Component)Component.m_237113_((String)"La contrase\u00f1a debe tener mas de 5 caracteres.").m_130940_(ChatFormatting.RED));
            return -1;
        }
        String name = player.m_7755_().getString().substring(player.m_7755_().getString().indexOf("]") + 2);
        UUID nameUUID = UUID.nameUUIDFromBytes(name.getBytes());
        playerPasswords.putIfAbsent(nameUUID, new ArrayList());
        List<String> passwordList = playerPasswords.get(UUID.nameUUIDFromBytes(name.getBytes()));
        passwordList.add(password);
        LoginSecurity.savePasswords();
        UUID sessionUUID = UUID.nameUUIDFromBytes((name + password).getBytes());
        logger.info("New user UUID: {}", (Object)sessionUUID);
        CompoundTag newTag = new CompoundTag();
        ListTag inventory = new ListTag();
        newTag.m_128365_("Inventory", (Tag)inventory);
        newTag.m_128365_("Health", (Tag)DoubleTag.m_128500_((double)20.0));
        newTag.m_128365_("UUID", (Tag)StringTag.m_129297_((String)sessionUUID.toString()));
        ServerLevel overworld = Objects.requireNonNull(source.m_81377_().m_129880_(Level.f_46428_));
        BlockPos spawn = overworld.m_220360_();
        ListTag position = new ListTag();
        position.add((Object)DoubleTag.m_128500_((double)((double)spawn.m_123341_() + 0.5)));
        position.add((Object)DoubleTag.m_128500_((double)spawn.m_123342_()));
        position.add((Object)DoubleTag.m_128500_((double)((double)spawn.m_123343_() + 0.5)));
        newTag.m_128365_("Pos", (Tag)position);
        LoginSecurity.savePlayer(player, sessionUUID, newTag);
        LoginSecurity.loadPlayer(player, sessionUUID);
        player.m_143403_(player.f_8924_.m_130008_());
        if (player.f_8924_.m_130008_() == GameType.SURVIVAL) {
            player.m_150110_().f_35935_ = false;
        }
        player.m_6885_();
        notLogged.remove(player.m_20148_());
        sessions.putIfAbsent(nameUUID, new ArrayList());
        sessions.get(nameUUID).add(new Session(player.m_9239_(), new Timestamp(System.currentTimeMillis()), sessionUUID));
        source.m_288197_(() -> Component.m_237113_((String)"El usuario se ha registrado correctamente!").m_130940_(ChatFormatting.GREEN), true);
        return 0;
    }

    private static int logIn(CommandSourceStack source, String password) {
        ServerPlayer player = source.m_230896_();
        assert (player != null);
        Session currentSession = LoginSecurity.getSession(player);
        if (premiumUsers.contains(player.m_20148_())) {
            source.m_81352_((Component)Component.m_237113_((String)"No necesitas iniciar sesion, sos premium.").m_130940_(ChatFormatting.RED));
            return -1;
        }
        if (currentSession != null) {
            source.m_81352_((Component)Component.m_237113_((String)"Ya estas en una sesion.").m_130940_(ChatFormatting.RED));
            return -1;
        }
        String name = player.m_7755_().getString().substring(player.m_7755_().getString().indexOf("]") + 2);
        UUID nameUUID = UUID.nameUUIDFromBytes(name.getBytes());
        List<String> passwordList = playerPasswords.get(UUID.nameUUIDFromBytes(name.getBytes()));
        if (passwordList == null || !passwordList.contains(password)) {
            source.m_81352_((Component)Component.m_237113_((String)"La contrase\u00f1a ingresada es incorrecta o no existe un registro previo.").m_130940_(ChatFormatting.RED));
            return -1;
        }
        UUID sessionUUID = UUID.nameUUIDFromBytes((name + password).getBytes());
        LoginSecurity.loadPlayer(player, sessionUUID);
        player.m_143403_(player.f_8924_.m_130008_());
        if (player.f_8924_.m_130008_() == GameType.SURVIVAL) {
            player.m_150110_().f_35935_ = false;
        }
        player.m_6885_();
        notLogged.remove(player.m_20148_());
        logger.info("User {} logged in!", (Object)sessionUUID);
        sessions.putIfAbsent(nameUUID, new ArrayList());
        sessions.get(nameUUID).add(new Session(player.m_9239_(), new Timestamp(System.currentTimeMillis()), sessionUUID));
        source.m_288197_(() -> Component.m_237113_((String)"El usuario a iniciado sesion en su cuenta correctamente!").m_130940_(ChatFormatting.GREEN), true);
        return 0;
    }

    @SubscribeEvent
    public static void onStart(ServerStartingEvent event) {
        CommandDispatcher dispatcher = event.getServer().m_129892_().m_82094_();
        LoginSecurity.loadPasswords();
        dispatcher.register((LiteralArgumentBuilder)Commands.m_82127_((String)"registrar").then(Commands.m_82129_((String)"contrase\u00f1a", (ArgumentType)StringArgumentType.string()).then(Commands.m_82129_((String)"repetir contrase\u00f1a", (ArgumentType)StringArgumentType.string()).executes(context -> {
            String password = StringArgumentType.getString((CommandContext)context, (String)"contrase\u00f1a");
            String confirm = StringArgumentType.getString((CommandContext)context, (String)"repetir contrase\u00f1a");
            return LoginSecurity.register((CommandSourceStack)context.getSource(), password, confirm);
        }))));
        dispatcher.register((LiteralArgumentBuilder)Commands.m_82127_((String)"iniciar").then(Commands.m_82129_((String)"contrase\u00f1a", (ArgumentType)StringArgumentType.string()).executes(context -> {
            String password = StringArgumentType.getString((CommandContext)context, (String)"contrase\u00f1a");
            return LoginSecurity.logIn((CommandSourceStack)context.getSource(), password);
        })));
    }

    @SubscribeEvent
    public static void onWorldSave(LevelEvent.Save event) {
        PlayerList players = Objects.requireNonNull(event.getLevel().m_7654_()).m_6846_();
        for (ServerPlayer player : players.m_11314_()) {
            Session session = LoginSecurity.getSession(player);
            if (session == null) continue;
            LoginSecurity.savePlayer(player, session.uuid, null);
        }
    }

    @SubscribeEvent
    public static void onStop(ServerStoppingEvent event) {
        PlayerList players = event.getServer().m_6846_();
        logger.info(players.toString());
        for (ServerPlayer player : players.m_11314_()) {
            Session session = LoginSecurity.getSession(player);
            if (session == null) continue;
            LoginSecurity.savePlayer(player, session.uuid, null);
        }
    }

    @SubscribeEvent
    public static void onJoin(PlayerEvent.PlayerLoggedInEvent event) {
        ServerPlayer player = (ServerPlayer)event.getEntity();
        String name = player.m_7755_().m_240452_((Component)Component.m_237113_((String)"[NP]")) ? player.m_7755_().getString().substring(player.m_7755_().getString().indexOf("]") + 2) : player.m_7755_().getString();
        UUID nameUUID = UUID.nameUUIDFromBytes(name.getBytes());
        ServerLevel serverLevel = Objects.requireNonNull(player.m_20194_()).m_129880_(Level.f_46428_);
        BlockPos spawn = Objects.requireNonNull(serverLevel).m_220360_();
        if (premiumUsers.contains(player.m_20148_())) {
            logger.info("User is premium.");
            return;
        }
        player.m_143403_(GameType.SPECTATOR);
        player.m_150109_().m_6211_();
        notLogged.add(player.m_20148_());
        Timestamp timestamp = new Timestamp(System.currentTimeMillis());
        Session currentSession = LoginSecurity.getSession(player);
        if (currentSession != null && timestamp.getTime() - currentSession.lastConnection.getTime() < 600000L) {
            LoginSecurity.loadPlayer(player, currentSession.uuid);
            player.m_143403_(player.f_8924_.m_130008_());
            if (player.f_8924_.m_130008_() == GameType.SURVIVAL) {
                player.m_150110_().f_35935_ = false;
            }
            player.m_6885_();
            notLogged.remove(player.m_20148_());
            player.m_213846_((Component)Component.m_237113_((String)"Resumiendo sesion...").m_130940_(ChatFormatting.GREEN));
            return;
        }
        if (currentSession != null) {
            sessions.get(nameUUID).remove(LoginSecurity.getSession(player));
        }
        player.m_8999_(serverLevel, (double)spawn.m_123341_() + 0.5, (double)spawn.m_123342_(), (double)spawn.m_123343_() + 0.5, player.m_146908_(), player.m_146909_());
        player.m_143403_(GameType.SPECTATOR);
        player.m_213846_((Component)Component.m_237113_((String)("Bienvenido " + name + ".\nLos jugadores no-premium deben registrarse.\nPara registrarte use \"/registrar <contrase\u00f1a> <repetir contrase\u00f1a>\"\nPara entrar a una sesion existente use \"/iniciar <contrase\u00f1a>\"\n")).m_130940_(ChatFormatting.YELLOW));
    }

    @SubscribeEvent
    public static void onMove(LivingEvent.LivingTickEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)livingEntity;
        ServerLevel serverLevel = Objects.requireNonNull(player.m_20194_()).m_129880_(Level.f_46428_);
        BlockPos spawn = Objects.requireNonNull(serverLevel).m_220360_();
        if (notLogged.contains(player.m_20148_())) {
            player.m_8999_(serverLevel, (double)spawn.m_123341_() + 0.5, (double)spawn.m_123342_(), (double)spawn.m_123343_() + 0.5, player.m_146908_(), player.m_146909_());
        }
    }

    @SubscribeEvent
    public static void onLeave(PlayerEvent.PlayerLoggedOutEvent event) {
        ServerPlayer player = (ServerPlayer)event.getEntity();
        String name = player.m_7755_().getString().substring(player.m_7755_().getString().indexOf("]") + 2);
        UUID nameUUID = UUID.nameUUIDFromBytes(name.getBytes());
        premiumUsers.remove(nameUUID);
        if (Objects.requireNonNull(player.m_20194_()).m_6846_().m_11255_(player.m_7755_().getString()) == null) {
            notLogged.remove(player.m_20148_());
        }
        Timestamp timestamp = new Timestamp(System.currentTimeMillis());
        Session currentSession = LoginSecurity.getSession(player);
        if (currentSession != null) {
            currentSession.lastConnection = timestamp;
            LoginSecurity.savePlayer(player, currentSession.uuid, null);
        }
    }
}

