/*
 * Decompiled with CFR 0.152.
 */
package org.magiclife.alltogether.mixins;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.exceptions.AuthenticationUnavailableException;
import com.mojang.logging.LogUtils;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import net.minecraft.DefaultUncaughtExceptionHandler;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.login.ServerboundKeyPacket;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.network.ServerLoginPacketListenerImpl;
import net.minecraft.util.Crypt;
import net.minecraft.util.CryptException;
import net.minecraftforge.fml.util.thread.SidedThreadGroups;
import org.apache.commons.lang3.Validate;
import org.magiclife.alltogether.LoginSecurity;
import org.slf4j.Logger;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={ServerLoginPacketListenerImpl.class})
public abstract class ServerLogin {
    @Shadow
    static AtomicInteger f_10014_;
    @Shadow
    private ServerLoginPacketListenerImpl.State f_10019_;
    @Shadow
    MinecraftServer f_10018_;
    @Shadow
    private byte[] f_252396_;
    @Shadow
    Connection f_10013_;
    @Shadow
    public GameProfile f_10021_;
    @Shadow
    static Logger f_10015_;

    @Shadow
    public abstract void m_10053_(Component var1);

    @Overwrite(remap=true)
    public void m_8072_(ServerboundKeyPacket p_10049_) {
        String s;
        Validate.validState((this.f_10019_ == ServerLoginPacketListenerImpl.State.KEY ? 1 : 0) != 0, (String)"Unexpected key packet", (Object[])new Object[0]);
        try {
            PrivateKey privatekey = this.f_10018_.m_129790_().getPrivate();
            if (!p_10049_.m_253194_(this.f_252396_, privatekey)) {
                throw new IllegalStateException("Protocol error");
            }
            SecretKey secretkey = p_10049_.m_134859_(privatekey);
            Cipher cipher = Crypt.m_13583_((int)2, (Key)secretkey);
            Cipher cipher1 = Crypt.m_13583_((int)1, (Key)secretkey);
            s = new BigInteger(Crypt.m_13590_((String)"", (PublicKey)this.f_10018_.m_129790_().getPublic(), (SecretKey)secretkey)).toString(16);
            this.f_10019_ = ServerLoginPacketListenerImpl.State.AUTHENTICATING;
            this.f_10013_.m_129495_(cipher, cipher1);
        }
        catch (CryptException cryptexception) {
            throw new IllegalStateException("Protocol error", cryptexception);
        }
        Thread thread = new Thread((ThreadGroup)SidedThreadGroups.SERVER, "User Authenticator #" + f_10014_.incrementAndGet()){

            @Override
            public void run() {
                GameProfile gameprofile = ServerLogin.this.f_10021_;
                try {
                    ServerLogin.this.f_10021_ = ServerLogin.this.f_10018_.m_129925_().hasJoinedServer(new GameProfile((UUID)null, gameprofile.getName()), s, this.getAddress());
                    if (ServerLogin.this.f_10021_ != null) {
                        f_10015_.info("UUID of player {} is {}", (Object)ServerLogin.this.f_10021_.getName(), (Object)ServerLogin.this.f_10021_.getId());
                        ServerLogin.this.f_10019_ = ServerLoginPacketListenerImpl.State.NEGOTIATING;
                        LoginSecurity.premiumUsers.add(ServerLogin.this.f_10021_.getId());
                        f_10015_.info("ServerLogin detected a premium user: {} with ID {}", (Object)ServerLogin.this.f_10021_.getName(), (Object)ServerLogin.this.f_10021_.getId());
                    } else if (ServerLogin.this.f_10018_.m_129792_()) {
                        f_10015_.warn("Failed to verify username but will let them in anyway!");
                        ServerLogin.this.f_10021_ = gameprofile;
                        ServerLogin.this.f_10019_ = ServerLoginPacketListenerImpl.State.NEGOTIATING;
                    } else {
                        f_10015_.info("Non-premium user: {}", (Object)gameprofile.getName());
                        ServerLogin.this.f_10021_ = new GameProfile(UUID.nameUUIDFromBytes(gameprofile.getName().getBytes()), "[NP] " + gameprofile.getName());
                        ServerLogin.this.f_10019_ = ServerLoginPacketListenerImpl.State.NEGOTIATING;
                    }
                }
                catch (AuthenticationUnavailableException authenticationunavailableexception) {
                    if (ServerLogin.this.f_10018_.m_129792_()) {
                        f_10015_.warn("Authentication servers are down but will let them in anyway!");
                        ServerLogin.this.f_10021_ = gameprofile;
                        ServerLogin.this.f_10019_ = ServerLoginPacketListenerImpl.State.NEGOTIATING;
                    }
                    ServerLogin.this.m_10053_((Component)Component.m_237115_((String)"multiplayer.disconnect.authservers_down"));
                    f_10015_.error("Couldn't verify username because servers are unavailable");
                }
            }

            @Nullable
            private InetAddress getAddress() {
                SocketAddress socketaddress = ServerLogin.this.f_10013_.m_129523_();
                return ServerLogin.this.f_10018_.m_129798_() && socketaddress instanceof InetSocketAddress ? ((InetSocketAddress)socketaddress).getAddress() : null;
            }
        };
        thread.setUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new DefaultUncaughtExceptionHandler(f_10015_));
        thread.start();
    }

    static {
        f_10015_ = LogUtils.getLogger();
    }
}

