/*
 * Decompiled with CFR 0.152.
 */
package com.github.jarva.arsadditions.client.jei;

import com.github.jarva.arsadditions.client.jei.ModPlugin;
import com.github.jarva.arsadditions.common.recipe.LocateStructureRecipe;
import com.github.jarva.arsadditions.common.ritual.RitualLocateStructure;
import com.github.jarva.arsadditions.setup.registry.AddonItemRegistry;
import com.hollingsworth.arsnouveau.api.registry.RitualRegistry;
import com.hollingsworth.arsnouveau.client.jei.MultiInputCategory;
import com.hollingsworth.arsnouveau.setup.registry.BlockRegistry;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.phys.Vec2;

public class LocateStructureRecipeCategory
implements IRecipeCategory<LocateStructureRecipe> {
    public IDrawable background;
    public IDrawable icon;
    protected Vec2 point = new Vec2(48.0f, 13.0f);
    protected Vec2 center = new Vec2(48.0f, 45.0f);

    public LocateStructureRecipeCategory(IGuiHelper helper) {
        this.background = helper.createBlankDrawable(114, 108);
        this.icon = helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)BlockRegistry.RITUAL_BLOCK));
    }

    public RecipeType<LocateStructureRecipe> getRecipeType() {
        return ModPlugin.LOCATE_STRUCTURE_RECIPE_TYPE;
    }

    public Component getTitle() {
        return Component.m_237115_((String)("item.ars_additions." + RitualLocateStructure.RESOURCE_LOCATION.m_135815_()));
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, LocateStructureRecipe recipe, IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.CATALYST, (int)this.center.f_82470_, (int)this.center.f_82471_).addIngredients(Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)RitualRegistry.getRitualItemMap().get(RitualLocateStructure.RESOURCE_LOCATION)}));
        NonNullList<Ingredient> inputs = recipe.m_7527_();
        double angleBetweenEach = 360.0 / (double)inputs.size();
        for (Ingredient input : inputs) {
            builder.addSlot(RecipeIngredientRole.INPUT, (int)this.point.f_82470_, (int)this.point.f_82471_).addIngredients(input);
            this.point = MultiInputCategory.rotatePointAbout((Vec2)this.point, (Vec2)this.center, (double)angleBetweenEach);
        }
        ItemStack wayfinder = new ItemStack((ItemLike)AddonItemRegistry.WAYFINDER.get());
        CompoundTag nbt = wayfinder.m_41784_();
        Component name = recipe.getName();
        nbt.m_128359_("Structure", Component.Serializer.m_130703_((Component)name));
        builder.addSlot(RecipeIngredientRole.OUTPUT, 86, 10).addIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)wayfinder);
    }

    public void draw(LocateStructureRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        Font renderer = Minecraft.m_91087_().f_91062_;
        Component name = recipe.getName();
        guiGraphics.m_280614_(renderer, name, 0, 100, 10, false);
    }
}

