/*
 * Decompiled with CFR 0.152.
 */
package com.github.jarva.arsadditions.common.item;

import com.github.jarva.arsadditions.server.util.MarkType;
import com.github.jarva.arsadditions.setup.config.ServerConfig;
import com.github.jarva.arsadditions.setup.registry.AddonEffectRegistry;
import com.github.jarva.arsadditions.setup.registry.AddonItemRegistry;
import com.hollingsworth.arsnouveau.api.item.inv.InteractType;
import com.hollingsworth.arsnouveau.api.item.inv.InventoryManager;
import com.hollingsworth.arsnouveau.api.item.inv.SlotReference;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.wrapped_caster.IWrappedCaster;
import com.hollingsworth.arsnouveau.api.spell.wrapped_caster.TileCaster;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class UnstableReliquary
extends Item {
    public UnstableReliquary() {
        super(new Item.Properties().m_41487_(1).m_41503_(1000));
    }

    public boolean m_8120_(ItemStack stack) {
        return false;
    }

    public void m_6883_(ItemStack stack, Level level, Entity entity, int slotId, boolean isSelected) {
        CompoundTag tag = stack.m_41783_();
        if (tag == null) {
            return;
        }
        String markType = tag.m_128461_("mark_type");
        MarkType mark = MarkType.valueOfDefaulted(markType);
        CompoundTag data = tag.m_128469_("mark_data");
        if (mark == MarkType.ENTITY && level instanceof ServerLevel) {
            ServerPlayer player;
            ServerLevel serverLevel = (ServerLevel)level;
            UUID uuid = data.m_128342_("entity_uuid");
            Entity found = serverLevel.m_8791_(uuid);
            if (found == null || !found.m_6084_()) {
                UnstableReliquary.breakReliquary(stack);
                return;
            }
            if (found instanceof ServerPlayer && !(player = (ServerPlayer)found).m_21023_((MobEffect)AddonEffectRegistry.MARKED_EFFECT.get())) {
                UnstableReliquary.breakReliquary(stack);
            }
        }
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltipComponents, TooltipFlag isAdvanced) {
        super.m_7373_(stack, level, tooltipComponents, isAdvanced);
        CompoundTag tag = stack.m_41783_();
        if (tag != null) {
            String entityTypeStr;
            Optional entityType;
            String markType = tag.m_128461_("mark_type");
            MarkType mark = MarkType.valueOfDefaulted(markType);
            CompoundTag data = tag.m_128469_("mark_data");
            if (mark == MarkType.ENTITY && (entityType = EntityType.m_20632_((String)(entityTypeStr = data.m_128461_("entity_type")))).isPresent()) {
                EntityType type = (EntityType)entityType.get();
                MutableComponent marked = Component.m_237110_((String)"tooltip.ars_additions.reliquary.marked", (Object[])new Object[]{Component.m_237115_((String)type.m_20675_())});
                if (data.m_128441_("entity_name")) {
                    MutableComponent name = Component.Serializer.m_130701_((String)data.m_128461_("entity_name"));
                    tooltipComponents.add((Component)Component.m_237110_((String)"tooltip.ars_additions.reliquary.marked.name", (Object[])new Object[]{marked, name}));
                } else {
                    tooltipComponents.add((Component)marked);
                }
                return;
            }
            if (mark == MarkType.LOCATION) {
                BlockPos pos = NbtUtils.m_129239_((CompoundTag)data.m_128469_("block_pos"));
                MutableComponent loc = Component.m_237110_((String)"tooltip.ars_additions.reliquary.marked.location", (Object[])new Object[]{pos.m_123341_(), pos.m_123342_(), pos.m_123343_()});
                tooltipComponents.add((Component)Component.m_237110_((String)"tooltip.ars_additions.reliquary.marked", (Object[])new Object[]{loc}));
                return;
            }
            if (mark == MarkType.BROKEN) {
                tooltipComponents.add((Component)Component.m_237115_((String)"tooltip.ars_additions.reliquary.marked.broken"));
            }
        }
        tooltipComponents.add((Component)Component.m_237115_((String)"tooltip.ars_additions.reliquary.marked.empty"));
    }

    public static void breakReliquary(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        if (tag == null) {
            return;
        }
        tag.m_128359_("mark_type", MarkType.BROKEN.toString());
        tag.m_128365_("mark_data", (Tag)new CompoundTag());
    }

    public static ItemStack getReliquaryFromCaster(SpellContext context, LivingEntity caster) {
        IWrappedCaster iWrappedCaster = context.getCaster();
        if (iWrappedCaster instanceof TileCaster) {
            TileCaster tileCaster = (TileCaster)iWrappedCaster;
            InventoryManager manager = tileCaster.getInvManager();
            SlotReference reference = manager.findItem(i -> i.m_150930_((Item)AddonItemRegistry.UNSTABLE_RELIQUARY.get()), InteractType.EXTRACT);
            if (reference.isEmpty()) {
                return null;
            }
            return reference.getHandler().getStackInSlot(reference.getSlot());
        }
        ItemStack main = caster.m_21205_();
        if (main.m_150930_((Item)AddonItemRegistry.UNSTABLE_RELIQUARY.get())) {
            return main;
        }
        ItemStack offhand = caster.m_21206_();
        if (offhand.m_150930_((Item)AddonItemRegistry.UNSTABLE_RELIQUARY.get())) {
            return offhand;
        }
        return null;
    }

    public static MarkType getMarkType(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        if (tag == null) {
            return null;
        }
        String markType = tag.m_128461_("mark_type");
        return MarkType.valueOfDefaulted(markType);
    }

    public static void damage(MarkType type, ItemStack stack, LivingEntity entity) {
        UnstableReliquary.damage(type, stack, entity, null);
    }

    public static void damage(MarkType type, ItemStack stack, LivingEntity entity, @Nullable Entity target) {
        int amount = switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case MarkType.ENTITY -> target instanceof Player ? (Integer)ServerConfig.SERVER.reliquary_cost_player.get() : (Integer)ServerConfig.SERVER.reliquary_cost_entity.get();
            case MarkType.LOCATION -> (Integer)ServerConfig.SERVER.reliquary_cost_location.get();
            case MarkType.EMPTY, MarkType.BROKEN -> 0;
        };
        stack.m_41622_(amount, entity, e -> {});
    }
}

