/*
 * Decompiled with CFR 0.152.
 */
package com.github.jarva.arsadditions.common.recipe;

import com.github.jarva.arsadditions.common.util.LangUtil;
import com.github.jarva.arsadditions.common.util.codec.ResourceOrTag;
import com.github.jarva.arsadditions.server.util.LocateUtil;
import com.github.jarva.arsadditions.setup.registry.AddonRecipeRegistry;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.hollingsworth.arsnouveau.api.enchanting_apparatus.EnchantingApparatusRecipe;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.DefaultedRegistry;
import net.minecraft.core.HolderSet;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.world.Container;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.structure.Structure;
import org.jetbrains.annotations.Nullable;

public class LocateStructureRecipe
implements Recipe<Container> {
    private final NonNullList<Ingredient> ingredients;
    private final ResourceLocation id;
    private final List<ResourceOrTag<Item>> augments;
    private final ResourceOrTag<Structure> structure;
    private final boolean skipKnownStructures;
    private final int radius;

    public LocateStructureRecipe(ResourceLocation id, List<ResourceOrTag<Item>> augments, ResourceOrTag<Structure> structure, int radius, boolean skipKnownStructures) {
        this.id = id;
        this.augments = augments;
        this.structure = structure;
        this.radius = radius;
        this.skipKnownStructures = skipKnownStructures;
        ArrayList ingredientList = new ArrayList();
        augments.forEach(either -> either.tag().map(Ingredient::m_204132_).or(() -> either.key().map(arg_0 -> ((DefaultedRegistry)BuiltInRegistries.f_257033_).m_6246_(arg_0)).map(xva$0 -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{xva$0}))).ifPresent(ingredientList::add));
        this.ingredients = NonNullList.m_122783_((Object)Ingredient.f_43901_, (Object[])ingredientList.toArray(new Ingredient[0]));
    }

    public boolean m_5818_(Container container, Level level) {
        return false;
    }

    public boolean matches(List<ItemStack> input) {
        return EnchantingApparatusRecipe.doItemsMatch(input, this.ingredients);
    }

    public ItemStack m_5874_(Container container, RegistryAccess registryAccess) {
        return ItemStack.f_41583_;
    }

    public boolean m_8004_(int i, int i1) {
        return false;
    }

    public ItemStack m_8043_(RegistryAccess registryAccess) {
        return ItemStack.f_41583_;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public NonNullList<Ingredient> m_7527_() {
        return this.ingredients;
    }

    private List<ResourceOrTag<Item>> getAugments() {
        return this.augments;
    }

    public ResourceOrTag<Structure> getStructure() {
        return this.structure;
    }

    public Component getName() {
        return this.structure.map(key -> key.f_203868_().m_135815_(), tag -> tag.m_135782_().m_135815_()).map(LangUtil::toTitleCase).orElse((Component)Component.m_237119_());
    }

    public HolderSet<Structure> getStructureHolder(ServerLevel level) {
        return this.structure.tag().map(tag -> LocateUtil.holderFromTag(level, (TagKey<Structure>)tag)).or(() -> this.structure.key().map(value -> LocateUtil.holderFromResource(level, (ResourceKey<Structure>)value))).orElse(null);
    }

    public int getRadius() {
        return this.radius;
    }

    public boolean getSkipExisting() {
        return this.skipKnownStructures;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)AddonRecipeRegistry.LOCATE_STRUCTURE_SERIALIZER.get();
    }

    public RecipeType<?> m_6671_() {
        return (RecipeType)AddonRecipeRegistry.LOCATE_STRUCTURE_TYPE.get();
    }

    public boolean m_5598_() {
        return true;
    }

    public JsonElement asRecipe() {
        JsonElement recipe = Serializer.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)this).result().orElse(null);
        JsonObject obj = recipe.getAsJsonObject();
        obj.addProperty("type", this.m_6671_().toString());
        return obj;
    }

    public static class Serializer
    implements RecipeSerializer<LocateStructureRecipe> {
        public static final Codec<LocateStructureRecipe> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourceLocation.f_135803_.fieldOf("id").forGetter(LocateStructureRecipe::m_6423_), (App)ResourceOrTag.ITEM_CODEC.listOf().fieldOf("augments").forGetter(LocateStructureRecipe::getAugments), (App)ResourceOrTag.STRUCTURE_CODEC.fieldOf("structure").forGetter(LocateStructureRecipe::getStructure), (App)Codec.INT.optionalFieldOf("radius", (Object)50).forGetter(LocateStructureRecipe::getRadius), (App)Codec.BOOL.optionalFieldOf("skip_known_structures", (Object)true).forGetter(LocateStructureRecipe::getSkipExisting)).apply((Applicative)instance, LocateStructureRecipe::new));

        public LocateStructureRecipe fromJson(ResourceLocation resourceLocation, JsonObject jsonObject) {
            return CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)jsonObject).result().orElse(null);
        }

        @Nullable
        public LocateStructureRecipe fromNetwork(ResourceLocation resourceLocation, FriendlyByteBuf friendlyByteBuf) {
            return (LocateStructureRecipe)friendlyByteBuf.m_271872_(CODEC);
        }

        public void toNetwork(FriendlyByteBuf friendlyByteBuf, LocateStructureRecipe locateStructureRecipe) {
            friendlyByteBuf.m_272073_(CODEC, (Object)locateStructureRecipe);
        }
    }
}

