/*
 * Decompiled with CFR 0.152.
 */
package com.github.jarva.arsartifice.datagen;

import com.github.jarva.arsartifice.datagen.Setup;
import com.github.jarva.arsartifice.glyphs.AnguishArtificeMethod;
import com.github.jarva.arsartifice.glyphs.FallingArtificeMethod;
import com.github.jarva.arsartifice.glyphs.IntervalArtificeMethod;
import com.github.jarva.arsartifice.glyphs.LandingArtificeMethod;
import com.hollingsworth.arsnouveau.api.spell.AbstractSpellPart;
import com.hollingsworth.arsnouveau.common.crafting.recipes.GlyphRecipe;
import com.hollingsworth.arsnouveau.common.datagen.GlyphRecipeProvider;
import com.hollingsworth.arsnouveau.setup.registry.ItemsRegistry;
import com.hollingsworth.arsnouveau.setup.registry.ModPotions;
import com.hollingsworth.arsnouveau.setup.registry.RegistryHelper;
import java.nio.file.Path;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataGenerator;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.crafting.StrictNBTIngredient;

public class GlyphProvider
extends GlyphRecipeProvider {
    public GlyphProvider(DataGenerator generatorIn) {
        super(generatorIn);
    }

    public void collectJsons(CachedOutput cache) {
        this.addEntries();
        for (GlyphRecipe recipe : this.recipes) {
            Path path = GlyphProvider.getScribeGlyphPath(this.output, recipe.output.m_41720_());
            this.saveStable(cache, recipe.asRecipe(), path);
        }
    }

    public void addEntries() {
        this.addRecipe(AnguishArtificeMethod.INSTANCE, this.i((ItemLike)Items.f_42740_), this.getPotionIngredient((Potion)ModPotions.DEFENCE_POTION.get()));
        this.addRecipe(FallingArtificeMethod.INSTANCE, this.i((ItemLike)Items.f_42402_), this.getPotionIngredient(Potions.f_43596_));
        this.addRecipe(IntervalArtificeMethod.INSTANCE, this.i((ItemLike)Items.f_42524_), this.i((ItemLike)ItemsRegistry.SOURCE_GEM));
        this.addRecipe(LandingArtificeMethod.INSTANCE, this.i((ItemLike)Items.f_42329_), this.i((ItemLike)Items.f_42471_));
    }

    public Ingredient i(ItemLike item) {
        return Ingredient.m_43929_((ItemLike[])new ItemLike[]{item});
    }

    public void addRecipe(AbstractSpellPart part, Ingredient ... items) {
        GlyphRecipe recipe = this.get(part);
        for (Ingredient item : items) {
            recipe.withIngredient(item);
        }
        this.recipes.add(recipe);
    }

    public Ingredient getPotionIngredient(Potion potion) {
        return StrictNBTIngredient.of((ItemStack)PotionUtils.m_43549_((ItemStack)Items.f_42589_.m_7968_(), (Potion)potion));
    }

    protected static Path getScribeGlyphPath(Path pathIn, Item glyph) {
        return pathIn.resolve("data/" + Setup.root + "/recipes/" + RegistryHelper.getRegistryName((Item)glyph).m_135815_() + ".json");
    }

    public String m_6055_() {
        return "Example Glyph Recipes";
    }
}

