/*
 * Decompiled with CFR 0.152.
 */
package com.github.jarva.arsartifice.glyphs;

import com.hollingsworth.arsnouveau.api.spell.AbstractAugment;
import com.hollingsworth.arsnouveau.api.spell.AbstractSpellPart;
import com.hollingsworth.arsnouveau.api.spell.ISpellCaster;
import com.hollingsworth.arsnouveau.api.spell.Spell;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.SpellStats;
import com.hollingsworth.arsnouveau.api.spell.wrapped_caster.IWrappedCaster;
import com.hollingsworth.arsnouveau.api.spell.wrapped_caster.LivingCaster;
import com.hollingsworth.arsnouveau.api.spell.wrapped_caster.PlayerCaster;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentAmplify;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentDampen;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentDurationDown;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentExtendTime;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentSensitive;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.HashMap;
import java.util.Set;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractArtificeMethod
extends AbstractSpellPart {
    public AbstractArtificeMethod(ResourceLocation tag, String description) {
        super(tag, description);
    }

    public Integer getTypeIndex() {
        return 1;
    }

    public boolean shouldShowInSpellBook() {
        return false;
    }

    @NotNull
    protected Set<AbstractAugment> getCompatibleAugments() {
        return this.augmentSetOf(new AbstractAugment[]{AugmentSensitive.INSTANCE});
    }

    public SpellStats getSpellStats(ISpellCaster caster, LivingEntity entity, Spell spell) {
        LivingCaster livingCaster;
        if (entity instanceof Player) {
            Player player = (Player)entity;
            livingCaster = new PlayerCaster(player);
        } else {
            livingCaster = new LivingCaster(entity);
        }
        LivingCaster wrapped = livingCaster;
        SpellContext context = new SpellContext(entity.m_9236_(), caster.modifySpellBeforeCasting(entity.m_9236_(), (Entity)entity, InteractionHand.MAIN_HAND, spell), entity, (IWrappedCaster)wrapped);
        SpellStats stats = new SpellStats.Builder().setAugments(spell.getAugments(0, entity)).addItemsFromEntity(entity).build((AbstractSpellPart)this, null, entity.m_9236_(), entity, context);
        return stats;
    }

    public Component format(double value, String descriptor) {
        NumberFormat nf = DecimalFormat.getNumberInstance();
        return Component.m_237110_((String)("ars_artifice.tooltip." + descriptor), (Object[])new Object[]{nf.format(value)});
    }

    public abstract Component getMeta(HashMap<AbstractAugment, Integer> var1);

    public double getAmpMultiplier(HashMap<AbstractAugment, Integer> augments) {
        return this.getAmpMultiplier(augments.getOrDefault(AugmentAmplify.INSTANCE, 0).intValue(), augments.getOrDefault(AugmentDampen.INSTANCE, 0).intValue());
    }

    public double getAmpMultiplier(double amplify, double dampen) {
        return amplify - dampen;
    }

    public double getDurationMultiplier(HashMap<AbstractAugment, Integer> augments) {
        return this.getDurationMultiplier(augments.getOrDefault(AugmentExtendTime.INSTANCE, 0).intValue(), augments.getOrDefault(AugmentDurationDown.INSTANCE, 0).intValue());
    }

    public double getDurationMultiplier(double extend, double down) {
        return extend - down;
    }
}

