/*
 * Decompiled with CFR 0.152.
 */
package com.github.jarva.arsartifice.glyphs;

import com.github.jarva.arsartifice.ArsArtifice;
import com.github.jarva.arsartifice.glyphs.AbstractArtificeMethod;
import com.github.jarva.arsartifice.glyphs.TickableArtificeMethod;
import com.hollingsworth.arsnouveau.api.spell.AbstractAugment;
import com.hollingsworth.arsnouveau.api.spell.ISpellCaster;
import com.hollingsworth.arsnouveau.api.spell.Spell;
import com.hollingsworth.arsnouveau.api.spell.SpellStats;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentDurationDown;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentExtendTime;
import java.util.HashMap;
import java.util.Set;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.ForgeConfigSpec;
import org.jetbrains.annotations.NotNull;

public class IntervalArtificeMethod
extends AbstractArtificeMethod
implements TickableArtificeMethod {
    public static IntervalArtificeMethod INSTANCE = new IntervalArtificeMethod(ArsArtifice.prefix("glyph_interval"), "Interval");
    public ForgeConfigSpec.IntValue INTERVAL;
    public ForgeConfigSpec.IntValue STEP;

    public IntervalArtificeMethod(ResourceLocation tag, String description) {
        super(tag, description);
    }

    public String getBookDescription() {
        return "Interval triggers on a loop. Amplify increases the duration between triggers. Dampen reduces the duration between triggers.";
    }

    public int getDefaultManaCost() {
        return 0;
    }

    public void buildConfig(ForgeConfigSpec.Builder builder) {
        super.buildConfig(builder);
        this.INTERVAL = builder.comment("Interval, in seconds").defineInRange("interval", 10, 1, Integer.MAX_VALUE);
        this.STEP = builder.comment("Interval change step, in seconds").defineInRange("step", 1, 1, Integer.MAX_VALUE);
    }

    public double getDuration(double duration) {
        return (double)((Integer)this.INTERVAL.get()).intValue() + duration * (double)((Integer)this.STEP.get()).intValue() * 20.0;
    }

    public double getDurationTicks(double duration) {
        return this.getDuration(duration) * 20.0;
    }

    @Override
    public void tick(LivingEntity entity, ItemStack stack, ISpellCaster caster, SpellStats stats, Spell spell) {
        double duration = this.getDurationTicks(stats.getDurationMultiplier());
        if ((double)entity.m_9236_().m_46467_() % duration != 0.0) {
            return;
        }
        caster.castSpell(entity.m_9236_(), entity, InteractionHand.MAIN_HAND, (Component)Component.m_237115_((String)"ars_nouveau.spell.validation.crafting.invalid"), spell);
    }

    @Override
    @NotNull
    protected Set<AbstractAugment> getCompatibleAugments() {
        return this.augmentSetOf(new AbstractAugment[]{AugmentExtendTime.INSTANCE, AugmentDurationDown.INSTANCE});
    }

    @Override
    public Component getMeta(HashMap<AbstractAugment, Integer> augments) {
        double duration = this.getDurationMultiplier(augments);
        return this.format(this.getDuration(duration), "seconds");
    }
}

