/*
 * Decompiled with CFR 0.152.
 */
package com.github.jarva.arsartifice.recipes;

import com.github.jarva.arsartifice.ArsArtifice;
import com.github.jarva.arsartifice.registry.ModRegistry;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.hollingsworth.arsnouveau.api.enchanting_apparatus.EnchantingApparatusRecipe;
import java.util.List;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import org.jetbrains.annotations.Nullable;

public class NoDamageEnchantmentRecipe
extends EnchantingApparatusRecipe {
    public NoDamageEnchantmentRecipe(ResourceLocation id, Ingredient reagent, ItemStack result, List<Ingredient> pedestalItems, int cost) {
        super(id, pedestalItems, reagent, result, cost, false);
    }

    public boolean doesReagentMatch(ItemStack stack) {
        return super.doesReagentMatch(stack) && stack.m_41773_() == 0;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ModRegistry.NO_DAMAGE_RECIPE.get();
    }

    public RecipeType<?> m_6671_() {
        return (RecipeType)ModRegistry.NO_DAMAGE_TYPE.get();
    }

    public JsonElement asRecipe() {
        JsonObject jsonobject = (JsonObject)super.asRecipe();
        jsonobject.addProperty("type", ArsArtifice.prefix("no_damage_enchantment").toString());
        return jsonobject;
    }

    public static class Serializer
    implements RecipeSerializer<NoDamageEnchantmentRecipe> {
        private final EnchantingApparatusRecipe.Serializer serializer = new EnchantingApparatusRecipe.Serializer();

        public NoDamageEnchantmentRecipe fromJson(ResourceLocation recipeId, JsonObject serializedRecipe) {
            EnchantingApparatusRecipe recipe = this.serializer.fromJson(recipeId, serializedRecipe);
            return new NoDamageEnchantmentRecipe(recipeId, recipe.reagent, recipe.result, recipe.pedestalItems, recipe.sourceCost);
        }

        @Nullable
        public NoDamageEnchantmentRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            EnchantingApparatusRecipe recipe = this.serializer.fromNetwork(recipeId, buffer);
            return new NoDamageEnchantmentRecipe(recipeId, recipe.reagent, recipe.result, recipe.pedestalItems, recipe.sourceCost);
        }

        public void toNetwork(FriendlyByteBuf buffer, NoDamageEnchantmentRecipe recipe) {
            this.serializer.toNetwork(buffer, (EnchantingApparatusRecipe)recipe);
        }
    }
}

