/*
 * Decompiled with CFR 0.152.
 */
package dev.qther.ars_controle.block;

import com.hollingsworth.arsnouveau.api.block.IPrismaticBlock;
import com.hollingsworth.arsnouveau.api.event.SpellProjectileHitEvent;
import com.hollingsworth.arsnouveau.api.spell.AbstractAugment;
import com.hollingsworth.arsnouveau.api.util.BlockUtil;
import com.hollingsworth.arsnouveau.api.util.SourceUtil;
import com.hollingsworth.arsnouveau.common.advancement.ANCriteriaTriggers;
import com.hollingsworth.arsnouveau.common.block.ModBlock;
import com.hollingsworth.arsnouveau.common.entity.EntityProjectileSpell;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentAccelerate;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentDecelerate;
import com.hollingsworth.arsnouveau.common.util.PortUtil;
import dev.qther.ars_controle.ArsControle;
import dev.qther.ars_controle.tile.WarpingSpellPrismTile;
import java.util.Iterator;
import net.minecraft.advancements.critereon.PlayerTrigger;
import net.minecraft.core.BlockPos;
import net.minecraft.core.BlockSourceImpl;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;

public class WarpingSpellPrismBlock
extends ModBlock
implements IPrismaticBlock,
EntityBlock {
    public WarpingSpellPrismBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public WarpingSpellPrismBlock() {
    }

    @NotNull
    public InteractionResult m_6227_(@NotNull BlockState state, @NotNull Level worldIn, @NotNull BlockPos pos, @NotNull Player player, @NotNull InteractionHand handIn, @NotNull BlockHitResult hit) {
        if (handIn != InteractionHand.MAIN_HAND) {
            return InteractionResult.PASS;
        }
        if (worldIn.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        if (!state.canEntityDestroy((BlockGetter)worldIn, pos, (Entity)player)) {
            return InteractionResult.FAIL;
        }
        BlockEntity te = worldIn.m_7702_(pos);
        if (te == null) {
            ArsControle.LOGGER.warn("No tile entity in scrying spell prism.");
            return InteractionResult.FAIL;
        }
        if (!(te instanceof WarpingSpellPrismTile)) {
            ArsControle.LOGGER.warn("Wrong tile entity in scrying spell prism.");
            return InteractionResult.FAIL;
        }
        WarpingSpellPrismTile tile = (WarpingSpellPrismTile)te;
        ItemStack stack = player.m_21120_(handIn);
        if (stack.m_41619_()) {
            if (player.m_6047_()) {
                tile.setEntityUUID(player.m_20148_());
                tile.m_6596_();
                PortUtil.sendMessage((Entity)player, (Component)Component.m_237115_((String)"ars_controle.target.set.self"));
                return InteractionResult.SUCCESS;
            }
            HitResult hitResult = tile.getHitResult();
            if (hitResult == null) {
                PortUtil.sendMessage((Entity)player, (Component)Component.m_237115_((String)"ars_controle.target.get.none"));
                return InteractionResult.SUCCESS;
            }
            if (hitResult instanceof EntityHitResult) {
                EntityHitResult e = (EntityHitResult)hitResult;
                Entity entity = e.m_82443_();
                PortUtil.sendMessage((Entity)player, (Component)Component.m_237110_((String)"ars_controle.target.get.entity", (Object[])new Object[]{entity.m_5446_(), entity.m_9236_().m_46472_().m_135782_().toString()}));
                return InteractionResult.SUCCESS;
            }
            if (hitResult instanceof BlockHitResult) {
                BlockHitResult b = (BlockHitResult)hitResult;
                ServerLevel dim = tile.getTargetLevel();
                PortUtil.sendMessage((Entity)player, (Component)Component.m_237110_((String)"ars_controle.target.get.block", (Object[])new Object[]{b.m_82425_().m_123344_(), dim == null ? "<invalid>" : dim.m_46472_().m_135782_().toString()}));
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }

    public void onHit(ServerLevel world, BlockPos pos, @NotNull EntityProjectileSpell spell) {
        int manaCost;
        EntityProjectileSpell newSpell;
        if (spell.spellResolver == null) {
            spell.m_142687_(Entity.RemovalReason.DISCARDED);
            return;
        }
        WarpingSpellPrismTile tile = (WarpingSpellPrismTile)new BlockSourceImpl(world, pos).m_8118_();
        HitResult hit = tile.getHitResult();
        if (hit == null) {
            world.m_8767_((ParticleOptions)ParticleTypes.f_123792_, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, 1, 0.0, 0.0, 0.0, 0.0);
            spell.m_142687_(Entity.RemovalReason.DISCARDED);
            return;
        }
        ServerLevel dim = tile.getTargetLevel();
        if (dim == null || !dim.m_46749_(BlockPos.m_274446_((Position)hit.m_82450_()))) {
            world.m_8767_((ParticleOptions)ParticleTypes.f_123792_, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, 1, 0.0, 0.0, 0.0, 0.0);
            spell.m_142687_(Entity.RemovalReason.DISCARDED);
            return;
        }
        Level oldLevel = spell.m_9236_();
        if (hit instanceof BlockHitResult) {
            EntityProjectileSpell newSpell2;
            BlockHitResult b = (BlockHitResult)hit;
            if (oldLevel != dim && (newSpell2 = WarpingSpellPrismBlock.changeSpellLevel(dim, spell)) != null) {
                spell = newSpell2;
            }
            hit = b.m_82432_(spell.m_6350_());
        }
        if (hit instanceof EntityHitResult && oldLevel != dim && (newSpell = WarpingSpellPrismBlock.changeSpellLevel(dim, spell)) != null) {
            spell = newSpell;
        }
        Vec3 oldPos = spell.m_20182_();
        Vec3 newPos = hit.m_82450_();
        if (newPos.equals((Object)oldPos) && oldLevel == spell.m_9236_()) {
            return;
        }
        spell.m_146884_(newPos);
        if (++spell.prismRedirect >= 3) {
            ANCriteriaTriggers.rewardNearbyPlayers((PlayerTrigger)ANCriteriaTriggers.PRISMATIC, (ServerLevel)world, (BlockPos)pos, (int)10);
        }
        if ((manaCost = tile.getSourceRequired(hit)) > 0 && SourceUtil.takeSourceWithParticles((BlockPos)pos, (Level)world, (int)10, (int)manaCost) == null) {
            world.m_8767_((ParticleOptions)ParticleTypes.f_123771_, (double)pos.m_123341_() + 0.5, (double)(pos.m_123342_() + 1), (double)pos.m_123343_() + 0.5, world.f_46441_.m_188503_(4) + 1, 0.0, 0.0, 0.0, 0.0);
            spell.m_142687_(Entity.RemovalReason.DISCARDED);
            return;
        }
        float acceleration = (float)spell.spellResolver.spell.getBuffsAtIndex(0, null, (AbstractAugment)AugmentAccelerate.INSTANCE) - (float)spell.spellResolver.spell.getBuffsAtIndex(0, null, (AbstractAugment)AugmentDecelerate.INSTANCE) * 0.5f;
        float velocity = Math.max(0.1f, 0.5f + 0.1f * Math.min(2.0f, acceleration));
        Vector3f dir = spell.m_6350_().m_253071_().normalize();
        spell.m_6686_((double)dir.x, (double)dir.y, (double)dir.z, velocity, 0.0f);
        if (spell.m_9236_().m_186434_((Entity)spell, spell.m_20191_()).iterator().hasNext()) {
            SpellProjectileHitEvent event = new SpellProjectileHitEvent(spell, hit);
            MinecraftForge.EVENT_BUS.post((Event)event);
            if (event.isCanceled()) {
                return;
            }
            spell.spellResolver.onResolveEffect(spell.m_9236_(), hit);
            spell.m_142687_(Entity.RemovalReason.DISCARDED);
        } else {
            Iterator entities = spell.m_9236_().m_45933_((Entity)spell, spell.m_20191_()).iterator();
            if (entities.hasNext()) {
                Entity e = (Entity)entities.next();
                SpellProjectileHitEvent event = new SpellProjectileHitEvent(spell, hit);
                MinecraftForge.EVENT_BUS.post((Event)event);
                if (event.isCanceled()) {
                    return;
                }
                spell.spellResolver.onResolveEffect(spell.m_9236_(), (HitResult)new EntityHitResult(e, spell.m_20182_()));
                spell.m_142687_(Entity.RemovalReason.DISCARDED);
            } else {
                spell.m_146884_(spell.m_20182_().m_82546_(new Vec3(spell.m_6350_().m_253071_().normalize().mul(velocity))));
            }
        }
        BlockUtil.updateObservers((Level)world, (BlockPos)pos);
    }

    public BlockEntity m_142194_(@NotNull BlockPos pPos, @NotNull BlockState pState) {
        return new WarpingSpellPrismTile(pPos, pState);
    }

    public static EntityProjectileSpell changeSpellLevel(ServerLevel level, EntityProjectileSpell old) {
        EntityProjectileSpell spell = (EntityProjectileSpell)old.m_6095_().m_20615_((Level)level);
        if (spell != null) {
            spell.m_20361_((Entity)old);
            spell.spellResolver = old.spellResolver;
            spell.prismRedirect = old.prismRedirect;
            spell.age = old.age;
            spell.pierceLeft = old.pierceLeft;
            spell.numSensitive = old.numSensitive;
            spell.m_20256_(old.m_20184_());
            level.m_143334_((Entity)spell);
            old.m_142687_(Entity.RemovalReason.CHANGED_DIMENSION);
        }
        return spell;
    }
}

