/*
 * Decompiled with CFR 0.152.
 */
package dev.qther.ars_controle.datagen;

import com.google.gson.JsonElement;
import com.hollingsworth.arsnouveau.api.enchanting_apparatus.EnchantingApparatusRecipe;
import com.hollingsworth.arsnouveau.api.familiar.AbstractFamiliarHolder;
import com.hollingsworth.arsnouveau.api.ritual.AbstractRitual;
import com.hollingsworth.arsnouveau.api.spell.AbstractCastMethod;
import com.hollingsworth.arsnouveau.api.spell.AbstractEffect;
import com.hollingsworth.arsnouveau.api.spell.AbstractSpellPart;
import com.hollingsworth.arsnouveau.common.crafting.recipes.GlyphRecipe;
import com.hollingsworth.arsnouveau.common.crafting.recipes.ImbuementRecipe;
import com.hollingsworth.arsnouveau.common.datagen.ApparatusRecipeProvider;
import com.hollingsworth.arsnouveau.common.datagen.GlyphRecipeProvider;
import com.hollingsworth.arsnouveau.common.datagen.ImbuementRecipeProvider;
import com.hollingsworth.arsnouveau.common.datagen.PatchouliProvider;
import com.hollingsworth.arsnouveau.common.datagen.patchouli.CraftingPage;
import com.hollingsworth.arsnouveau.common.datagen.patchouli.EnchantingPage;
import com.hollingsworth.arsnouveau.common.datagen.patchouli.EntityPage;
import com.hollingsworth.arsnouveau.common.datagen.patchouli.GlyphScribePage;
import com.hollingsworth.arsnouveau.common.datagen.patchouli.IPatchouliPage;
import com.hollingsworth.arsnouveau.common.datagen.patchouli.ImbuementPage;
import com.hollingsworth.arsnouveau.common.datagen.patchouli.PatchouliBuilder;
import com.hollingsworth.arsnouveau.common.datagen.patchouli.TextPage;
import com.hollingsworth.arsnouveau.setup.registry.BlockRegistry;
import com.hollingsworth.arsnouveau.setup.registry.ItemsRegistry;
import com.hollingsworth.arsnouveau.setup.registry.RegistryHelper;
import dev.qther.ars_controle.ArsNouveauRegistry;
import dev.qther.ars_controle.registry.ModRegistry;
import java.nio.file.Path;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.Tags;

public class ArsProviders {
    static String root = "ars_controle";

    public static class PatchouliProvider
    extends com.hollingsworth.arsnouveau.common.datagen.PatchouliProvider {
        public PatchouliProvider(DataGenerator generatorIn) {
            super(generatorIn);
        }

        public void collectJsons(CachedOutput cache) {
            for (AbstractSpellPart spell : ArsNouveauRegistry.registeredSpells) {
                this.addGlyphPage(spell);
            }
            for (PatchouliProvider.PatchouliPage patchouliPage : this.pages) {
                DataProvider.m_253162_((CachedOutput)cache, (JsonElement)patchouliPage.build(), (Path)patchouliPage.path());
            }
        }

        public PatchouliProvider.PatchouliPage addBasicItem(ItemLike item, ResourceLocation category, IPatchouliPage recipePage) {
            PatchouliBuilder builder = new PatchouliBuilder(category, item.m_5456_().m_5524_()).withIcon((ItemLike)item.m_5456_()).withPage((IPatchouliPage)new TextPage(root + ".page." + RegistryHelper.getRegistryName((Item)item.m_5456_()).m_135815_())).withPage(recipePage);
            PatchouliProvider.PatchouliPage page = new PatchouliProvider.PatchouliPage(builder, this.getPath(category, RegistryHelper.getRegistryName((Item)item.m_5456_()).m_135815_()));
            this.pages.add(page);
            return page;
        }

        public void addFamiliarPage(AbstractFamiliarHolder familiarHolder) {
            PatchouliBuilder builder = new PatchouliBuilder(FAMILIARS, "entity." + root + "." + familiarHolder.getRegistryName().m_135815_()).withIcon(root + ":" + familiarHolder.getRegistryName().m_135815_()).withTextPage(root + ".familiar_desc." + familiarHolder.getRegistryName().m_135815_()).withPage((IPatchouliPage)new EntityPage(familiarHolder.getRegistryName().toString()));
            this.pages.add(new PatchouliProvider.PatchouliPage(builder, this.getPath(FAMILIARS, familiarHolder.getRegistryName().m_135815_())));
        }

        public void addRitualPage(AbstractRitual ritual) {
            PatchouliBuilder builder = new PatchouliBuilder(RITUALS, "item." + root + "." + ritual.getRegistryName().m_135815_()).withIcon(ritual.getRegistryName().toString()).withTextPage(ritual.getDescriptionKey()).withPage((IPatchouliPage)new CraftingPage(root + ":tablet_" + ritual.getRegistryName().m_135815_()));
            this.pages.add(new PatchouliProvider.PatchouliPage(builder, this.getPath(RITUALS, ritual.getRegistryName().m_135815_())));
        }

        public void addEnchantmentPage(Enchantment enchantment) {
            PatchouliBuilder builder = new PatchouliBuilder(ENCHANTMENTS, enchantment.m_44704_()).withIcon(RegistryHelper.getRegistryName((Item)Items.f_42690_).toString()).withTextPage(root + ".enchantment_desc." + RegistryHelper.getRegistryName((Enchantment)enchantment).m_135815_());
            for (int i = enchantment.m_44702_(); i <= enchantment.m_6586_(); ++i) {
                builder.withPage((IPatchouliPage)new EnchantingPage("ars_nouveau:" + RegistryHelper.getRegistryName((Enchantment)enchantment).m_135815_() + "_" + i));
            }
            this.pages.add(new PatchouliProvider.PatchouliPage(builder, this.getPath(ENCHANTMENTS, RegistryHelper.getRegistryName((Enchantment)enchantment).m_135815_())));
        }

        public void addGlyphPage(AbstractSpellPart spellPart) {
            ResourceLocation category = switch (spellPart.defaultTier().value) {
                case 1 -> GLYPHS_1;
                case 2 -> GLYPHS_2;
                default -> GLYPHS_3;
            };
            PatchouliBuilder builder = new PatchouliBuilder(category, spellPart.getName()).withName(root + ".glyph_name." + spellPart.getRegistryName().m_135815_()).withIcon(spellPart.getRegistryName().toString()).withSortNum(spellPart instanceof AbstractCastMethod ? 1 : (spellPart instanceof AbstractEffect ? 2 : 3)).withPage((IPatchouliPage)new TextPage(root + ".glyph_desc." + spellPart.getRegistryName().m_135815_())).withPage((IPatchouliPage)new GlyphScribePage(spellPart));
            this.pages.add(new PatchouliProvider.PatchouliPage(builder, this.getPath(category, spellPart.getRegistryName().m_135815_())));
        }

        public String m_6055_() {
            return "Ars Controle Patchouli Datagen";
        }

        public Path getPath(ResourceLocation category, String fileName) {
            return this.generator.getPackOutput().m_245114_().resolve("data/" + root + "/patchouli_books/example/en_us/entries/" + category.m_135815_() + "/" + fileName + ".json");
        }

        ImbuementPage ImbuementPage(ItemLike item) {
            return new ImbuementPage(root + ":imbuement_" + RegistryHelper.getRegistryName((Item)item.m_5456_()).m_135815_());
        }
    }

    public static class ImbuementProvider
    extends ImbuementRecipeProvider {
        public ImbuementProvider(DataGenerator generatorIn) {
            super(generatorIn);
        }

        public void collectJsons(CachedOutput cache) {
            Path output = this.generator.getPackOutput().m_245114_();
            for (ImbuementRecipe g : this.recipes) {
                Path path = this.getRecipePath(output, g.m_6423_().m_135815_());
                this.saveStable(cache, g.asRecipe(), path);
            }
        }

        protected Path getRecipePath(Path pathIn, String str) {
            return pathIn.resolve("data/" + root + "/recipes/" + str + ".json");
        }

        public String m_6055_() {
            return "Ars Controle Imbuement";
        }
    }

    public static class EnchantingAppProvider
    extends ApparatusRecipeProvider {
        public EnchantingAppProvider(DataGenerator generatorIn) {
            super(generatorIn);
        }

        public void collectJsons(CachedOutput cache) {
            this.addRecipe(this.builder().withResult(ModRegistry.WARPING_SPELL_PRISM_ITEM).withReagent((ItemLike)BlockRegistry.SPELL_PRISM).withPedestalItem(4, Ingredient.m_204132_((TagKey)Tags.Items.ENDER_PEARLS)).withPedestalItem(4, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42731_})).build());
            this.addRecipe(this.builder().withResult(ModRegistry.REMOTE).withReagent((ItemLike)ItemsRegistry.DOMINION_ROD).withPedestalItem(4, Ingredient.m_204132_((TagKey)Tags.Items.ENDER_PEARLS)).withPedestalItem(4, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42731_})).build());
            Path output = this.generator.getPackOutput().m_245114_();
            for (EnchantingApparatusRecipe g : this.recipes) {
                if (g == null) continue;
                Path path = EnchantingAppProvider.getRecipePath(output, g.m_6423_().m_135815_());
                this.saveStable(cache, g.asRecipe(), path);
            }
        }

        protected static Path getRecipePath(Path pathIn, String str) {
            return pathIn.resolve("data/" + root + "/recipes/" + str + ".json");
        }

        public String m_6055_() {
            return "Ars Controle Apparatus";
        }
    }

    public static class GlyphProvider
    extends GlyphRecipeProvider {
        public GlyphProvider(DataGenerator generatorIn) {
            super(generatorIn);
        }

        public void collectJsons(CachedOutput cache) {
            Path output = this.generator.getPackOutput().m_245114_();
            for (GlyphRecipe recipe : this.recipes) {
                Path path = GlyphProvider.getScribeGlyphPath(output, recipe.output.m_41720_());
                this.saveStable(cache, recipe.asRecipe(), path);
            }
        }

        protected static Path getScribeGlyphPath(Path pathIn, Item glyph) {
            return pathIn.resolve("data/" + root + "/recipes/" + RegistryHelper.getRegistryName((Item)glyph).m_135815_() + ".json");
        }

        public String m_6055_() {
            return "Ars Controle Glyph Recipes";
        }
    }
}

