/*
 * Decompiled with CFR 0.152.
 */
package dev.qther.ars_controle.tile;

import com.hollingsworth.arsnouveau.api.item.IWandable;
import com.hollingsworth.arsnouveau.common.block.tile.ModdedTile;
import com.hollingsworth.arsnouveau.common.util.PortUtil;
import dev.qther.ars_controle.Cached;
import dev.qther.ars_controle.ServerConfig;
import dev.qther.ars_controle.registry.ModRegistry;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class WarpingSpellPrismTile
extends ModdedTile
implements IWandable {
    public static final UUID ZERO_UUID = new UUID(0L, 0L);

    public WarpingSpellPrismTile(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModRegistry.WARPING_SPELL_PRISM_TILE.get(), pos, state);
    }

    @Nullable
    public HitResult getHitResult() {
        BlockPos blockPos = this.getBlock();
        if (blockPos != null) {
            Vec3 pos = blockPos.m_252807_();
            return new BlockHitResult(pos, Direction.DOWN, blockPos, true);
        }
        CompoundTag tag = this.getPersistentData();
        Entity entity = null;
        if (tag.m_128403_("entity")) {
            UUID uuid = tag.m_128342_("entity");
            entity = Cached.getEntityByUUID(this.f_58857_.m_7654_().m_129785_(), uuid);
        }
        if (entity == null || !entity.m_6084_()) {
            return null;
        }
        return new EntityHitResult(entity, entity.m_146892_());
    }

    public void setBlock(@Nullable ResourceKey<Level> level, @Nullable BlockPos block) {
        CompoundTag tag = this.getPersistentData();
        if (level == null) {
            tag.m_128473_("dimension");
        }
        if (block == null) {
            tag.m_128473_("block");
        }
        if (level == null || block == null) {
            this.m_6596_();
            return;
        }
        tag.m_128359_("dimension", level.m_135782_().toString());
        tag.m_128356_("block", block.m_121878_());
        tag.m_128473_("entity");
        this.m_6596_();
    }

    @Nullable
    public ServerLevel getTargetLevel() {
        CompoundTag tag = this.getPersistentData();
        if (this.getBlock() != null) {
            String s;
            String string = s = tag.m_128425_("dimension", 8) ? tag.m_128461_("dimension") : null;
            if (s == null || this.f_58857_ == null) {
                return null;
            }
            return Cached.getLevelByName(this.f_58857_.m_7654_().m_129785_(), s);
        }
        Entity entity = this.getEntity();
        if (entity != null) {
            return (ServerLevel)entity.m_9236_();
        }
        return null;
    }

    @Nullable
    public BlockPos getBlock() {
        CompoundTag tag = this.getPersistentData();
        return tag.m_128425_("block", 99) ? BlockPos.m_122022_((long)tag.m_128454_("block")) : null;
    }

    public void setEntityUUID(UUID uuid) {
        CompoundTag tag = this.getPersistentData();
        tag.m_128362_("entity", uuid);
        tag.m_128473_("block");
        this.m_6596_();
    }

    public UUID getEntityUUID() {
        CompoundTag tag = this.getPersistentData();
        return tag.m_128441_("entity") ? tag.m_128342_("entity") : ZERO_UUID;
    }

    @Nullable
    public Entity getEntity() {
        UUID uuid = this.getEntityUUID();
        return uuid == ZERO_UUID ? null : Cached.getEntityByUUID(this.f_58857_.m_7654_().m_129785_(), uuid);
    }

    public int getSourceRequired(HitResult hitResult) {
        double distSqr = 0.0;
        int dimCost = 0;
        if (hitResult instanceof BlockHitResult) {
            BlockHitResult b = (BlockHitResult)hitResult;
            distSqr = b.m_82425_().m_252807_().m_82557_(this.m_58899_().m_252807_());
            if (this.getTargetLevel() != this.f_58857_) {
                dimCost = (Integer)ServerConfig.SERVER.WARPING_SPELL_PRISM_COST_DIMENSION.get();
            }
        } else if (hitResult instanceof EntityHitResult) {
            EntityHitResult e = (EntityHitResult)hitResult;
            distSqr = e.m_82450_().m_82557_(this.m_58899_().m_252807_());
            if (this.getTargetLevel() != this.f_58857_) {
                dimCost = (Integer)ServerConfig.SERVER.WARPING_SPELL_PRISM_COST_DIMENSION.get();
            }
        }
        Integer costMinDistance = (Integer)ServerConfig.SERVER.WARPING_SPELL_PRISM_COST_MIN_DISTANCE.get();
        int costMinDistanceSqr = costMinDistance * costMinDistance;
        Integer costPerBlock = (Integer)ServerConfig.SERVER.WARPING_SPELL_PRISM_COST_PER_BLOCK.get();
        if (distSqr > (double)costMinDistanceSqr) {
            Integer maxCost = (Integer)ServerConfig.SERVER.WARPING_SPELL_PRISM_MAX_SOURCE_COST.get();
            return (int)Math.min((double)maxCost.intValue(), (double)dimCost + Math.sqrt(distSqr - (double)costMinDistanceSqr) * (double)costPerBlock.intValue());
        }
        return dimCost;
    }

    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        UUID uuid = this.getEntityUUID();
        if (uuid != ZERO_UUID) {
            tag.m_128362_("entity", uuid);
            return;
        }
        BlockPos pos = this.getBlock();
        if (pos != null) {
            tag.m_128356_("block", pos.m_121878_());
        }
    }

    public void onFinishedConnectionLast(@Nullable BlockPos storedPos, @Nullable Direction face, @Nullable LivingEntity storedEntity, Player player) {
        if (storedPos != null) {
            ResourceKey dim = player.m_9236_().m_46472_();
            this.setBlock((ResourceKey<Level>)dim, storedPos);
            this.m_6596_();
            PortUtil.sendMessage((Entity)player, (Component)Component.m_237110_((String)"ars_controle.target.set.block", (Object[])new Object[]{storedPos.m_123344_(), dim.m_135782_().toString()}));
            return;
        }
        if (storedEntity != null) {
            this.setEntityUUID(storedEntity.m_20148_());
            this.setEntityUUID(storedEntity.m_20148_());
            this.m_6596_();
            PortUtil.sendMessage((Entity)player, (Component)Component.m_237110_((String)"ars_controle.target.set.entity", (Object[])new Object[]{storedEntity.m_5446_(), storedEntity.m_9236_().m_46472_().m_135782_().toString()}));
        }
    }
}

