/*
 * Decompiled with CFR 0.152.
 */
package com.insider.ars_extended_glyphs;

import com.hollingsworth.arsnouveau.api.event.SpellCostCalcEvent;
import com.hollingsworth.arsnouveau.api.spell.SpellSchool;
import com.hollingsworth.arsnouveau.api.util.CuriosUtil;
import com.hollingsworth.arsnouveau.setup.registry.CapabilityRegistry;
import com.insider.ars_extended_glyphs.item.Tablet;
import com.insider.ars_extended_glyphs.registry.ModRegistry;
import java.util.Optional;
import java.util.stream.IntStream;
import net.minecraft.world.damagesource.DamageSources;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.items.IItemHandlerModifiable;

@Mod.EventBusSubscriber(modid="ars_extended_glyphs")
public class Events {
    private static boolean hasCurio(Entity entity, Level level, Item curio) {
        Optional curios;
        if (!level.f_46443_ && entity instanceof Player && (curios = CuriosUtil.getAllWornItems((LivingEntity)((LivingEntity)entity)).resolve()).isPresent()) {
            IItemHandlerModifiable items = (IItemHandlerModifiable)curios.get();
            return IntStream.range(0, items.getSlots()).anyMatch(i -> items.getStackInSlot(i).m_41720_() == curio);
        }
        return false;
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void discountGlyph(SpellCostCalcEvent ev) {
        Optional curios;
        LivingEntity entity = ev.context.getUnwrappedCaster();
        Level level = entity.m_9236_();
        if (!level.f_46443_ && entity instanceof Player && (curios = CuriosUtil.getAllWornItems((LivingEntity)entity).resolve()).isPresent()) {
            IItemHandlerModifiable items = (IItemHandlerModifiable)curios.get();
            IntStream.range(0, items.getSlots()).forEach(i -> {
                Item patt2913$temp = items.getStackInSlot(i).m_41720_();
                if (patt2913$temp instanceof Tablet) {
                    Tablet tab = (Tablet)patt2913$temp;
                    if (ev.context.getSpell().recipe.stream().anyMatch(arg_0 -> ((SpellSchool)tab.getSchool()).isPartOfSchool(arg_0))) {
                        ev.currentCost -= 50;
                    }
                }
            });
        }
    }

    @SubscribeEvent
    public static void fallDamage(LivingFallEvent ev) {
        Player player;
        LivingEntity livingEntity = ev.getEntity();
        if (livingEntity instanceof Player && !(player = (Player)livingEntity).m_20193_().m_5776_() && Events.hasCurio((Entity)player, player.m_9236_(), (Item)ModRegistry.AIR_TABLET_FRAG.get())) {
            int dist = (int)ev.getDistance() * 3;
            CapabilityRegistry.getMana((LivingEntity)player).ifPresent(mana -> {
                if (mana.getCurrentMana() > (double)dist) {
                    mana.removeMana((double)dist);
                    ev.setDamageMultiplier(0.0f);
                }
            });
        }
    }

    @SubscribeEvent
    public static void fireDamage(LivingHurtEvent ev) {
        Player player;
        LivingEntity livingEntity = ev.getEntity();
        if (livingEntity instanceof Player && !(player = (Player)livingEntity).m_20193_().m_5776_()) {
            DamageSources srcTbl = player.m_269291_();
            if (Events.hasCurio((Entity)player, player.m_9236_(), (Item)ModRegistry.FIRE_TABLET_FRAG.get()) && (ev.getSource() == srcTbl.m_269549_() || ev.getSource() == srcTbl.m_269387_() || ev.getSource() == srcTbl.m_269233_())) {
                int pwr = (int)ev.getAmount() * 25;
                CapabilityRegistry.getMana((LivingEntity)player).ifPresent(mana -> {
                    if (mana.getCurrentMana() > (double)pwr) {
                        mana.removeMana((double)pwr);
                        ev.setCanceled(true);
                    }
                });
            } else if (Events.hasCurio((Entity)player, player.m_9236_(), (Item)ModRegistry.EARTH_TABLET_FRAG.get()) && (ev.getSource() == srcTbl.m_269318_() || ev.getSource() == srcTbl.m_269515_() || ev.getSource() == srcTbl.m_269047_())) {
                int pwr = (int)ev.getAmount() * 20;
                CapabilityRegistry.getMana((LivingEntity)player).ifPresent(mana -> {
                    if (mana.getCurrentMana() > (double)pwr) {
                        mana.removeMana((double)pwr);
                        ev.setCanceled(true);
                    }
                });
            } else if (Events.hasCurio((Entity)player, player.m_9236_(), (Item)ModRegistry.WATER_TABLET_FRAG.get()) && (ev.getSource() == srcTbl.m_269063_() || ev.getSource() == srcTbl.m_269254_())) {
                int pwr = 45;
                CapabilityRegistry.getMana((LivingEntity)player).ifPresent(mana -> {
                    if (mana.getCurrentMana() > (double)pwr) {
                        mana.removeMana((double)pwr);
                        ev.setCanceled(true);
                    }
                });
            }
        }
    }
}

