/*
 * Decompiled with CFR 0.152.
 */
package com.insider.ars_extended_glyphs.glyphs;

import com.hollingsworth.arsnouveau.api.spell.AbstractAugment;
import com.hollingsworth.arsnouveau.api.spell.AbstractEffect;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.SpellResolver;
import com.hollingsworth.arsnouveau.api.spell.SpellSchool;
import com.hollingsworth.arsnouveau.api.spell.SpellSchools;
import com.hollingsworth.arsnouveau.api.spell.SpellStats;
import com.hollingsworth.arsnouveau.api.spell.SpellTier;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentAmplify;
import com.insider.ars_extended_glyphs.Main;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodData;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraftforge.common.ForgeConfigSpec;

public class Saturate
extends AbstractEffect {
    public static Saturate INSTANCE = new Saturate(Main.prefix("glyph_saturate"), "Saturate");

    public Saturate(ResourceLocation tag, String description) {
        super(tag, description);
    }

    public int getDefaultManaCost() {
        return 150;
    }

    public void onResolveEntity(EntityHitResult rayTraceResult, Level world, @Nonnull LivingEntity shooter, SpellStats spellStats, SpellContext spellContext, SpellResolver resolver) {
        super.onResolveEntity(rayTraceResult, world, shooter, spellStats, spellContext, resolver);
        Entity entity = rayTraceResult.m_82443_();
        if (entity instanceof LivingEntity) {
            LivingEntity entity2 = (LivingEntity)entity;
            if (entity2.m_213877_() || entity2.m_21223_() <= 0.0f) {
                return;
            }
            float healVal = (float)((Double)this.GENERIC_DOUBLE.get() + (Double)this.AMP_VALUE.get() * spellStats.getAmpMultiplier());
            if (entity2 instanceof Player) {
                Player player = (Player)entity2;
                FoodData foodData = player.m_36324_();
                int maxSat = 10;
                float curr = foodData.m_38722_();
                float toSet = curr + healVal;
                if (toSet > (float)maxSat) {
                    toSet = Math.max(curr, (float)maxSat);
                }
                foodData.m_38717_(toSet);
                world.m_5594_(null, player.m_20183_(), SoundEvents.f_11912_, SoundSource.NEUTRAL, 1.0f, 1.0f);
            }
        }
    }

    @Nonnull
    public Set<AbstractAugment> getCompatibleAugments() {
        return this.augmentSetOf(new AbstractAugment[]{AugmentAmplify.INSTANCE});
    }

    public SpellTier defaultTier() {
        return SpellTier.TWO;
    }

    @Nonnull
    public Set<SpellSchool> getSchools() {
        return this.setOf(new SpellSchool[]{SpellSchools.ABJURATION});
    }

    public void buildConfig(ForgeConfigSpec.Builder builder) {
        super.buildConfig(builder);
        this.addGenericDouble(builder, 3.0, "Base saturate amount", "base_saturate");
        this.addAmpConfig(builder, 3.0);
    }
}

