/*
 * Decompiled with CFR 0.152.
 */
package com.insider.ars_extended_glyphs.glyphs;

import com.hollingsworth.arsnouveau.api.spell.AbstractAugment;
import com.hollingsworth.arsnouveau.api.spell.AbstractEffect;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.SpellResolver;
import com.hollingsworth.arsnouveau.api.spell.SpellSchool;
import com.hollingsworth.arsnouveau.api.spell.SpellSchools;
import com.hollingsworth.arsnouveau.api.spell.SpellStats;
import com.hollingsworth.arsnouveau.api.spell.SpellTier;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentAmplify;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentDampen;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentSensitive;
import com.hollingsworth.arsnouveau.setup.registry.ModPotions;
import com.insider.ars_extended_glyphs.Main;
import com.insider.ars_extended_glyphs.glyphs.AugmentExtreme;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class SummonHostile
extends AbstractEffect {
    public static SummonHostile INSTANCE = new SummonHostile(Main.prefix("glyph_summonhostile"), "Summon Hostile");
    private final EntityType<?>[] entities = new EntityType[]{EntityType.f_20501_, EntityType.f_20524_, EntityType.f_20558_, EntityType.f_20479_, EntityType.f_20554_, EntityType.f_20566_, EntityType.f_20549_, EntityType.f_20526_, EntityType.f_20495_};

    public SummonHostile(ResourceLocation tag, String description) {
        super(tag, description);
    }

    public int getDefaultManaCost() {
        return 350;
    }

    public void onResolve(HitResult rayTraceResult, Level world, @Nonnull LivingEntity shooter, SpellStats spellStats, SpellContext spellContext, SpellResolver resolver) {
        if (!this.canSummon(shooter)) {
            return;
        }
        if (shooter instanceof Player) {
            Vec3 vector3d = this.safelyGetHitPos(rayTraceResult);
            BlockPos pos = new BlockPos(new Vec3i((int)vector3d.f_82479_, (int)vector3d.f_82480_, (int)vector3d.f_82481_));
            int i = 0;
            while ((double)i < 3.0 + spellStats.getAmpMultiplier()) {
                BlockPos blockpos = pos.m_7918_(-2 + shooter.m_217043_().m_188503_(5), 1, -2 + shooter.m_217043_().m_188503_(5));
                int c = this.entities.length;
                if (spellStats.getBuffCount((AbstractAugment)AugmentSensitive.INSTANCE) > 0) {
                    c -= 5;
                }
                EntityType<?> type = spellStats.getBuffCount((AbstractAugment)AugmentExtreme.INSTANCE) > 0 ? EntityType.f_20558_ : this.entities[shooter.m_217043_().m_188503_(c)];
                type.m_20592_((ServerLevel)world, shooter.m_21120_(InteractionHand.MAIN_HAND), (Player)shooter, blockpos, MobSpawnType.MOB_SUMMONED, false, false);
                ++i;
            }
            world.m_5594_(null, pos, SoundEvents.f_11738_, SoundSource.NEUTRAL, 1.0f, 0.8f);
        }
        shooter.m_7292_(new MobEffectInstance((MobEffect)ModPotions.SUMMONING_SICKNESS_EFFECT.get(), (int)(800.0 + 200.0 * spellStats.getAmpMultiplier())));
    }

    @Nonnull
    public Set<AbstractAugment> getCompatibleAugments() {
        return this.augmentSetOf(new AbstractAugment[]{AugmentAmplify.INSTANCE, AugmentDampen.INSTANCE, AugmentExtreme.INSTANCE, AugmentSensitive.INSTANCE});
    }

    public int getAugmentLimit(ResourceLocation augmentTag) {
        return augmentTag == AugmentAmplify.INSTANCE.getRegistryName() || augmentTag == AugmentDampen.INSTANCE.getRegistryName() ? 2 : 1;
    }

    public SpellTier defaultTier() {
        return SpellTier.THREE;
    }

    @Nonnull
    public Set<SpellSchool> getSchools() {
        return this.setOf(new SpellSchool[]{SpellSchools.CONJURATION});
    }
}

