/*
 * Decompiled with CFR 0.152.
 */
package com.insider.ars_extended_glyphs.glyphs;

import com.hollingsworth.arsnouveau.api.spell.AbstractAugment;
import com.hollingsworth.arsnouveau.api.spell.AbstractEffect;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.SpellResolver;
import com.hollingsworth.arsnouveau.api.spell.SpellSchool;
import com.hollingsworth.arsnouveau.api.spell.SpellSchools;
import com.hollingsworth.arsnouveau.api.spell.SpellStats;
import com.hollingsworth.arsnouveau.api.spell.SpellTier;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentAmplify;
import com.hollingsworth.arsnouveau.setup.registry.ModPotions;
import com.insider.ars_extended_glyphs.Main;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class SummonWildlife
extends AbstractEffect {
    public static SummonWildlife INSTANCE = new SummonWildlife(Main.prefix("glyph_summonwildlife"), "Summon Wildlife");
    private final EntityType<?>[] entities = new EntityType[]{EntityType.f_20520_, EntityType.f_20520_, EntityType.f_20557_, EntityType.f_20557_, EntityType.f_20510_, EntityType.f_20510_, EntityType.f_20549_, EntityType.f_20555_, EntityType.f_20555_};

    public SummonWildlife(ResourceLocation tag, String description) {
        super(tag, description);
    }

    public int getDefaultManaCost() {
        return 250;
    }

    public void onResolve(HitResult rayTraceResult, Level world, @Nonnull LivingEntity shooter, SpellStats spellStats, SpellContext spellContext, SpellResolver resolver) {
        if (!this.canSummon(shooter)) {
            return;
        }
        if (shooter instanceof Player) {
            Vec3 vector3d = this.safelyGetHitPos(rayTraceResult);
            BlockPos pos = new BlockPos(new Vec3i((int)vector3d.f_82479_, (int)vector3d.f_82480_, (int)vector3d.f_82481_));
            int i = 0;
            while ((double)i < 3.0 + spellStats.getAmpMultiplier()) {
                BlockPos blockpos = pos.m_7918_(-2 + shooter.m_217043_().m_188503_(5), 2, -2 + shooter.m_217043_().m_188503_(5));
                EntityType<?> type = this.entities[shooter.m_217043_().m_188503_(this.entities.length)];
                type.m_20592_((ServerLevel)world, shooter.m_21120_(InteractionHand.MAIN_HAND), (Player)shooter, blockpos, MobSpawnType.COMMAND, false, false);
                ++i;
            }
        }
        shooter.m_7292_(new MobEffectInstance((MobEffect)ModPotions.SUMMONING_SICKNESS_EFFECT.get(), (int)(600.0 + 200.0 * spellStats.getAmpMultiplier())));
    }

    @Nonnull
    public Set<AbstractAugment> getCompatibleAugments() {
        return this.augmentSetOf(new AbstractAugment[]{AugmentAmplify.INSTANCE});
    }

    public int getAugmentLimit(ResourceLocation augmentTag) {
        return 3;
    }

    public SpellTier defaultTier() {
        return SpellTier.TWO;
    }

    @Nonnull
    public Set<SpellSchool> getSchools() {
        return this.setOf(new SpellSchool[]{SpellSchools.CONJURATION});
    }
}

