/*
 * Decompiled with CFR 0.152.
 */
package com.insider.ars_extended_glyphs.item;

import com.hollingsworth.arsnouveau.api.ANFakePlayer;
import com.hollingsworth.arsnouveau.api.item.ICasterTool;
import com.hollingsworth.arsnouveau.api.spell.AbstractCastMethod;
import com.hollingsworth.arsnouveau.api.spell.AbstractSpellPart;
import com.hollingsworth.arsnouveau.api.spell.ISpellCaster;
import com.hollingsworth.arsnouveau.api.spell.Spell;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.SpellResolver;
import com.hollingsworth.arsnouveau.api.spell.wrapped_caster.IWrappedCaster;
import com.hollingsworth.arsnouveau.api.spell.wrapped_caster.LivingCaster;
import com.hollingsworth.arsnouveau.api.spell.wrapped_caster.PlayerCaster;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentDurationDown;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentExtendTime;
import com.hollingsworth.arsnouveau.common.spell.method.MethodSelf;
import com.hollingsworth.arsnouveau.common.util.PortUtil;
import com.hollingsworth.arsnouveau.setup.registry.ItemsRegistry;
import com.insider.ars_extended_glyphs.glyphs.Repair;
import com.mojang.blaze3d.platform.InputConstants;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PassiveCast
extends Item
implements ICasterTool {
    private int speed = 5;

    public PassiveCast(Item.Properties pProperties, int spellSpeed) {
        super(pProperties);
        this.speed = spellSpeed;
    }

    private long getTickSpeed(ItemStack pStack) {
        CompoundTag tag = pStack.m_41784_();
        long tSpeed = tag.m_128451_("invTickSpeed");
        return (long)this.speed + Math.max(-9L, tSpeed) * 20L;
    }

    private boolean getEnabled(ItemStack pStack) {
        CompoundTag tag = pStack.m_41784_();
        return tag.m_128471_("canTick");
    }

    public void m_6883_(ItemStack pStack, Level pLevel, Entity pEntity, int pSlotId, boolean pIsSelected) {
        if (this.getEnabled(pStack) && pEntity instanceof LivingEntity) {
            LivingEntity ent = (LivingEntity)pEntity;
            ISpellCaster caster = this.getSpellCaster(pStack);
            Spell spell = caster.getSpell();
            if (pLevel.m_46467_() % this.getTickSpeed(pStack) == 0L && pStack.m_41773_() < pStack.m_41776_() - 1) {
                ANFakePlayer aNFakePlayer;
                LivingCaster wrappedCaster;
                InteractionHand handIn = InteractionHand.MAIN_HAND;
                if (pLevel.f_46443_) {
                    spell = caster.modifySpellBeforeCasting(pLevel, (Entity)ent, handIn, spell);
                }
                if (ent instanceof Player) {
                    Player pCaster = (Player)ent;
                    v0 = new PlayerCaster(pCaster);
                } else {
                    v0 = wrappedCaster = new LivingCaster(ent);
                }
                if (ent instanceof Player) {
                    Player thisPlayer = (Player)ent;
                    aNFakePlayer = thisPlayer;
                } else {
                    aNFakePlayer = ANFakePlayer.getPlayer((ServerLevel)((ServerLevel)pLevel));
                }
                ANFakePlayer player = aNFakePlayer;
                SpellResolver resolver = caster.getSpellResolver(new SpellContext(pLevel, spell, ent, (IWrappedCaster)wrappedCaster, pStack), pLevel, (LivingEntity)player, handIn);
                if (resolver.onCastOnEntity(pStack, (Entity)ent, handIn)) {
                    caster.playSound(ent.m_20097_(), pLevel, (Entity)ent, caster.getCurrentSound(), SoundSource.PLAYERS);
                    if (ent instanceof ServerPlayer) {
                        ServerPlayer serverPlayer = (ServerPlayer)ent;
                        pStack.m_220157_(1, pLevel.f_46441_, serverPlayer);
                    }
                }
            }
        }
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return enchantment == Enchantments.f_44986_;
    }

    public boolean m_8120_(ItemStack pStack) {
        return true;
    }

    public boolean m_6832_(@NotNull ItemStack pToRepair, ItemStack pRepair) {
        return pRepair.m_41720_() == ItemsRegistry.SOURCE_GEM.get();
    }

    public boolean setSpell(ISpellCaster caster, Player player, InteractionHand hand, ItemStack stack, Spell spell) {
        ArrayList<Object> recipe = new ArrayList<Object>();
        recipe.add(MethodSelf.INSTANCE);
        CompoundTag tag = stack.m_41784_();
        int newSpeed = 0;
        boolean finishedFirst = false;
        for (AbstractSpellPart part : spell.recipe) {
            if (!finishedFirst && part == AugmentExtendTime.INSTANCE) {
                ++newSpeed;
                continue;
            }
            if (!finishedFirst && part == AugmentDurationDown.INSTANCE) {
                --newSpeed;
                continue;
            }
            finishedFirst = true;
            if (part == Repair.INSTANCE) continue;
            recipe.add(part);
        }
        tag.m_128405_("invTickSpeed", newSpeed);
        tag.m_128405_("color", player.m_217043_().m_188502_());
        spell.recipe = recipe;
        spell.sound = caster.getSound(caster.getCurrentSlot());
        spell.color = caster.getColor(caster.getCurrentSlot());
        return super.setSpell(caster, player, hand, stack, spell);
    }

    public boolean isScribedSpellValid(ISpellCaster caster, Player player, InteractionHand hand, ItemStack stack, Spell spell) {
        return spell.recipe.stream().noneMatch(s -> s instanceof AbstractCastMethod);
    }

    public void m_7373_(ItemStack pStack, @Nullable Level pLevel, List<Component> pTooltipComponents, TooltipFlag pIsAdvanced) {
        pTooltipComponents.add((Component)Component.m_237113_((String)("Rate: " + this.getTickSpeed(pStack) / 20L + " second(s)")).m_130948_(Style.f_131099_.m_131140_(ChatFormatting.GOLD)));
        pTooltipComponents.add((Component)Component.m_237113_((String)("Status: " + (this.getEnabled(pStack) ? "Enabled" : "Disabled"))).m_130948_(Style.f_131099_.m_131140_(ChatFormatting.GOLD)));
        if (InputConstants.m_84830_((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)Minecraft.m_91087_().f_91066_.f_92090_.getKey().m_84873_())) {
            pTooltipComponents.add((Component)Component.m_237115_((String)"aeg.passive_caster.desc"));
            pTooltipComponents.add((Component)Component.m_237115_((String)"aeg.passive_caster.desc2"));
        } else {
            pTooltipComponents.add((Component)Component.m_237115_((String)"tooltip.aeg.await"));
        }
        pTooltipComponents.add((Component)Component.m_237119_());
        this.getInformation(pStack, pLevel, pTooltipComponents, pIsAdvanced);
        super.m_7373_(pStack, pLevel, pTooltipComponents, pIsAdvanced);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level pLevel, Player pPlayer, InteractionHand pUsedHand) {
        CompoundTag tag;
        tag.m_128379_("canTick", !(tag = pPlayer.m_21120_(pUsedHand).m_41784_()).m_128471_("canTick"));
        PortUtil.sendMessageNoSpam((Entity)pPlayer, (Component)Component.m_237115_((String)(tag.m_128471_("canTick") ? "aeg.passive_caster_on" : "aeg.passive_caster_off")).m_130948_(Style.f_131099_.m_131140_(ChatFormatting.GOLD)));
        return super.m_7203_(pLevel, pPlayer, pUsedHand);
    }
}

