/*
 * Decompiled with CFR 0.152.
 */
package com.insider.ars_extended_glyphs.registry;

import com.hollingsworth.arsnouveau.api.registry.RitualRegistry;
import com.hollingsworth.arsnouveau.api.ritual.AbstractRitual;
import com.hollingsworth.arsnouveau.api.spell.SpellSchools;
import com.hollingsworth.arsnouveau.common.items.curios.AbstractManaCurio;
import com.hollingsworth.arsnouveau.common.items.curios.DiscountRing;
import com.hollingsworth.arsnouveau.common.util.RegistryWrapper;
import com.insider.ars_extended_glyphs.item.PassiveCast;
import com.insider.ars_extended_glyphs.item.RefinedMagestone;
import com.insider.ars_extended_glyphs.item.Tablet;
import com.insider.ars_extended_glyphs.item.TabletFragment;
import com.insider.ars_extended_glyphs.item.UselessTablet;
import com.insider.ars_extended_glyphs.item.UselessTabletFragment;
import com.insider.ars_extended_glyphs.loot.AddItemModifier;
import com.insider.ars_extended_glyphs.ritual.RitualDifficultyIncrease;
import com.mojang.serialization.Codec;
import net.minecraft.ChatFormatting;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class ModRegistry {
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"ars_extended_glyphs");
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"ars_extended_glyphs");
    public static final DeferredRegister<EntityType<?>> ENTITIES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ENTITY_TYPES, (String)"ars_extended_glyphs");
    public static final DeferredRegister<Codec<? extends IGlobalLootModifier>> LOOT_MODIFIERS = DeferredRegister.create((ResourceKey)ForgeRegistries.Keys.GLOBAL_LOOT_MODIFIER_SERIALIZERS, (String)"ars_extended_glyphs");
    public static final AbstractRitual[] RITUALS = new AbstractRitual[]{new RitualDifficultyIncrease()};
    public static final RegistryObject<Item> MAGESTONE = ITEMS.register("magestone", () -> new Item(new Item.Properties()));
    public static final RegistryObject<Item> REFINED_MAGESTONE = ITEMS.register("refined_magestone", RefinedMagestone::new);
    public static final RegistryObject<DiscountRing> RING_OF_GREATER_DISCOUNT = ITEMS.register("ring_of_greatest_discount", () -> new DiscountRing(){

        public int getManaDiscount() {
            return 50;
        }
    });
    public static final RegistryObject<AbstractManaCurio> AMULET_OF_GREATER_MANA_POWER = ITEMS.register("amulet_of_greater_mana_power", () -> new AbstractManaCurio(){

        public int getManaRegenBonus(ItemStack i) {
            return 20;
        }

        public int getMaxManaBoost(ItemStack i) {
            return 150;
        }

        public int getManaDiscount(ItemStack i) {
            return 20;
        }
    });
    public static final RegistryWrapper<Item> PASSIVE_CAST = new RegistryWrapper(ITEMS.register("passive_caster", () -> new PassiveCast(new Item.Properties().m_41503_(128), 200)));
    public static final Rarity UNIQUE_RARITY = Rarity.create((String)"aeg_unique", (ChatFormatting)ChatFormatting.DARK_AQUA);
    public static final RegistryObject<Item> BLANK_TABLET = ITEMS.register("blank_tablet", UselessTablet::new);
    public static final RegistryObject<Item> AIR_TABLET = ITEMS.register("air_tablet", () -> new Tablet(SpellSchools.ELEMENTAL_AIR));
    public static final RegistryObject<Item> WATER_TABLET = ITEMS.register("water_tablet", () -> new Tablet(SpellSchools.ELEMENTAL_WATER));
    public static final RegistryObject<Item> FIRE_TABLET = ITEMS.register("fire_tablet", () -> new Tablet(SpellSchools.ELEMENTAL_FIRE));
    public static final RegistryObject<Item> EARTH_TABLET = ITEMS.register("earth_tablet", () -> new Tablet(SpellSchools.ELEMENTAL_EARTH));
    public static final RegistryObject<Item> CONJURATION_TABLET = ITEMS.register("conjuration_tablet", () -> new Tablet(SpellSchools.CONJURATION));
    public static final RegistryObject<Item> MANIPULATION_TABLET = ITEMS.register("manipulation_tablet", () -> new Tablet(SpellSchools.MANIPULATION));
    public static final RegistryObject<Item> ABJURATION_TABLET = ITEMS.register("abjuration_tablet", () -> new Tablet(SpellSchools.ABJURATION));
    public static final RegistryObject<Item> BLANK_TABLET_FRAG = ITEMS.register("blank_tablet_fragment", UselessTabletFragment::new);
    public static final RegistryObject<Item> AIR_TABLET_FRAG = ITEMS.register("air_tablet_fragment", () -> new TabletFragment(SpellSchools.ELEMENTAL_AIR));
    public static final RegistryObject<Item> FIRE_TABLET_FRAG = ITEMS.register("fire_tablet_fragment", () -> new TabletFragment(SpellSchools.ELEMENTAL_FIRE));
    public static final RegistryObject<Item> WATER_TABLET_FRAG = ITEMS.register("water_tablet_fragment", () -> new TabletFragment(SpellSchools.ELEMENTAL_WATER));
    public static final RegistryObject<Item> EARTH_TABLET_FRAG = ITEMS.register("earth_tablet_fragment", () -> new TabletFragment(SpellSchools.ELEMENTAL_EARTH));
    public static final RegistryObject<Codec<? extends IGlobalLootModifier>> ADD_ITEM = LOOT_MODIFIERS.register("include_tablet", AddItemModifier.CODEC);

    public static void registerRegistries(IEventBus bus) {
        BLOCKS.register(bus);
        ITEMS.register(bus);
        ENTITIES.register(bus);
        LOOT_MODIFIERS.register(bus);
        for (AbstractRitual rit : RITUALS) {
            RitualRegistry.registerRitual((AbstractRitual)rit);
        }
    }

    static <T extends Entity> RegistryObject<EntityType<T>> registerEntity(String name, EntityType.Builder<T> builder) {
        return ENTITIES.register(name, () -> builder.m_20712_("ars_extended_glyphs:" + name));
    }
}

