/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.ars_technica;

import com.simibubi.create.content.kinetics.BlockStressDefaults;
import com.simibubi.create.foundation.utility.Couple;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.mcreator.ars_technica.ConfigHandler;
import net.mcreator.ars_technica.client.AllPartialModels;
import net.mcreator.ars_technica.client.events.ClientHandler;
import net.mcreator.ars_technica.common.items.equipment.SpyMonocleCurioRenderer;
import net.mcreator.ars_technica.init.ArsTechnicaModSounds;
import net.mcreator.ars_technica.recipe.ConfigRecipeCondition;
import net.mcreator.ars_technica.setup.ArsNouveauRegistry;
import net.mcreator.ars_technica.setup.BlockRegistry;
import net.mcreator.ars_technica.setup.ItemsRegistry;
import net.mcreator.ars_technica.setup.ModSetup;
import net.mcreator.ars_technica.setup.NetworkHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.conditions.IConditionSerializer;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.util.thread.SidedThreadGroups;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.simple.SimpleChannel;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import top.theillusivec4.curios.api.client.CuriosRendererRegistry;

@Mod(value="ars_technica")
public class ArsTechnicaMod {
    public static final Logger LOGGER = LogManager.getLogger(ArsTechnicaMod.class);
    public static final String MODID = "ars_technica";
    private static final String PROTOCOL_VERSION = "1";
    public static final SimpleChannel PACKET_HANDLER = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("ars_technica", "ars_technica"), () -> "1", "1"::equals, "1"::equals);
    private static int messageID = 0;
    private static final Collection<AbstractMap.SimpleEntry<Runnable, Integer>> workQueue = new ConcurrentLinkedQueue<AbstractMap.SimpleEntry<Runnable, Integer>>();

    public ArsTechnicaMod() {
        MinecraftForge.EVENT_BUS.register((Object)this);
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        IEventBus forgeEventBus = MinecraftForge.EVENT_BUS;
        ArsTechnicaModSounds.REGISTRY.register(bus);
        ModSetup.registers(bus);
        ArsNouveauRegistry.init();
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)ConfigHandler.COMMON_SPEC);
        bus.addListener(this::setup);
        DistExecutor.unsafeCallWhenOn((Dist)Dist.CLIENT, () -> () -> {
            AllPartialModels.init();
            bus.addListener(this::doClientStuff);
            return new Object();
        });
    }

    @OnlyIn(value=Dist.CLIENT)
    private void doClientStuff(FMLClientSetupEvent event) {
        CuriosRendererRegistry.register((Item)((Item)ItemsRegistry.SPY_MONOCLE.get()), () -> new SpyMonocleCurioRenderer(Minecraft.m_91087_().m_167973_().m_171103_(SpyMonocleCurioRenderer.SPY_MONOCLE_LAYER)));
    }

    public void setup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            CraftingHelper.register((IConditionSerializer)ConfigRecipeCondition.Serializer.INSTANCE);
            ArsNouveauRegistry.postInit();
            NetworkHandler.registerMessages();
        });
        ArsTechnicaMod.registerStressValues();
    }

    private static void registerStressValues() {
        ResourceLocation sourceEngineId = BlockRegistry.SOURCE_ENGINE.getId();
        BlockStressDefaults.setDefaultCapacity((ResourceLocation)sourceEngineId, (double)256.0);
        BlockStressDefaults.setGeneratorSpeed((ResourceLocation)sourceEngineId, () -> Couple.create((Object)0, (Object)256));
    }

    public void clientSetup(FMLClientSetupEvent event) {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(ClientHandler::init);
    }

    public static <T> void addNetworkMessage(Class<T> messageType, BiConsumer<T, FriendlyByteBuf> encoder, Function<FriendlyByteBuf, T> decoder, BiConsumer<T, Supplier<NetworkEvent.Context>> messageConsumer) {
        PACKET_HANDLER.registerMessage(messageID, messageType, encoder, decoder, messageConsumer);
        ++messageID;
    }

    public static void queueServerWork(int tick, Runnable action) {
        if (Thread.currentThread().getThreadGroup() == SidedThreadGroups.SERVER) {
            workQueue.add(new AbstractMap.SimpleEntry<Runnable, Integer>(action, tick));
        }
    }

    @SubscribeEvent
    public void tick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            ArrayList actions = new ArrayList();
            workQueue.forEach(work -> {
                work.setValue((Integer)work.getValue() - 1);
                if ((Integer)work.getValue() == 0) {
                    actions.add(work);
                }
            });
            actions.forEach(e -> ((Runnable)e.getKey()).run());
            workQueue.removeAll(actions);
        }
    }
}

