/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.ars_technica.armor;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.hollingsworth.arsnouveau.ArsNouveau;
import com.hollingsworth.arsnouveau.api.item.ISpellModifierItem;
import com.hollingsworth.arsnouveau.api.perk.ArmorPerkHolder;
import com.hollingsworth.arsnouveau.api.perk.IPerk;
import com.hollingsworth.arsnouveau.api.perk.IPerkHolder;
import com.hollingsworth.arsnouveau.api.perk.IPerkProvider;
import com.hollingsworth.arsnouveau.api.perk.PerkAttributes;
import com.hollingsworth.arsnouveau.api.perk.PerkInstance;
import com.hollingsworth.arsnouveau.api.registry.PerkRegistry;
import com.hollingsworth.arsnouveau.api.spell.AbstractSpellPart;
import com.hollingsworth.arsnouveau.api.spell.Spell;
import com.hollingsworth.arsnouveau.api.spell.SpellSchools;
import com.hollingsworth.arsnouveau.api.util.PerkUtil;
import com.hollingsworth.arsnouveau.common.armor.AnimatedMagicArmor;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.mcreator.ars_technica.ConfigHandler;
import net.mcreator.ars_technica.armor.TechnomancerArmorModel;
import net.mcreator.ars_technica.armor.TechnomancerMaterial;
import net.mcreator.ars_technica.client.TooltipUtils;
import net.mcreator.ars_technica.client.renderer.item.TechnomancerArmorRenderer;
import net.mcreator.ars_technica.setup.ItemsRegistry;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.GeoArmorRenderer;

public class TechnomancerArmor
extends AnimatedMagicArmor
implements ISpellModifierItem {
    private final String specialInformation;
    private static final EnumMap<ArmorItem.Type, UUID> ARMOR_MODIFIER_UUID_PER_TYPE = (EnumMap)Util.m_137469_(new EnumMap(ArmorItem.Type.class), p_266744_ -> {
        p_266744_.put(ArmorItem.Type.BOOTS, UUID.fromString("845DB27C-C624-495F-8C9F-6020A9A58B6B"));
        p_266744_.put(ArmorItem.Type.LEGGINGS, UUID.fromString("D8499B04-0E66-4726-AB29-64469D734E0D"));
        p_266744_.put(ArmorItem.Type.CHESTPLATE, UUID.fromString("9F3D476D-C118-4544-8365-64846904B48E"));
        p_266744_.put(ArmorItem.Type.HELMET, UUID.fromString("2AD3F246-FEE1-4E67-B886-69FD380BB150"));
    });
    EquipmentSlot[] OrderedSlots = new EquipmentSlot[]{EquipmentSlot.HEAD, EquipmentSlot.CHEST, EquipmentSlot.LEGS, EquipmentSlot.FEET};
    private final Supplier<Item[]> orderedItemsSupplier = () -> new Item[]{(Item)ItemsRegistry.TECHNOMANCER_HELMET.get(), (Item)ItemsRegistry.TECHNOMANCER_CHESTPLATE.get(), (Item)ItemsRegistry.TECHNOMANCER_LEGGINGS.get(), (Item)ItemsRegistry.TECHNOMANCER_BOOTS.get()};

    public TechnomancerArmor(ArmorItem.Type slot, @Nullable String tooltipSpecialInformation) {
        super((ArmorMaterial)TechnomancerMaterial.INSTANCE, slot, new TechnomancerArmorModel("technomancer_medium_armor").withEmptyAnim());
        this.specialInformation = tooltipSpecialInformation;
    }

    public int getMinTier() {
        return 2;
    }

    @Nullable
    public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
        String color = this.getColor(stack);
        String location = "textures/armor/technomancer_medium_armor_" + color + ".png";
        return new ResourceLocation("ars_technica", location).toString();
    }

    public int getManaDiscount(ItemStack i, Spell spell) {
        double sum = 0.0;
        for (AbstractSpellPart part : spell.recipe) {
            if (!SpellSchools.MANIPULATION.isPartOfSchool(part)) continue;
            sum += 0.2 * (double)part.getCastingCost();
        }
        return Mth.m_14165_((double)sum);
    }

    public String getColor(ItemStack object) {
        IPerkHolder perkHolder = PerkUtil.getPerkHolder((ItemStack)object);
        if (!(perkHolder instanceof ArmorPerkHolder)) {
            return "brown";
        }
        ArmorPerkHolder data = (ArmorPerkHolder)perkHolder;
        return data.getColor() == null || data.getColor().isEmpty() ? "brown" : data.getColor();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, Level world, List<Component> tooltip, TooltipFlag flags) {
        IPerkProvider perkProvider = PerkRegistry.getPerkProvider((Item)stack.m_41720_());
        if (perkProvider != null) {
            tooltip.add((Component)Component.m_237110_((String)"ars_nouveau.tier", (Object[])new Object[]{4}).m_130940_(ChatFormatting.GOLD));
            perkProvider.getPerkHolder((Object)stack).appendPerkTooltip(tooltip, (Object)stack);
        }
        TooltipUtils.addOnShift(tooltip, () -> this.addInformationAfterShift(stack, world, tooltip, flags), "armor_set");
    }

    @OnlyIn(value=Dist.CLIENT)
    public void addInformationAfterShift(ItemStack stack, Level world, List<Component> list, TooltipFlag flags) {
        Player player = ArsNouveau.proxy.getPlayer();
        if (player != null) {
            ArrayList<MutableComponent> equippedList = new ArrayList<MutableComponent>();
            Item[] orderedItems = this.orderedItemsSupplier.get();
            int equippedCounter = 0;
            for (int i = 0; i < this.OrderedSlots.length; ++i) {
                EquipmentSlot slot = this.OrderedSlots[i];
                Item armor = orderedItems[i];
                MutableComponent cmp = Component.m_237113_((String)" - ").m_7220_(armor.m_7968_().m_41786_());
                if (player.m_6844_(slot).m_41720_() == armor) {
                    cmp.m_130940_(ChatFormatting.GREEN);
                    ++equippedCounter;
                } else {
                    cmp.m_130940_(ChatFormatting.GRAY);
                }
                equippedList.add(cmp);
            }
            list.add(this.getArmorSetTitle(equippedCounter));
            list.addAll(equippedList);
            Component specialInfo = this.getArmorPieceSpecialInformation();
            if (specialInfo != null) {
                list.add(specialInfo);
            }
            list.add((Component)Component.m_237115_((String)"ars_technica.armor_set.technomancer.desc").m_130940_(ChatFormatting.GRAY));
        }
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot pEquipmentSlot, ItemStack stack) {
        ImmutableMultimap.Builder attributes = new ImmutableMultimap.Builder();
        attributes.putAll(super.m_7167_(pEquipmentSlot));
        if (this.m_266204_().m_266308_() == pEquipmentSlot) {
            UUID uuid = ARMOR_MODIFIER_UUID_PER_TYPE.get(this.m_266204_());
            IPerkHolder perkHolder = PerkUtil.getPerkHolder((ItemStack)stack);
            if (perkHolder != null) {
                attributes.put((Object)((Attribute)PerkAttributes.MAX_MANA.get()), (Object)new AttributeModifier(uuid, "max_mana_armor", (double)((Integer)ConfigHandler.Common.ARMOR_MAX_MANA.get()).intValue(), AttributeModifier.Operation.ADDITION));
                attributes.put((Object)((Attribute)PerkAttributes.MANA_REGEN_BONUS.get()), (Object)new AttributeModifier(uuid, "mana_regen_armor", (double)((Integer)ConfigHandler.Common.ARMOR_MANA_REGEN.get()).intValue(), AttributeModifier.Operation.ADDITION));
                for (PerkInstance perkInstance : perkHolder.getPerkInstances()) {
                    IPerk perk = perkInstance.getPerk();
                    attributes.putAll(perk.getModifiers(this.m_266204_().m_266308_(), stack, perkInstance.getSlot().value));
                }
            }
        }
        return attributes.build();
    }

    private Component getArmorSetTitle(int equipped) {
        return Component.m_237115_((String)"ars_technica.armor_set.technomancer").m_130946_(" (" + equipped + " / 4)").m_130940_(ChatFormatting.DARK_AQUA);
    }

    @Nullable
    private Component getArmorPieceSpecialInformation() {
        if (this.specialInformation == null) {
            return null;
        }
        return Component.m_237115_((String)("ars_technica" + this.specialInformation)).m_130940_(ChatFormatting.GOLD);
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        super.initializeClient(consumer);
        consumer.accept(new IClientItemExtensions(){
            private GeoArmorRenderer<?> renderer;

            @NotNull
            public HumanoidModel<?> getHumanoidArmorModel(LivingEntity livingEntity, ItemStack itemStack, EquipmentSlot equipmentSlot, HumanoidModel<?> original) {
                if (this.renderer == null) {
                    this.renderer = new TechnomancerArmorRenderer((GeoModel<AnimatedMagicArmor>)TechnomancerArmor.this.getArmorModel());
                }
                this.renderer.prepForRender((Entity)livingEntity, itemStack, equipmentSlot, original);
                return this.renderer;
            }
        });
    }

    public static boolean isWearingFullSet(LivingEntity entity) {
        ItemStack head = entity.m_6844_(EquipmentSlot.HEAD);
        ItemStack chest = entity.m_6844_(EquipmentSlot.CHEST);
        ItemStack legs = entity.m_6844_(EquipmentSlot.LEGS);
        ItemStack boots = entity.m_6844_(EquipmentSlot.FEET);
        return head.m_41720_() instanceof TechnomancerArmor && chest.m_41720_() instanceof TechnomancerArmor && legs.m_41720_() instanceof TechnomancerArmor && boots.m_41720_() instanceof TechnomancerArmor;
    }
}

