/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.ars_technica.common.blocks;

import com.simibubi.create.AllItems;
import com.simibubi.create.AllShapes;
import com.simibubi.create.content.kinetics.base.DirectionalKineticBlock;
import com.simibubi.create.foundation.block.IBE;
import com.simibubi.create.foundation.gui.ScreenOpener;
import java.util.Collections;
import java.util.List;
import net.mcreator.ars_technica.common.blocks.SourceEngineBlockEntity;
import net.mcreator.ars_technica.common.blocks.SourceEngineScreen;
import net.mcreator.ars_technica.setup.EntityRegistry;
import net.mcreator.ars_technica.setup.ItemsRegistry;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.DistExecutor;

public class SourceEngineBlock
extends DirectionalKineticBlock
implements IBE<SourceEngineBlockEntity> {
    public SourceEngineBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return AllShapes.MOTOR_BLOCK.get((Direction)state.m_61143_((Property)FACING));
    }

    public List<ItemStack> m_49635_(BlockState state, LootParams.Builder builder) {
        return Collections.singletonList(new ItemStack((ItemLike)ItemsRegistry.SOURCE_ENGINE.get()));
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        Direction preferred = this.getPreferredFacing(context);
        if (context.m_43723_() != null && context.m_43723_().m_6144_() || preferred == null) {
            return super.m_5573_(context);
        }
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)preferred);
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        if (player != null && AllItems.WRENCH.isIn(player.m_21120_(handIn))) {
            return InteractionResult.PASS;
        }
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> this.withBlockEntityDo((BlockGetter)worldIn, pos, be -> this.displayScreen((SourceEngineBlockEntity)((Object)((Object)((Object)be))), player)));
        return InteractionResult.SUCCESS;
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void displayScreen(SourceEngineBlockEntity be, Player player) {
        if (player instanceof LocalPlayer) {
            ScreenOpener.open((Screen)new SourceEngineScreen(be));
        }
    }

    public boolean hasShaftTowards(LevelReader world, BlockPos pos, BlockState state, Direction face) {
        return face == state.m_61143_((Property)FACING);
    }

    public Direction.Axis getRotationAxis(BlockState state) {
        return ((Direction)state.m_61143_((Property)FACING)).m_122434_();
    }

    public boolean hideStressImpact() {
        return true;
    }

    public void m_6807_(BlockState state, Level world, BlockPos pos, BlockState oldState, boolean isMoving) {
        super.m_6807_(state, world, pos, oldState, isMoving);
        this.checkForPower(world, pos);
    }

    public void m_6861_(BlockState state, Level world, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        super.m_6861_(state, world, pos, block, fromPos, isMoving);
        this.checkForPower(world, pos);
    }

    private void checkForPower(Level world, BlockPos pos) {
        BlockEntity blockEntity = world.m_7702_(pos);
        if (blockEntity instanceof SourceEngineBlockEntity) {
            boolean isPowered = world.m_276867_(pos);
            ((SourceEngineBlockEntity)blockEntity).setPowered(isPowered);
        }
    }

    public boolean m_7357_(BlockState state, BlockGetter reader, BlockPos pos, PathComputationType type) {
        return false;
    }

    public Class<SourceEngineBlockEntity> getBlockEntityClass() {
        return SourceEngineBlockEntity.class;
    }

    public BlockEntityType<? extends SourceEngineBlockEntity> getBlockEntityType() {
        return (BlockEntityType)EntityRegistry.SOURCE_ENGINE_BLOCK_ENTITY.get();
    }
}

