/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.ars_technica.common.entity;

import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.content.kinetics.press.PressingRecipe;
import java.util.List;
import java.util.Optional;
import net.mcreator.ars_technica.common.entity.ArcaneProcessEntity;
import net.mcreator.ars_technica.common.entity.Colorable;
import net.mcreator.ars_technica.common.helpers.RecipeHelpers;
import net.mcreator.ars_technica.setup.EntityRegistry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.Color;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class ArcanePressEntity
extends ArcaneProcessEntity
implements GeoEntity,
Colorable {
    AnimatableInstanceCache factory = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public ArcanePressEntity(Vec3 position, Level world, int maxAmountToPress, float speed, Color color, List<ItemEntity> pressableEntities) {
        super((EntityType)EntityRegistry.ARCANE_PRESS_ENTITY.get(), position, world, maxAmountToPress, speed, color, pressableEntities);
    }

    public ArcanePressEntity(EntityType<ArcanePressEntity> entityType, Level world) {
        super(entityType, world);
    }

    @Override
    protected void process(ItemEntity item) {
        this.press(item);
    }

    private void press(ItemEntity item) {
        ItemStack currentStack = item.m_32055_();
        if (currentStack.m_41613_() > 0) {
            Optional<PressingRecipe> pressingRecipe = RecipeHelpers.getPressingRecipeForItemStack(currentStack, this.world);
            if (pressingRecipe.isEmpty()) {
                this.processableEntities.remove(this.currentItem);
                this.currentItem = null;
                return;
            }
            Vec3 currentPos = this.currentItem.m_20318_(1.0f);
            this.m_146884_(currentPos.m_82520_(Math.random() / 4.0, 1.0, Math.random() / 4.0));
            RegistryAccess registryAccess = this.world.m_9598_();
            PressingRecipe recipe = pressingRecipe.get();
            ItemStack pressedStack = recipe.m_8043_(registryAccess);
            pressedStack.m_41764_(1);
            this.growOutput(item, pressedStack);
            currentStack.m_41774_(1);
            ++this.amountProcessed;
            AllSoundEvents.MECHANICAL_PRESS_ACTIVATION.playOnServer(this.world, (Vec3i)this.m_20183_(), 0.5f, 0.75f + this.speed / 16.0f);
        }
        if (currentStack.m_41613_() <= 0) {
            this.currentItem = null;
        }
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "pressController", 0, this::pressAnimationPredicate)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.factory;
    }

    private PlayState pressAnimationPredicate(AnimationState<?> event) {
        event.getController().setAnimation(RawAnimation.begin().thenPlay("press"));
        event.getController().setAnimationSpeed((double)this.speed);
        return PlayState.CONTINUE;
    }
}

