/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.ars_technica.common.entity.fusion;

import com.hollingsworth.arsnouveau.client.particle.ParticleColor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.mcreator.ars_technica.client.particles.SpiralDustParticleTypeData;
import net.mcreator.ars_technica.common.entity.fusion.ArcaneFusionEntity;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

public class ArcaneFusionParticles {
    private final ArcaneFusionEntity parent;
    private final Level world;
    private static final EntityDataAccessor<String> INGREDIENT_A = SynchedEntityData.m_135353_(ArcaneFusionEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private static final EntityDataAccessor<String> INGREDIENT_B = SynchedEntityData.m_135353_(ArcaneFusionEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private static final EntityDataAccessor<String> INGREDIENT_C = SynchedEntityData.m_135353_(ArcaneFusionEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private static final EntityDataAccessor<String> INGREDIENT_D = SynchedEntityData.m_135353_(ArcaneFusionEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private ItemStack ingredientA;
    private ItemStack ingredientB;
    private ItemStack ingredientC;
    private ItemStack ingredientD;
    private List<ItemStack> recipeItemStacks;
    private boolean rendered_impact_particles = false;
    private static float TIME_TO_ANGLE_MULTIPLIER = 1.5f;

    public ArcaneFusionParticles(ArcaneFusionEntity parent, Level world) {
        this.parent = parent;
        this.world = world;
        this.defineSynchedData();
    }

    private void defineSynchedData() {
        this.parent.m_20088_().m_135372_(INGREDIENT_A, (Object)"");
        this.parent.m_20088_().m_135372_(INGREDIENT_B, (Object)"");
        this.parent.m_20088_().m_135372_(INGREDIENT_C, (Object)"");
        this.parent.m_20088_().m_135372_(INGREDIENT_D, (Object)"");
    }

    public void onSyncedDataUpdated(EntityDataAccessor<?> key) {
        if (INGREDIENT_A.equals(key)) {
            this.ingredientA = this.getItemStackFromRegistry((String)this.parent.m_20088_().m_135370_(INGREDIENT_A));
        }
        if (INGREDIENT_B.equals(key)) {
            this.ingredientB = this.getItemStackFromRegistry((String)this.parent.m_20088_().m_135370_(INGREDIENT_B));
        }
        if (INGREDIENT_C.equals(key)) {
            this.ingredientC = this.getItemStackFromRegistry((String)this.parent.m_20088_().m_135370_(INGREDIENT_C));
        }
        if (INGREDIENT_D.equals(key)) {
            this.ingredientD = this.getItemStackFromRegistry((String)this.parent.m_20088_().m_135370_(INGREDIENT_D));
        }
    }

    private void setIngredientList() {
        if (this.recipeItemStacks == null && this.ingredientA != null) {
            ArrayList<ItemStack> temporaryList = new ArrayList<ItemStack>(Arrays.asList(this.ingredientA));
            this.addNonNullToList(this.ingredientB, temporaryList);
            this.addNonNullToList(this.ingredientC, temporaryList);
            this.addNonNullToList(this.ingredientD, temporaryList);
            this.recipeItemStacks = temporaryList.stream().toList();
        }
    }

    public void setIngredientsForParticles(List<ItemEntity> ingredients) {
        if (ingredients.size() > 0) {
            this.parent.m_20088_().m_135381_(INGREDIENT_A, (Object)this.getItemRegistryName(ingredients.get(0).m_32055_().m_41720_()));
        }
        if (ingredients.size() > 1) {
            this.parent.m_20088_().m_135381_(INGREDIENT_B, (Object)this.getItemRegistryName(ingredients.get(1).m_32055_().m_41720_()));
        }
        if (ingredients.size() > 2) {
            this.parent.m_20088_().m_135381_(INGREDIENT_C, (Object)this.getItemRegistryName(ingredients.get(2).m_32055_().m_41720_()));
        }
        if (ingredients.size() > 3) {
            this.parent.m_20088_().m_135381_(INGREDIENT_D, (Object)this.getItemRegistryName(ingredients.get(3).m_32055_().m_41720_()));
        }
    }

    private String getItemRegistryName(Item item) {
        ResourceLocation registryName = ForgeRegistries.ITEMS.getKey((Object)item);
        return registryName != null ? registryName.toString() : "";
    }

    private void addNonNullToList(@Nullable ItemStack itemStack, ArrayList<ItemStack> list) {
        if (itemStack != null) {
            list.add(itemStack);
        }
    }

    private ItemStack getItemStackFromRegistry(String registryName) {
        if (registryName.isEmpty()) {
            return ItemStack.f_41583_;
        }
        ResourceLocation resourceLocation = new ResourceLocation(registryName);
        Item item = (Item)ForgeRegistries.ITEMS.getValue(resourceLocation);
        return item != null ? new ItemStack((ItemLike)item) : ItemStack.f_41583_;
    }

    public void handleParticles() {
        this.setIngredientList();
        if (this.world == null || this.recipeItemStacks == null) {
            return;
        }
        if (!this.parent.getImpacted()) {
            float diameterMultiplier = this.parent.getSwung() ? 1.0f - (this.parent.getElapsedTime() - ArcaneFusionEntity.CHARGE_TIME) * 2.0f : 1.0f;
            this.renderCircleParticles(diameterMultiplier);
            this.renderFusionParticles();
        }
        if (this.parent.getImpacted() && !this.rendered_impact_particles) {
            this.renderImpactParticles();
            this.rendered_impact_particles = true;
        }
    }

    private void renderCircleParticles(float diameterMultiplier) {
        int numStacks = Math.min(this.recipeItemStacks.size(), 4);
        double angleStep = 360.0 / (double)numStacks;
        Vec3 center = this.parent.m_20318_(1.0f);
        float elapsedTime = this.parent.getElapsedTime();
        double speedMultiplier = (double)TIME_TO_ANGLE_MULTIPLIER * Math.exp((double)elapsedTime / 1.0);
        double circleDiameter = (double)0.3f * Math.exp(elapsedTime) * (double)diameterMultiplier;
        double circleRadius = circleDiameter / 2.0;
        for (int i = 0; i < numStacks; ++i) {
            double angle = Math.toRadians((double)i * angleStep) + (double)elapsedTime * speedMultiplier;
            double offsetX = circleRadius * Math.cos(angle) + this.parent.getRandom().m_188583_() * 0.1;
            double offsetZ = circleRadius * Math.sin(angle) + this.parent.getRandom().m_188583_() * 0.1;
            Vec3 particlePos = center.m_82520_(offsetX, 0.25, offsetZ);
            ItemStack itemStack = this.recipeItemStacks.get(i);
            ItemParticleOption data = new ItemParticleOption(ParticleTypes.f_123752_, itemStack);
            this.world.m_7106_((ParticleOptions)data, particlePos.f_82479_, particlePos.f_82480_, particlePos.f_82481_, 0.0, 0.1, 0.0);
        }
    }

    private void renderFusionParticles() {
        if (this.parent.getTickCount() % 2 == 0) {
            int particleColorIndex = this.parent.getRandom().m_216332_(0, 2);
            ParticleColor particleColor = this.parent.getFusionType().getParticleColors().get(particleColorIndex);
            SpiralDustParticleTypeData particleData = new SpiralDustParticleTypeData(particleColor, false, 1.0f, 1.0f, 20);
            this.addParticle(particleData, Math.toRadians(this.parent.getRandom().m_188583_() * 360.0), 0.0, 0.04, 0.0);
        }
    }

    private void renderImpactParticles() {
        this.addParticle((ParticleOptions)ParticleTypes.f_123813_, 0.0, 0.0, 0.0, 0.0);
        for (int i = 0; i < 5; ++i) {
            this.addParticle((ParticleOptions)ParticleTypes.f_123777_, 0.0, 2.0E-4, 0.4, 0.05);
        }
        int itemParticleCount = 16;
        double angleStep = 360.0 / (double)itemParticleCount;
        for (int i = 0; i < 16; ++i) {
            double angle = Math.toRadians((double)i * angleStep);
            ItemStack itemStack = this.recipeItemStacks.get(i % this.recipeItemStacks.size());
            ItemParticleOption data = new ItemParticleOption(ParticleTypes.f_123752_, itemStack);
            this.addParticle((ParticleOptions)data, angle, 0.1, 0.2, 0.2);
        }
    }

    private void addParticle(ParticleOptions particleData, double angle, double speedMultiplier, double offsetMultiplier, double ySpeed) {
        double offsetX = this.parent.getRandom().m_188583_() * offsetMultiplier;
        double offsetY = this.parent.getRandom().m_188583_() * offsetMultiplier;
        double offsetZ = this.parent.getRandom().m_188583_() * offsetMultiplier;
        double speedX = Math.cos(angle) + this.parent.getRandom().m_188583_() * speedMultiplier;
        double speedZ = Math.sin(angle) + this.parent.getRandom().m_188583_() * speedMultiplier;
        this.world.m_7106_(particleData, this.parent.m_20185_() + offsetX, this.parent.m_20186_() + offsetY, this.parent.m_20189_() + offsetZ, speedX, ySpeed, speedZ);
    }
}

