/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.ars_technica.common.glyphs;

import com.hollingsworth.arsnouveau.api.spell.AbstractAugment;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.SpellResolver;
import com.hollingsworth.arsnouveau.api.spell.SpellSchool;
import com.hollingsworth.arsnouveau.api.spell.SpellSchools;
import com.hollingsworth.arsnouveau.api.spell.SpellStats;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentAOE;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentSplit;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import net.mcreator.ars_technica.common.glyphs.AbstractItemResolveEffect;
import net.mcreator.ars_technica.common.helpers.StorageHelpers;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.NotNull;

public class EffectInsert
extends AbstractItemResolveEffect {
    public static EffectInsert INSTANCE = new EffectInsert();

    private EffectInsert() {
        super(new ResourceLocation("ars_technica", "glyph_insert"), "Insert");
    }

    @Override
    public void onResolveEntities(List<ItemEntity> entityList, BlockPos pos, Vec3 posVec, Level world, LivingEntity shooter, SpellStats spellStats, SpellContext spellContext, SpellResolver resolver) {
        double expansion = 2.0 + spellStats.getAoeMultiplier();
        List<BlockEntity> containers = this.getContainersInArea(pos, world, (int)expansion);
        boolean split = !spellStats.getAugments().stream().filter(x -> x == AugmentSplit.INSTANCE).findFirst().isEmpty();
        this.processItemEntities(world, entityList, containers, split);
    }

    public void processItemEntities(Level world, List<ItemEntity> entityList, List<BlockEntity> containers, boolean split) {
        ArrayList<BlockPos> containerPosTargets = new ArrayList<BlockPos>();
        for (BlockEntity container : containers) {
            containerPosTargets.add(container.m_58899_());
        }
        Iterator<ItemEntity> itemIterator = entityList.iterator();
        while (itemIterator.hasNext()) {
            ItemEntity itemEntity = itemIterator.next();
            ItemStack stack = itemEntity.m_32055_();
            if (stack.m_41619_()) {
                itemIterator.remove();
                continue;
            }
            if (split) {
                this.processItemsSplit(stack, itemEntity, itemIterator, world, containerPosTargets);
                continue;
            }
            this.processItemsNonSplit(stack, itemEntity, itemIterator, world, containerPosTargets);
        }
    }

    private void processItemsNonSplit(ItemStack stack, ItemEntity itemEntity, Iterator<ItemEntity> itemIterator, Level world, List<BlockPos> containerPosTargets) {
        IItemHandler itemHandler;
        BlockEntity bestContainer;
        BlockPos bestPos = StorageHelpers.getValidStorePos(world, containerPosTargets, stack);
        if (bestPos != null && (bestContainer = world.m_7702_(bestPos)) != null && (itemHandler = StorageHelpers.getItemCapFromTile(bestContainer)) != null) {
            ItemStack remaining = ItemHandlerHelper.insertItemStacked((IItemHandler)itemHandler, (ItemStack)stack, (boolean)false);
            if (remaining.m_41619_()) {
                itemIterator.remove();
                itemEntity.m_146870_();
            } else {
                itemEntity.m_32045_(remaining);
            }
        }
    }

    private void processItemsSplit(ItemStack stack, ItemEntity itemEntity, Iterator<ItemEntity> itemIterator, Level world, List<BlockPos> containerPosTargets) {
        List<BlockPos> validPositions = StorageHelpers.getValidStorePositions(world, containerPosTargets, stack);
        int totalItems = stack.m_41613_();
        int itemsPerContainer = totalItems / validPositions.size();
        int remainder = totalItems % validPositions.size();
        int itemsInserted = 0;
        for (BlockPos pos : validPositions) {
            IItemHandler itemHandler;
            BlockEntity container = world.m_7702_(pos);
            if (container == null || (itemHandler = StorageHelpers.getItemCapFromTile(container)) == null) continue;
            int itemsToInsert = itemsPerContainer + (remainder > 0 ? 1 : 0);
            ItemStack toInsert = new ItemStack((ItemLike)stack.m_41720_(), itemsToInsert);
            ItemStack remaining = ItemHandlerHelper.insertItemStacked((IItemHandler)itemHandler, (ItemStack)toInsert, (boolean)false);
            int inserted = itemsToInsert - remaining.m_41613_();
            itemsInserted += inserted;
            remainder -= inserted > 0 ? 1 : 0;
        }
        if (itemsInserted >= totalItems) {
            itemIterator.remove();
            itemEntity.m_146870_();
        } else {
            stack.m_41764_(totalItems - itemsInserted);
            itemEntity.m_32045_(stack);
        }
    }

    public List<BlockEntity> getContainersInArea(BlockPos pos, Level world, int expansion) {
        ArrayList<BlockEntity> containers = new ArrayList<BlockEntity>();
        BlockPos minPos = pos.m_7918_(-expansion, -expansion, -expansion);
        BlockPos maxPos = pos.m_7918_(expansion, expansion, expansion);
        for (BlockPos currentPos : BlockPos.m_121940_((BlockPos)minPos, (BlockPos)maxPos)) {
            BlockEntity tileEntity = world.m_7702_(currentPos);
            if (!(tileEntity instanceof Container)) continue;
            containers.add(tileEntity);
        }
        return containers;
    }

    @NotNull
    public Set<AbstractAugment> getCompatibleAugments() {
        return this.augmentSetOf(new AbstractAugment[]{AugmentAOE.INSTANCE, AugmentSplit.INSTANCE});
    }

    public String getBookDescription() {
        return "Inserts nearby items into nearby containers in a medium radius where this spell is activated. The range may be expanded with AOE.";
    }

    public int getDefaultManaCost() {
        return 15;
    }

    @NotNull
    public Set<SpellSchool> getSchools() {
        return this.setOf(new SpellSchool[]{SpellSchools.MANIPULATION});
    }
}

