/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.ars_technica.common.glyphs;

import com.hollingsworth.arsnouveau.api.spell.AbstractAugment;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.SpellResolver;
import com.hollingsworth.arsnouveau.api.spell.SpellSchool;
import com.hollingsworth.arsnouveau.api.spell.SpellSchools;
import com.hollingsworth.arsnouveau.api.spell.SpellStats;
import com.hollingsworth.arsnouveau.api.spell.SpellTier;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentAOE;
import com.simibubi.create.content.kinetics.press.PressingRecipe;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.mcreator.ars_technica.common.entity.ArcanePressEntity;
import net.mcreator.ars_technica.common.glyphs.AbstractItemResolveEffect;
import net.mcreator.ars_technica.common.helpers.RecipeHelpers;
import net.mcreator.ars_technica.common.helpers.SpellResolverHelpers;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import software.bernie.geckolib.core.object.Color;

public class EffectPress
extends AbstractItemResolveEffect {
    public static final EffectPress INSTANCE = new EffectPress();
    private static float DEFAULT_SPEED = 4.0f;

    private EffectPress() {
        super(new ResourceLocation("ars_technica", "glyph_press"), "Press");
    }

    @Override
    public void onResolveEntities(List<ItemEntity> entityList, BlockPos pos, Vec3 posVec, Level world, @Nullable LivingEntity shooter, SpellStats spellStats, SpellContext spellContext, SpellResolver resolver) {
        ItemEntity closest;
        ArrayList<ItemEntity> validPressableEntities = new ArrayList<ItemEntity>();
        for (ItemEntity itemEntity : entityList) {
            ItemStack itemStack = itemEntity.m_32055_();
            Optional<PressingRecipe> pressingRecipe = RecipeHelpers.getPressingRecipeForItemStack(itemStack, world);
            if (!pressingRecipe.isPresent()) continue;
            validPressableEntities.add(itemEntity);
        }
        boolean hasFocus = SpellResolverHelpers.hasTransmutationFocus(resolver);
        int aoeBuff = (int)Math.round(spellStats.getAoeMultiplier());
        int maxAmountToPress = Math.round(4 * (1 + aoeBuff)) * (hasFocus ? 2 : 1);
        float speed = hasFocus ? DEFAULT_SPEED * 2.5f : DEFAULT_SPEED;
        Color color = new Color(spellContext.getColors().getColor());
        if (!validPressableEntities.isEmpty() && (closest = (ItemEntity)validPressableEntities.stream().min(Comparator.comparingDouble(e -> e.m_20182_().m_82554_(posVec))).orElse(null)) != null) {
            ArcanePressEntity arcanePressEntity = new ArcanePressEntity(closest.m_20182_().m_82520_(0.0, 1.0, 0.0), world, maxAmountToPress, speed, color, validPressableEntities);
            world.m_7967_((Entity)arcanePressEntity);
        }
    }

    public int getDefaultManaCost() {
        return 100;
    }

    @Nonnull
    public Set<AbstractAugment> getCompatibleAugments() {
        return this.augmentSetOf(new AbstractAugment[]{AugmentAOE.INSTANCE});
    }

    @Nonnull
    public Set<SpellSchool> getSchools() {
        return this.setOf(new SpellSchool[]{SpellSchools.MANIPULATION});
    }

    public String getBookDescription() {
        return "Flattens items into their pressed variants";
    }

    public SpellTier defaultTier() {
        return SpellTier.TWO;
    }
}

