/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.ars_technica.common.glyphs;

import com.hollingsworth.arsnouveau.api.spell.AbstractAugment;
import com.hollingsworth.arsnouveau.api.spell.AbstractEffect;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.SpellResolver;
import com.hollingsworth.arsnouveau.api.spell.SpellSchool;
import com.hollingsworth.arsnouveau.api.spell.SpellSchools;
import com.hollingsworth.arsnouveau.api.spell.SpellStats;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentPierce;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentSensitive;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import net.mcreator.ars_technica.common.entity.ItemProjectileEntity;
import net.mcreator.ars_technica.common.helpers.ConsumptionHelper;
import net.mcreator.ars_technica.common.helpers.FluidHelper;
import net.mcreator.ars_technica.common.helpers.RecipeHelpers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Cow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.PotionItem;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;

public class EffectTelefeast
extends AbstractEffect {
    public static final EffectTelefeast INSTANCE = new EffectTelefeast();

    private EffectTelefeast() {
        super(new ResourceLocation("ars_technica", "glyph_telefeast"), "Telefeast");
    }

    public void onResolveEntity(EntityHitResult rayTraceResult, Level world, @NotNull LivingEntity shooter, SpellStats spellStats, SpellContext spellContext, SpellResolver resolver) {
        Entity target = rayTraceResult.m_82443_();
        this.handleEntity(shooter, target, world);
    }

    public void onResolveBlock(BlockHitResult rayTraceResult, Level world, @NotNull LivingEntity shooter, SpellStats spellStats, SpellContext spellContext, SpellResolver resolver) {
        IItemHandler itemHandler;
        BlockPos pos = rayTraceResult.m_82425_();
        BlockEntity be = world.m_7702_(pos);
        boolean canUse = spellStats.isSensitive();
        boolean forwardItem = spellStats.getBuffCount((AbstractAugment)AugmentPierce.INSTANCE) > 0;
        Direction dir = rayTraceResult.m_82434_();
        Vec3 inverseDirection = new Vec3((double)dir.m_122429_(), (double)dir.m_122430_(), (double)dir.m_122431_()).m_82490_(-1.0).m_82541_();
        if (be != null && be.getCapability(ForgeCapabilities.FLUID_HANDLER).isPresent()) {
            IFluidHandler fluidHandler = FluidHelper.getHandlerFromCap(pos, world, 0);
            if (fluidHandler != null) {
                this.handleFluid(shooter, fluidHandler.getFluidInTank(0), fluidHandler, world, inverseDirection, be.m_58899_(), forwardItem);
            }
        } else if (be != null && be.getCapability(ForgeCapabilities.ITEM_HANDLER).isPresent() && (itemHandler = (IItemHandler)be.getCapability(ForgeCapabilities.ITEM_HANDLER).orElse(null)) != null) {
            this.handleItem(shooter, itemHandler, world, inverseDirection, be.m_58899_(), canUse, forwardItem);
        }
    }

    private void handleEntity(LivingEntity caster, Entity target, Level world) {
        if (target instanceof Cow) {
            ItemStack itemResult = new ItemStack((ItemLike)Items.f_42455_);
            ConsumptionHelper.playSound(SoundEvents.f_11911_, world, caster);
            itemResult.m_41671_(world, caster);
        }
    }

    private void handleItem(LivingEntity caster, IItemHandler itemHandler, Level world, Vec3 direction, BlockPos position, boolean canUse, boolean forwardItem) {
        for (int i = 0; i < itemHandler.getSlots(); ++i) {
            ItemStack itemStack = itemHandler.getStackInSlot(i);
            if (itemStack.m_41619_()) continue;
            if (forwardItem) {
                ItemStack extractedItem = itemHandler.extractItem(i, 1, false);
                this.forwardItem(world, extractedItem, direction, position.m_252807_());
                break;
            }
            if (ConsumptionHelper.tryUseConsumableItem(caster, itemStack, world, canUse) || ConsumptionHelper.tryUseEdibleItem(caster, itemStack, world)) break;
        }
    }

    private void handleFluid(LivingEntity caster, FluidStack fluid, IFluidHandler handler, Level world, Vec3 direction, BlockPos position, boolean forwardItem) {
        Optional<RecipeHelpers.FillingResult> bucketRecipe;
        if (fluid.getFluid() == Fluids.f_76195_ && !forwardItem) {
            Holder.Reference lavaDamageType = world.m_9598_().m_175515_(Registries.f_268580_).m_246971_(DamageTypes.f_268546_);
            DamageSource lavaDamage = new DamageSource((Holder)lavaDamageType, (Entity)caster, (Entity)caster);
            handler.drain(250, IFluidHandler.FluidAction.EXECUTE);
            caster.m_6469_(lavaDamage, 50.0f);
            return;
        }
        ItemStack outputItem = null;
        Optional<RecipeHelpers.FillingResult> bottleRecipe = RecipeHelpers.getSpoutFillingRecipe(fluid, new ItemStack((ItemLike)Items.f_42590_), world);
        if (bottleRecipe.isPresent() && handler.getFluidInTank(0).getAmount() >= bottleRecipe.get().fluidAmount) {
            outputItem = bottleRecipe.get().output.m_41777_();
            if (outputItem.m_41720_() instanceof PotionItem || outputItem.m_41780_() == UseAnim.DRINK) {
                handler.drain(bottleRecipe.get().fluidAmount, IFluidHandler.FluidAction.EXECUTE);
            } else {
                outputItem = null;
            }
        }
        if (outputItem == null && (bucketRecipe = RecipeHelpers.getSpoutFillingRecipe(fluid, new ItemStack((ItemLike)Items.f_42446_), world)).isPresent() && handler.getFluidInTank(0).getAmount() >= bucketRecipe.get().fluidAmount) {
            outputItem = bucketRecipe.get().output.m_41777_();
            if (outputItem.m_41780_() == UseAnim.DRINK) {
                handler.drain(bucketRecipe.get().fluidAmount, IFluidHandler.FluidAction.EXECUTE);
            } else {
                outputItem = null;
            }
        }
        if (outputItem != null) {
            if (!forwardItem) {
                ConsumptionHelper.tryUseEdibleItem(caster, outputItem, world);
            } else {
                this.forwardItem(world, outputItem, direction, position.m_252807_());
            }
        }
    }

    private void forwardItem(Level world, ItemStack item, Vec3 direction, Vec3 position) {
        if (item.m_41619_()) {
            return;
        }
        ItemProjectileEntity projectile = new ItemProjectileEntity(world, position.m_82520_(0.0, -0.5, 0.0), direction, item);
        world.m_7967_((Entity)projectile);
    }

    protected int getDefaultManaCost() {
        return 10;
    }

    @NotNull
    protected Set<AbstractAugment> getCompatibleAugments() {
        return Set.of(AugmentSensitive.INSTANCE, AugmentPierce.INSTANCE);
    }

    @Nonnull
    public Set<SpellSchool> getSchools() {
        return this.setOf(new SpellSchool[]{SpellSchools.MANIPULATION});
    }

    public String getBookDescription() {
        return "Consumes the first edible/potion, or some amount of liquid, found in the container/tank this was cast on. Augment with Sensitive for also targeting 'usable' items";
    }
}

