/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.ars_technica.common.helpers;

import com.simibubi.create.AllRecipeTypes;
import com.simibubi.create.content.equipment.sandPaper.SandPaperPolishingRecipe;
import com.simibubi.create.content.fluids.transfer.FillingRecipe;
import com.simibubi.create.content.fluids.transfer.GenericItemFilling;
import com.simibubi.create.content.kinetics.fan.processing.HauntingRecipe;
import com.simibubi.create.content.kinetics.fan.processing.SplashingRecipe;
import com.simibubi.create.content.kinetics.press.PressingRecipe;
import com.simibubi.create.content.processing.recipe.ProcessingRecipe;
import com.simibubi.create.foundation.fluid.FluidIngredient;
import java.util.List;
import java.util.Optional;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.RecipeWrapper;

public class RecipeHelpers {
    public static Optional<SplashingRecipe> getSplashingRecipeForItemStack(RecipeManager recipeManager, ItemStack input, Level world) {
        SplashingRecipe.SplashingWrapper wrapper = new SplashingRecipe.SplashingWrapper();
        wrapper.m_6836_(0, input);
        return recipeManager.m_44015_(AllRecipeTypes.SPLASHING.getType(), (Container)wrapper, world);
    }

    public static Optional<HauntingRecipe> getHauntingRecipeForItemStack(RecipeManager recipeManager, ItemStack input, Level world) {
        HauntingRecipe.HauntingWrapper wrapper = new HauntingRecipe.HauntingWrapper();
        wrapper.m_6836_(0, input);
        return recipeManager.m_44015_(AllRecipeTypes.HAUNTING.getType(), (Container)wrapper, world);
    }

    public static Optional<PressingRecipe> getPressingRecipeForItemStack(final ItemStack input, Level world) {
        return world.m_7465_().m_44015_(AllRecipeTypes.PRESSING.getType(), (Container)new RecipeWrapper((IItemHandlerModifiable)new ItemStackHandler(1){
            {
                super(size);
                this.setStackInSlot(0, input);
            }
        }), world);
    }

    public static Optional<ProcessingRecipe<RecipeWrapper>> getCrushingRecipeForItemStack(final ItemStack input, Level world) {
        RecipeWrapper wrapper = new RecipeWrapper((IItemHandlerModifiable)new ItemStackHandler(1){
            {
                super(size);
                this.setStackInSlot(0, input);
            }
        });
        Optional crushingRecipe = world.m_7465_().m_44015_(AllRecipeTypes.CRUSHING.getType(), (Container)wrapper, world);
        if (!crushingRecipe.isPresent()) {
            return world.m_7465_().m_44015_(AllRecipeTypes.MILLING.getType(), (Container)wrapper, world);
        }
        return crushingRecipe;
    }

    public static Optional<SandPaperPolishingRecipe> getPolishingRecipeForItemStack(ItemStack input, Level world) {
        SandPaperPolishingRecipe.SandPaperInv sandpaperInventory = new SandPaperPolishingRecipe.SandPaperInv(input);
        return world.m_7465_().m_44015_(AllRecipeTypes.SANDPAPER_POLISHING.getType(), (Container)sandpaperInventory, world);
    }

    public static boolean isChanceBased(ItemStack input, ProcessingRecipe<?> recipe) {
        List rollables = recipe.getRollableResults();
        return rollables.stream().anyMatch(rollable -> input.m_41720_() == rollable.getStack().m_41720_() && rollable.getChance() < 1.0f);
    }

    private static <C extends Container, T extends Recipe<C>> Optional<T> getRecipeFor(RecipeManager recipeManager, RecipeType<T> recipeType, C container, Level world) {
        return recipeManager.m_44015_(recipeType, container, world);
    }

    public static Optional<FillingResult> getSpoutFillingRecipe(FluidStack fluidIngredient, ItemStack itemIngredient, Level world) {
        int requiredAmount;
        RecipeManager recipeManager = world.m_7465_();
        List allFillingRecipes = recipeManager.m_44013_(AllRecipeTypes.FILLING.getType());
        Optional<FillingRecipe> staticRecipe = allFillingRecipes.stream().filter(FillingRecipe.class::isInstance).map(FillingRecipe.class::cast).filter(recipe -> ((FluidIngredient)recipe.getFluidIngredients().get(0)).getMatchingFluidStacks().stream().anyMatch(stack -> stack.getFluid().m_6212_(fluidIngredient.getFluid()))).filter(recipe -> ((Ingredient)recipe.m_7527_().get(0)).m_43908_()[0].m_41720_() == itemIngredient.m_41720_()).findFirst();
        if (staticRecipe.isPresent()) {
            FillingRecipe recipe2 = staticRecipe.get();
            FillingResult result = new FillingResult(recipe2.m_8043_(world.m_9598_()).m_41777_(), recipe2.getRequiredFluid().getRequiredAmount());
            return Optional.of(result);
        }
        if (GenericItemFilling.canItemBeFilled((Level)world, (ItemStack)itemIngredient) && (requiredAmount = GenericItemFilling.getRequiredAmountForItem((Level)world, (ItemStack)itemIngredient, (FluidStack)fluidIngredient)) != -1 && requiredAmount <= fluidIngredient.getAmount()) {
            ItemStack itemResult = GenericItemFilling.fillItem((Level)world, (int)requiredAmount, (ItemStack)itemIngredient, (FluidStack)fluidIngredient);
            fluidIngredient.setAmount(fluidIngredient.getAmount() + requiredAmount);
            FillingResult result = new FillingResult(itemResult, requiredAmount);
            return Optional.of(result);
        }
        return Optional.empty();
    }

    public static class FillingResult {
        public final ItemStack output;
        public final int fluidAmount;

        public FillingResult(ItemStack output, int fluidAmount) {
            this.output = output;
            this.fluidAmount = fluidAmount;
        }
    }
}

