/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.ars_technica.common.kinetics;

import com.hollingsworth.arsnouveau.api.spell.SpellResolver;
import com.hollingsworth.arsnouveau.client.particle.ParticleColor;
import com.simibubi.create.content.kinetics.fan.processing.AllFanProcessingTypes;
import com.simibubi.create.content.kinetics.fan.processing.FanProcessingType;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import net.mcreator.ars_technica.client.events.ModParticles;
import net.mcreator.ars_technica.common.entity.WhirlEntity;
import net.mcreator.ars_technica.common.helpers.PlayerHelpers;
import net.mcreator.ars_technica.common.kinetics.WhirlProcessing;
import net.mcreator.ars_technica.init.ArsTechnicaModSounds;
import net.mcreator.ars_technica.network.ParticleEffectPacket;
import net.mcreator.ars_technica.setup.NetworkHandler;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkDirection;

public class WhirlCurrent {
    private final WhirlEntity source;
    private AABB bounds;
    private List<ItemEntity> affectedEntities;
    private float radius;
    private int tickCount = 0;
    private double tangentialFactor = 0.25;
    private double pullFactor = 3.0;

    public WhirlCurrent(WhirlEntity source) {
        this.source = source;
        this.radius = source.getRadius();
        Vec3 centerPos = source.m_20318_(1.0f);
        this.bounds = new AABB(centerPos.m_82492_((double)this.radius, (double)this.radius, (double)this.radius), centerPos.m_82520_((double)this.radius, (double)this.radius, (double)this.radius));
    }

    public void tick(SpellResolver whirlOwner) {
        ++this.tickCount;
        Level world = this.source.getLevel();
        if (world == null) {
            return;
        }
        this.tickAffectedEntities(world, whirlOwner);
    }

    protected void tickAffectedEntities(Level world, SpellResolver whirlOwner) {
        this.affectedEntities = world.m_45976_(ItemEntity.class, this.bounds);
        List<ServerPlayer> nearbyPlayers = PlayerHelpers.getNearbyPlayers(this.source.m_20318_(1.0f), world);
        if (this.tickCount % 4 == 0) {
            this.sendWhirlParticles(nearbyPlayers, this.source.getProcessor());
        }
        Iterator<ItemEntity> iterator = this.affectedEntities.iterator();
        while (iterator.hasNext()) {
            ItemEntity itemEntity;
            Entity entity = (Entity)iterator.next();
            if (!entity.m_6084_() || !entity.m_20191_().m_82381_(this.bounds)) {
                iterator.remove();
                continue;
            }
            this.moveItem(entity);
            FanProcessingType processingType = this.source.getProcessor();
            entity.f_19864_ = true;
            if (processingType == AllFanProcessingTypes.NONE || !(entity instanceof ItemEntity) || !WhirlProcessing.canProcess((ItemEntity)(itemEntity = (ItemEntity)entity), (FanProcessingType)processingType)) continue;
            Vec3 itemPosition = itemEntity.m_20318_(1.0f);
            if (WhirlProcessing.applyProcessing(itemEntity, processingType, world, whirlOwner)) {
                this.sendProcessingFinishedSound(itemPosition, processingType);
            }
            if (this.tickCount % 8 == 0) {
                this.sendProcessingSound(itemPosition, processingType);
                this.sendProcessingParticles(nearbyPlayers, itemEntity, processingType);
            }
            this.sendProcessingParticles(nearbyPlayers, itemEntity, processingType);
        }
    }

    private void moveItem(Entity entity) {
        Vec3 direction = this.source.m_20182_().m_82546_(entity.m_20182_()).m_82541_();
        double distance = entity.m_20182_().m_82554_(this.source.m_20182_());
        Vec3 motion = entity.m_20184_();
        double heightDifference = Math.abs(entity.m_20182_().f_82480_ - this.source.m_20182_().f_82480_);
        double heightFactor = Math.max(0.0, 1.0 - heightDifference);
        Vec3 tangentialMotion = new Vec3(-direction.f_82481_, 0.0, direction.f_82479_).m_82490_(this.tangentialFactor * heightFactor * (double)(this.radius / 3.0f) * (double)this.source.getScaledSpeed() * 0.5);
        Vec3 pull = direction.m_82490_(this.pullFactor * (Math.sqrt(this.radius) - distance * 1.5) * heightFactor * (double)(1.0f / this.radius) * (double)this.source.getScaledSpeed() * 0.5);
        if (pull.m_82553_() > 0.5) {
            pull = pull.m_82541_().m_82490_(0.1 * (double)this.radius);
        }
        entity.m_20256_(motion.m_82549_(tangentialMotion).m_82546_(pull));
        entity.f_19789_ = 0.0f;
    }

    private void sendProcessingSound(Vec3 itemPos, FanProcessingType processingType) {
        SoundEvent event = (SoundEvent)ArsTechnicaModSounds.WHIRL_PROCESS_AFFECT_FIRE.get();
        if (processingType == AllFanProcessingTypes.SPLASHING) {
            event = (SoundEvent)ArsTechnicaModSounds.WHIRL_PROCESS_AFFECT_WATER.get();
        }
        this.sendSoundEvent(itemPos, event);
    }

    private void sendProcessingFinishedSound(Vec3 itemPos, FanProcessingType processingType) {
        SoundEvent event = SoundEvents.f_11937_;
        if (processingType == AllFanProcessingTypes.SPLASHING) {
            event = SoundEvents.f_12277_;
        }
        this.sendSoundEvent(itemPos, event);
    }

    private void sendSoundEvent(Vec3 pos, SoundEvent event) {
        if (event != null) {
            this.source.getLevel().m_6263_(null, pos.f_82479_, pos.f_82480_, pos.f_82481_, event, SoundSource.AMBIENT, 0.25f, 1.0f);
        }
    }

    private void sendWhirlParticles(List<ServerPlayer> players, FanProcessingType processingType) {
        if (processingType == AllFanProcessingTypes.NONE) {
            return;
        }
        ParticleColor color = ParticleColor.WHITE;
        if (processingType == AllFanProcessingTypes.BLASTING || processingType == AllFanProcessingTypes.HAUNTING || processingType == AllFanProcessingTypes.SMOKING) {
            color = new ParticleColor(32, 32, 32);
        }
        for (ServerPlayer player : players) {
            ParticleEffectPacket packet = new ParticleEffectPacket(this.source.m_20318_(1.0f), (ParticleType)ModParticles.SPIRAL_DUST_TYPE.get(), color);
            NetworkHandler.CHANNEL.sendTo((Object)packet, player.f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
        }
    }

    private void sendProcessingParticles(List<ServerPlayer> players, ItemEntity itemEntity, FanProcessingType processingType) {
        Vec3 itemPos = itemEntity.m_20182_();
        Object particleType = processingType == AllFanProcessingTypes.BLASTING ? ParticleTypes.f_123762_ : (processingType == AllFanProcessingTypes.HAUNTING ? ParticleTypes.f_123745_ : (processingType == AllFanProcessingTypes.SMOKING ? ParticleTypes.f_123759_ : ParticleTypes.f_123805_));
        for (ServerPlayer player : players) {
            ParticleEffectPacket packet = new ParticleEffectPacket(itemPos, (ParticleType<?>)particleType);
            NetworkHandler.CHANNEL.sendTo((Object)packet, player.f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
        }
    }

    public void stopAffectedItems() {
        if (this.affectedEntities == null) {
            return;
        }
        for (ItemEntity item : this.affectedEntities) {
            item.m_20256_(Vec3.f_82478_);
            item.f_19864_ = true;
        }
        this.affectedEntities.clear();
    }

    private static UUID getProcessingId(Entity entity) {
        CompoundTag createData;
        CompoundTag nbt = entity.getPersistentData();
        if (nbt.m_128441_("CreateData") && (createData = nbt.m_128469_("CreateData")).m_128441_("WhirlwindId")) {
            return createData.m_128342_("WhirlwindId");
        }
        return null;
    }
}

