/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.ars_technica.common.kinetics;

import com.hollingsworth.arsnouveau.api.spell.SpellResolver;
import com.simibubi.create.content.kinetics.fan.processing.AllFanProcessingTypes;
import com.simibubi.create.content.kinetics.fan.processing.FanProcessing;
import com.simibubi.create.content.kinetics.fan.processing.FanProcessingType;
import com.simibubi.create.content.kinetics.fan.processing.FanProcessingTypeRegistry;
import com.simibubi.create.content.processing.recipe.ProcessingRecipe;
import com.simibubi.create.infrastructure.config.AllConfigs;
import java.util.List;
import java.util.Optional;
import net.mcreator.ars_technica.common.helpers.RecipeHelpers;
import net.mcreator.ars_technica.common.helpers.SpellResolverHelpers;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class WhirlProcessing
extends FanProcessing {
    public static boolean applyProcessing(ItemEntity entity, FanProcessingType type, Level world, SpellResolver whirlOwner) {
        double processingBoost = 0.0;
        if (SpellResolverHelpers.hasTransmutationFocus(whirlOwner)) {
            processingBoost += 1.0;
        }
        if (WhirlProcessing.decrementProcessingTime(entity, type, processingBoost) != 0) {
            return false;
        }
        List<ItemStack> stacks = type.process(entity.m_32055_(), entity.m_9236_());
        if (stacks == null || stacks.isEmpty()) {
            entity.m_146870_();
            return false;
        }
        stacks = WhirlProcessing.applyCustomProcessing(stacks, entity, type, world, whirlOwner);
        entity.m_32045_(stacks.remove(0));
        for (ItemStack additional : stacks) {
            ItemEntity entityIn = new ItemEntity(entity.m_9236_(), entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), additional);
            entityIn.m_20256_(entity.m_20184_());
            entity.m_9236_().m_7967_((Entity)entityIn);
        }
        return true;
    }

    private static List<ItemStack> applyCustomProcessing(List<ItemStack> stacks, ItemEntity entity, FanProcessingType type, Level world, SpellResolver whirlOwner) {
        Optional<ProcessingRecipe<?>> recipe;
        if (SpellResolverHelpers.shouldDoubleOutputs(whirlOwner) && !(recipe = WhirlProcessing.getProcessingRecipeForEntity(entity, type, world)).isEmpty()) {
            for (ItemStack stack : stacks) {
                if (!RecipeHelpers.isChanceBased(stack, recipe.get())) continue;
                stack.m_41769_(stack.m_41613_());
            }
        }
        return stacks;
    }

    private static Optional<ProcessingRecipe<?>> getProcessingRecipeForEntity(ItemEntity entity, FanProcessingType type, Level world) {
        if (type == AllFanProcessingTypes.SPLASHING) {
            return RecipeHelpers.getSplashingRecipeForItemStack(world.m_7465_(), entity.m_32055_(), world).map(recipe -> recipe);
        }
        if (type == AllFanProcessingTypes.HAUNTING) {
            return RecipeHelpers.getHauntingRecipeForItemStack(world.m_7465_(), entity.m_32055_(), world).map(recipe -> recipe);
        }
        return Optional.empty();
    }

    private static int decrementProcessingTime(ItemEntity entity, FanProcessingType type, double processingBoost) {
        CompoundTag processing;
        CompoundTag createData;
        CompoundTag nbt = entity.getPersistentData();
        if (!nbt.m_128441_("CreateData")) {
            nbt.m_128365_("CreateData", (Tag)new CompoundTag());
        }
        if (!(createData = nbt.m_128469_("CreateData")).m_128441_("Processing")) {
            createData.m_128365_("Processing", (Tag)new CompoundTag());
        }
        if (!(processing = createData.m_128469_("Processing")).m_128441_("Type") || AllFanProcessingTypes.parseLegacy((String)processing.m_128461_("Type")) != type) {
            processing.m_128359_("Type", FanProcessingTypeRegistry.getIdOrThrow((FanProcessingType)type).toString());
            int timeModifierForStackSize = (entity.m_32055_().m_41613_() - 1) / 16 + 1;
            int baseProcessingTime = (Integer)AllConfigs.server().kinetics.fanProcessingTime.get() * timeModifierForStackSize + 1;
            int processingTime = (int)((double)baseProcessingTime / (1.0 + processingBoost));
            processing.m_128405_("Time", processingTime);
        }
        int value = processing.m_128451_("Time") - 1;
        processing.m_128405_("Time", value);
        return value;
    }
}

