/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.ars_technica.mixin;

import com.hollingsworth.arsnouveau.common.block.tile.RuneTile;
import com.simibubi.create.content.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.foundation.utility.Lang;
import java.util.List;
import net.mcreator.ars_technica.common.api.IRuneTileModifier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={RuneTile.class})
public class RuneTileMixin
implements IRuneTileModifier,
IHaveGoggleInformation {
    @Shadow(remap=false)
    private int ticksUntilCharge;
    private int ticksUntilChargeCount = 0;

    @Inject(method={"castSpell"}, at={@At(value="TAIL")}, remap=false)
    private void modifyTicksUntilCharge(Entity entity, CallbackInfo ci) {
        if (entity == null) {
            return;
        }
        if (this.ticksUntilChargeCount > 0) {
            this.ticksUntilCharge = this.ticksUntilChargeCount;
        }
    }

    @Inject(method={"saveAdditional"}, at={@At(value="HEAD")})
    private void saveTicksUntilChargeCount(CompoundTag tag, CallbackInfo ci) {
        tag.m_128405_("ticksUntilChargeCount", this.ticksUntilChargeCount);
    }

    @Inject(method={"load"}, at={@At(value="HEAD")})
    private void loadTicksUntilChargeCount(CompoundTag tag, CallbackInfo ci) {
        this.ticksUntilChargeCount = tag.m_128451_("ticksUntilChargeCount");
    }

    @Override
    public void incrementCustomTicksUntilCharge() {
        this.ticksUntilChargeCount = this.ticksUntilChargeCount == 20 ? 40 : (this.ticksUntilChargeCount += 40);
        if (this.ticksUntilChargeCount >= 680) {
            this.ticksUntilChargeCount = 20;
        }
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        Lang.text((String)"Cooldown: ").forGoggles(tooltip);
        double cooldownSeconds = (this.ticksUntilChargeCount == 0 ? 40 : this.ticksUntilChargeCount) / 20;
        Lang.number((double)cooldownSeconds).add(Lang.text((String)" s")).forGoggles(tooltip);
        return true;
    }
}

