/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.ars_technica.recipe;

import com.google.gson.JsonObject;
import net.mcreator.ars_technica.ConfigHandler;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.common.crafting.conditions.IConditionSerializer;

public class ConfigRecipeCondition
implements ICondition {
    private static final ResourceLocation NAME = new ResourceLocation("ars_technica", "config_enabled");
    private final String configKey;

    public ConfigRecipeCondition(String configKey) {
        this.configKey = configKey;
    }

    public boolean test(ICondition.IContext context) {
        switch (this.configKey) {
            case "recipeFocusTransmutationEnabled": {
                return (Boolean)ConfigHandler.COMMON.RECIPE_FOCUS_TRANSMUTATION_ENABLED.get();
            }
            case "recipeCalibratedPrecisionMechanismEnabled": {
                return (Boolean)ConfigHandler.COMMON.RECIPE_CALIBRATED_PRECISION_MECHANISM_ENABLED.get();
            }
            case "recipeRunicSpannerEnabled": {
                return (Boolean)ConfigHandler.COMMON.RECIPE_RUNIC_SPANNER_ENABLED.get();
            }
            case "recipeThreadPressureEnabled": {
                return (Boolean)ConfigHandler.COMMON.RECIPE_THREAD_PRESSURE_ENABLED.get();
            }
            case "recipeSpyMonocleEnabled": {
                return (Boolean)ConfigHandler.COMMON.RECIPE_SPY_MONOCLE_ENABLED.get();
            }
        }
        return true;
    }

    public ResourceLocation getID() {
        return NAME;
    }

    public static class Serializer
    implements IConditionSerializer<ConfigRecipeCondition> {
        public static final Serializer INSTANCE = new Serializer();

        public void write(JsonObject json, ConfigRecipeCondition condition) {
            json.addProperty("config_option", condition.configKey);
        }

        public ConfigRecipeCondition read(JsonObject json) {
            return new ConfigRecipeCondition(json.get("config_option").getAsString());
        }

        public ResourceLocation getID() {
            return NAME;
        }
    }
}

